/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAIThrow;
import net.torocraft.toroquest.entities.render.RenderPigLord;
import net.torocraft.toroquest.generation.WorldGenPlacer;

public class EntityPigLord
extends EntityPigZombie
implements IMob {
    protected static final DataParameter<Integer> RAID_X = EntityDataManager.func_187226_a(EntityPigLord.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> RAID_Y = EntityDataManager.func_187226_a(EntityPigLord.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> RAID_Z = EntityDataManager.func_187226_a(EntityPigLord.class, (DataSerializer)DataSerializers.field_187192_b);
    public static String NAME = "pig_lord";
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationY() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Y));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    public void func_82227_f(boolean childZombie) {
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityPigLord.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int func_184649_cE() {
        return 5;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityPigLord.class, (IRenderFactory)new IRenderFactory<EntityPigLord>(){

            public Render<EntityPigLord> createRenderFor(RenderManager manager) {
                return new RenderPigLord(manager);
            }
        });
    }

    public EntityPigLord(World worldIn, int x, int y, int z) {
        super(worldIn);
        this.setUpEntity();
        this.setRaidLocation(x, y, z);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.75));
    }

    private void setUpEntity() {
        this.field_70178_ae = true;
        this.func_110163_bv();
        this.func_82227_f(false);
        this.func_70105_a(1.9f, 5.9f);
        this.setRealSize(1.9f, 5.9f);
        this.field_70728_aV = 280;
        this.field_70138_W = 4.05f;
    }

    public EntityPigLord(World worldIn) {
        super(worldIn);
        this.setUpEntity();
        int x = this.getRaidLocationX();
        int y = this.getRaidLocationY();
        int z = this.getRaidLocationZ();
        if (y != 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.75));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(64.0);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151010_B));
    }

    public float func_70047_e() {
        return super.func_70047_e() * 3.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        WorldGenPlacer.clearTrees(this.field_70170_p, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 32);
        livingdata = super.func_180482_a(difficulty, livingdata);
        if ((int)this.field_70163_u != 0 && this.getRaidLocationY() == 0) {
            this.setRaidLocation((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        return livingdata;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
    }

    protected void func_175456_n() {
        super.func_175456_n();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIThrow((EntityCreature)this, 1.2, true, 0.75, 40));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    private void triggerBossAbility() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.spawnLightning(16);
            List pigZombieCount = this.field_70170_p.func_72872_a(EntityPigZombie.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(16.0, 8.0, 16.0));
            for (EntityPigZombie p : pigZombieCount) {
                p.func_70624_b(this.func_70638_az());
            }
        }
    }

    private void spawnLightning(int range) {
        if (!this.func_70089_S() || this.func_110143_aJ() <= 0.0f) {
            return;
        }
        this.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 16, 2));
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int amount = this.field_70146_Z.nextInt(5);
        for (int i = 0; i < amount; ++i) {
            this.lightning(range);
        }
    }

    protected void lightning(int range) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos pos = this.getSurfacePosition(this.field_70170_p, this.field_70165_t + (double)this.field_70146_Z.nextInt(range) - (double)(range / 2), this.field_70163_u + (double)this.field_70146_Z.nextInt(range / 2), this.field_70161_v + (double)this.field_70146_Z.nextInt(range) - (double)(range / 2));
        if (pos == null) {
            return;
        }
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
    }

    private BlockPos getSurfacePosition(World world, double x, double y, double z) {
        IBlockState blockState;
        BlockPos search = new BlockPos(x, y, z);
        while (search.func_177956_o() > 0 && !this.isLiquid(blockState = world.func_180495_p(search = search.func_177977_b())) && !blockState.func_185914_p()) {
        }
        return search;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private Block getBlockDoor(BlockPos pos) {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150357_h) {
            return null;
        }
        return block;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() != null) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        float health = this.func_110143_aJ() / this.func_110138_aP();
        if (this.field_70173_aa % 25 == 0) {
            PathNavigateGround pathnavigateground;
            Path path;
            this.triggerBossAbility();
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.bossInfo.func_186735_a(health);
            if (this.field_70123_F && (path = (pathnavigateground = (PathNavigateGround)this.func_70661_as()).func_75505_d()) != null && !path.func_75879_b()) {
                for (int i = 0; i < Math.min(path.func_75873_e() + 2, path.func_75874_d()); ++i) {
                    PathPoint pathpoint = path.func_75877_a(i);
                    for (int j = 8; j >= 0; --j) {
                        BlockPos doorPosition = new BlockPos(pathpoint.field_75839_a + this.field_70146_Z.nextInt(4) - 3, pathpoint.field_75837_b + j, pathpoint.field_75838_c + this.field_70146_Z.nextInt(4) - 3);
                        Block doorBlock = this.getBlockDoor(doorPosition);
                        if (doorBlock == null || doorBlock == Blocks.field_150350_a || !(doorBlock.func_176195_g(doorBlock.func_176223_P(), this.field_70170_p, doorPosition) <= 3.0f)) continue;
                        this.field_70170_p.func_175656_a(doorPosition, Blocks.field_150350_a.func_176223_P());
                        if (this.field_70146_Z.nextBoolean()) {
                            if (this.field_70146_Z.nextBoolean()) {
                                this.field_70170_p.func_175718_b(1021, doorPosition, 0);
                            } else {
                                this.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
                            }
                        }
                        this.field_70170_p.func_175718_b(2001, doorPosition, Block.func_149682_b((Block)doorBlock));
                    }
                }
            }
        }
        if ((double)health <= 0.2 && this.field_70173_aa % 11 == 0) {
            this.spawnLightning(16);
            this.spawnLightning(48);
            this.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 25, 2, true, false));
            if (this.field_70146_Z.nextInt(6) == 0) {
                this.func_184185_a(SoundEvents.field_187938_hl, this.func_70599_aP() * 2.0f, (float)(this.field_70146_Z.nextInt(5) / 10) + 0.4f);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_180431_b(source) || source == DamageSource.field_180137_b || source == DamageSource.field_76379_h || source == null || source.func_76346_g() == null || !this.func_70089_S()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            double dist = source.func_76346_g().func_174818_b(this.func_180425_c());
            if (dist > 256.0) {
                amount = (float)((double)amount * (256.0 / dist));
            }
            if (!(source.func_76346_g() instanceof EntityPlayer)) {
                amount /= 16.0f;
            }
            List help = this.field_70170_p.func_175647_a(EntityPigZombie.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(32.0, 16.0, 32.0), (Predicate)new Predicate<EntityPigZombie>(){

                public boolean apply(@Nullable EntityPigZombie entity) {
                    return true;
                }
            });
            for (EntityPigZombie pigman : help) {
                if (pigman.func_70638_az() == null) {
                    pigman.func_70624_b((EntityLivingBase)source.func_76346_g());
                    continue;
                }
                if (this.field_70146_Z.nextInt(6) != 0) continue;
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropBossLoot();
            int x = this.getRaidLocationX();
            int y = this.getRaidLocationY();
            int z = this.getRaidLocationZ();
            if (y == 0) {
                x = this.func_180425_c().func_177958_n();
                y = this.func_180425_c().func_177956_o();
                z = this.func_180425_c().func_177952_p();
            }
            int range = 64;
            for (int xx = -range; xx < range; ++xx) {
                for (int yy = -32; yy < 32; ++yy) {
                    for (int zz = -range; zz < range; ++zz) {
                        BlockPos pos = new BlockPos(x + xx, y + yy, z + zz);
                        this.field_70170_p.func_175719_a(null, pos, EnumFacing.UP);
                        IBlockState block = this.field_70170_p.func_180495_p(pos);
                        if (block == Blocks.field_150343_Z.func_176223_P() || block == Blocks.field_150388_bm.func_176223_P()) {
                            this.field_70170_p.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
                        }
                        if (block != Blocks.field_150425_aM.func_176223_P() && block != Blocks.field_150424_aL.func_176223_P() && block != Blocks.field_189877_df.func_176223_P()) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                    }
                }
            }
        }
    }

    private void dropBossLoot() {
        if (!this.field_70170_p.field_72995_K) {
            int x = this.func_180425_c().func_177958_n();
            int y = this.func_180425_c().func_177956_o();
            int z = this.func_180425_c().func_177952_p();
            int range = 128;
            for (int xx = -range / 2; xx < range; ++xx) {
                for (int yy = -range / 4; yy < range / 2; ++yy) {
                    for (int zz = -range / 2; zz < range; ++zz) {
                        BlockPos pos = new BlockPos(x + xx - 16, y + yy - 4, z + zz - 16);
                        this.field_70170_p.func_175719_a(null, pos, EnumFacing.UP);
                        IBlockState block = this.field_70170_p.func_180495_p(pos);
                        if (block == null || block != Blocks.field_150343_Z) continue;
                        this.field_70170_p.func_175698_g(pos);
                    }
                }
            }
            this.dropTrophy();
            this.dropSword();
            this.dropLootItem(Items.field_151103_aS, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151103_aS, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151103_aS, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151078_bh, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151078_bh, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151078_bh, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151157_am, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151157_am, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151157_am, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151074_bl, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151043_k, this.field_70146_Z.nextInt(3) + 3);
            this.dropLootItem(Items.field_151150_bK, 1);
        }
    }

    private void dropTrophy() {
        ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:trophy_pig"));
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, stack.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = 0.5;
        dropItem.field_70179_y = 0.0;
        dropItem.field_70159_w = 0.0;
        this.field_70170_p.func_72838_d((Entity)dropItem);
        dropItem.func_184195_f(true);
    }

    private void dropSword() {
        ItemStack stack = new ItemStack(Items.field_151010_B, 1);
        stack.func_77966_a(Enchantment.func_180305_b((String)"minecraft:knockback"), 13);
        stack.func_151001_c("Sword of Nago");
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, stack.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = 0.5;
        dropItem.field_70179_y = 0.0;
        dropItem.field_70159_w = 0.0;
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble() + 0.1;
            dropItem.field_70179_y = 2.0 * this.field_70146_Z.nextGaussian();
            dropItem.field_70159_w = 2.0 * this.field_70146_Z.nextGaussian();
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    protected SoundEvent func_184639_G() {
        this.func_184185_a(SoundEvents.field_187935_hi, this.func_70599_aP() * 2.0f, (float)(this.field_70146_Z.nextInt(5) / 10) + 0.4f);
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(SoundEvents.field_187938_hl, this.func_70599_aP() * 2.0f, (float)(this.field_70146_Z.nextInt(5) / 10) + 0.4f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_187937_hk, this.func_70599_aP() * 2.0f, (float)(this.field_70146_Z.nextInt(5) / 10) + 0.4f);
        return null;
    }

    protected SoundEvent func_190731_di() {
        this.func_184185_a(SoundEvents.field_187605_cG, this.func_70599_aP() * 2.0f, (float)(this.field_70146_Z.nextInt(5) / 10) + 0.4f);
        return null;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void setRealSize(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

