/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.render.RenderOrc;

public class EntityOrc
extends EntitySentry
implements IRangedAttackMob,
IMob {
    public double renderSizeXZ;
    public double renderSizeY;
    public static String NAME = "orc";
    private ResourceLocation banditSkin;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityOrc.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)1, (boolean)true, (int)3182374, (int)14734169);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityOrc.class, (IRenderFactory)new IRenderFactory<EntityOrc>(){

            public Render<EntityOrc> createRenderFor(RenderManager manager) {
                return new RenderOrc(manager);
            }
        });
    }

    @Override
    public String getChatName() {
        return null;
    }

    @Override
    public boolean func_145818_k_() {
        this.func_174805_g(false);
        return false;
    }

    @Override
    public void addMask() {
        if (ToroQuestConfiguration.renderOrcMask) {
            ItemStack head = new ItemStack(Item.func_111206_d((String)"toroquest:bandit_helmet"), 1);
            this.func_184201_a(EntityEquipmentSlot.HEAD, head);
        }
    }

    @Override
    public int getSkinID() {
        int i = (Integer)this.func_184212_Q().func_187225_a(SKIN_ID);
        if (i < 1) {
            i = 1 + this.field_70146_Z.nextInt(ToroQuestConfiguration.orcSkins);
            this.setSkinID(i);
        }
        return i;
    }

    @Override
    public ResourceLocation getSkin() {
        return this.banditSkin;
    }

    @Override
    public double getRenderSizeXZ() {
        return this.renderSizeXZ;
    }

    @Override
    public double getRenderSizeY() {
        return this.renderSizeY;
    }

    public EntityOrc(World worldIn) {
        super(worldIn);
        this.renderSizeXZ = 1.0 + this.field_70146_Z.nextDouble() / 10.0;
        this.renderSizeY = this.renderSizeXZ * (1.025 + this.field_70146_Z.nextGaussian() / 16.0);
        this.banditSkin = new ResourceLocation("toroquest:textures/entity/orc/orc_" + this.getSkinID() + ".png");
        this.func_70105_a(0.65f, 1.95f);
        this.func_174805_g(false);
        this.field_70728_aV = 30;
        this.splashPotionTimer = -1;
        this.hasSplashPotion = -1;
        this.limitPotions = -1;
    }

    public EntityOrc(World worldIn, int x, int z) {
        this(worldIn);
        this.setRaidLocation(x, z);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRaid(this, x, z, 0.675));
    }

    @Override
    public void setBribed(boolean b) {
        this.func_184212_Q().func_187227_b(BRIBED, (Object)false);
    }

    @Override
    public boolean getBribed() {
        return false;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_184641_n(false);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ToroQuestConfiguration.orcBaseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.orcAttackDamage);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)ToroQuestConfiguration.orcArmor);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)ToroQuestConfiguration.orcArmorToughness);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.393 + this.field_70146_Z.nextDouble() / 50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
    }

    @Override
    public void addEquipment() {
        int weapon = this.field_70146_Z.nextInt(3);
        if (weapon == 0) {
            if (this.field_70146_Z.nextBoolean()) {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcTwoHandedMeleeWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcTwoHandedMeleeWeapons.length)]), 1);
                if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.orcBaseHealth) {
                    this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcTwoHandedMeleeWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcTwoHandedMeleeWeaponsPowerful.length)]), 1);
                }
                if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                    this.weaponMain = this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151052_q, 1) : new ItemStack(Items.field_151049_t, 1);
                }
                if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                    String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                        enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon.length)].split(",");
                        this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    }
                }
            } else {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcOneHandedMeleeWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcOneHandedMeleeWeapons.length)]), 1);
                if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.orcBaseHealth) {
                    this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcOneHandedMeleeWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcOneHandedMeleeWeaponsPowerful.length)]), 1);
                }
                if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                    this.weaponMain = this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151052_q, 1) : new ItemStack(Items.field_151049_t, 1);
                }
                if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                    String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                        enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon.length)].split(",");
                        this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    }
                }
                this.weaponOff = this.weaponMain.func_77946_l();
            }
        } else if (weapon == 1) {
            String[] enchant;
            this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcOneHandedMeleeWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcOneHandedMeleeWeapons.length)]), 1);
            if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.orcBaseHealth) {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcOneHandedMeleeWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcOneHandedMeleeWeaponsPowerful.length)]), 1);
            }
            if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                this.weaponMain = this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151052_q, 1) : new ItemStack(Items.field_151049_t, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon.length)].split(",");
                this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                    enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                }
            }
            this.weaponOff = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcShields[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcShields.length)]), 1);
            if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.orcBaseHealth) {
                this.weaponOff = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcShieldsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcShieldsPowerful.length)]), 1);
            }
            if (this.weaponOff == null || this.weaponOff.func_190926_b()) {
                this.weaponOff = new ItemStack(Items.field_185159_cQ, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcShield[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcShield.length)].split(",");
                this.weaponOff.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
            }
        } else if (weapon == 2) {
            this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcRangedWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcRangedWeapons.length)]), 1);
            if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.orcBaseHealth) {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.orcRangedWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.orcRangedWeaponsPowerful.length)]), 1);
            }
            if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                this.weaponMain = new ItemStack((Item)Items.field_151031_f, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcRanged[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcRanged.length)].split(",");
                this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                    enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcRanged[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcRanged.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                }
            }
        }
        if (this.weaponMain != null && !this.weaponMain.func_190926_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, this.weaponMain);
        }
        if (this.weaponOff != null && !this.weaponOff.func_190926_b()) {
            this.func_184611_a(EnumHand.OFF_HAND, this.weaponOff);
        }
        this.addMask();
        if (ToroQuestConfiguration.banditsHaveArmorForSpartanWeaponry) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151026_S, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T, 1));
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.orcAttackDamage);
    }

    @Override
    public void dropLoot() {
        if (!this.field_70170_p.field_72995_K) {
            EntityItem dropItem;
            ItemStack stack;
            if (ToroQuestConfiguration.orcsDropMasks) {
                this.dropMask();
            }
            if (ToroQuestConfiguration.orcsDropEmeralds && this.field_70146_Z.nextInt(3) == 0) {
                stack = new ItemStack(Items.field_151166_bC, this.field_70146_Z.nextInt(4) + 1);
                dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                this.field_70170_p.func_72838_d((Entity)dropItem);
            }
            if (this.field_70146_Z.nextInt(3) == 0) {
                stack = new ItemStack(Items.field_151103_aS, this.field_70146_Z.nextInt(2) + 1);
                dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                this.field_70170_p.func_72838_d((Entity)dropItem);
            }
        }
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        this.func_184185_a(SoundEvents.field_187935_hi, 1.0f, 0.5f + this.field_70146_Z.nextFloat() / 5.0f);
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_184185_a(SoundEvents.field_191245_bo, 0.8f, 0.7f + this.field_70146_Z.nextFloat() / 10.0f);
            this.func_184185_a(SoundEvents.field_187938_hl, 1.0f, 0.7f + this.field_70146_Z.nextFloat() / 5.0f);
        } else if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_184185_a(SoundEvents.field_193786_de, 0.8f, 0.7f + this.field_70146_Z.nextFloat() / 10.0f);
            this.func_184185_a(SoundEvents.field_187938_hl, 1.0f, 0.7f + this.field_70146_Z.nextFloat() / 5.0f);
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_187937_hk, 1.0f, 1.0f + this.field_70146_Z.nextFloat() / 5.0f);
        return null;
    }

    @Override
    protected void playAttackSound() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_184185_a(SoundEvents.field_187935_hi, 0.9f, 0.55f + this.field_70146_Z.nextFloat() / 5.0f);
        }
    }

    @Override
    protected void callForHelp(EntityLivingBase attacker) {
        if (attacker == null || !attacker.func_70089_S()) {
            return;
        }
        List help = this.field_70170_p.func_175647_a(EntityOrc.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(32.0, 16.0, 32.0), (Predicate)new Predicate<EntityOrc>(){

            public boolean apply(@Nullable EntityOrc entity) {
                return true;
            }
        });
        for (EntityOrc entity : help) {
            if (entity.func_70638_az() != null) continue;
            entity.func_70624_b(attacker);
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

