/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.render.RenderMonolithEye;
import net.torocraft.toroquest.generation.WorldGenPlacer;

public class EntityMonolithEye
extends EntityMob
implements IRangedAttackMob,
IMob {
    public static String NAME = "monolitheye";
    protected static final DataParameter<Integer> RAID_X;
    protected static final DataParameter<Integer> RAID_Y;
    protected static final DataParameter<Integer> RAID_Z;
    protected int crystalsDestroyed = 0;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public boolean func_174833_aM() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public EntityMonolithEye(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_70105_a(20.0f, 38.0f);
        this.setRealSize(20.0f, 38.0f);
        this.field_70178_ae = true;
        this.bossInfo.func_186745_a(BossInfo.Color.WHITE);
        this.func_184224_h(true);
        this.func_189654_d(true);
        this.field_70728_aV = 440;
    }

    public EntityMonolithEye(World worldIn, int x, int y, int z) {
        this(worldIn);
        this.setRaidLocation(x, y, z);
    }

    protected void setRealSize(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        WorldGenPlacer.clearTrees(this.field_70170_p, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 56);
        if ((int)this.field_70163_u != 0 && this.getRaidLocationY() == 0) {
            this.setRaidLocation((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationY() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Y));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropBossLoot();
            int x = this.getRaidLocationX();
            int y = this.getRaidLocationY();
            int z = this.getRaidLocationZ();
            if (y == 0) {
                x = this.func_180425_c().func_177958_n();
                y = this.func_180425_c().func_177956_o();
                z = this.func_180425_c().func_177952_p();
            }
            int range = 64;
            for (int xx = -range; xx < range; ++xx) {
                for (int yy = -32; yy < 8; ++yy) {
                    for (int zz = -range; zz < range; ++zz) {
                        BlockPos pos = new BlockPos(x + xx, y + yy, z + zz);
                        this.field_70170_p.func_175719_a(null, pos, EnumFacing.UP);
                        IBlockState block = this.field_70170_p.func_180495_p(pos);
                        if (block != Blocks.field_150343_Z.func_176223_P()) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
                    }
                }
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityMonolithEye.class, (IRenderFactory)new IRenderFactory<EntityMonolithEye>(){

            public Render<EntityMonolithEye> createRenderFor(RenderManager manager) {
                return new RenderMonolithEye(manager);
            }
        });
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (entityIn instanceof EntityLivingBase) {
            float damage = 6.0f;
            DamageSource ds = DamageSource.func_76354_b((Entity)this, (Entity)this);
            this.func_70656_aK();
            entityIn.func_70097_a(ds, damage);
            entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!this.field_70170_p.field_72995_K) {
                Vec3d velocityVector = new Vec3d(entityIn.field_70165_t - this.field_70165_t, entityIn.field_70163_u - this.field_70163_u, entityIn.field_70161_v - this.field_70161_v);
                entityIn.func_70024_g(velocityVector.field_72450_a, velocityVector.field_72448_b, velocityVector.field_72449_c);
                entityIn.field_70133_I = true;
            }
        }
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityMonolithEye.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)16724004, (int)14735033);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
    }

    protected SoundEvent func_184639_G() {
        EntityLivingBase entitylivingbase = this.func_70638_az();
        if (entitylivingbase != null) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 1.0f, 0.7f + this.field_70146_Z.nextFloat() / 100.0f);
        }
        return SoundEvents.field_187529_aS;
    }

    protected SoundEvent getHurtSound() {
        EntityLivingBase entitylivingbase = this.func_70643_av();
        if (entitylivingbase != null) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, SoundEvents.field_187526_aP, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 100.0f);
        }
        return SoundEvents.field_187526_aP;
    }

    protected SoundEvent func_184615_bR() {
        EntityLivingBase entitylivingbase = this.func_70643_av();
        if (entitylivingbase != null) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, SoundEvents.field_187522_aL, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 100.0f);
        }
        return SoundEvents.field_187522_aL;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() != null) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (this.field_70173_aa % 25 == 0) {
            List crystals;
            EntityPlayer p;
            List e;
            Iterator iterator;
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.func_70638_az() != null) {
                this.spawnAuraParticle();
                this.field_70170_p.func_72960_a((Entity)this, (byte)16);
                if (!this.func_70638_az().func_70089_S()) {
                    this.func_70624_b(null);
                    return;
                }
            }
            if ((iterator = (e = this.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(88.0, 64.0, 88.0), (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer entity) {
                    return true;
                }
            })).iterator()).hasNext() && this.func_70032_d((Entity)(p = (EntityPlayer)iterator.next())) < 88.0f) {
                this.func_70624_b((EntityLivingBase)p);
            }
            if ((crystals = this.field_70170_p.func_72872_a(EntityEnderCrystal.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(96.0, 64.0, 96.0))).size() < 1) {
                if (this.func_190530_aW()) {
                    this.func_70656_aK();
                    this.field_70170_p.func_72960_a((Entity)this, (byte)15);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187522_aL, this.func_184176_by(), 1.0f, 1.0f);
                    if (this.func_70638_az() != null) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_187522_aL, this.func_184176_by(), 1.0f, 1.0f);
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_187539_bB, this.func_184176_by(), 1.0f, 1.0f);
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_193777_bb, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 32.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 32.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 32.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 32.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 32.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 32.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 32.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 32.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 32.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 32.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 32.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 32.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, this.field_70163_u - (double)(this.field_70146_Z.nextFloat() * 16.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0, false));
                }
                this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
                this.func_184224_h(false);
            } else {
                this.bossInfo.func_186745_a(BossInfo.Color.WHITE);
                this.func_184224_h(true);
            }
            int current = this.crystalsDestroyed;
            this.crystalsDestroyed = MathHelper.func_76125_a((int)(12 - crystals.size()), (int)0, (int)12);
            if (current != this.crystalsDestroyed && this.func_70638_az() != null) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187522_aL, this.func_184176_by(), 1.0f, 1.0f);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_187526_aP, this.func_184176_by(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() / 50.0f);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_193777_bb, this.func_184176_by(), 1.0f, 1.0f);
            }
        }
        if (this.getRaidLocationY() != 0) {
            this.func_70107_b(this.getRaidLocationX().intValue(), this.getRaidLocationY().intValue(), this.getRaidLocationZ().intValue());
        }
        if (this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) {
            return;
        }
        double d0 = this.func_70032_d((Entity)this.func_70638_az());
        if (d0 <= 22.0) {
            this.func_82167_n((Entity)this.func_70638_az());
        }
        if (d0 <= 88.0) {
            int attackTimer = this.field_70173_aa % 132;
            if (attackTimer == 28) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_187525_aO, this.func_184176_by(), 1.0f, 1.2f);
            } else if (attackTimer == 30 && this.crystalsDestroyed >= 8 || attackTimer == 40 || attackTimer == 50 && this.crystalsDestroyed >= 4 || attackTimer == 60 && this.crystalsDestroyed >= 1 || attackTimer == 70 && this.crystalsDestroyed >= 12) {
                Vec3d vec3d = this.func_70676_i(1.0f);
                double d2 = this.func_70638_az().field_70165_t - (this.field_70165_t + vec3d.field_72450_a) + this.field_70146_Z.nextGaussian() * ((double)this.crystalsDestroyed / 8.0);
                double d3 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)this.func_70638_az().field_70131_O - (this.field_70163_u + (double)this.field_70131_O / 9.0) + this.field_70146_Z.nextGaussian() * ((double)this.crystalsDestroyed / 12.0) - 3.0;
                double d4 = this.func_70638_az().field_70161_v - (this.field_70161_v + vec3d.field_72449_c) + this.field_70146_Z.nextGaussian() * ((double)this.crystalsDestroyed / 8.0);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, SoundEvents.field_187527_aQ, this.func_184176_by(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 25.0f);
                EntityLargeFireball entitylargefireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
                entitylargefireball.field_92057_e = 2;
                entitylargefireball.field_70165_t = this.field_70165_t - vec3d.field_72450_a * 2.0;
                entitylargefireball.field_70163_u = this.field_70163_u - vec3d.field_72448_b * 2.0;
                entitylargefireball.field_70161_v = this.field_70161_v - vec3d.field_72449_c * 2.0;
                this.field_70170_p.func_72838_d((Entity)entitylargefireball);
            }
        } else {
            this.func_70624_b(null);
            return;
        }
    }

    public void spawnAuraParticle() {
        if (this.func_70638_az() != null && this.field_70170_p instanceof WorldServer) {
            for (int i = 16; i > 0; --i) {
                ((WorldServer)this.field_70170_p).func_175688_a(EnumParticleTypes.PORTAL, this.func_70638_az().field_70165_t + this.field_70146_Z.nextGaussian() * 0.06999999523162842, this.func_70638_az().field_70163_u + this.field_70146_Z.nextGaussian() * 0.20999999523162843, this.func_70638_az().field_70161_v + this.field_70146_Z.nextGaussian() * 0.06999999523162842, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, new int[0]);
            }
        }
    }

    public void spawnAttackParticles() {
        if (this.field_70170_p instanceof WorldServer) {
            for (int i = 16; i > 0; --i) {
                ((WorldServer)this.field_70170_p).func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + this.field_70146_Z.nextGaussian() * 2.05, this.field_70163_u + this.field_70146_Z.nextGaussian() * 2.05, this.field_70161_v + this.field_70146_Z.nextGaussian() * 2.05, this.field_70146_Z.nextGaussian() * 2.05, this.field_70146_Z.nextGaussian() * 2.05, this.field_70146_Z.nextGaussian() * 2.05, new int[0]);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public float func_70047_e() {
        return 16.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(88.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_190530_aW()) {
            this.func_184185_a(SoundEvents.field_187529_aS, 0.8f, 0.7f + this.field_70146_Z.nextFloat() / 25.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 0.8f, 0.7f + this.field_70146_Z.nextFloat() / 25.0f);
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_180431_b(source) || source == DamageSource.field_76379_h || source == null || source.func_76346_g() == null || !this.func_70089_S()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase && super.func_70097_a(source, amount)) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, source.func_76346_g().field_70165_t, source.func_76346_g().field_70163_u, source.func_76346_g().field_70161_v, SoundEvents.field_187525_aO, this.func_184176_by(), 1.0f, 1.4f);
            this.field_70170_p.func_184148_a((EntityPlayer)null, source.func_76346_g().field_70165_t, source.func_76346_g().field_70163_u, source.func_76346_g().field_70161_v, SoundEvents.field_187526_aP, this.func_184176_by(), 1.0f, 1.2f);
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            if ((damageAmount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            damageAmount = this.func_70655_b(damageSrc, damageAmount);
            float f = damageAmount = this.func_70672_c(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - damageAmount));
            damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount);
            if (damageAmount != 0.0f) {
                float f1 = this.func_110143_aJ();
                this.func_110142_aN().func_94547_a(damageSrc, f1, damageAmount);
                this.func_70606_j(f1 - damageAmount);
                this.func_110149_m(this.func_110139_bj() - damageAmount);
            }
        }
    }

    protected void redirectAttack(DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        if (attacker != null) {
            attacker.func_70097_a(source, amount);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void dropBossLoot() {
        this.dropTrophy();
        this.dropLootItem(Item.func_111206_d((String)"minecraft:obsidian"), this.field_70146_Z.nextInt(3) + 1);
        this.dropLootItem(Item.func_111206_d((String)"minecraft:obsidian"), this.field_70146_Z.nextInt(3) + 1);
        this.dropLootItem(Item.func_111206_d((String)"minecraft:obsidian"), this.field_70146_Z.nextInt(3) + 1);
        this.dropLootItem(Item.func_111206_d((String)"minecraft:obsidian"), this.field_70146_Z.nextInt(3) + 1);
        this.dropLootItem(Item.func_111206_d((String)"minecraft:obsidian"), this.field_70146_Z.nextInt(3) + 1);
        this.dropLootItem(Item.func_111206_d((String)"minecraft:obsidian"), this.field_70146_Z.nextInt(3) + 1);
    }

    private void dropTrophy() {
        ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:trophy_beholder"));
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, stack.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = 0.5;
        dropItem.field_70179_y = 0.0;
        dropItem.field_70159_w = 0.0;
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
            dropItem.func_184195_f(true);
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        RAID_X = EntityDataManager.func_187226_a(EntityMonolithEye.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Y = EntityDataManager.func_187226_a(EntityMonolithEye.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Z = EntityDataManager.func_187226_a(EntityMonolithEye.class, (DataSerializer)DataSerializers.field_187192_b);
    }

    static class MonolithEyeTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityMonolithEye parentEntity;

        public MonolithEyeTargetSelector(EntityMonolithEye guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable EntityLivingBase e) {
            return e instanceof EntityLivingBase && e.func_70068_e((Entity)this.parentEntity) > 512.0;
        }
    }
}

