/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public class EntityMage
extends EntityMob
implements IRangedAttackMob,
IMob {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.func_187226_a(EntityMage.class, (DataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private int staffTimer;
    public static String NAME = "mage";
    private static final DataParameter<Boolean> STAFF_ATTACK;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityMage.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)16724004, (int)14735033);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public EntityMage(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 360;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropLoot();
            this.achievement(cause);
        }
    }

    public boolean func_174833_aM() {
        return false;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected void achievement(DamageSource cause) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = cause.func_76346_g();
        if (entity == null || entity instanceof EntityPlayer) {
            // empty if block
        }
    }

    private void dropLoot() {
        this.dropTrophy();
        this.dropLootItem(Items.field_151102_aT, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151016_H, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151069_bo, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151166_bC, this.field_70146_Z.nextInt(10));
        this.dropLootItem(Items.field_151114_aO, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151137_ax, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151075_bm, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151055_y, this.field_70146_Z.nextInt(10));
        this.dropLootItem(Items.field_151122_aG, 1);
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    private void dropTrophy() {
        ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:trophy_archmage"));
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = 0.25;
        dropItem.field_70179_y = 0.0;
        dropItem.field_70159_w = 0.0;
        this.field_70170_p.func_72838_d((Entity)dropItem);
        dropItem.func_184195_f(true);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 16, 10.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_AGGRESSIVE, (Object)false);
        this.field_70180_af.func_187214_a(STAFF_ATTACK, (Object)false);
        this.field_70178_ae = true;
    }

    public boolean isStaffAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(STAFF_ATTACK);
    }

    private void setStaffAttacking(boolean b) {
        this.staffTimer = b ? 1 : 0;
        this.field_70180_af.func_187227_b(STAFF_ATTACK, (Object)b);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_191246_bp;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    public void setAggressive(boolean aggressive) {
        this.func_184212_Q().func_187227_b(IS_AGGRESSIVE, (Object)aggressive);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AGGRESSIVE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
    }

    public void func_70636_d() {
        this.updateLogic();
        super.func_70636_d();
    }

    protected void updateLogic() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 25 == 0) {
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        if (this.isDrinkingPotion()) {
            this.handleDrinkingPotionUpdate();
        } else {
            this.handleAttackLogicUpdate();
        }
        if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        }
        if (this.staffTimer > 0) {
            ++this.staffTimer;
            if (this.staffTimer > 20) {
                this.setStaffAttacking(false);
            }
        }
    }

    protected void handleAttackLogicUpdate() {
        PotionType potiontype = null;
        if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
            potiontype = PotionTypes.field_185248_t;
        } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70027_ad() && !this.func_70644_a(MobEffects.field_76426_n)) {
            potiontype = PotionTypes.field_185241_m;
        } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
            potiontype = PotionTypes.field_185250_v;
        } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
            potiontype = PotionTypes.field_185243_o;
        }
        if (potiontype != null) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
            this.attackTimer = 10;
            this.setAggressive(true);
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(MODIFIER);
            iattributeinstance.func_111121_a(MODIFIER);
        }
    }

    protected void handleDrinkingPotionUpdate() {
        if (this.attackTimer-- <= 0) {
            List list;
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.setAggressive(false);
            ItemStack itemstack = this.func_184592_cb();
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151068_bn && (list = PotionUtils.func_185189_a((ItemStack)itemstack)) != null) {
                for (PotionEffect potioneffect : list) {
                    this.func_70690_d(new PotionEffect(potioneffect));
                }
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 15) {
            this.spawnWitchParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnWitchParticles() {
        for (int i = 0; i < this.field_70146_Z.nextInt(35) + 10; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.13f, this.func_174813_aQ().field_72337_e + 0.5 + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (source.func_82725_o()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        if (this.isDrinkingPotion()) {
            return;
        }
        int roll = this.field_70146_Z.nextInt(100);
        this.setStaffAttacking(true);
        if (roll < 60) {
            this.attackWithPotion(target);
        } else if (roll < 90) {
            if (this.func_70068_e((Entity)target) > 16.0 && this.field_70146_Z.nextInt(100) > 60) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, false));
            } else {
                this.attackWithForce(target);
            }
        } else {
            this.attackWithMobSpawn(target);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    private void attackWithMobSpawn(EntityLivingBase target) {
        int roll = this.field_70146_Z.nextInt(100);
        Object mob = null;
        mob = roll < 45 ? new EntitySkeleton(this.field_70170_p) : (roll < 90 ? new EntityZombie(this.field_70170_p) : new EntityWitch(this.field_70170_p));
        mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac, 1));
        mob.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)mob);
    }

    private void attackWithForce(EntityLivingBase target) {
        this.setStaffAttacking(true);
        double force = 8.0;
        double relX = target.field_70165_t - this.field_70165_t;
        double relZ = target.field_70161_v - this.field_70161_v;
        double mag = Math.sqrt(relX * relX + relZ * relZ);
        double forceX = force * (relX / mag);
        double forceZ = force * (relZ / mag);
        target.func_70024_g(forceX, 1.0, forceZ);
        target.field_70133_I = true;
        this.func_184185_a(SoundEvents.field_187524_aN, 2.0f, 0.5f);
    }

    protected void attackWithPotion(EntityLivingBase target) {
        double targetY = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double targetX = target.field_70165_t + target.field_70159_w - this.field_70165_t;
        double d2 = targetY - this.field_70163_u;
        double targetZ = target.field_70161_v + target.field_70179_y - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
        PotionType potiontype = PotionTypes.field_185252_x;
        if (f >= 8.0f && !target.func_70644_a(MobEffects.field_76421_d)) {
            potiontype = PotionTypes.field_185246_r;
        } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
            potiontype = PotionTypes.field_185254_z;
        } else if (f <= 3.0f && !target.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            potiontype = PotionTypes.field_185226_I;
        }
        EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
        entitypotion.field_70125_A -= -20.0f;
        entitypotion.func_70186_c(targetX, d2 + (double)(f * 0.2f), targetZ, 0.75f, 8.0f);
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        this.field_70170_p.func_72838_d((Entity)entitypotion);
    }

    protected void attackWithArrow(EntityLivingBase target) {
        int charge = 2 + this.field_70146_Z.nextInt(10);
        EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        entityarrow.func_70239_b((double)((float)charge * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (this.field_70146_Z.nextBoolean()) {
            entityarrow.func_70015_d(100);
        }
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public float func_70047_e() {
        return 1.62f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (source instanceof EntityDamageSourceIndirect) {
            this.redirectArrowAtAttacker(source);
            return false;
        }
        amount = this.redirectAttack(source, amount);
        return super.func_70097_a(source, amount);
    }

    protected float redirectAttack(DamageSource source, float amount) {
        float reflectFactor = this.field_70146_Z.nextFloat();
        float reflectAmount = amount * reflectFactor;
        float passAmount = amount - reflectAmount;
        reflectAmount *= ToroQuestConfiguration.bossAttackDamageMultiplier;
        Entity attacker = source.func_76346_g();
        if (attacker != null) {
            attacker.func_70097_a(source, reflectAmount);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        return passAmount;
    }

    protected void redirectArrowAtAttacker(DamageSource source) {
        if ("arrow".equals(source.func_76355_l())) {
            if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                this.attackWithArrow((EntityLivingBase)source.func_76346_g());
            }
            if (source.func_76364_f() != null) {
                source.func_76364_f().func_70106_y();
            }
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        STAFF_ATTACK = EntityDataManager.func_187226_a(EntityMage.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

