/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestCaptureEntity;
import net.torocraft.toroquest.civilization.quests.QuestCaptureFugitives;
import net.torocraft.toroquest.civilization.quests.QuestRecruit;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.AIArcher;
import net.torocraft.toroquest.entities.AIAttackWithSword;
import net.torocraft.toroquest.entities.EntityCaravan;
import net.torocraft.toroquest.entities.EntityConstruct;
import net.torocraft.toroquest.entities.EntityFugitive;
import net.torocraft.toroquest.entities.EntitySmartArrow;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.EntityToroVillager;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAINearestAttackableBanditTarget;
import net.torocraft.toroquest.entities.ai.EntityAINearestAttackableCivTarget;
import net.torocraft.toroquest.entities.ai.EntityAISmartTempt;
import net.torocraft.toroquest.entities.render.RenderGuard;

public class EntityGuard
extends EntityToroNpc
implements IRangedAttackMob {
    protected float strafeVer = 0.0f;
    protected int stance = this.field_70146_Z.nextInt(8) + 3;
    protected int blockingTimer = 0;
    protected int lastTargetY = 0;
    public boolean canShieldPush = true;
    protected boolean postReady = true;
    protected boolean blocking = false;
    public boolean spawnedNearBandits = false;
    public boolean searchNextEnemy = true;
    public boolean wildernessGuardSpeak = true;
    public boolean interactTalkReady = true;
    public static DataParameter<String> PLAYER_GUARD = EntityDataManager.func_187226_a(EntityGuard.class, (DataSerializer)DataSerializers.field_187194_d);
    protected final AIArcher<EntityGuard> aiArrowAttack = new AIArcher<EntityGuard>(this, 0.6, 40, 36.0f);
    public static String NAME = "guard";
    public int aggroTimer = 0;
    private Village village = null;
    private VillageDoorInfo doorInfo = null;

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PLAYER_GUARD, (Object)String.valueOf(""));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityGuard.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)1, (boolean)true, (int)5256486, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGuard.class, (IRenderFactory)new IRenderFactory<EntityGuard>(){

            public Render<EntityGuard> createRenderFor(RenderManager manager) {
                return new RenderGuard(manager);
            }
        });
    }

    public void func_70031_b(boolean b) {
        if (this.func_70638_az() != null) {
            this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
        }
        super.func_70031_b(b);
    }

    public String getChatName() {
        return "Guard";
    }

    public boolean func_145818_k_() {
        if (this.actionTimer <= 3 || this.func_95999_t() == null || this.func_95999_t().equals("...") || this.func_95999_t().equals(this.getChatName())) {
            this.func_174805_g(false);
            return false;
        }
        this.func_174805_g(true);
        return true;
    }

    public EntityGuard(World worldIn, Province prov) {
        super(worldIn);
        this.func_110163_bv();
        this.pledgeAllegiance(prov);
        this.func_96094_a("...");
        this.func_174805_g(true);
        this.setCombatTask();
    }

    public EntityGuard(World worldIn, Province prov, int x, int y, int z) {
        this(worldIn, prov);
        this.setRaidLocation(x, y, z);
    }

    public EntityGuard(World worldIn) {
        this(worldIn, null);
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    public float func_70047_e() {
        return 1.94f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ToroQuestConfiguration.guardBaseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.guardAttackDamage);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)ToroQuestConfiguration.guardArmor);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)ToroQuestConfiguration.guardArmorToughness);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.39);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
    }

    @Override
    protected float func_189749_co() {
        return this.func_184587_cr() ? 0.81f : 0.92f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISmartTempt(this, 0.6, Item.func_111206_d((String)"toroquest:recruitment_papers")){

            @Override
            public boolean func_75250_a() {
                if (!EntityGuard.this.isFriendly(this.temptingPlayer) || EntityGuard.this.inCombat() || EntityGuard.this.isAnnoyed() || EntityGuard.this.underAttackTimer > 0 || EntityGuard.this.func_70027_ad()) {
                    return false;
                }
                return super.func_75250_a();
            }

            @Override
            public boolean isTempting(ItemStack stack) {
                if (EntityGuard.this.getCivilization() == null && EntityGuard.this.getRaidLocationY() != 0) {
                    return true;
                }
                return super.isTempting(stack);
            }
        });
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f){

            public boolean func_75250_a() {
                if (!EntityGuard.this.func_70661_as().func_75500_f() || EntityGuard.this.func_70638_az() != null) {
                    return false;
                }
                if (EntityGuard.this.actionTimer > 3 && EntityGuard.this.talkingWith != null) {
                    this.field_75334_a = EntityGuard.this.talkingWith;
                    return true;
                }
                if (this.field_75332_b.func_70681_au().nextFloat() >= 0.05f) {
                    return false;
                }
                if (this.field_75332_b.func_70638_az() != null) {
                    this.field_75334_a = this.field_75332_b.func_70638_az();
                    return true;
                }
                this.field_75334_a = this.field_75332_b.field_70170_p.func_190525_a(this.field_75332_b.field_70165_t, this.field_75332_b.field_70163_u, this.field_75332_b.field_70161_v, (double)this.field_75333_c, Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)EntitySelectors.func_191324_b((Entity)this.field_75332_b)));
                if (this.field_75334_a != null) {
                    return true;
                }
                this.field_75334_a = this.field_75332_b.field_70170_p.func_72857_a(EntityVillager.class, this.field_75332_b.func_174813_aQ().func_72314_b((double)this.field_75333_c, 3.0, (double)this.field_75333_c), (Entity)this.field_75332_b);
                return this.field_75334_a != null;
            }

            public boolean func_75253_b() {
                if (EntityGuard.this.talkingWith == null) {
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableCivTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableBanditTarget(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 100 == 0) {
            this.pledgeAllegianceIfUnaffiliated(false);
            this.func_70031_b(false);
            super.func_85033_bc();
            if (!this.actionReady()) {
                --this.actionTimer;
                if (this.actionTimer <= 3) {
                    this.interactTalkReady = true;
                    this.func_96094_a("...");
                    this.func_174805_g(false);
                    this.talkingWith = null;
                }
            } else {
                this.func_96094_a("...");
                this.func_174805_g(false);
            }
            if (!(this.func_110143_aJ() >= this.func_110138_aP())) {
                this.func_70691_i(1.0f);
            }
            this.postReady = true;
            if (this.isAnnoyed()) {
                --this.isAnnoyedTimer;
            } else {
                this.annoyedAt = null;
            }
            if (this.underAttackTimer > 0 && --this.underAttackTimer < 1) {
                this.underAttack = null;
                if (this.func_70638_az() instanceof EntityPlayer && this.murderWitness() != this.func_70638_az()) {
                    this.blocking = false;
                    this.blockingTimer = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
                    this.canShieldPush = true;
                    this.func_184602_cy();
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                    if (this.getCivilization() != null && this.func_70032_d((Entity)this.func_70638_az()) <= 10.0f && PlayerCivilizationCapabilityImpl.get((EntityPlayer)this.func_70638_az()).getReputation(this.getCivilization()) > -50) {
                        this.chat((EntityPlayer)this.func_70638_az(), "dropplayeraggro", "House " + this.getCivilization().getDisplayName((EntityPlayer)this.func_70638_az()));
                        List guards = this.func_70638_az().field_70170_p.func_175647_a(EntityGuard.class, new AxisAlignedBB(this.func_70638_az().func_180425_c()).func_72314_b(48.0, 20.0, 48.0), (Predicate)new Predicate<EntityGuard>(){

                            public boolean apply(@Nullable EntityGuard entity) {
                                return true;
                            }
                        });
                        for (EntityGuard guard : guards) {
                            if (guard.func_70638_az() != this.func_70638_az()) continue;
                            guard.func_70624_b(null);
                        }
                    }
                    this.strafeVer = 0.0f;
                    this.stance = 0;
                    this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                    this.func_70661_as().func_75499_g();
                    this.func_70624_b(null);
                    this.returningToPost = this.returnToPost();
                    this.isAnnoyedTimer = 0;
                    return;
                }
            }
            if (this.murderTimer > 0 && this.field_70146_Z.nextBoolean() && --this.murderTimer < 1) {
                this.murderWitness = null;
            }
            if (!this.inCombat) {
                this.func_70031_b(false);
                this.aggroTimer = 0;
                ItemStack iStack = this.func_184614_ca();
                Item lantern = Item.func_111206_d((String)ToroQuestConfiguration.lanternResourceName);
                if (lantern == null) {
                    lantern = Item.func_150898_a((Block)Blocks.field_150478_aa);
                }
                if (this.func_70638_az() == null) {
                    if (this.lastTargetY < 4 && iStack != null && iStack.func_77973_b() instanceof ItemBow) {
                        this.func_184602_cy();
                        this.func_184185_a(SoundEvents.field_187725_r, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                        if (!this.field_70170_p.field_72995_K) {
                            this.setMeleeWeapon();
                            if (this.field_70170_p.func_175678_i(this.func_180425_c()) && this.field_70170_p.func_72820_D() >= 12500L && this.field_70170_p.func_72820_D() <= 23500L) {
                                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(lantern, 1));
                            }
                        }
                        this.blockingTimer = 0;
                    } else if (this.field_70170_p.func_175678_i(this.func_180425_c()) && !(iStack.func_77973_b() instanceof ItemBow) && this.field_70170_p.func_72820_D() >= 12500L && this.field_70170_p.func_72820_D() <= 23500L) {
                        if (iStack.func_77973_b() != lantern) {
                            this.func_184602_cy();
                            this.func_184185_a(SoundEvents.field_187725_r, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                            if (!this.field_70170_p.field_72995_K) {
                                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(lantern, 1));
                            }
                            this.blockingTimer = 0;
                        }
                    } else if (iStack.func_77973_b() == lantern) {
                        this.func_184602_cy();
                        this.func_184185_a(SoundEvents.field_187725_r, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                        if (!this.field_70170_p.field_72995_K) {
                            this.setMeleeWeapon();
                        }
                    }
                    if (this.underAttackTimer < 1) {
                        this.hitSafety = true;
                        if (this.getOutOfWater()) {
                            this.returningToPost = false;
                        }
                        if (this.avoidNear()) {
                            this.returningToPost = false;
                        } else if (this.speakWithVillagers()) {
                            this.returningToPost = false;
                        } else if (this.actionTimer <= 3 && !this.isAnnoyed() && this.murderTimer <= 0) {
                            int d = 20 - this.getDistance(this.getRaidLocationX().intValue(), this.getRaidLocationZ().intValue());
                            if (this.returningToPost || d < 1 || this.field_70146_Z.nextInt(d) == 0) {
                                this.returningToPost = this.returnToPost();
                            } else if (this.wanderVillage()) {
                                this.returningToPost = false;
                            }
                        }
                    }
                }
            } else if (this.func_70638_az() != null) {
                if (this.aggroTimer++ > 3 && !this.func_184587_cr() && Math.abs(this.field_70163_u - this.func_70638_az().field_70163_u) * 3.0 >= (double)this.func_70032_d((Entity)this.func_70638_az()) && !this.func_70685_l((Entity)this.func_70638_az()) || this.aggroTimer > 5) {
                    if (this.func_70638_az() instanceof EntityLiving) {
                        ((EntityLiving)this.func_70638_az()).func_70624_b(null);
                    }
                    this.func_70624_b(null);
                    this.returningToPost = this.returnToPost();
                    this.searchNextEnemy = false;
                    this.aggroTimer = 0;
                } else {
                    this.callForHelp(this.func_70638_az());
                }
            } else {
                this.inCombat = false;
                this.aggroTimer = 0;
            }
            if (this.getCivilization() == null && !this.isPlayerGuard() && this.field_70170_p.func_72820_D() % 22000L == 0L && this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0)).isEmpty()) {
                this.func_70606_j(0.0f);
                this.func_70106_y();
                return;
            }
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            if (this.func_70051_ag()) {
                this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
            } else {
                this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            List arrows = this.field_70170_p.func_175647_a(EntityArrow.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(8.0, 8.0, 8.0), (Predicate)new Predicate<EntityArrow>(){

                public boolean apply(@Nullable EntityArrow entity) {
                    return entity.field_70142_S == 0.0 && entity.field_70250_c == EntityGuard.this.func_70638_az();
                }
            });
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (!arrows.isEmpty()) {
                this.stance = this.field_70146_Z.nextInt(6) + 5;
                this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
                this.blockingTimer = dist <= 12.0 ? 25 : 50;
                this.blocking = true;
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                this.canShieldPush = true;
                this.func_184602_cy();
                this.func_184598_c(EnumHand.OFF_HAND);
                this.func_184608_ct();
                this.strafeVer = 0.4f;
            }
            this.lastTargetY = (int)(Math.abs(this.field_70163_u - this.func_70638_az().field_70163_u) + 0.5);
            ItemStack iStack = this.func_184614_ca();
            if (!this.inCombat) {
                this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                this.func_70661_as().func_75499_g();
                this.canShieldPush = true;
                this.func_184602_cy();
                this.inCombat = true;
                this.stance = this.field_70146_Z.nextInt(6) + 5;
                this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
                if (this.field_70122_E && this.func_70661_as().func_75494_a((Entity)this.func_70638_az()) == null) {
                    this.blockingTimer = -200;
                } else {
                    this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                    this.func_70661_as().func_75499_g();
                }
            }
            if (dist < (double)(200 + this.blockingTimer) || this.lastTargetY < 4 && dist <= 20.0 && this.func_70685_l((Entity)this.func_70638_az())) {
                if (iStack != null && (iStack.func_77973_b() instanceof ItemBow || iStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa))) {
                    this.canShieldPush = true;
                    this.func_184602_cy();
                    this.func_184185_a(SoundEvents.field_187725_r, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 10.0f);
                    this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                    this.func_70661_as().func_75499_g();
                    if (!this.field_70170_p.field_72995_K) {
                        this.setMeleeWeapon();
                    }
                    this.blockingTimer = 0;
                }
                if (!this.blocking && !this.func_70051_ag() && dist <= 12.0 && this.blockingTimer <= -((int)((double)(this.stance * 5) + dist + 20.0)) && this.func_70643_av() != null && this.func_70643_av().func_70089_S()) {
                    this.stance = this.field_70146_Z.nextInt(8) + 3;
                    this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
                    this.blockingTimer = (int)MathHelper.func_151237_a((double)((double)(this.field_70146_Z.nextInt(70) + 20) - dist), (double)20.0, (double)80.0);
                    this.blocking = true;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                    this.canShieldPush = true;
                    this.func_184602_cy();
                    this.func_184598_c(EnumHand.OFF_HAND);
                    this.func_184608_ct();
                    this.strafeVer = dist <= 6.0 ? 0.2f : 0.4f;
                } else if (this.blocking && this.blockingTimer % 16 == 0) {
                    this.canShieldPush = true;
                    this.strafeVer = dist <= 3.0 ? 0.2f : 0.4f;
                }
                if (this.blocking && this.blockingTimer <= 0) {
                    this.blocking = false;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
                    this.stance = this.field_70146_Z.nextInt(8) + 3;
                    this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
                    this.canShieldPush = true;
                    this.func_184602_cy();
                } else if (!this.blocking && dist <= 64.0 && (this.blockingTimer == -12 || this.blockingTimer == -32 || this.blockingTimer < -32 && this.blockingTimer % 14 == 0) && this.field_70146_Z.nextInt(3) == 0) {
                    this.stance = this.field_70146_Z.nextInt(8) + 3;
                    this.lookWhereMoving(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
                }
                if (!this.blocking) {
                    float strafeMod = 1.0f;
                    if (this.stance < 5) {
                        this.func_70031_b(false);
                        if (dist <= 32.0 && dist > 2.0) {
                            Vec3d velocityVector;
                            if (this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                                double push = 1.0 + 3.7 * dist;
                                this.func_70024_g(velocityVector.field_72450_a / push, -0.002, velocityVector.field_72449_c / push);
                                this.field_70133_I = true;
                            }
                            this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)0.4f);
                            this.func_70605_aq().func_188488_a(-1.0f, this.getStrafe(this.stance));
                        } else {
                            this.stance = this.field_70146_Z.nextInt(6) + 5;
                            this.func_70661_as().func_75499_g();
                            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                        }
                        if (this.field_70146_Z.nextBoolean()) {
                            --this.blockingTimer;
                        }
                        return;
                    }
                    if (dist <= 2.0) {
                        this.strafeVer = 0.4f;
                    } else if (dist <= 4.0) {
                        this.strafeVer = 0.8f;
                        strafeMod = 0.9f;
                    } else if (dist <= 9.0) {
                        this.strafeVer = 0.9f;
                        strafeMod = 0.8f;
                    } else {
                        this.strafeVer = 1.0f;
                        strafeMod = 0.7f;
                    }
                    if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                        Vec3d velocityVector;
                        if (dist >= 12.0) {
                            --this.blockingTimer;
                        } else if (dist <= 1.5) {
                            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                            this.func_70661_as().func_75499_g();
                        } else if (dist <= 3.0 && this.field_70122_E && !this.func_70051_ag() && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + dist * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                        if (this.field_70163_u + 1.5 < this.func_70638_az().field_70163_u) {
                            this.func_70605_aq().func_188488_a(this.strafeVer, 0.0f);
                            if (this.field_70122_E && this.field_70146_Z.nextInt(10) == 0) {
                                this.func_70024_g(0.0, 0.38, 0.0);
                                this.field_70133_I = true;
                            }
                        } else {
                            this.func_70605_aq().func_188488_a(this.strafeVer, this.getStrafe(this.stance) * strafeMod);
                        }
                    } else {
                        this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                        if (this.field_70122_E && !this.field_70160_al) {
                            this.func_70661_as().func_75499_g();
                        }
                    }
                } else {
                    if (this.strafeVer < 0.4f) {
                        Vec3d velocityVector;
                        if (!this.field_70170_p.field_72995_K && this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + dist * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                    } else if (this.strafeVer > 0.4f) {
                        this.strafeVer = 0.4f;
                    }
                    if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                        this.func_70605_aq().func_188488_a(this.strafeVer, this.getStrafe(this.stance) * 1.5f);
                    } else {
                        this.func_70605_aq().func_188488_a(this.strafeVer * 0.5f, this.getStrafe(this.stance) * 0.5f);
                    }
                }
            } else if (iStack != null && !(iStack.func_77973_b() instanceof ItemBow)) {
                EntityLiving v;
                if (!this.field_70122_E) {
                    this.field_70159_w /= 2.0;
                    this.field_70179_y /= 2.0;
                }
                if (this.func_70638_az() instanceof EntityPlayer) {
                    this.setAnnoyed((EntityPlayer)this.func_70638_az());
                } else if (ToroQuestConfiguration.mobsAttackGuards && this.func_70638_az() instanceof EntityLiving && (v = (EntityLiving)this.func_70638_az()).func_70638_az() == null) {
                    v.func_70624_b((EntityLivingBase)this);
                }
                this.blocking = false;
                this.blockingTimer = -200;
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
                this.canShieldPush = true;
                this.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f, 1));
                    this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                }
                this.func_70604_c(this.func_70638_az());
                this.strafeVer = 0.0f;
                this.stance = 0;
                this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                this.func_70661_as().func_75499_g();
            }
            --this.blockingTimer;
        } else if (this.blocking || this.inCombat) {
            this.inCombat = false;
            this.blocking = false;
            this.func_70624_b(null);
            this.returningToPost = this.returnToPost();
            this.searchNextEnemy = true;
            this.canShieldPush = true;
            this.func_184602_cy();
            this.field_184628_bn = 0;
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
            this.stance = 0;
            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.func_70661_as().func_75499_g();
            this.aggroTimer = 0;
        }
    }

    public boolean func_70617_f_() {
        if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() instanceof ItemBow) {
            return false;
        }
        return super.func_70617_f_();
    }

    public float getStrafe(int stance) {
        switch (stance) {
            case 3: {
                return -0.32f;
            }
            case 4: {
                return 0.32f;
            }
            case 5: {
                return -0.31f;
            }
            case 6: {
                return 0.31f;
            }
            case 7: {
                return -0.3f;
            }
            case 8: {
                return 0.3f;
            }
            case 9: {
                return -0.29f;
            }
            case 10: {
                return 0.29f;
            }
        }
        return 0.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source == null) {
            return super.func_70097_a(source, amount);
        }
        if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source == DamageSource.field_76367_g) {
            return false;
        }
        if (source == DamageSource.field_76379_h) {
            if ((amount /= 2.0f) <= 2.0f) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }
        if (source.func_76346_g() == null) {
            if (this.field_70146_Z.nextBoolean()) {
                BlockPos pos = this.func_180425_c();
                IBlockState block = this.field_70170_p.func_180495_p(pos);
                if (block == Blocks.field_150353_l.func_176223_P() || block == Blocks.field_150356_k.func_176223_P()) {
                    Vec3d vec3d;
                    if (this.field_71093_bK == 0) {
                        this.func_184609_a(EnumHand.MAIN_HAND);
                        if (this.field_70181_x <= 0.1) {
                            this.func_70024_g(0.0, 0.3, 0.0);
                            this.field_70133_I = true;
                        }
                        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151131_as, 1));
                        this.field_70170_p.func_175656_a(pos.func_177984_a(), Blocks.field_150355_j.func_176223_P());
                    }
                    if ((vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)8, (int)4)) != null) {
                        this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65);
                    }
                } else if (block.func_177230_c() instanceof BlockFire) {
                    this.func_184609_a(EnumHand.MAIN_HAND);
                    this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
                    this.field_70170_p.func_175698_g(pos);
                } else if (this.field_70146_Z.nextBoolean()) {
                    this.func_70066_B();
                } else {
                    Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)8, (int)4);
                    if (vec3d != null) {
                        this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65);
                    }
                }
            }
            if (source.func_76347_k() || source.func_94541_c() || source.func_82725_o() || source.func_76352_a()) {
                return super.func_70097_a(source, amount);
            }
            return false;
        }
        if (source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityToroNpc || source.func_76346_g() instanceof EntityVillager) {
            return false;
        }
        this.aggroTimer = 0;
        if (source.func_76346_g() instanceof EntityPlayer) {
            if (source.func_76346_g().func_70005_c_().equals(this.getPlayerGuard())) {
                this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
                return false;
            }
            if (this.hitSafety && this.func_70638_az() != (EntityPlayer)source.func_76346_g()) {
                this.hitSafety = false;
                if (this.underAttackTimer < 1) {
                    this.underAttackTimer = 2;
                }
                this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
                return false;
            }
            if (this.func_70638_az() != source.func_76346_g() && this.func_70643_av() != source.func_76346_g() && !source.func_76346_g().func_130014_f_().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(3.0, 3.0, 3.0), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(@Nullable EntityLivingBase entity) {
                    return entity instanceof IMob || entity instanceof EntityMob;
                }
            }).isEmpty()) {
                return false;
            }
        }
        if (this.blocking && this.canBlockDamageSource(source)) {
            if (this.blockingTimer > 10 && this.field_70146_Z.nextBoolean()) {
                this.blockingTimer = 10;
            }
            double dist = source.func_76346_g().func_70068_e((Entity)this);
            if (!(source.func_76352_a() || source.func_82725_o() || source.func_76347_k())) {
                if (source.func_76346_g() instanceof EntityLivingBase) {
                    EntityLivingBase e = (EntityLivingBase)source.func_76346_g();
                    if (amount >= 5.0f && (e.func_184614_ca().func_77973_b() instanceof ItemAxe || e.func_184614_ca().func_77973_b().getRegistryName().toString().contains("halberd") || e.func_184614_ca().func_77973_b().getRegistryName().toString().contains("battleaxe"))) {
                        this.func_184602_cy();
                        this.field_70170_p.func_72960_a((Entity)this, (byte)29);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)30);
                        if (dist < 16.0) {
                            this.canShieldPush = true;
                            Vec3d velocityVector = new Vec3d(this.field_70165_t - e.field_70165_t, 0.0, this.field_70161_v - e.field_70161_v);
                            if (velocityVector != null) {
                                this.func_70024_g(velocityVector.field_72450_a / (dist + 1.0) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.2), (0.22 - MathHelper.func_151237_a((double)(dist / 100.0), (double)0.0, (double)0.16)) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.0), velocityVector.field_72449_c / (dist + 1.0) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.2));
                                this.field_70133_I = true;
                            }
                        }
                        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                        this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                        this.blockingTimer = 50;
                        return super.func_70097_a(source, amount / 2.0f);
                    }
                    this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                    if (dist < 16.0) {
                        if (this.canShieldPush) {
                            this.canShieldPush = false;
                            this.knockBackSmart(e, (float)(0.3 - dist / 100.0));
                        } else if (e.field_70122_E && !e.field_70160_al) {
                            this.knockBackSmart(e, 0.1f);
                        } else {
                            this.knockBackSmart(e, 0.0f);
                        }
                    }
                    this.field_70170_p.func_72960_a((Entity)this, (byte)29);
                    return false;
                }
            } else if (source.func_76352_a()) {
                this.blockingTimer = 8;
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
                this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                return false;
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
            }
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            if (this.field_70146_Z.nextInt(3) == 0 || this.func_70638_az() == null) {
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
            }
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
            this.callForHelp((EntityLivingBase)source.func_76346_g());
        }
        if (source.func_76346_g() instanceof EntityPlayer && super.func_70097_a(source, amount)) {
            this.adjustRep((Entity)((EntityPlayer)source.func_76346_g()), -((int)MathHelper.func_76131_a((float)(amount * 4.0f), (float)5.0f, (float)(this.func_110143_aJ() * 4.0f))));
            this.setUnderAttack((EntityPlayer)source.func_76346_g());
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && this.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = this.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public void knockBackSmart(EntityLivingBase entityIn, float strength) {
        try {
            Vec3d pos = this.func_174791_d();
            Vec3d targetPos = entityIn.func_174791_d();
            entityIn.func_70653_a((Entity)entityIn, strength, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
            entityIn.field_70133_I = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70624_b(EntityLivingBase e) {
        if (e == null || !e.func_70089_S()) {
            this.func_70031_b(false);
            super.func_70624_b(null);
            return;
        }
        if (e instanceof EntityPlayer) {
            if (this.isAnnoyedTimer < 4) {
                return;
            }
            if (!this.isAnnoyedAt((EntityPlayer)e)) {
                return;
            }
            if (e.func_70005_c_().equals(this.getPlayerGuard())) {
                this.func_70031_b(false);
                super.func_70624_b(null);
                return;
            }
            this.setAnnoyed((EntityPlayer)e);
            this.underAttack = (EntityPlayer)e;
            if (this.underAttackTimer <= 2) {
                this.underAttackTimer = 2 + this.field_70146_Z.nextInt(3);
            }
        }
        if (e.func_110143_aJ() <= 0.0f || !e.func_70089_S() || e instanceof EntityToroNpc || e instanceof EntityVillager || e instanceof EntityIronGolem) {
            this.func_70031_b(false);
            super.func_70624_b(null);
            return;
        }
        super.func_70624_b(e);
    }

    private void adjustRep(Entity entity, int amount) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        CivilizationType civ = this.getCivilization();
        if (civ == null) {
            return;
        }
        EventHandlers.adjustPlayerRep(player, civ, amount);
    }

    @Override
    public void onPledge(Province prov) {
        if (this.isPlayerGuard()) {
            this.setRaidLocation(prov.getCenterPosX() + this.field_70146_Z.nextInt(65) - 32, -1, prov.getCenterPosZ() + this.field_70146_Z.nextInt(55) - 32);
            for (EntityPlayer player : this.field_70170_p.field_73010_i) {
                try {
                    if (!this.isGuarding(player)) continue;
                    this.recruitGuard(player, prov, "civvillagerrecruit");
                }
                catch (Exception exception) {}
            }
            this.setPlayerGuard(null);
        } else if (this.field_70173_aa > 202) {
            this.setRaidLocation(prov.getCenterPosX() + this.field_70146_Z.nextInt(65) - 32, -1, prov.getCenterPosZ() + this.field_70146_Z.nextInt(65) - 32);
            List players = this.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(32.0, 16.0, 32.0), (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer entity) {
                    return true;
                }
            });
            for (EntityPlayer player : players) {
                try {
                    this.recruitGuard(player, prov, "civvillagerrecruit");
                }
                catch (Exception exception) {}
            }
        } else if (this.getRaidLocationX() == null || this.getRaidLocationZ() == null) {
            this.setRaidLocation(this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o(), this.func_180425_c().func_177952_p());
        }
    }

    public void recruitGuard(EntityPlayer player, Province prov, String chat) {
        if (player != null && prov != null) {
            EventHandlers.adjustPlayerRep(player, prov.getCiv(), ToroQuestConfiguration.recruitGuardRepGain);
            try {
                QuestRecruit.INSTANCE.onRecruit(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setPlayerGuard(null);
            this.playTameEffect(false);
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            this.chat(player, chat, prov.getCiv().getDisplayName(player));
            player.func_146105_b((ITextComponent)new TextComponentString("Guard Recruited!"), true);
            this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
            this.pledgeAllegianceIfUnaffiliated(false);
            if (!this.field_70170_p.field_72995_K) {
                this.setMeleeWeapon();
            }
        }
    }

    public boolean isPlayerGuard() {
        return !this.getPlayerGuard().equals("");
    }

    public boolean isGuarding(EntityPlayer player) {
        return player.func_70005_c_().equals(this.getPlayerGuard());
    }

    public void setPlayerGuard(@Nullable String s) {
        if (s == null) {
            this.field_70180_af.func_187227_b(PLAYER_GUARD, (Object)"");
        } else {
            this.field_70180_af.func_187227_b(PLAYER_GUARD, (Object)s);
        }
    }

    public String getPlayerGuard() {
        return (String)this.field_70180_af.func_187225_a(PLAYER_GUARD);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184641_n(false);
        if (!this.field_70170_p.field_72995_K) {
            this.func_96094_a("...");
            this.func_174805_g(true);
            this.setMeleeWeapon();
            if (ToroQuestConfiguration.guardsHaveArmorForSpartanWeaponry) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U, 1));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V, 1));
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W, 1));
                this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X, 1));
            }
        }
        return livingdata;
    }

    public void setMeleeWeapon() {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.guardAttackDamage);
        CivilizationType civ = this.getCivilization();
        if (civ == null) {
            this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151040_l, 1));
            ItemStack istack = new ItemStack(Item.func_111206_d((String)"spartanshields:shield_tower_wood"));
            if (istack != null && !istack.func_190926_b()) {
                this.func_184611_a(EnumHand.OFF_HAND, istack);
            } else {
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Items.field_185159_cQ, 1));
            }
            return;
        }
        switch (civ) {
            case FIRE: {
                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardWeapon_RED_BRIAR), 1));
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardShield_RED_BRIAR), 1));
                return;
            }
            case EARTH: {
                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardWeapon_GREEN_WILD), 1));
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardShield_GREEN_WILD), 1));
                return;
            }
            case SUN: {
                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardWeapon_YELLOW_DAWN), 1));
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardShield_YELLOW_DAWN), 1));
                return;
            }
            case WIND: {
                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardWeapon_BROWN_MITHRIL), 1));
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardShield_BROWN_MITHRIL), 1));
                return;
            }
            case MOON: {
                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardWeapon_BLACK_MOOR), 1));
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardShield_BLACK_MOOR), 1));
                return;
            }
            case WATER: {
                this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardWeapon_BLUE_GLACIER), 1));
                this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.guardShield_BLUE_GLACIER), 1));
                return;
            }
        }
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151040_l, 1));
        this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Items.field_185159_cQ, 1));
    }

    public static BlockPos findSpawnSurface(World world, BlockPos pos, int yOffset) {
        boolean airspace = false;
        boolean floor = false;
        while (yOffset > 0) {
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState instanceof BlockLiquid) {
                return null;
            }
            if (blockState.func_177230_c() instanceof BlockAir) {
                if (floor) {
                    if (airspace) {
                        return pos.func_177984_a();
                    }
                    airspace = true;
                }
            } else {
                floor = true;
                airspace = false;
            }
            pos = pos.func_177984_a();
            --yOffset;
        }
        return null;
    }

    public void playTameEffect(boolean hearts) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!hearts) {
            enumparticletypes = EnumParticleTypes.CLOUD;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == null || player.field_70170_p.field_72995_K || !this.func_70089_S() || player.func_82150_aj()) {
            return true;
        }
        if (this.actionReady()) {
            this.func_70625_a((Entity)player, 30.0f, 30.0f);
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
        }
        if (!player.func_82150_aj()) {
            CivilizationType civ = this.getCivilization();
            Integer rep = null;
            ItemStack itemstack = player.func_184586_b(hand);
            Item item = itemstack.func_77973_b();
            if (civ != null) {
                rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(civ);
                if (item == Items.field_151166_bC && rep < 0) {
                    if (this.murderWitness == player) {
                        if (this.actionReady()) {
                            this.chat(player, "murderer", this.getHomeProvince().getName());
                        }
                        this.setAnnoyed(player);
                        this.func_70624_b((EntityLivingBase)player);
                    } else {
                        int maxRepGain = -rep.intValue();
                        int emeraldRep = itemstack.func_190916_E() * ToroQuestConfiguration.donateEmeraldRepGain;
                        if (emeraldRep > maxRepGain) {
                            this.chat(player, "bountyclear", this.getHomeProvince().getName());
                            int remainder = emeraldRep - maxRepGain;
                            this.adjustRep((Entity)player, maxRepGain);
                            player.func_184611_a(hand, new ItemStack(item, remainder / ToroQuestConfiguration.donateEmeraldRepGain));
                            this.underAttack = null;
                            this.isAnnoyedTimer = 0;
                        } else {
                            this.chat(player, "bounty", this.getHomeProvince().getName());
                            this.adjustRep((Entity)player, emeraldRep);
                            this.underAttack = null;
                            this.isAnnoyedTimer = 0;
                            player.func_184611_a(hand, new ItemStack(Items.field_190931_a, 0));
                        }
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187716_o, SoundCategory.AMBIENT, 1.0f, 1.2f);
                        this.func_70624_b(null);
                    }
                    return true;
                }
                if (this.inCombat()) {
                    return false;
                }
                if (rep <= -100 || this.murderWitness() == player || this.underAttack() == player) {
                    if (this.actionReady()) {
                        this.insult(player);
                    }
                    return true;
                }
                if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemLead) {
                    List fugitives = player.field_70170_p.func_175647_a(EntityFugitive.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(8.0, 4.0, 8.0), (Predicate)new Predicate<EntityFugitive>(){

                        public boolean apply(@Nullable EntityFugitive entity) {
                            return true;
                        }
                    });
                    for (EntityFugitive v : fugitives) {
                        if (this.inCombat() || v == null || !v.func_70089_S() || v.func_110166_bE() == null || this.murderWitness != null && this.murderWitness == player || this.underAttack != null && this.underAttack == player) continue;
                        try {
                            QuestCaptureFugitives.INSTANCE.onReturn(player);
                            this.chat(player, "fugitive", this.getHomeProvince().getName());
                            this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                            this.func_184185_a(SoundEvents.field_187689_f, 0.5f, 0.8f);
                            this.func_184185_a(SoundEvents.field_187913_gm, 0.8f, 0.8f);
                            v.func_70106_y();
                            v.func_70606_j(0.0f);
                            EventHandlers.adjustPlayerRep(player, (int)(player.field_70165_t / 16.0), (int)(player.field_70161_v / 16.0), ToroQuestConfiguration.returnFugitiveRepGain);
                            this.actionTimer = 5;
                            ItemStack lead = new ItemStack(Items.field_151058_ca, 1);
                            lead.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"item.fugitive_bindings.name", (Object[])new Object[0]).func_150254_d());
                            player.func_184611_a(EnumHand.MAIN_HAND, lead);
                            return true;
                        }
                        catch (Exception lead) {
                        }
                    }
                    List toros = player.field_70170_p.func_175647_a(EntitySheep.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(8.0, 4.0, 8.0), (Predicate)new Predicate<EntitySheep>(){

                        public boolean apply(@Nullable EntitySheep entity) {
                            return true;
                        }
                    });
                    for (EntitySheep v : toros) {
                        if (this.inCombat() || v == null || !v.func_70089_S() || v.func_110166_bE() == null || this.murderWitness != null && this.murderWitness == player || this.underAttack != null && this.underAttack == player) continue;
                        boolean flag = false;
                        for (String t : v.func_184216_O()) {
                            if (!t.equals("capture_quest")) continue;
                            flag = true;
                        }
                        if (!flag) continue;
                        try {
                            if (!QuestCaptureEntity.INSTANCE.onReturn(player)) continue;
                            this.chat(player, "returnsheep", this.getHomeProvince().getName());
                            v.func_70106_y();
                            v.func_70606_j(0.0f);
                            this.func_184185_a(SoundEvents.field_187689_f, 0.5f, 0.8f);
                            this.func_184185_a(SoundEvents.field_187757_eG, 0.8f, 0.8f);
                            EventHandlers.adjustPlayerRep(player, (int)(player.field_70165_t / 16.0), (int)(player.field_70161_v / 16.0), ToroQuestConfiguration.returnFugitiveRepGain);
                            this.actionTimer = 5;
                            ItemStack lead = new ItemStack(Items.field_151058_ca, 1);
                            lead.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"item.sheep_bindings.name", (Object[])new Object[0]).func_150254_d());
                            player.func_184611_a(EnumHand.MAIN_HAND, lead);
                            return true;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            if (this.inCombat()) {
                return true;
            }
            if (this.postReady && item.equals(Item.func_111206_d((String)"toroquest:recruitment_papers"))) {
                this.setPost(player, rep);
                return true;
            }
        }
        if (this.actionReady() || this.interactTalkReady) {
            EntityGuard.guardTalkToPlayer(this, player, true);
            return true;
        }
        return true;
    }

    public void setPost(EntityPlayer player, Integer rep) {
        this.postReady = false;
        if (!this.inCombat() && (rep == null || rep >= 0) && this.isFriendly(player)) {
            if (player.func_70093_af()) {
                BlockPos pos = EntityGuard.findSpawnSurface(this.field_70170_p, this.func_180425_c().func_177984_a(), 32);
                if (pos == null) {
                    pos = EntityGuard.findSpawnSurface(this.field_70170_p, this.func_180425_c().func_177977_b(), 4);
                }
                if (pos == null || rep == null) {
                    player.func_146105_b((ITextComponent)new TextComponentString("\u00a7oInvalid post location!\u00a7r"), true);
                    this.func_184185_a(SoundEvents.field_187679_dF, 1.2f, 0.8f);
                } else {
                    this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187578_au, 1.0f, 1.0f);
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    this.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    this.setRaidLocation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    player.func_146105_b((ITextComponent)new TextComponentString("\u00a7oGuard posted at [" + pos.func_177958_n() + ", " + pos.func_177952_p() + "]\u00a7r"), true);
                }
            } else if (rep == null) {
                player.func_146105_b((ITextComponent)new TextComponentString("\u00a7oInvalid post location!\u00a7r"), true);
                this.func_184185_a(SoundEvents.field_187679_dF, 1.2f, 0.8f);
            } else {
                this.setRaidLocation(this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o(), this.func_180425_c().func_177952_p());
                player.func_146105_b((ITextComponent)new TextComponentString("\u00a7oGuard posted at [" + this.func_180425_c().func_177958_n() + ", " + this.func_180425_c().func_177952_p() + "]\u00a7r"), true);
                this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
            }
        } else {
            this.func_184185_a(SoundEvents.field_187679_dF, 1.2f, 0.8f);
        }
    }

    public void chat(EntityPlayer player, String message, @Nullable String extra) {
        if (player == null) {
            return;
        }
        EntityGuard.lookAtSpeaking(this, player);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!ToroQuestConfiguration.guardsHaveDialogue) {
            return;
        }
        if (this.func_70032_d((Entity)player) > 12.0f) {
            return;
        }
        if (player.func_82150_aj()) {
            try {
                int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"entity.toroquest.guard.invisible", (Object[])new Object[0]).func_150260_c()));
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard.invisible" + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.getChatName() + "\u00a7r: " + s));
                this.func_96094_a(s);
                this.func_174805_g(true);
                this.actionTimer = 5;
            }
            catch (Exception e) {
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"entity.toroquest.guard.invisible", (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.getChatName() + "\u00a7r: " + s));
                this.func_96094_a(s);
                this.func_174805_g(true);
                this.actionTimer = 5;
            }
            this.playChatSound();
            return;
        }
        this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
        this.func_70625_a((Entity)player, 30.0f, 30.0f);
        if (this.func_70638_az() == null) {
            this.func_70661_as().func_75499_g();
            this.func_70661_as().func_75492_a((player.field_70165_t - this.field_70165_t) / 2.0 + this.field_70165_t, player.field_70163_u, (player.field_70161_v - this.field_70161_v) / 2.0 + this.field_70161_v, 0.5);
        }
        try {
            int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message), (Object[])new Object[0]).func_150260_c()));
            String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
            if (extra != null) {
                s = s.replace("@e", extra);
            }
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.getChatName() + "\u00a7r: " + s));
            this.func_96094_a(s);
            this.func_174805_g(true);
            this.actionTimer = 5;
        }
        catch (Exception e) {
            String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
            if (extra != null) {
                s = s.replace("@e", extra);
            }
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.getChatName() + "\u00a7r: " + s));
            this.func_96094_a(s);
            this.func_174805_g(true);
            this.actionTimer = 5;
        }
        this.interactTalkReady = false;
        this.playChatSound();
    }

    @Override
    public void chat(EntityToroNpc guard, EntityPlayer player, String message, @Nullable String extra) {
        if (player == null) {
            return;
        }
        EntityGuard.lookAtSpeaking(this, player);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (ToroQuestConfiguration.guardsHaveDialogue) {
            return;
        }
        if (guard.func_70032_d((Entity)player) > 12.0f) {
            return;
        }
        if (player.func_82150_aj()) {
            try {
                int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"entity.toroquest.guard.invisible", (Object[])new Object[0]).func_150260_c()));
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard.invisible" + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7lGuard\u00a7r: " + s));
                guard.func_96094_a(s);
                guard.func_174805_g(true);
                guard.actionTimer = 5;
            }
            catch (Exception e) {
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"entity.toroquest.guard.invisible", (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7lGuard\u00a7r: " + s));
                guard.func_96094_a(s);
                guard.func_174805_g(true);
                guard.actionTimer = 5;
            }
            guard.playChatSound();
            return;
        }
        guard.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
        guard.func_70625_a((Entity)player, 30.0f, 30.0f);
        if (guard.func_70638_az() == null) {
            guard.func_70661_as().func_75499_g();
            guard.func_70661_as().func_75492_a((player.field_70165_t - guard.field_70165_t) / 2.0 + guard.field_70165_t, player.field_70163_u, (player.field_70161_v - guard.field_70161_v) / 2.0 + guard.field_70161_v, 0.5);
        }
        try {
            int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message), (Object[])new Object[0]).func_150260_c()));
            String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
            if (extra != null) {
                s = s.replace("@e", extra);
            }
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7lGuard\u00a7r: " + s));
            guard.func_96094_a(s);
            guard.func_174805_g(true);
            guard.actionTimer = 5;
        }
        catch (Exception e) {
            String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
            if (extra != null) {
                s = s.replace("@e", extra);
            }
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7lGuard\u00a7r: " + s));
            guard.func_96094_a(s);
            guard.func_174805_g(true);
            guard.actionTimer = 5;
        }
        guard.interactTalkReady = false;
        guard.playChatSound();
    }

    public void setCombatTask() {
        this.aiArrowAttack.setAttackCooldown(40);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIAttackWithSword(this, 0.65));
        this.field_70714_bg.func_75776_a(7, this.aiArrowAttack);
        this.inCombat = false;
        this.blocking = false;
        this.blockingTimer = 0;
        this.func_70624_b(null);
        this.canShieldPush = true;
        this.func_184602_cy();
        this.func_184598_c(EnumHand.MAIN_HAND);
        this.field_184628_bn = 0;
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
        this.stance = 0;
        this.func_70605_aq().func_188488_a(0.0f, 0.0f);
        this.func_70661_as().func_75499_g();
        this.aggroTimer = 0;
    }

    @Override
    public void callForHelp(EntityLivingBase attacker) {
        if (attacker == null || !attacker.func_70089_S() || attacker instanceof EntityToroNpc || attacker instanceof EntityVillager) {
            return;
        }
        List guards = this.func_130014_f_().func_175647_a(EntityGuard.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(16.0, 16.0, 16.0), (Predicate)new Predicate<EntityGuard>(){

            public boolean apply(@Nullable EntityGuard entity) {
                return true;
            }
        });
        for (EntityGuard guard : guards) {
            if (guard.func_70638_az() != null || !guard.func_70685_l((Entity)attacker)) continue;
            if (attacker instanceof EntityPlayer) {
                guard.setAnnoyed((EntityPlayer)attacker);
            }
            guard.func_70624_b(attacker);
        }
        if (!(this.func_70638_az() != null && this.func_70638_az().func_70089_S() || this.func_70643_av() == null)) {
            if (this.func_70643_av() instanceof EntityPlayer) {
                this.setAnnoyed((EntityPlayer)attacker);
            }
            this.func_70624_b(this.func_70643_av());
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        List villagers = attacker.func_130014_f_().func_175647_a(EntityToroVillager.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(12.0, 8.0, 12.0), (Predicate)new Predicate<EntityToroVillager>(){

            public boolean apply(@Nullable EntityToroVillager entity) {
                return true;
            }
        });
        for (EntityToroVillager villager : villagers) {
            villager.setUnderAttack(attacker);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (target == null || this.func_184614_ca() == null) {
            return;
        }
        this.aggroTimer = 0;
        this.func_70624_b(target);
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        entityarrow.func_70243_d(true);
        entityarrow.func_70239_b(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 2.0 - (double)this.field_70131_O / 2.0 - entityarrow.field_70163_u - this.field_70146_Z.nextDouble();
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 2.3f, 1.0f);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.5f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        return new EntitySmartArrow(this.field_70170_p, (EntityLivingBase)this);
    }

    protected void func_184608_ct() {
        if (this.func_184587_cr()) {
            ItemStack itemstack = this.func_184586_b(this.func_184600_cs());
            if (itemstack.func_77973_b() instanceof ItemShield) {
                this.field_184628_bn = 30;
                if (this.field_184628_bn > 0) {
                    this.field_184627_bm.func_77973_b().onUsingTick(this.field_184627_bm, (EntityLivingBase)this, this.field_184628_bn);
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.canShieldPush = true;
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn <= 0 && !this.field_70170_p.field_72995_K) {
                    this.func_71036_o();
                }
            } else if (itemstack == this.field_184627_bm) {
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = ForgeEventFactory.onItemUseTick((EntityLivingBase)this, (ItemStack)this.field_184627_bm, (int)this.field_184628_bn);
                    if (this.field_184628_bn > 0) {
                        this.field_184627_bm.func_77973_b().onUsingTick(this.field_184627_bm, (EntityLivingBase)this, this.field_184628_bn);
                    }
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.canShieldPush = true;
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn <= 0 && !this.field_70170_p.field_72995_K) {
                    this.func_71036_o();
                }
            } else {
                this.canShieldPush = true;
                this.func_184602_cy();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        boolean flag2;
        boolean flag = id == 33;
        boolean flag1 = id == 36;
        boolean bl = flag2 = id == 37;
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        }
        if (!(id == 2 || flag || flag1 || flag2)) {
            if (id == 3) {
                SoundEvent soundevent1 = this.func_184615_bR();
                if (soundevent1 != null) {
                    this.func_184185_a(soundevent1, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.func_70606_j(0.0f);
                this.func_70645_a(DamageSource.field_76377_j);
            } else if (id == 30) {
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            } else if (id == 29) {
                this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            } else {
                super.func_70103_a(id);
            }
        } else {
            DamageSource damagesource;
            SoundEvent soundevent;
            this.field_70721_aZ = 1.5f;
            this.field_70172_ad = this.field_70771_an;
            this.field_70737_aN = this.field_70738_aO = 10;
            this.field_70739_aP = 0.0f;
            if (flag) {
                this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if ((soundevent = this.func_184601_bQ(damagesource = flag2 ? DamageSource.field_76370_b : (flag1 ? DamageSource.field_76369_e : DamageSource.field_76377_j))) != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.func_70097_a(DamageSource.field_76377_j, -1.0f);
        }
        super.func_70103_a(id);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void insult(EntityPlayer player) {
        if (this.isGuarding(player)) {
            return;
        }
        if (this.murderWitness() == player) {
            this.chat(player, "murderer", this.getHomeProvince().getName());
        } else if (this.getCivilization() != null) {
            this.chat(player, "insult", "House " + this.getCivilization().getDisplayName(player));
        } else if (this.isPlayerGuard()) {
            this.chat(player, "insult", this.getPlayerGuard());
        } else {
            this.chat(player, "insult", TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.null.name", (Object[])new Object[0]).func_150254_d());
        }
        this.setAnnoyed(player);
        this.func_70624_b((EntityLivingBase)player);
    }

    @Override
    public boolean func_70652_k(Entity victim) {
        EntityLiving v;
        if (victim == null || !victim.func_70089_S()) {
            this.func_70624_b(null);
            return false;
        }
        this.aggroTimer = 0;
        if (victim instanceof EntityToroNpc || victim instanceof EntityVillager || victim instanceof EntityGolem && !(victim instanceof EntityConstruct)) {
            if (victim instanceof EntityLiving) {
                EntityLiving v2 = (EntityLiving)victim;
                v2.func_70624_b(null);
            }
            this.func_70624_b(null);
            return false;
        }
        if (victim instanceof EntityLiving && (v = (EntityLiving)victim).func_110143_aJ() <= 0.0f) {
            this.func_70624_b(null);
            if (this.field_70146_Z.nextInt(8) == 0) {
                v.func_70106_y();
            }
        }
        this.attackTargetEntityWithCurrentItem(victim);
        if (victim instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)victim;
            if (!player.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(25) == 0) {
                this.insult(player);
            }
        }
        this.func_70031_b(false);
        return true;
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.playAngrySound();
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)this)) {
            float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float modifierForCreature = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            if (attackDamage > 0.0f || modifierForCreature > 0.0f) {
                ItemStack itemstack;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
                boolean criticalHit = this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl = criticalHit = criticalHit && !this.func_70051_ag();
                if (criticalHit) {
                    attackDamage *= 1.5f;
                }
                attackDamage += modifierForCreature;
                boolean swordSweep = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (!criticalHit && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(EnumHand.MAIN_HAND)) != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemAxe)) {
                    swordSweep = true;
                }
                float targetHealth = 0.0f;
                boolean setFireToTarget = false;
                int fireAspectModiferOfGuard = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
                if (targetEntity instanceof EntityLivingBase) {
                    targetHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspectModiferOfGuard > 0 && !targetEntity.func_70027_ad()) {
                        setFireToTarget = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double targetMotionX = targetEntity.field_70159_w;
                double targetMotionY = targetEntity.field_70181_x;
                double targetMotionZ = targetEntity.field_70179_y;
                boolean successfulAttack = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage);
                if (successfulAttack) {
                    AIHelper.spawnSweepHit((Entity)this, targetEntity);
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else if (!this.field_70170_p.field_72995_K) {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (swordSweep) {
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == targetEntity || this.func_184191_r((Entity)entitylivingbase) || !(this.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                            entitylivingbase.func_70653_a((Entity)this, 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                            entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
                        }
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.spawnSweepParticles();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = targetMotionX;
                        targetEntity.field_70181_x = targetMotionY;
                        targetEntity.field_70179_y = targetMotionZ;
                    }
                    if (criticalHit) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.onCriticalHit(targetEntity);
                    }
                    if (!criticalHit && !swordSweep) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (modifierForCreature > 0.0f) {
                        this.onEnchantmentCritical(targetEntity);
                    }
                    if (!this.field_70170_p.field_72995_K && targetEntity instanceof EntityPlayer) {
                        ItemStack itemstack3;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemstack2 = this.func_184614_ca();
                        ItemStack itemStack = itemstack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                        if (itemstack2 != null && itemstack3 != null && itemstack3.func_77973_b() instanceof ItemShield && (itemstack2.func_77973_b() instanceof ItemAxe || itemstack2.func_77973_b().getRegistryName().toString().contains("halberd") || itemstack2.func_77973_b().getRegistryName().toString().contains("battleaxe"))) {
                            float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                            if (this.field_70146_Z.nextFloat() < f3) {
                                entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                            }
                        }
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
                    ItemStack mainhandItem = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (mainhandItem != null && entity instanceof EntityLivingBase) {
                        mainhandItem.func_77973_b().func_77644_a(mainhandItem, (EntityLivingBase)entity, (EntityLivingBase)this);
                        if (mainhandItem.func_190916_E() <= 0) {
                            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float damageDealt = targetHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        if (fireAspectModiferOfGuard > 0) {
                            targetEntity.func_70015_d(fireAspectModiferOfGuard * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && damageDealt > 2.0f) {
                            int k = (int)((double)damageDealt * 0.5);
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (setFireToTarget) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    public void onCriticalHit(Entity entityHit) {
    }

    public void onEnchantmentCritical(Entity entityHit) {
    }

    public void spawnSweepParticles() {
        double d0 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_184185_a(SoundEvents.field_191269_hn, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        }
        return super.func_184601_bQ(damageSourceIn);
    }

    @Override
    protected SoundEvent func_184615_bR() {
        if (this.field_70146_Z.nextBoolean()) {
            this.func_184185_a(SoundEvents.field_191245_bo, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        } else {
            this.func_184185_a(SoundEvents.field_193786_de, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        }
        return null;
    }

    public void playAngrySound() {
        this.func_184185_a(SoundEvents.field_191268_hm, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
    }

    @Override
    public void playChatSound() {
        this.func_184185_a(SoundEvents.field_191268_hm, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    public int getDistance(double x, double z) {
        return (int)(Math.abs(this.field_70165_t - x) + Math.abs(this.field_70161_v - z));
    }

    public boolean wanderVillage() {
        int i;
        Vec3d vec3d;
        if (this.field_70146_Z.nextBoolean() && (vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)16, (int)8)) != null) {
            if (this.func_130014_f_().func_180495_p(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b + 2.0, vec3d.field_72449_c)) instanceof BlockAir && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6)) {
                this.lookWhereMoving(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                return true;
            }
            return false;
        }
        if (this.village == null) {
            this.village = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this), 20);
            if (this.village == null) {
                return false;
            }
        }
        if ((i = this.village.func_75558_f().size()) > 0) {
            this.doorInfo = (VillageDoorInfo)this.village.func_75558_f().get(this.field_70146_Z.nextInt(i));
        }
        if (this.doorInfo == null) {
            return false;
        }
        PathNavigateGround pathnavigateground = (PathNavigateGround)this.func_70661_as();
        boolean flag = pathnavigateground.func_179686_g();
        pathnavigateground.func_179688_b(false);
        pathnavigateground.func_179688_b(flag);
        Vec3d vec3d2 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)8, (Vec3d)new Vec3d((double)this.doorInfo.func_179852_d().func_177958_n(), (double)this.doorInfo.func_179852_d().func_177956_o(), (double)this.doorInfo.func_179852_d().func_177952_p()));
        if (vec3d2 == null) {
            return false;
        }
        if (this.func_130014_f_().func_180495_p(new BlockPos(vec3d2.field_72450_a, vec3d2.field_72448_b + 2.0, vec3d2.field_72449_c)) instanceof BlockAir && pathnavigateground.func_75492_a(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, 0.6)) {
            pathnavigateground.func_179688_b(false);
            pathnavigateground.func_179688_b(flag);
            this.lookWhereMoving(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c);
            return true;
        }
        return false;
    }

    private void lookWhereMoving(double x, double y, double z) {
        AIHelper.faceEntitySmart((EntityLivingBase)this, x, z);
        this.func_70671_ap().func_75650_a(x, y, z, 30.0f, 30.0f);
    }

    public boolean getOutOfWater() {
        Vec3d vec3d;
        if (this.func_70090_H() && (vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)12, (int)6)) != null) {
            if (this.func_130014_f_().func_180495_p(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b + 2.0, vec3d.field_72449_c)) instanceof BlockAir && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6)) {
                this.lookWhereMoving(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean avoidNear() {
        Vec3d vec3d;
        List guards = this.field_70170_p.func_175647_a(EntityGuard.class, this.func_174813_aQ().func_72314_b(3.0, 3.0, 3.0), (Predicate)new Predicate<EntityGuard>(){

            public boolean apply(@Nullable EntityGuard entity) {
                return EntityGuard.this != entity;
            }
        });
        for (EntityToroNpc guard : guards) {
            Vec3d vec3d2 = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)6, (int)4, (Vec3d)new Vec3d(guard.field_70165_t, guard.field_70163_u, guard.field_70161_v));
            if (vec3d2 == null) continue;
            if (this.func_130014_f_().func_180495_p(new BlockPos(vec3d2.field_72450_a, vec3d2.field_72448_b + 2.0, vec3d2.field_72449_c)) instanceof BlockAir && this.func_70661_as().func_75492_a(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, 0.6)) {
                this.lookWhereMoving(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c);
                return true;
            }
            return false;
        }
        if (this.actionReady()) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0));
            for (EntityPlayer player : players) {
                if (!this.func_70685_l((Entity)player)) continue;
                if (this.field_70170_p.field_73012_v.nextFloat() < ToroQuestConfiguration.guardSpeakChance) {
                    EntityGuard.guardTalkToPlayer(this, player, false);
                    this.returningToPost = false;
                    this.func_70661_as().func_75492_a((player.field_70165_t - this.field_70165_t) / 2.0 + this.field_70165_t, player.field_70163_u, (player.field_70161_v - this.field_70161_v) / 2.0 + this.field_70161_v, 0.5);
                    this.lookWhereMoving(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    return true;
                }
                this.interactTalkReady = true;
                this.actionTimer = 3;
            }
        }
        if (this.collidedHorizontallyWide(this.field_70163_u + 0.4) && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)6, (int)4, (Vec3d)new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null) {
            if (this.func_130014_f_().func_180495_p(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b + 2.0, vec3d.field_72449_c)) instanceof BlockAir && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6)) {
                this.lookWhereMoving(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean speakWithVillagers() {
        if (this.actionReady() && !(this.func_184614_ca().func_77973_b() instanceof ItemBow) && this.field_70146_Z.nextInt(4) == 0) {
            List villagers = this.field_70170_p.func_72872_a(EntityVillager.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(8.0, 3.0, 8.0));
            Collections.shuffle(villagers);
            for (EntityVillager p : villagers) {
                if (p.func_70940_q()) continue;
                this.func_70661_as().func_75499_g();
                boolean flag0 = this.func_70661_as().func_75492_a((p.field_70165_t - this.field_70165_t) / 2.0 + this.field_70165_t, p.field_70163_u, (p.field_70161_v - this.field_70161_v) / 2.0 + this.field_70161_v, 0.6);
                p.func_70661_as().func_75499_g();
                boolean flag1 = p.func_70661_as().func_75492_a((this.field_70165_t - p.field_70165_t) / 3.0 + p.field_70165_t, this.field_70163_u, (this.field_70161_v - p.field_70161_v) / 3.0 + p.field_70161_v, 0.6);
                if (!flag0 || !flag1) continue;
                this.lookWhereMoving(p.field_70165_t, p.field_70163_u, p.field_70161_v);
                this.actionTimer = 5;
                p.func_70625_a((Entity)this, 30.0f, 30.0f);
                p.func_70671_ap().func_75651_a((Entity)this, 30.0f, 30.0f);
                AIHelper.faceEntitySmart((EntityLivingBase)p, (EntityLivingBase)this);
                if (p instanceof EntityToroVillager) {
                    ((EntityToroVillager)p).chattingWithGuard = (short)5;
                }
                return true;
            }
        }
        return false;
    }

    public boolean collidedHorizontallyWide(double d) {
        try {
            IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + 0.6, d, this.field_70161_v));
            if (block != Blocks.field_150350_a.func_176223_P()) {
                return true;
            }
            block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d, this.field_70161_v + 0.6));
            if (block != Blocks.field_150350_a.func_176223_P()) {
                return true;
            }
            block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - 0.6, d, this.field_70161_v));
            if (block != Blocks.field_150350_a.func_176223_P()) {
                return true;
            }
            block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d, this.field_70161_v - 0.6));
            if (block != Blocks.field_150350_a.func_176223_P()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void guardTalkToPlayer(EntityGuard entity, EntityPlayer player, boolean processInteract) {
        if (entity == null || player == null) {
            return;
        }
        if (entity.func_70638_az() == player) {
            entity.insult(player);
            return;
        }
        if (entity.func_70638_az() != null) {
            return;
        }
        entity.func_70661_as().func_75499_g();
        if (!ToroQuestConfiguration.guardsHaveDialogue) {
            return;
        }
        CivilizationType civ = entity.getCivilization();
        boolean bandit = false;
        for (ItemStack itemStack : player.func_184193_aE()) {
            if (!itemStack.func_77973_b().equals(Item.func_111206_d((String)"toroquest:bandit_helmet")) && !itemStack.func_77973_b().equals(Item.func_111206_d((String)"toroquest:legendary_bandit_helmet"))) continue;
            bandit = true;
        }
        if (civ == null) {
            if (!entity.getPlayerGuard().equals("")) {
                if (player.func_70005_c_().equals(entity.getPlayerGuard())) {
                    if ((double)entity.func_110143_aJ() <= (double)entity.func_110138_aP() * 0.75) {
                        if (entity.actionReady()) {
                            entity.chat(player, "wounded", null);
                        }
                        return;
                    }
                    if (entity.actionReady()) {
                        entity.chat(player, "playersguard", null);
                    }
                    return;
                }
                if (entity.actionReady()) {
                    entity.chat(player, "otherplayersguard", entity.getPlayerGuard());
                }
                return;
            }
            if (bandit || entity.murderWitness == player || entity.underAttack == player) {
                if (entity.actionReady()) {
                    entity.insult(player);
                }
                return;
            }
            if (entity.wildernessGuardSpeak) {
                if (!entity.field_70170_p.func_175647_a(EntityCaravan.class, new AxisAlignedBB(entity.func_180425_c()).func_72314_b(25.0, 15.0, 25.0), (Predicate)new Predicate<EntityCaravan>(){

                    public boolean apply(@Nullable EntityCaravan entity) {
                        return true;
                    }
                }).isEmpty()) {
                    entity.func_70661_as().func_75499_g();
                    entity.func_70625_a((Entity)player, 30.0f, 30.0f);
                    entity.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
                    entity.chat(player, "caravan", null);
                } else {
                    entity.func_70661_as().func_75499_g();
                    entity.func_70625_a((Entity)player, 30.0f, 30.0f);
                    entity.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
                    entity.chat(player, "nociv", null);
                }
                entity.wildernessGuardSpeak = false;
            }
            return;
        }
        if (bandit) {
            if (entity.actionReady() || processInteract && entity.interactTalkReady) {
                entity.chat(player, "bandit", null);
            }
            return;
        }
        if (entity.actionReady() || processInteract && entity.interactTalkReady) {
            ItemStack itemStack2;
            entity.interactTalkReady = false;
            String name = "";
            Province prov = entity.getHomeProvince();
            if (prov == null) {
                name = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.null.name", (Object[])new Object[0]).func_150254_d();
            } else {
                name = prov.getName();
                if (prov.hasLord) {
                    for (ItemStack itemStack2 : player.func_184193_aE()) {
                        if (!itemStack2.func_77973_b().equals(Item.func_111206_d((String)"toroquest:royal_helmet"))) continue;
                        entity.chat(player, "falselord", name);
                        entity.setAnnoyed(player);
                        entity.func_70624_b((EntityLivingBase)player);
                        return;
                    }
                } else {
                    for (ItemStack itemStack2 : player.func_184193_aE()) {
                        if (!itemStack2.func_77973_b().equals(Item.func_111206_d((String)"toroquest:royal_helmet"))) continue;
                        entity.chat(player, "lord", name);
                        return;
                    }
                }
            }
            int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(civ);
            rep = (int)((double)rep * (1.0 + entity.field_70146_Z.nextGaussian() / 3.0));
            itemStack2 = player.func_184614_ca();
            Item item = itemStack2.func_77973_b();
            if (rep <= -50 || entity.murderWitness == player || entity.underAttack == player) {
                entity.insult(player);
                return;
            }
            if (entity.isAnnoyedAt(player) || rep < 0) {
                entity.chat(player, "annoyed", name);
                return;
            }
            if ((double)entity.func_110143_aJ() <= (double)entity.func_110138_aP() * 0.75) {
                entity.chat(player, "wounded", name);
                return;
            }
            if (entity.field_70146_Z.nextInt(4) == 0 && item instanceof ItemSword) {
                entity.chat(player, "sword", item.func_77653_i(itemStack2));
                return;
            }
            if (entity.field_70146_Z.nextBoolean() && item instanceof ItemAxe) {
                entity.chat(player, "axe", item.func_77653_i(itemStack2));
                return;
            }
            if (item instanceof ItemHoe) {
                entity.chat(player, "hoe", item.func_77653_i(itemStack2));
                return;
            }
            if (entity.field_70146_Z.nextBoolean() && item instanceof ItemPickaxe) {
                entity.chat(player, "pickaxe", item.func_77653_i(itemStack2));
                return;
            }
            if (item instanceof ItemSpade) {
                entity.chat(player, "spade", item.func_77653_i(itemStack2));
                return;
            }
            if (entity.field_70146_Z.nextInt(4) == 0 && item instanceof ItemBow) {
                entity.chat(player, "bow", item.func_77653_i(itemStack2));
                return;
            }
            if (entity.field_70146_Z.nextInt(8) == 0 && entity.field_70170_p.func_175727_C(entity.func_180425_c())) {
                entity.chat(player, "rain", name);
                return;
            }
            if (entity.field_70146_Z.nextInt(8) == 0 && entity.field_70170_p.func_72896_J() && entity.field_70170_p.canSnowAtBody(entity.func_180425_c(), false)) {
                entity.chat(player, "snow", name);
                return;
            }
            if (entity.field_70146_Z.nextInt(32) == 0) {
                int time = (int)entity.field_70170_p.func_72820_D();
                if (time > 9000 && time < 13000) {
                    entity.chat(player, "evening", name);
                } else if (time >= 4000 && time < 9000) {
                    entity.chat(player, "morning", name);
                } else if (time <= 9000) {
                    entity.chat(player, "afternoon", name);
                } else {
                    entity.chat(player, "night", name);
                }
                return;
            }
            if (prov != null && !prov.hasLord && entity.field_70173_aa > 500) {
                entity.chat(player, "nolord", name);
                return;
            }
            if (entity.field_70146_Z.nextInt(10) == 0) {
                entity.chat(player, "anyrep", name);
                return;
            }
            if (rep < 300) {
                entity.chat(player, "lowrep", name);
                return;
            }
            if (rep < 1500) {
                entity.chat(player, "mediumrep", name);
                return;
            }
            entity.chat(player, "highrep", name);
            return;
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

