/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityZombieVillagerRaider;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAIThrow;
import net.torocraft.toroquest.entities.render.RenderGraveTitan;
import net.torocraft.toroquest.generation.WorldGenPlacer;

public class EntityGraveTitan
extends EntityZombie
implements IMob {
    public static String NAME = "grave_titan";
    private float xsize = 4.5f;
    private float ysize = 12.5f;
    protected static final DataParameter<Integer> RAID_X;
    protected static final DataParameter<Integer> RAID_Y;
    protected static final DataParameter<Integer> RAID_Z;
    protected int maxZombiesSpawned = 100;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public boolean func_174833_aM() {
        return false;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityGraveTitan.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGraveTitan.class, (IRenderFactory)new IRenderFactory<EntityGraveTitan>(){

            public Render<EntityGraveTitan> createRenderFor(RenderManager manager) {
                return new RenderGraveTitan(manager);
            }
        });
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationY() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Y));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    public EntityGraveTitan(World world) {
        super(world);
        this.func_110163_bv();
        int x = this.getRaidLocationX();
        int y = this.getRaidLocationY();
        int z = this.getRaidLocationZ();
        if (y != 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 1.0));
        }
        this.setUpEntity();
    }

    public void setUpEntity() {
        this.func_82227_f(false);
        this.func_110163_bv();
        this.setRealSize(this.xsize, this.ysize);
        this.func_70105_a(this.xsize, this.ysize);
        this.field_70138_W = 4.05f;
        this.field_70728_aV = 200;
        this.field_70178_ae = true;
    }

    public EntityGraveTitan(World world, int x, int y, int z) {
        super(world);
        this.setRaidLocation(x, y, z);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 1.0));
        this.setUpEntity();
    }

    protected boolean func_190730_o() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(64.0);
    }

    public float func_70047_e() {
        return this.func_110143_aJ() / this.func_110138_aP() * 8.0f + 1.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        WorldGenPlacer.clearTrees(this.field_70170_p, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 16);
        this.func_98053_h(false);
        this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        this.func_70606_j(this.func_110138_aP());
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean func_70601_bi() {
        return true;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    public static void registerFixesGiantZombie(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityGiantZombie.class);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIThrow((EntityCreature)this, 0.5, true, 0.2, 60));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false, false));
    }

    private void spawnZombies(double a) {
        List help;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (a > 1.0 && this.maxZombiesSpawned > 0 && (help = this.field_70170_p.func_175647_a(EntityZombie.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 10.0, 25.0), (Predicate)new Predicate<EntityZombie>(){

            public boolean apply(@Nullable EntityZombie entity) {
                return true;
            }
        })).size() < 10) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt((int)(this.func_110143_aJ() / this.func_110138_aP() * 3.0f + 1.0f)); ++i) {
                this.spawnZombie();
                this.dropLootItem(Items.field_151078_bh, 1);
                this.dropLootItem(Items.field_151078_bh, 1);
                --this.maxZombiesSpawned;
            }
        }
    }

    public int func_184649_cE() {
        return 5;
    }

    protected void spawnZombie() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        EntityZombieVillagerRaider mob = new EntityZombieVillagerRaider(this.field_70170_p, true);
        double x = (double)this.field_70146_Z.nextInt(7) - 3.0 + 0.5;
        double y = (double)this.field_70146_Z.nextInt(7) + 0.5;
        double z = (double)this.field_70146_Z.nextInt(7) - 3.0 + 0.5;
        mob.func_70107_b(this.field_70165_t + x, this.field_70163_u + y, this.field_70161_v + z);
        mob.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)mob)), null);
        Vec3d velocityVector = new Vec3d(mob.field_70165_t - this.field_70165_t, 0.0, mob.field_70161_v - this.field_70161_v);
        mob.func_70024_g(velocityVector.field_72450_a / 6.0, 0.2, velocityVector.field_72449_c / 6.0);
        this.field_70170_p.func_72838_d((Entity)mob);
    }

    public boolean func_70104_M() {
        return false;
    }

    private Block getBlockDoor(BlockPos pos) {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150357_h) {
            return null;
        }
        return block;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() != null) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 20.0f, 20.0f);
        }
        if (this.field_70173_aa % 25 == 0) {
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            this.adjustSize();
            if (this.func_70638_az() != null && this.field_70123_F && this.func_110143_aJ() >= 10.0f) {
                this.func_184185_a(SoundEvents.field_187524_aN, 2.0f, 0.25f + this.field_70146_Z.nextFloat() / 10.0f);
                this.func_184185_a(SoundEvents.field_187676_dE, 1.5f, 0.5f + this.field_70146_Z.nextFloat() / 10.0f);
                PathNavigateGround pathnavigateground = (PathNavigateGround)this.func_70661_as();
                Path path = pathnavigateground.func_75505_d();
                if (path != null && !path.func_75879_b()) {
                    for (int i = 0; i < Math.min(path.func_75873_e() + 2, path.func_75874_d()); ++i) {
                        PathPoint pathpoint = path.func_75877_a(i);
                        for (int j = 8; j >= 0; --j) {
                            BlockPos doorPosition = new BlockPos(pathpoint.field_75839_a + this.field_70146_Z.nextInt(4) - 3, pathpoint.field_75837_b + j, pathpoint.field_75838_c + this.field_70146_Z.nextInt(4) - 3);
                            Block doorBlock = this.getBlockDoor(doorPosition);
                            if (doorBlock == null || doorBlock == Blocks.field_150350_a || !(doorBlock.func_176195_g(doorBlock.func_176223_P(), this.field_70170_p, doorPosition) <= 3.0f)) continue;
                            this.field_70170_p.func_175656_a(doorPosition, Blocks.field_150350_a.func_176223_P());
                            if (this.field_70146_Z.nextBoolean()) {
                                if (this.field_70146_Z.nextBoolean()) {
                                    this.field_70170_p.func_175718_b(1021, doorPosition, 0);
                                } else {
                                    this.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
                                }
                            }
                            this.field_70170_p.func_175718_b(2001, doorPosition, Block.func_149682_b((Block)doorBlock));
                        }
                    }
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)(this.func_110143_aJ() / this.func_110138_aP()) * 10.0);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_180431_b(source) || source == DamageSource.field_76379_h || source == null || source.func_76346_g() == null || !this.func_70089_S()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            double dist = source.func_76346_g().func_174818_b(this.func_180425_c());
            if (dist > 256.0) {
                amount = (float)((double)amount * (256.0 / dist));
            }
            if (!(source.func_76346_g() instanceof EntityPlayer)) {
                amount /= 16.0f;
            }
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        float f = amount;
        boolean flag = false;
        boolean flag1 = true;
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(source, amount - this.field_110153_bc);
            this.field_110153_bc = amount;
            flag1 = false;
        } else {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            this.adjustSize();
            this.field_110153_bc = amount;
            this.field_70172_ad = this.field_70771_an;
            this.func_70665_d(source, amount);
            this.spawnZombies(amount);
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            if (entity1 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)entity1);
            }
            if (entity1 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)entity1;
            } else {
                return false;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)33);
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - this.field_70165_t;
                double d0 = entity1.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(entity1, 1.0f / (this.func_110143_aJ() / this.func_110138_aP() * 4.0f + 2.0f), d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (flag1) {
            this.func_184581_c(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (entity1 instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity1, (Entity)this, source, f, amount, flag);
        }
        List help = this.field_70170_p.func_175647_a(EntityZombie.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(32.0, 16.0, 32.0), (Predicate)new Predicate<EntityZombie>(){

            public boolean apply(@Nullable EntityZombie entity) {
                return true;
            }
        });
        for (EntityZombie zomb : help) {
            if (zomb.func_70638_az() == null) {
                zomb.func_70624_b((EntityLivingBase)source.func_76346_g());
                zomb.func_70604_c((EntityLivingBase)source.func_76346_g());
                continue;
            }
            if (this.field_70146_Z.nextInt(5) != 0) continue;
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
        }
        return flag2;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        if (this.func_110143_aJ() <= 0.0f) {
            this.func_70645_a(damageSrc);
        }
        this.adjustSize();
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:trophy_titan"));
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = 0.25;
            dropItem.field_70179_y = 0.0;
            dropItem.field_70159_w = 0.0;
            this.field_70170_p.func_72838_d((Entity)dropItem);
            dropItem.func_184195_f(true);
            this.dropLootItem(Items.field_151078_bh, this.field_70146_Z.nextInt(100) + 100);
            this.dropLootItem(Items.field_151103_aS, this.field_70146_Z.nextInt(100) + 100);
        }
        super.func_70645_a(cause);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void adjustSize() {
        if (this.func_110143_aJ() == 0.0f) {
            return;
        }
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        float healthPercentage = MathHelper.func_76131_a((float)percent, (float)0.1f, (float)1.0f);
        this.bossInfo.func_186735_a(percent);
        float hsize = this.xsize * healthPercentage;
        float vsize = this.ysize * healthPercentage;
        this.setRealSize(hsize, vsize);
        this.func_70105_a(hsize, vsize);
    }

    protected void setRealSize(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187899_gZ, 1.5f, 0.5f + this.field_70146_Z.nextFloat() / 2.0f);
        this.func_184185_a(SoundEvents.field_187524_aN, 2.0f, 0.25f + this.field_70146_Z.nextFloat() / 10.0f);
        this.func_184185_a(SoundEvents.field_187676_dE, 1.5f, 0.5f + this.field_70146_Z.nextFloat() / 10.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(SoundEvents.field_187940_hn, 1.0f, 0.5f + this.field_70146_Z.nextFloat() / 5.0f);
        return SoundEvents.field_187944_hr;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_187943_hq, 1.0f, 0.5f + this.field_70146_Z.nextFloat() / 5.0f);
        return SoundEvents.field_187943_hq;
    }

    protected SoundEvent func_184639_G() {
        this.func_184185_a(SoundEvents.field_187899_gZ, 3.0f, 0.3f);
        return SoundEvents.field_187940_hn;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        RAID_X = EntityDataManager.func_187226_a(EntityGraveTitan.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Y = EntityDataManager.func_187226_a(EntityGraveTitan.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Z = EntityDataManager.func_187226_a(EntityGraveTitan.class, (DataSerializer)DataSerializers.field_187192_b);
    }
}

