/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHarvestFarmland;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIVillagerInteract;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.render.RenderFugitive;

public class EntityFugitive
extends EntityVillager {
    public static String NAME = "fugitive";
    public EntityPlayer underAttack = null;
    public static final Predicate<EntityPlayer> PLAYER_WITH_LEAD;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityFugitive.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFugitive.class, (IRenderFactory)new IRenderFactory<EntityFugitive>(){

            public RenderFugitive createRenderFor(RenderManager manager) {
                return new RenderFugitive(manager);
            }
        });
    }

    public EntityFugitive(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.7){

            public boolean func_75250_a() {
                if (EntityFugitive.this.underAttack != null) {
                    return this.func_190863_f();
                }
                return false;
            }

            protected boolean func_190863_f() {
                Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.field_75267_a, (int)16, (int)8, (Vec3d)EntityFugitive.this.underAttack.func_174791_d());
                if (vec3d == null) {
                    return false;
                }
                this.field_75266_c = vec3d.field_72450_a;
                this.field_75263_d = vec3d.field_72448_b;
                this.field_75264_e = vec3d.field_72449_c;
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, PLAYER_WITH_LEAD, 16.0f, 0.6, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.4, Items.field_151166_bC, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.5, 0.7));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityToroNpc.class, 8.0f, 0.4, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.55));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIVillagerInteract((EntityVillager)this));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.55){

            protected Vec3d func_190864_f() {
                if (this.field_75457_a.func_70090_H() || this.field_75457_a.func_180799_ab()) {
                    Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)16, (int)8);
                    return vec3d == null ? super.func_190864_f() : vec3d;
                }
                return this.field_75457_a.func_70681_au().nextFloat() >= this.field_190865_h ? RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)10, (int)7) : super.func_190864_f();
            }
        });
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_145779_a(Items.field_151166_bC, this.field_70146_Z.nextInt(4) + 1);
        }
    }

    public ITextComponent func_145748_c_() {
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("entity.toroquest.fugitive.name", new Object[0]);
        textcomponenttranslation.func_150256_b().func_150209_a(this.func_174823_aP());
        textcomponenttranslation.func_150256_b().func_179989_a(this.func_189512_bd());
        return textcomponenttranslation;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187913_gm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191186_av;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187913_gm;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIHarvestFarmland((EntityVillager)this, 0.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        PLAYER_WITH_LEAD = new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer player) {
                return player.func_70089_S() && this.holdingLead(player);
            }

            private boolean holdingLead(EntityPlayer player) {
                return this.holdingLeadIn(player, EntityEquipmentSlot.MAINHAND) || this.holdingLeadIn(player, EntityEquipmentSlot.MAINHAND);
            }

            private boolean holdingLeadIn(EntityPlayer player, EntityEquipmentSlot mainhand) {
                ItemStack itemstack = player.func_184582_a(mainhand);
                return !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151058_ca;
            }
        };
    }
}

