/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.SoundHandler;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityConstructQuest;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.render.RenderConstruct;

public class EntityConstruct
extends EntityGolem
implements IMob {
    private int attackTimer;
    public static String NAME = "construct";
    protected boolean canShieldPush = false;
    protected int combatTicks = -1;
    protected int steamCounter = -1;
    protected boolean steamUp = false;
    protected int leaping = -1;

    public boolean func_174833_aM() {
        return false;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityConstruct.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)1, (boolean)true, (int)0x995533, (int)0x99AA33);
    }

    public int func_184649_cE() {
        return 5;
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityConstruct.class, (IRenderFactory)new IRenderFactory<EntityConstruct>(){

            public RenderConstruct createRenderFor(RenderManager manager) {
                return new RenderConstruct(manager);
            }
        });
    }

    public EntityConstruct(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.95f, 2.35f);
        this.field_70178_ae = true;
        this.field_70728_aV = 80;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Arrays.fill(this.field_82174_bp, 0.0f);
        Arrays.fill(this.field_184655_bs, 0.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag, 1));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151171_ah, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151149_ai, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151151_aj, 1));
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return cls != EntityConstruct.class && cls != EntityConstructQuest.class;
    }

    public static void registerFixesIronGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityConstruct.class);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.leaping > 0) {
            return false;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b());
        if (flag) {
            entityIn.field_70181_x += 0.41;
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187718_dS, 1.0f, 0.7f);
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source == null || source == DamageSource.field_76379_h || source.func_76346_g() == null || source.func_76347_k() || !this.func_70089_S()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase e = (EntityLivingBase)source.func_76346_g();
            if (this.field_70146_Z.nextBoolean() && !(e instanceof EntityConstruct)) {
                this.func_70624_b(e);
            }
            if (!source.func_82725_o() && source.func_76352_a()) {
                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                return false;
            }
            if (!(source.func_76352_a() || source.func_82725_o() || source.func_76347_k() || e.func_184614_ca().func_77973_b() instanceof ItemPickaxe || e.func_184614_ca().func_77973_b().getRegistryName().toString().contains("mace") || e.func_184614_ca().func_77973_b().getRegistryName().toString().contains("hammer"))) {
                double dist = e.func_70068_e((Entity)this);
                if (this.canShieldPush) {
                    this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    this.canShieldPush = false;
                    Vec3d velocityVector = new Vec3d(e.field_70165_t - this.field_70165_t, 0.0, e.field_70161_v - this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        e.func_70024_g(velocityVector.field_72450_a / (dist + 1.0) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.2), (0.22 - MathHelper.func_151237_a((double)(dist / 100.0), (double)0.0, (double)0.16)) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.0), velocityVector.field_72449_c / (dist + 1.0) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.2));
                        e.field_70133_I = true;
                    }
                }
                return false;
            }
        } else {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 20.0f, 20.0f);
            if (!this.func_70638_az().func_70089_S()) {
                this.func_70624_b(null);
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.0 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
        if (this.func_70638_az() instanceof EntityConstruct) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            PathNavigateGround pathnavigateground;
            Path path;
            double dist = this.func_70068_e((Entity)this.func_70638_az()) + 1.0;
            if (dist <= 200.0) {
                int tt = this.combatTicks % 200;
                if (tt % 10 == 0) {
                    this.canShieldPush = true;
                }
                if (tt == 0 || this.field_70146_Z.nextBoolean() && tt == 12 || this.field_70146_Z.nextBoolean() && tt % 33 == 0) {
                    if (tt == 0) {
                        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    }
                    switch (this.field_70146_Z.nextInt(4)) {
                        case 0: {
                            this.func_184185_a(SoundHandler.STEAM_0, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                            break;
                        }
                        case 1: {
                            this.func_184185_a(SoundHandler.STEAM_1, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                            break;
                        }
                        case 2: {
                            this.func_184185_a(SoundHandler.STEAM_2, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                            break;
                        }
                        case 3: {
                            this.func_184185_a(SoundHandler.STEAM_3, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                        }
                    }
                    this.steamCounter = 10;
                    this.steamUp = this.field_70146_Z.nextBoolean();
                }
                if (tt >= 100 && tt <= 108) {
                    if (tt == 100) {
                        this.attackTimer = 13;
                        this.func_184185_a(SoundEvents.field_187552_ah, 2.0f, 0.3f);
                        this.func_184185_a(SoundEvents.field_187749_eC, 2.0f, 0.8f);
                        this.func_184185_a(SoundEvents.field_187715_dR, 1.5f, 0.8f + this.field_70146_Z.nextFloat() / 10.0f);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                    } else if (tt == 108) {
                        this.leaping = 4;
                    }
                    Vec3d velocityVector = new Vec3d(this.func_70638_az().field_70165_t - this.field_70165_t, 0.0, this.func_70638_az().field_70161_v - this.field_70161_v);
                    double d0 = 0.0;
                    double d1 = 0.0;
                    if (dist < 64.0) {
                        d0 = velocityVector.field_72450_a / (dist + 64.0);
                        d1 = velocityVector.field_72449_c / (dist + 64.0);
                    }
                    this.func_70024_g(d0, 0.16, d1);
                    this.field_70133_I = true;
                }
                ++this.combatTicks;
            } else {
                this.combatTicks = -1;
                this.canShieldPush = true;
                this.leaping = -1;
            }
            if (this.leaping > 0) {
                if (this.field_70122_E || this.field_70171_ac || this.func_180799_ab()) {
                    if (--this.leaping <= 0) {
                        this.leaping = -1;
                        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                        this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 0.7f + this.field_70146_Z.nextFloat() / 10.0f);
                        List e = this.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(10.0, 10.0, 10.0), (Predicate)new Predicate<EntityLivingBase>(){

                            public boolean apply(@Nullable EntityLivingBase entity) {
                                return true;
                            }
                        });
                        for (EntityLivingBase entity : e) {
                            if (entity == this || !(dist <= 81.0) || !(entity.field_70163_u - this.field_70163_u < 0.7) || !(this.field_70163_u - entity.field_70163_u < 2.7)) continue;
                            entity.func_70024_g(0.8 / (entity.field_70165_t - this.field_70165_t), MathHelper.func_151237_a((double)(0.8 / Math.sqrt(dist)), (double)0.1, (double)0.4), 0.8 / (entity.field_70161_v - this.field_70161_v));
                            entity.field_70133_I = true;
                            entity.func_70097_a(new DamageSource("explosion"), (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() - Math.sqrt(dist) * 2.0));
                            entity.func_130011_c((Entity)this);
                            entity.func_70604_c((EntityLivingBase)this);
                        }
                    }
                } else {
                    this.func_70024_g(0.0, -0.08, 0.0);
                }
            }
            if (this.steamCounter >= 0) {
                if (this.steamUp) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                }
                --this.steamCounter;
            }
            if (this.field_70123_F && (path = (pathnavigateground = (PathNavigateGround)this.func_70661_as()).func_75505_d()) != null && !path.func_75879_b()) {
                for (int i2 = 0; i2 < Math.min(path.func_75873_e() + 2, path.func_75874_d()); ++i2) {
                    PathPoint pathpoint = path.func_75877_a(i2);
                    for (int j2 = 8; j2 >= 0; --j2) {
                        BlockPos doorPosition = new BlockPos(pathpoint.field_75839_a + this.field_70146_Z.nextInt(3) - 2, pathpoint.field_75837_b + j2, pathpoint.field_75838_c + this.field_70146_Z.nextInt(3) - 2);
                        Block doorBlock = this.getBlockDoor(doorPosition);
                        if (doorBlock == null || doorBlock == Blocks.field_150350_a || !(doorBlock.func_176195_g(doorBlock.func_176223_P(), this.field_70170_p, doorPosition) <= 2.0f)) continue;
                        this.field_70170_p.func_175656_a(doorPosition, Blocks.field_150350_a.func_176223_P());
                        if (this.field_70146_Z.nextBoolean()) {
                            if (this.field_70146_Z.nextBoolean()) {
                                this.field_70170_p.func_175718_b(1021, doorPosition, 0);
                            } else {
                                this.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
                            }
                        }
                        this.field_70170_p.func_175718_b(2001, doorPosition, Block.func_149682_b((Block)doorBlock));
                    }
                }
            }
        }
    }

    private Block getBlockDoor(BlockPos pos) {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150357_h) {
            return null;
        }
        return block;
    }

    protected void playSteamEffect(boolean up) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        if (this.field_70146_Z.nextInt(5) == 0) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        if (up) {
            for (int i = 0; i < 5; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.01;
                double d1 = this.field_70146_Z.nextDouble() * 0.16;
                double d2 = this.field_70146_Z.nextGaussian() * 0.01;
                this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u - (double)0.2f + (double)this.field_70131_O, this.field_70161_v + (double)(this.field_70130_N / 2.0f), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                double d0 = -this.func_70040_Z().field_72450_a * 0.16 + this.field_70146_Z.nextGaussian() / 50.0;
                double d1 = this.field_70146_Z.nextDouble() * 0.016;
                double d2 = this.func_70040_Z().field_72449_c * 0.16 + this.field_70146_Z.nextGaussian() / 50.0;
                if (this.field_70146_Z.nextBoolean()) {
                    d0 = this.func_70040_Z().field_72450_a * 0.16 + this.field_70146_Z.nextGaussian() / 50.0;
                    d2 = -this.func_70040_Z().field_72449_c * 0.16 + this.field_70146_Z.nextGaussian() / 50.0;
                }
                this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u - (double)0.2f + (double)this.field_70131_O, this.field_70161_v + (double)(this.field_70130_N / 2.0f), d0, d1, d2, new int[0]);
            }
        }
    }

    protected void playJumpEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (int i = 0; i < 20; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.CLOUD;
            double d0 = this.field_70146_Z.nextGaussian() * 0.01;
            double d1 = this.field_70146_Z.nextDouble() * 0.15;
            double d2 = this.field_70146_Z.nextGaussian() * 0.01;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u, this.field_70161_v + (double)(this.field_70130_N / 2.0f), d0, d1, d2, new int[0]);
        }
    }

    protected void playStompEffect() {
        double y;
        double x;
        int i;
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.CLOUD;
            x = (double)MathHelper.func_76133_a((double)((double)i / 15.0)) * 0.75;
            y = (double)MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0)) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u - (double)0.1f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, 0.0, y, new int[0]);
        }
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.CLOUD;
            x = (double)MathHelper.func_76133_a((double)((double)i / 15.0)) * 0.75;
            y = (double)(-MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0))) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u - (double)0.1f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, 0.0, y, new int[0]);
        }
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.CLOUD;
            x = (double)(-MathHelper.func_76133_a((double)((double)i / 15.0))) * 0.75;
            y = (double)MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0)) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, 0.0, y, new int[0]);
        }
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.CLOUD;
            x = (double)(-MathHelper.func_76133_a((double)((double)i / 15.0))) * 0.75;
            y = (double)(-MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0))) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, 0.0, y, new int[0]);
        }
    }

    protected void playDeathEffect() {
        double y;
        double x;
        int i;
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.CLOUD;
            x = (double)MathHelper.func_76133_a((double)((double)i / 15.0)) * 0.75;
            y = (double)MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0)) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, this.field_70146_Z.nextDouble(), y, new int[0]);
        }
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.CLOUD;
            x = (double)MathHelper.func_76133_a((double)((double)i / 15.0)) * 0.75;
            y = (double)(-MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0))) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, this.field_70146_Z.nextDouble(), y, new int[0]);
        }
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.CLOUD;
            x = (double)(-MathHelper.func_76133_a((double)((double)i / 15.0))) * 0.75;
            y = (double)MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0)) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, this.field_70146_Z.nextDouble(), y, new int[0]);
        }
        for (i = 0; i <= 15; ++i) {
            enumparticletypes = this.field_70146_Z.nextInt(5) == 0 ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.CLOUD;
            x = (double)(-MathHelper.func_76133_a((double)((double)i / 15.0))) * 0.75;
            y = (double)(-MathHelper.func_76133_a((double)((15.0 - (double)i) / 15.0))) * 0.75;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, this.field_70146_Z.nextDouble(), y, new int[0]);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 13;
            this.func_184185_a(SoundEvents.field_187718_dS, 1.0f, 0.7f);
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187578_au, 1.0f, 0.7f + this.field_70146_Z.nextFloat() / 10.0f);
        } else if (id == 6) {
            this.playSteamEffect(true);
        } else if (id == 7) {
            this.playSteamEffect(false);
        } else if (id == 8) {
            this.attackTimer = 13;
            this.playJumpEffect();
        } else if (id == 9) {
            this.playStompEffect();
        } else if (id == 10) {
            this.playDeathEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && !(entityIn instanceof EntityConstruct) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.STEAM_AMBIENT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this.field_70146_Z.nextBoolean()) {
            this.func_184185_a(SoundHandler.STEAM_STEP_0, 0.8f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        } else {
            this.func_184185_a(SoundHandler.STEAM_STEP_1, 0.8f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        this.func_184185_a(SoundEvents.field_187676_dE, 2.0f, 0.5f + this.field_70146_Z.nextFloat() / 10.0f);
    }

    public void func_70645_a(DamageSource cause) {
        if (ToroQuestConfiguration.steamGolemsDropLoot) {
            this.dropLoot();
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        this.func_184185_a(SoundEvents.field_187539_bB, 1.5f, 0.7f + this.field_70146_Z.nextFloat() / 10.0f);
        List e = this.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(10.0, 10.0, 10.0), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                return true;
            }
        });
        for (EntityLivingBase entity : e) {
            double dist = this.func_70068_e((Entity)entity) + 1.0;
            if (entity == this || !(dist <= 81.0) || !(entity.field_70163_u - this.field_70163_u < 0.7) || !(this.field_70163_u - entity.field_70163_u < 2.7)) continue;
            entity.func_70024_g(0.8 / (entity.field_70165_t - this.field_70165_t), MathHelper.func_151237_a((double)(0.8 / Math.sqrt(dist)), (double)0.1, (double)0.4), 0.8 / (entity.field_70161_v - this.field_70161_v));
            entity.field_70133_I = true;
            entity.func_70097_a(new DamageSource("explosion"), (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() - Math.sqrt(dist) * 2.0));
            entity.func_130011_c((Entity)this);
            entity.func_70604_c((EntityLivingBase)this);
        }
        super.func_70645_a(cause);
    }

    public void dropLoot() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack(Items.field_151137_ax, this.field_70146_Z.nextInt(3) + 1);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            this.field_70170_p.func_72838_d((Entity)dropItem);
            stack = new ItemStack(Items.field_151016_H, this.field_70146_Z.nextInt(3) + 1);
            dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            this.field_70170_p.func_72838_d((Entity)dropItem);
            stack = new ItemStack(Items.field_151166_bC, 1);
            dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

