/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityOrc;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.EntityToroVillager;

public class EntityCaravan
extends EntityToroVillager
implements IMerchant {
    public static String NAME = "caravan";
    public boolean escorted = false;
    protected Random field_70146_Z = new Random();
    protected int despawnTimer = 300;
    protected boolean canSpawnBandits = true;
    protected boolean backupLeash = true;

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.despawnTimer = compound.func_74762_e("customDespawnTimer");
        this.backupLeash = compound.func_74767_n("backupLeash");
        this.canSpawnBandits = compound.func_74767_n("canSpawnBandits");
        super.func_70037_a(compound);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("customDespawnTimer", this.despawnTimer);
        compound.func_74757_a("backupLeash", this.backupLeash);
        compound.func_74757_a("canSpawnBandits", this.canSpawnBandits);
        super.func_70014_b(compound);
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityCaravan.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0, (int)14735033);
    }

    public EntityCaravan(World worldIn) {
        super(worldIn, 0);
    }

    @Override
    protected boolean func_70692_ba() {
        return this.despawnTimer <= 0;
    }

    public void addCaravan() {
        if (!this.field_70170_p.field_72995_K) {
            EntityMule mule = new EntityMule(this.field_70170_p);
            mule.func_184211_a(this.func_110124_au().toString());
            mule.func_184211_a("toroquest_caravan");
            mule.func_174820_d(499, new ItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae)));
            mule.func_174820_d(400, new ItemStack(Items.field_151141_av));
            if (this.field_70146_Z.nextInt(4) == 0) {
                int i;
                for (i = this.field_70146_Z.nextInt(4) + 4; i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151025_P, 1));
                }
                for (i = this.field_70146_Z.nextInt(4) + 4; i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151015_O, 5));
                }
            } else if (this.field_70146_Z.nextInt(4) == 0) {
                for (int i = this.field_70146_Z.nextInt(4) + 4; i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151166_bC, 5));
                }
            } else if (this.field_70146_Z.nextInt(4) == 0) {
                int i;
                for (i = this.field_70146_Z.nextInt(4) + 4; i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_179555_bs, 5));
                }
                for (i = this.field_70146_Z.nextInt(4) + 2; i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151116_aA, 5));
                }
            } else {
                int i;
                for (i = this.field_70146_Z.nextInt(3) + 2; i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_185164_cV, 5));
                }
                for (i = this.field_70146_Z.nextInt(4); i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151034_e, 5));
                }
                for (i = this.field_70146_Z.nextInt(4); i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151172_bF, 5));
                }
                for (i = this.field_70146_Z.nextInt(4); i > 0; --i) {
                    mule.func_174820_d(500 + this.field_70146_Z.nextInt(18), new ItemStack(Items.field_151174_bG, 5));
                }
            }
            mule.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            mule.getEntityData().func_74768_a("despawnTimer", 300);
            mule.getEntityData().func_74776_a("raidSpeed", 1.0f);
            mule.getEntityData().func_74768_a("raidX", 0);
            mule.getEntityData().func_74768_a("raidZ", 0);
            this.field_70170_p.func_72838_d((Entity)mule);
            mule.func_184226_ay();
            mule.func_70014_b(new NBTTagCompound());
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K || this.escorted) {
            return;
        }
        if (!this.escorted && this.field_70173_aa % 20 == 0) {
            Province province;
            if (this.underAttack != null) {
                this.blockedTrade = (short)(this.blockedTrade - 1);
                if (this.blockedTrade <= 0) {
                    this.underAttack = null;
                } else {
                    return;
                }
            }
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0));
            if (this.field_70173_aa % 100 == 0 && this.despawnTimer-- < 0 && (players.isEmpty() || this.field_70170_p.func_72820_D() == 22000L && this.despawnTimer < -150 || this.despawnTimer < -300)) {
                this.func_70606_j(0.0f);
                this.func_70106_y();
                return;
            }
            List mules = this.field_70170_p.func_175647_a(EntityMule.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0), (Predicate)new Predicate<EntityMule>(){

                public boolean apply(@Nullable EntityMule entity) {
                    return true;
                }
            });
            for (EntityMule mule : mules) {
                if (!mule.func_70089_S() || !mule.func_190695_dh() || !mule.func_110257_ck() || !mule.func_184216_O().contains(this.field_96093_i.toString())) continue;
                if (mule.func_110166_bE() == null || !mule.func_110167_bD()) {
                    if (this.despawnTimer > 290) {
                        mule.func_110162_b((Entity)this, true);
                    } else if (this.backupLeash) {
                        mule.func_110162_b((Entity)this, true);
                        this.backupLeash = false;
                        this.func_70014_b(new NBTTagCompound());
                    }
                }
                if (this.field_70146_Z.nextBoolean() && !mule.func_184188_bt().isEmpty()) {
                    mule.func_184226_ay();
                    this.func_184185_a(SoundEvents.field_187913_gm, 1.0f, 1.0f);
                }
                if (!(mule.func_70032_d((Entity)this) > 9.0f)) continue;
                mule.func_70661_as().func_75497_a((Entity)this, 1.5);
            }
            if (this.canSpawnBandits && this.field_70146_Z.nextInt(200) == 0 && this.spawnBanditsNearPlayer()) {
                this.canSpawnBandits = false;
                this.func_70014_b(new NBTTagCompound());
            }
            if ((province = CivilizationUtil.getProvinceAt(this.field_70170_p, this.field_70176_ah, this.field_70164_aj)) != null && Math.abs(this.field_70165_t - (double)province.getCenterPosX()) + Math.abs(this.field_70161_v - (double)province.getCenterPosZ()) <= 86.0) {
                float multiplier = 1.0f;
                for (EntityMule mule : mules) {
                    if (mule == null || !mule.func_70089_S() || !mule.func_184216_O().contains(this.field_96093_i.toString())) continue;
                    mule.func_184226_ay();
                    mule.func_110160_i(true, false);
                    this.func_110160_i(true, false);
                    if (ToroQuestConfiguration.removeMuleOnCaravanEscort) {
                        try {
                            mule.func_184226_ay();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        mule.func_70606_j(0.0f);
                        mule.func_70106_y();
                    } else {
                        try {
                            mule.getEntityData().func_82580_o("despawnTimer");
                            mule.getEntityData().func_82580_o("raidSpeed");
                            mule.getEntityData().func_82580_o("raidX");
                            mule.getEntityData().func_82580_o("raidZ");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    multiplier += 0.25f;
                }
                for (EntityPlayer player : players) {
                    TextComponentString message = new TextComponentString("\u00a7lCaravan Escorted!\u00a7r");
                    this.escorted = true;
                    player.func_146105_b((ITextComponent)message, true);
                    this.func_184185_a(SoundEvents.field_187786_du, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                    EventHandlers.adjustPlayerRep(player, province.civilization, (int)((float)ToroQuestConfiguration.escortCaravanRepGain * multiplier));
                }
                this.func_70606_j(0.0f);
                this.func_70106_y();
                EntityToroVillager newEntity = new EntityToroVillager(this.field_70170_p, this.func_70946_n());
                BlockPos pos = this.func_180425_c();
                newEntity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                newEntity.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)newEntity);
                return;
            }
            for (EntityPlayer player : players) {
                this.func_70661_as().func_75497_a((Entity)player, 0.6);
                TextComponentString message = new TextComponentString("\u00a7oEscorting Caravan\u00a7r");
                player.func_146105_b((ITextComponent)message, true);
                if (this.despawnTimer >= 0) continue;
                this.despawnTimer = 0;
            }
        }
    }

    protected boolean spawnBanditsNearPlayer() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        try {
            for (int tries = 3; tries > 0; --tries) {
                int playerPosZ;
                int playerPosX;
                if (this.field_70170_p.field_73011_w.getDimension() != 0 || CivilizationUtil.getProvinceAt(this.field_70170_p, (playerPosX = (int)this.field_70165_t) / 16, (playerPosZ = (int)this.field_70161_v) / 16) != null) continue;
                int range = 40 + this.field_70146_Z.nextInt(20);
                double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                int x = (int)(Math.cos(angle) * (double)range);
                int z = (int)(Math.sin(angle) * (double)range);
                BlockPos banditSpawnPos = EventHandlers.findSpawnLocationFrom(this.field_70170_p, new BlockPos(x += playerPosX, EventHandlers.MAX_SPAWN_HEIGHT, z += playerPosZ));
                if (banditSpawnPos == null || CivilizationUtil.getProvinceAt(this.field_70170_p, banditSpawnPos.func_177958_n() / 16, banditSpawnPos.func_177952_p() / 16) != null || !this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(banditSpawnPos).func_72314_b(25.0, 10.0, 25.0)).isEmpty()) continue;
                int amountToSpawn = 3;
                if (ToroQuestConfiguration.orcsAreNeutral || this.field_70146_Z.nextBoolean()) {
                    for (int i = amountToSpawn; i > 0; --i) {
                        EntitySentry e = new EntitySentry(this.field_70170_p, playerPosX * 2 - banditSpawnPos.func_177958_n(), playerPosZ * 2 - banditSpawnPos.func_177952_p());
                        e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                        this.field_70170_p.func_72838_d((Entity)e);
                        e.despawnTick();
                        e.field_70133_I = true;
                        e.func_70624_b((EntityLivingBase)this);
                        e.func_70014_b(new NBTTagCompound());
                    }
                } else {
                    for (int i = amountToSpawn; i > 0; --i) {
                        EntityOrc e = new EntityOrc(this.field_70170_p, playerPosX * 2 - banditSpawnPos.func_177958_n(), playerPosZ * 2 - banditSpawnPos.func_177952_p());
                        e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                        this.field_70170_p.func_72838_d((Entity)e);
                        e.despawnTick();
                        e.field_70133_I = true;
                        e.func_70624_b((EntityLivingBase)this);
                        e.func_70014_b(new NBTTagCompound());
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR SPAWNING Caravan Bandits: " + e);
        }
        return false;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

