/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityVampireBat;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAIThrow;
import net.torocraft.toroquest.entities.ai.EntityAIZombieLeap;
import net.torocraft.toroquest.entities.render.RenderBas;

public class EntityBas
extends EntitySkeleton
implements IMob {
    public static String NAME = "bas";
    public static DataParameter<Integer> RAID_X;
    public static DataParameter<Integer> RAID_Y;
    public static DataParameter<Integer> RAID_Z;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationY() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Y));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityBas.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBas.class, (IRenderFactory)new IRenderFactory<EntityBas>(){

            public Render<EntityBas> createRenderFor(RenderManager manager) {
                return new RenderBas(manager);
            }
        });
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_174833_aM() {
        return false;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public int func_184649_cE() {
        return 10;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(64.0);
    }

    public EntityBas(World world) {
        super(world);
        this.func_110163_bv();
        int x = this.getRaidLocationX();
        int y = this.getRaidLocationY();
        int z = this.getRaidLocationZ();
        if (y != 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.8));
        }
        this.setUpEntity();
    }

    private void setUpEntity() {
        this.func_110163_bv();
        this.func_70105_a(1.95f, 3.5f);
        this.setRealSize(1.95f, 3.5f);
        this.field_70728_aV = 320;
        this.field_70178_ae = true;
        this.field_70138_W = 4.05f;
    }

    public EntityBas(World world, int x, int y, int z) {
        super(world);
        this.setRaidLocation(x, y, z);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.8));
        this.setUpEntity();
    }

    public void faceMovingDirection() {
        try {
            float f1;
            PathPoint p = this.func_70661_as().func_75505_d().func_75870_c();
            double d0 = ((double)p.field_75839_a - this.field_70165_t) * 2.0;
            double d2 = ((double)p.field_75838_c - this.field_70161_v) * 2.0;
            double d1 = (double)p.field_75837_b - this.field_70163_u;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
            this.field_70177_z = f;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void setRealSize(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184641_n(false);
    }

    public float func_70047_e() {
        return 2.2f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_184641_n(false);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.spawnBat(null);
        this.spawnBat(null);
        this.spawnBat(null);
        if ((int)this.field_70163_u != 0 && this.getRaidLocationY() == 0) {
            this.setRaidLocation((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        return livingdata;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
        super.func_184651_r();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIThrow((EntityCreature)this, 1.0, true, 0.2, 30));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIZombieLeap((EntityLiving)this, 0.4f, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void spawnSweepParticles() {
        this.func_184185_a(SoundEvents.field_187718_dS, 1.0f, 0.6f + this.field_70146_Z.nextFloat() / 6.0f);
        this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 0.6f + this.field_70146_Z.nextFloat() / 6.0f);
        this.func_184185_a(SoundEvents.field_187688_dI, 1.0f, 0.5f);
        double xx = this.field_70165_t + (double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 0.02f)));
        double yy = this.field_70163_u + (double)this.field_70131_O * 0.2;
        double zz = this.field_70161_v + (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof WorldServer) {
            for (int i = 16; i > 0; --i) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, xx + this.field_70146_Z.nextGaussian() / 6.0, yy + this.field_70146_Z.nextGaussian() / 6.0, zz + this.field_70146_Z.nextGaussian() / 6.0, 0, 0.0, 0.0, 0.0, 0.01, new int[0]);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            this.spawnSweepParticles();
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void spawnBat(EntityLivingBase target) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(32.0, 16.0, 32.0)).size();
        int batCount = this.field_70170_p.func_72872_a(EntityVampireBat.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(32.0, 16.0, 32.0)).size();
        if (batCount > 7 * players) {
            return;
        }
        EntityVampireBat mob = new EntityVampireBat(this.field_70170_p);
        if (target == null) {
            BlockPos pos = new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(9) - 4.0, this.field_70163_u + 6.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(9) - 4.0);
            if (mob.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && mob.field_70170_p.func_180495_p(pos = new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(9) - 4.0, this.field_70163_u + 6.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(9) - 4.0)).func_177230_c() != Blocks.field_150350_a) {
                mob.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            mob.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            BlockPos pos = new BlockPos(target.field_70165_t + (double)this.field_70146_Z.nextInt(9) - 4.0, target.field_70163_u + 4.0 + (double)this.field_70146_Z.nextInt(2), target.field_70161_v + (double)this.field_70146_Z.nextInt(9) - 4.0);
            if (mob.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && mob.field_70170_p.func_180495_p(pos = new BlockPos(target.field_70165_t + (double)this.field_70146_Z.nextInt(9) - 4.0, target.field_70163_u + 4.0 + (double)this.field_70146_Z.nextInt(2), target.field_70161_v + (double)this.field_70146_Z.nextInt(9) - 4.0)).func_177230_c() != Blocks.field_150350_a) {
                mob.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            mob.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        this.field_70170_p.func_72838_d((Entity)mob);
        if (target != null) {
            mob.func_70624_b(target);
        }
    }

    public void func_70636_d() {
        double dist;
        EntityLivingBase attacker;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() != null) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 20.0f, 20.0f);
        }
        float health = this.func_110143_aJ() / this.func_110138_aP();
        this.bossInfo.func_186735_a(health);
        if (this.field_70173_aa % 25 == 0) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                if (this.func_70638_az() instanceof EntityPlayer && !this.teleportToEntity((Entity)this.func_70638_az())) {
                    this.teleportTo(this.getRaidLocationX().intValue(), this.getRaidLocationY().intValue(), this.getRaidLocationZ().intValue());
                }
                this.spawnBat(null);
            }
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f) - 1.0, this.field_70161_v, 2, 0.1, 0.1, 0.1, 0.01, new int[0]);
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        }
        if (((attacker = this.func_70638_az()) == null || !attacker.func_70089_S()) && (attacker = this.func_70643_av()) != null && attacker.func_70089_S()) {
            this.func_70624_b(attacker);
        }
        if (attacker != null && attacker.func_70089_S() && (dist = this.func_70068_e((Entity)attacker)) < 8.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (source == null || this.func_180431_b(source) || source == DamageSource.field_76379_h || source.func_76346_g() == null || !this.func_70089_S()) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.spawnBat((EntityLivingBase)source.func_76346_g());
            }
        } else if (this.field_70146_Z.nextBoolean() && source.func_76346_g() instanceof EntityLivingBase) {
            if (this.field_70146_Z.nextBoolean()) {
                this.spawnBat((EntityLivingBase)source.func_76346_g());
            } else {
                this.spawnBat(null);
            }
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            double dist = source.func_76346_g().func_174818_b(this.func_180425_c());
            if (dist > 256.0) {
                amount = (float)((double)amount * (256.0 / dist));
            }
            if (!(source.func_76346_g() instanceof EntityPlayer)) {
                amount /= 16.0f;
            }
        }
        boolean flag = super.func_70097_a(source, amount);
        if (this.field_70146_Z.nextInt(3) == 0 && !this.teleportRandomly() && this.getRaidLocationY() != 0) {
            this.teleportTo(this.getRaidLocationX().intValue(), this.getRaidLocationY().intValue(), this.getRaidLocationZ().intValue());
        }
        return flag;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 40.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(40) - 20);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 40.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        boolean flag = this.func_184595_k(x, y, z);
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return true;
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropLoot();
        }
    }

    private void dropLoot() {
        this.dropTrophy();
        this.dropLootItem(Items.field_151103_aS, this.field_70146_Z.nextInt(100) + 20);
        this.dropLootItem(Items.field_151044_h, this.field_70146_Z.nextInt(20) + 5);
    }

    private void dropTrophy() {
        ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:trophy_skeleton"));
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = 0.5;
        dropItem.field_70179_y = 0.0;
        dropItem.field_70159_w = 0.0;
        this.field_70170_p.func_72838_d((Entity)dropItem);
        dropItem.func_184195_f(true);
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        this.func_184185_a(SoundEvents.field_190036_ha, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 6.0f);
        this.func_184185_a(SoundEvents.field_187533_aW, 1.0f, 0.6f + this.field_70146_Z.nextFloat() / 6.0f);
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(SoundEvents.field_190038_hc, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 6.0f);
        this.func_184185_a(SoundEvents.field_187531_aU, 1.0f, 0.8f * this.field_70146_Z.nextFloat() / 6.0f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_190037_hb, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 6.0f);
        this.func_184185_a(SoundEvents.field_187530_aT, 1.0f, 0.8f);
        return null;
    }

    protected SoundEvent func_190727_o() {
        this.func_184185_a(SoundEvents.field_190039_hd, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 6.0f);
        return null;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        RAID_X = EntityDataManager.func_187226_a(EntityBas.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Y = EntityDataManager.func_187226_a(EntityBas.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Z = EntityDataManager.func_187226_a(EntityBas.class, (DataSerializer)DataSerializers.field_187192_b);
    }
}

