/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.AIArcher;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.EntityToroMob;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.render.RenderBanditLord;

public class EntityBanditLord
extends EntitySentry
implements IRangedAttackMob,
IMob {
    public static String NAME = "bandit_lord";
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    protected final AIArcher<EntityBanditLord> aiArrowAttack = new AIArcher<EntityBanditLord>(this, 0.4, 20, 40.0f);
    protected int stance = this.field_70146_Z.nextInt(6) + 5;
    protected float strafeVer = 0.0f;
    protected float strafeHor = 0.0f;
    protected int actionTimer = 0;
    public float capeAni = 0.0f;
    public boolean capeAniUp = true;
    protected boolean blocking = false;
    protected int blockingTimer = 0;
    protected int lastTargetY = 0;
    protected int canSwap = 0;

    public boolean func_174833_aM() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    @Override
    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityBanditLord.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)1, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    @Override
    public int func_184649_cE() {
        return 10;
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBanditLord.class, (IRenderFactory)new IRenderFactory<EntityBanditLord>(){

            public RenderBanditLord createRenderFor(RenderManager manager) {
                return new RenderBanditLord(manager);
            }
        });
    }

    public EntityBanditLord(World world) {
        super(world);
        this.func_110163_bv();
        this.func_70105_a(0.95f, 2.7f);
        this.field_70138_W = 3.05f;
        this.func_96094_a("...");
        this.func_174805_g(false);
        this.field_70728_aV = 240;
        this.field_70178_ae = true;
        Arrays.fill(this.field_184655_bs, 0.0f);
        Arrays.fill(this.field_82174_bp, 0.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
    }

    @Override
    public float func_70047_e() {
        return 2.5f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_184641_n(false);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.banditAttackDamage * 1.5 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_180431_b(source) || source == DamageSource.field_76379_h || source == null || source.func_76346_g() == null || !this.func_70089_S()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityToroMob) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            double dist = source.func_76346_g().func_174818_b(this.func_180425_c());
            if (dist > 256.0) {
                amount = (float)((double)amount * (256.0 / dist));
            }
            if (!(source.func_76346_g() instanceof EntityPlayer)) {
                amount /= 16.0f;
            }
            this.callForHelp((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        float f1 = this.func_110143_aJ();
        this.func_110142_aN().func_94547_a(damageSrc, f1, damageAmount);
        this.func_70606_j(f1 - damageAmount);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        this.func_174820_d(100 + EntityEquipmentSlot.HEAD.func_188454_b(), ItemStack.field_190927_a);
        super.func_70645_a(cause);
    }

    @Override
    public void dropLoot() {
        if (!this.field_70170_p.field_72995_K) {
            this.dropTrophy();
            this.weaponMain = new ItemStack(Item.func_111206_d((String)"spartanweaponry:warhammer_gold"), 1);
            if (this.weaponMain.func_190926_b()) {
                this.weaponMain = new ItemStack(Items.field_151006_E, 1);
            }
            this.weaponMain.func_151001_c("Sledge");
            this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)"minecraft:unbreaking"), 10);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.weaponMain);
            dropItem.func_174868_q();
            dropItem.field_70181_x = 0.25;
            dropItem.field_70179_y = 0.0;
            dropItem.field_70159_w = 0.0;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    @Override
    public void addEquipment() {
    }

    private void dropTrophy() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:legendary_bandit_helmet"), 1);
            stack.func_77966_a(Enchantment.func_180305_b((String)"minecraft:binding_curse"), 1);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
            dropItem.func_174868_q();
            dropItem.field_70181_x = 0.25;
            dropItem.field_70179_y = 0.0;
            dropItem.field_70159_w = 0.0;
            this.field_70170_p.func_72838_d((Entity)dropItem);
            dropItem.func_184195_f(true);
            this.dropLootItem(Items.field_151166_bC, 5);
            this.dropLootItem(Items.field_151166_bC, 5);
            this.dropLootItem(Items.field_151166_bC, 5);
            ItemStack head = new ItemStack(Item.func_111206_d((String)"toroquest:royal_helmet"), 1);
            EntityItem dropHead = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, head.func_77946_l());
            this.field_70170_p.func_72838_d((Entity)dropHead);
        }
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 25 == 0) {
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            if (this.func_70051_ag()) {
                AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
            } else {
                this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            List arrows = this.field_70170_p.func_175647_a(EntityArrow.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(8.0, 8.0, 8.0), (Predicate)new Predicate<EntityArrow>(){

                public boolean apply(@Nullable EntityArrow entity) {
                    return entity.field_70142_S == 0.0 && entity.field_70250_c == EntityBanditLord.this.func_70638_az();
                }
            });
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (!arrows.isEmpty()) {
                this.stance = this.field_70146_Z.nextInt(6) + 5;
                AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                this.blockingTimer = dist <= 12.0 ? 25 : 50;
                this.blocking = true;
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                this.canShieldPush = true;
                this.func_184602_cy();
                this.func_184598_c(EnumHand.OFF_HAND);
                this.func_184608_ct();
                this.strafeVer = 0.4f;
            }
            this.lastTargetY = (int)(Math.abs(this.field_70163_u - this.func_70638_az().field_70163_u) + 0.5);
            ItemStack iStack = this.func_184614_ca();
            if (!this.inCombat) {
                this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                this.func_70661_as().func_75499_g();
                this.canShieldPush = true;
                this.func_184602_cy();
                this.inCombat = true;
                this.stance = this.field_70146_Z.nextInt(6) + 5;
                AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                if (this.field_70122_E && this.func_70661_as().func_75494_a((Entity)this.func_70638_az()) == null) {
                    this.blockingTimer = -200;
                } else {
                    this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                    this.func_70661_as().func_75499_g();
                }
            }
            if (dist < (double)(200 + this.blockingTimer) || this.lastTargetY < 4 && dist <= 20.0 && this.func_70685_l((Entity)this.func_70638_az())) {
                if (iStack != null && (iStack.func_77973_b() instanceof ItemBow || iStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa))) {
                    this.canShieldPush = true;
                    this.func_184602_cy();
                    this.func_184185_a(SoundEvents.field_187725_r, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 10.0f);
                    this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                    this.func_70661_as().func_75499_g();
                    if (!this.field_70170_p.field_72995_K) {
                        this.setMeleeWeapon();
                    }
                    this.blockingTimer = 0;
                }
                if (!this.blocking && !this.func_70051_ag() && dist <= 12.0 && this.blockingTimer <= -((int)((double)(this.stance * 5) + dist + 20.0)) && this.func_70643_av() != null && this.func_70643_av().func_70089_S()) {
                    this.stance = this.field_70146_Z.nextInt(8) + 3;
                    AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                    this.blockingTimer = (int)MathHelper.func_151237_a((double)((double)(this.field_70146_Z.nextInt(70) + 20) - dist), (double)20.0, (double)80.0);
                    this.blocking = true;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                    this.canShieldPush = true;
                    this.func_184602_cy();
                    this.func_184598_c(EnumHand.OFF_HAND);
                    this.func_184608_ct();
                    this.strafeVer = dist <= 6.0 ? 0.2f : 0.4f;
                } else if (this.blocking && this.blockingTimer % 16 == 0) {
                    this.canShieldPush = true;
                    this.strafeVer = dist <= 3.0 ? 0.2f : 0.4f;
                }
                if (this.blocking && this.blockingTimer <= 0) {
                    this.blocking = false;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
                    this.stance = this.field_70146_Z.nextInt(8) + 3;
                    AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                    this.canShieldPush = true;
                    this.func_184602_cy();
                } else if (!this.blocking && dist <= 64.0 && (this.blockingTimer == -12 || this.blockingTimer == -32 || this.blockingTimer < -32 && this.blockingTimer % 14 == 0) && this.field_70146_Z.nextInt(3) == 0) {
                    this.stance = this.field_70146_Z.nextInt(8) + 3;
                    AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                }
                if (!this.blocking) {
                    float strafeMod = 1.0f;
                    if (this.stance < 5) {
                        this.func_70031_b(false);
                        if (dist <= 32.0 && dist > 2.0) {
                            Vec3d velocityVector;
                            if (this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                                double push = 1.0 + 3.7 * dist;
                                this.func_70024_g(velocityVector.field_72450_a / push, -0.002, velocityVector.field_72449_c / push);
                                this.field_70133_I = true;
                            }
                            this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)0.4f);
                            this.func_70605_aq().func_188488_a(-1.0f, this.getStrafe(this.stance));
                        } else {
                            this.stance = this.field_70146_Z.nextInt(6) + 5;
                            this.func_70661_as().func_75499_g();
                            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                        }
                        if (this.field_70146_Z.nextBoolean()) {
                            --this.blockingTimer;
                        }
                        return;
                    }
                    if (dist <= 2.0) {
                        this.strafeVer = 0.4f;
                    } else if (dist <= 4.0) {
                        this.strafeVer = 0.8f;
                        strafeMod = 0.9f;
                    } else if (dist <= 9.0) {
                        this.strafeVer = 0.9f;
                        strafeMod = 0.8f;
                    } else {
                        this.strafeVer = 1.0f;
                        strafeMod = 0.7f;
                    }
                    if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                        Vec3d velocityVector;
                        if (dist >= 12.0) {
                            --this.blockingTimer;
                        } else if (dist <= 1.5) {
                            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                            this.func_70661_as().func_75499_g();
                        } else if (dist <= 3.0 && this.field_70122_E && !this.func_70051_ag() && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + dist * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                        if (this.field_70163_u + 1.5 < this.func_70638_az().field_70163_u) {
                            this.func_70605_aq().func_188488_a(this.strafeVer, 0.0f);
                            if (this.field_70122_E && this.field_70146_Z.nextInt(10) == 0) {
                                this.func_70024_g(0.0, 0.38, 0.0);
                                this.field_70133_I = true;
                            }
                        } else {
                            this.func_70605_aq().func_188488_a(this.strafeVer, this.getStrafe(this.stance) * strafeMod);
                        }
                    } else {
                        this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                        if (this.field_70122_E && !this.field_70160_al) {
                            this.func_70661_as().func_75499_g();
                        }
                    }
                } else {
                    if (this.strafeVer < 0.4f) {
                        Vec3d velocityVector;
                        if (!this.field_70170_p.field_72995_K && this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + dist * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                    } else if (this.strafeVer > 0.4f) {
                        this.strafeVer = 0.4f;
                    }
                    if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                        this.func_70605_aq().func_188488_a(this.strafeVer, this.getStrafe(this.stance) * 1.5f);
                    } else {
                        this.func_70605_aq().func_188488_a(this.strafeVer * 0.5f, this.getStrafe(this.stance) * 0.5f);
                    }
                }
            } else if (iStack != null && !(iStack.func_77973_b() instanceof ItemBow)) {
                if (!this.field_70122_E) {
                    this.field_70159_w /= 2.0;
                    this.field_70179_y /= 2.0;
                }
                this.blocking = false;
                this.blockingTimer = -200;
                this.canShieldPush = true;
                this.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f, 1));
                    this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                }
                this.func_70604_c(this.func_70638_az());
                this.strafeVer = 0.0f;
                this.stance = 0;
                this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                this.func_70661_as().func_75499_g();
            }
            --this.blockingTimer;
        } else if (this.blocking || this.inCombat) {
            this.inCombat = false;
            this.blocking = false;
            this.func_70624_b(null);
            this.canShieldPush = true;
            this.func_184602_cy();
            this.field_184628_bn = 0;
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.guardKnockBackResistance);
            this.stance = 0;
            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.func_70661_as().func_75499_g();
            this.aggroTimer = 0;
        }
    }

    @Override
    public boolean func_70617_f_() {
        if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() instanceof ItemBow) {
            return false;
        }
        return super.func_70617_f_();
    }

    public void setMeleeWeapon() {
        this.weaponMain = new ItemStack(Item.func_111206_d((String)"spartanweaponry:warhammer_gold"), 1);
        if (this.weaponMain.func_190926_b()) {
            this.weaponMain = new ItemStack(Items.field_151006_E, 1);
        }
        this.weaponMain.func_151001_c("Sledge");
        this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)"minecraft:unbreaking"), 10);
        this.func_184611_a(EnumHand.MAIN_HAND, this.weaponMain);
        this.weaponOff = new ItemStack(Item.func_111206_d((String)"spartanshields:shield_basic_gold"), 1);
        if (this.weaponOff.func_190926_b()) {
            this.weaponOff = new ItemStack(Items.field_185159_cQ, 1);
        }
        this.func_184611_a(EnumHand.OFF_HAND, this.weaponOff);
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(false);
        this.func_184641_n(false);
        this.setMeleeWeapon();
        this.inCombat = false;
        this.blocking = false;
        this.blockingTimer = 0;
        this.func_70624_b(null);
        this.func_70604_c(null);
        this.func_184602_cy();
        this.func_184598_c(EnumHand.MAIN_HAND);
        this.field_184628_bn = 0;
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
        this.strafeVer = 0.0f;
        this.strafeHor = 0.0f;
        this.func_70605_aq().func_188488_a(0.0f, 0.0f);
        this.func_70661_as().func_75499_g();
        ItemStack head = new ItemStack(Item.func_111206_d((String)"toroquest:royal_helmet"), 1);
        this.func_184201_a(EntityEquipmentSlot.HEAD, head);
        return livingdata;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (target == null) {
            return;
        }
        EntityArrow entityarrow0 = this.getArrow(distanceFactor);
        EntityArrow entityarrow1 = this.getArrow(distanceFactor);
        EntityArrow entityarrow2 = this.getArrow(distanceFactor);
        entityarrow0.func_70243_d(true);
        entityarrow1.func_70243_d(true);
        entityarrow2.func_70243_d(true);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 2.0 - entityarrow0.field_70163_u - 1.5 - this.field_70146_Z.nextDouble();
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow0.func_70015_d(12);
        entityarrow1.func_70015_d(12);
        entityarrow2.func_70015_d(12);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.5f + 0.8f));
        entityarrow0.func_70186_c(d0, d1 + d3 * 0.2, d2, 2.35f, 4.0f);
        this.field_70170_p.func_72838_d((Entity)entityarrow0);
        entityarrow1.func_70186_c(d0, d1 + d3 * 0.2, d2, 2.35f, 4.0f);
        this.field_70170_p.func_72838_d((Entity)entityarrow1);
        entityarrow2.func_70186_c(d0, d1 + d3 * 0.2, d2, 2.35f, 4.0f);
        this.field_70170_p.func_72838_d((Entity)entityarrow2);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

