/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntitySentry;

public class AIAttackWithSword
extends EntityAIBase {
    protected World world;
    protected EntityCreature attacker;
    protected int attackTick = 0;
    protected double speedTowardsTarget;
    protected Path path;
    protected boolean offhandAttack = false;
    protected boolean bigWeapon = false;
    protected double range = 3.25;
    protected Random rand = new Random();

    public AIAttackWithSword(EntityCreature creature, double speedIn) {
        this.attacker = creature;
        this.world = creature.field_70170_p;
        this.speedTowardsTarget = speedIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.func_75253_b()) {
            return false;
        }
        if (!(this.attacker instanceof EntitySentry)) {
            this.path = this.attacker.func_70661_as().func_75494_a((Entity)this.attacker.func_70638_az());
            if (this.path != null) {
                return true;
            }
        }
        return this.getAttackReachSqr(this.attacker.func_70638_az()) >= this.attacker.func_70092_e(this.attacker.func_70638_az().field_70165_t, this.attacker.func_70638_az().func_174813_aQ().field_72338_b, this.attacker.func_70638_az().field_70161_v);
    }

    public boolean func_75253_b() {
        if (this.attacker.func_184614_ca().func_77973_b() instanceof ItemBow) {
            return false;
        }
        if (this.attacker.func_70638_az() == null) {
            return false;
        }
        return this.attacker.func_70638_az().func_70089_S();
    }

    public void func_75249_e() {
        ItemStack iStack = this.attacker.func_184614_ca();
        if (iStack != null && !iStack.func_190926_b()) {
            String s = iStack.func_77973_b().getRegistryName().toString();
            if (s.contains("pike_")) {
                this.range = 4.5;
                this.bigWeapon = true;
            } else if (s.contains("spear_")) {
                this.range = 3.85;
                this.bigWeapon = true;
            } else if (s.contains("glaive_")) {
                this.range = 3.85;
                this.bigWeapon = true;
            } else if (s.contains("halberd_")) {
                this.range = 3.85;
                this.bigWeapon = true;
            } else if (s.contains("greatsword_")) {
                this.range = 3.85;
                this.bigWeapon = true;
            } else if (s.contains("lance_")) {
                this.range = 3.85;
                this.bigWeapon = true;
            } else if (s.contains("staff")) {
                this.range = 3.85;
                this.bigWeapon = true;
            }
        }
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
    }

    public void func_75251_c() {
        this.attacker.func_70031_b(false);
    }

    public void func_75246_d() {
        if (!this.func_75253_b()) {
            return;
        }
        this.attacker.func_70625_a((Entity)this.attacker.func_70638_az(), 30.0f, 30.0f);
        this.attacker.func_70671_ap().func_75651_a((Entity)this.attacker.func_70638_az(), 30.0f, 30.0f);
        double d0 = this.attacker.func_70092_e(this.attacker.func_70638_az().field_70165_t, this.attacker.func_70638_az().func_174813_aQ().field_72338_b, this.attacker.func_70638_az().field_70161_v);
        --this.attackTick;
        this.checkAndPerformAttack(this.attacker.func_70638_az(), d0);
    }

    protected void checkAndPerformAttack(EntityLivingBase victim, double distanceSq) {
        int tt;
        EntityCreature e;
        boolean backPeddaling = false;
        if (this.attacker instanceof EntitySentry) {
            e = (EntitySentry)this.attacker;
            if (e.isDrinkingPotion()) {
                this.attackTick = 10;
                backPeddaling = true;
                return;
            }
            if (e.stance < 5) {
                backPeddaling = true;
            }
            if (e.flanking) {
                backPeddaling = true;
            }
        } else if (this.attacker instanceof EntityGuard) {
            e = (EntityGuard)this.attacker;
            if (((EntityGuard)e).stance < 5) {
                backPeddaling = true;
            }
        }
        this.attacker.func_70031_b(false);
        if (!(this.attacker.field_70123_F || backPeddaling || this.attacker.func_184587_cr() || (tt = Math.abs(this.attackTick - 5) % 40) >= 3)) {
            this.attacker.func_70031_b(true);
            if (tt == 0 && distanceSq <= 12.0) {
                if (distanceSq >= 3.5 && this.attacker.field_70122_E && this.rand.nextInt(5) == 0) {
                    if (!this.world.field_72995_K) {
                        Vec3d velocityVector = new Vec3d(victim.field_70165_t - this.attacker.field_70165_t, 0.0, victim.field_70161_v - this.attacker.field_70161_v);
                        this.attacker.func_70024_g(velocityVector.field_72450_a / 12.0, 0.3, velocityVector.field_72449_c / 12.0);
                        this.attacker.field_70133_I = true;
                    }
                } else if (!this.world.field_72995_K) {
                    Vec3d velocityVector = new Vec3d(victim.field_70165_t - this.attacker.field_70165_t, 0.0, victim.field_70161_v - this.attacker.field_70161_v);
                    this.attacker.func_70024_g(velocityVector.field_72450_a / 10.0, 0.02, velocityVector.field_72449_c / 10.0);
                    this.attacker.field_70133_I = true;
                }
            }
        }
        double attackDistance = this.getAttackReachSqr(victim);
        if (this.attacker.func_184600_cs().equals((Object)EnumHand.OFF_HAND)) {
            this.attackTick = 7;
        } else if (distanceSq <= attackDistance && this.attackTick <= 0) {
            if (this.offhandAttack) {
                this.attacker.func_184609_a(EnumHand.OFF_HAND);
                this.attackTick = this.bigWeapon ? 18 + this.rand.nextInt(9) : 12 + this.rand.nextInt(9);
                this.offhandAttack = false;
                this.attacker.func_70652_k((Entity)victim);
                return;
            }
            this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            this.attackTick = this.bigWeapon ? 30 + this.rand.nextInt(11) : 20 + this.rand.nextInt(11);
            this.attacker.func_70652_k((Entity)victim);
            ItemStack iStack = this.attacker.func_184586_b(EnumHand.OFF_HAND);
            if (!(iStack == null || iStack.func_190926_b() || iStack.func_77973_b() instanceof ItemBow || iStack.func_77973_b() instanceof ItemPotion || iStack.func_77973_b() instanceof ItemShield)) {
                this.offhandAttack = true;
                this.attackTick = 12 + this.rand.nextInt(9);
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return (double)this.attacker.field_70130_N * this.range * (double)this.attacker.field_70130_N * this.range + (double)attackTarget.field_70130_N + this.rand.nextDouble() / 8.0;
    }

    public static boolean canReach(EntityCreature creature) {
        return !creature.func_70661_as().func_75500_f();
    }
}

