/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.item.ItemBow;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public class AIArcher<T extends EntityLiving>
extends EntityAIBase {
    private final T entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private Random rand = new Random();
    private float hStrafeMod = (float)(this.rand.nextInt(6) + 1) / 14.0f;
    private float vStrafeMod = (float)(this.rand.nextInt(3) + 1) / 14.0f;

    public AIArcher(T p_i47515_1_, double p_i47515_2_, int p_i47515_4_, float p_i47515_5_) {
        this.entity = p_i47515_1_;
        this.moveSpeedAmp = p_i47515_2_;
        this.attackCooldown = p_i47515_4_;
        this.maxAttackDistance = p_i47515_5_;
        this.func_75248_a(3);
    }

    public void setAttackCooldown(int p_189428_1_) {
        this.attackCooldown = p_189428_1_;
    }

    public boolean func_75250_a() {
        return this.func_75253_b();
    }

    public boolean func_75253_b() {
        if (!(this.entity.func_184614_ca().func_77973_b() instanceof ItemBow)) {
            return false;
        }
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        return this.entity.func_70638_az().func_70089_S();
    }

    public void func_75249_e() {
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
        this.entity.func_70605_aq().func_188488_a(0.0f, 0.0f);
        this.entity.func_70661_as().func_75499_g();
        this.strafingClockwise = this.rand.nextBoolean();
        this.hStrafeMod = this.rand.nextFloat() * 0.4f + 0.08f;
        this.vStrafeMod = this.rand.nextFloat() * 0.3f + 0.06f;
        super.func_75249_e();
        ((IRangedAttackMob)this.entity).func_184724_a(true);
    }

    public void func_75251_c() {
        this.entity.func_70605_aq().func_188488_a(0.0f, 0.0f);
        this.entity.func_70661_as().func_75499_g();
        if (this.entity.func_70638_az() != null && (this.entity.func_70638_az().field_70128_L || this.entity.func_70638_az().func_110143_aJ() <= 0.0f)) {
            this.entity.func_70624_b(null);
        }
        ((IRangedAttackMob)this.entity).func_184724_a(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
    }

    public void func_75246_d() {
        if (this.func_75250_a()) {
            double d0 = this.entity.func_70032_d((Entity)this.entity.func_70638_az());
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az());
            boolean seeTimeIsGreaterThanZero = this.seeTime > 0;
            boolean outOfReach = false;
            this.entity.func_70625_a((Entity)this.entity.func_70638_az(), 20.0f, 20.0f);
            if (canSee != seeTimeIsGreaterThanZero) {
                this.seeTime = 0;
            }
            if (canSee) {
                this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 20.0f, 20.0f);
                ++this.seeTime;
            } else {
                --this.seeTime;
            }
            if (this.seeTime <= -80) {
                Vec3d vec3d;
                if (this.entity instanceof EntityCreature && (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)((EntityCreature)this.entity), (int)12, (int)6, (Vec3d)this.entity.func_70638_az().func_174791_d())) != null && this.entity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.55)) {
                    this.entity.func_70624_b(null);
                    return;
                }
                return;
            }
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70605_aq().func_188488_a(0.0f, 0.0f);
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), this.moveSpeedAmp);
                this.entity.func_70031_b(true);
                this.strafingTime = -1;
            }
            if (d0 > (double)this.maxAttackDistance) {
                outOfReach = true;
                if (++this.attackTime >= this.attackCooldown) {
                    this.func_75251_c();
                }
            }
            float hAmount = this.hStrafeMod;
            float vAmount = this.vStrafeMod;
            float sChance = 0.2f;
            if (this.entity.func_184218_aH()) {
                sChance = 0.1f;
            }
            if (this.strafingTime >= 20) {
                if (this.entity.func_70681_au().nextFloat() < sChance) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.entity.func_70681_au().nextFloat() < sChance) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            boolean moveTo = false;
            if (this.strafingTime > -1 && canSee) {
                if (d0 > (double)(this.maxAttackDistance * 0.6f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.36f)) {
                    this.strafingBackwards = true;
                }
                if (this.attackTime != 0) {
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -vAmount / 2.0f : vAmount, this.strafingClockwise ? -hAmount : hAmount);
                } else {
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -vAmount / 4.0f : hAmount / 2.0f, this.strafingClockwise ? -hAmount / 2.0f : hAmount / 2.0f);
                }
            } else {
                moveTo = true;
            }
            if (!outOfReach) {
                if (this.entity.func_184587_cr()) {
                    int i;
                    if (!canSee && this.seeTime <= -80) {
                        if (++this.attackTime >= this.attackCooldown) {
                            this.func_75251_c();
                        }
                    } else if (canSee && this.seeTime >= 10 && (i = this.entity.func_184612_cw()) >= 20) {
                        this.entity.func_184602_cy();
                        ((IRangedAttackMob)this.entity).func_82196_d(this.entity.func_70638_az(), ItemBow.func_185059_b((int)i));
                        this.attackTime = this.attackCooldown;
                    }
                    return;
                }
                if (--this.attackTime <= 0 && this.seeTime >= 10 && canSee) {
                    this.entity.func_184598_c(EnumHand.MAIN_HAND);
                }
                return;
            }
            if (!this.entity.func_184587_cr()) {
                moveTo = true;
            }
            if (moveTo) {
                this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), this.moveSpeedAmp);
            }
            if (!((EntityLiving)this.entity).field_70122_E || ((EntityLiving)this.entity).field_70160_al || ((EntityLiving)this.entity).field_70123_F || ((EntityLiving)this.entity).field_70124_G) {
                ((EntityLiving)this.entity).field_70159_w *= 0.1;
                ((EntityLiving)this.entity).field_70179_y *= 0.1;
                ((EntityLiving)this.entity).field_70133_I = true;
            }
        }
    }
}

