/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.config;

import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ToroQuestConfiguration {
    private static final String CATEGORY = "ToroQuest Settings";
    private static final String CATEGORY_SKINS = "Custom Mob Skins";
    private static final String CATEGORY_TRADES = "Trades";
    private static final String CATEGORY_RAIDS = "Village Raids";
    private static final String CATEGORY_MOBS = "Mobs";
    private static final String CATEGORY_WEAPONS = "Bandit, Orc, and Guard Weapons & Shields";
    private static final String CATEGORY_GEN = "Generation";
    private static final String CATEGORY_SPAWNING = "Spawning";
    private static final String CATEGORY_BOSSES = "Bosses";
    private static final String CATEGORY_REPUTATION = "Reputation";
    private static Configuration config;
    public static boolean useCrownToCreateNewProvinces;
    public static boolean removeProvinceOnLordDeath;
    public static boolean coinTradeSounds;
    public static float bossHealthMultiplier;
    public static float bossAttackDamageMultiplier;
    public static int banditBaseHealth;
    public static float banditAttackDamage;
    public static int banditArmor;
    public static int banditArmorToughness;
    public static int orcBaseHealth;
    public static float orcAttackDamage;
    public static int orcArmor;
    public static int orcArmorToughness;
    public static float banditAndOrcFleeHealthPercentageBase;
    public static float banditAndOrcFleeHealthPercentageRange;
    public static float banditAndOrcKnockBackResistance;
    public static float guardKnockBackResistance;
    public static boolean showGatedTradesAsLocked;
    public static float guardSpeakChance;
    public static int guardBaseHealth;
    public static float guardAttackDamage;
    public static int guardArmor;
    public static int guardArmorToughness;
    public static float guardDamageBaseMultiplierToMobs;
    public static float guardDamageBaseMultiplierToPlayers;
    public static float trophyTitanAdditionalGuardDamageMulitiplier;
    public static float guardDamageBaseMultiplierToMobsOutsideProvinceOrToBosses;
    public static int minBaseHealthToBeConsideredBossMob;
    public static int configRaiderSiegeChance;
    public static boolean disableKeep;
    public static boolean disableShop;
    public static boolean disableGuardTower;
    public static boolean disableBarracks;
    public static int maxSpawnHeight;
    public static int minSpawnHeight;
    public static int villagerUniqueShopInventoryVarients;
    public static int toroVillagerMateChance;
    public static float villageDoorsModifier;
    public static int maxVillagersPerVillage;
    public static boolean replaceWoolLanternsWithActualLanterns;
    public static String turkeyBlockResourceName;
    public static String cakeBlockResourceName;
    public static String chandelierResourceName;
    public static String candleResourceName;
    public static String tableResourceName;
    public static String chairResourceName;
    public static String lanternResourceName;
    public static String chainResourceName;
    public static String craftingTableResourceName;
    public static String enchantingTableResourceName;
    public static boolean replaceVillageChestsWithTrappedChests;
    public static boolean toastReputationLevels;
    public static float banditArmorDropChance;
    public static float banditHandsDropChance;
    public static float guardArmorDropChance;
    public static float guardHandsDropChance;
    public static boolean banditsUseBoats;
    public static boolean banditsDropEmeralds;
    public static boolean banditsDropMasks;
    public static boolean orcsDropEmeralds;
    public static boolean orcsDropMasks;
    public static boolean steamGolemsDropLoot;
    public static boolean anyAnimalForBreedQuest;
    public static boolean cartographerMapTrade;
    public static int banditsDropPotions;
    public static boolean renderGuardCape;
    public static boolean renderArrowLayer;
    public static boolean renderBanditMask;
    public static boolean renderOrcMask;
    public static boolean banditsHaveArmorForSpartanWeaponry;
    public static boolean guardsHaveArmorForSpartanWeaponry;
    public static boolean showProvinceEnterTitle;
    public static boolean sendRepLevelMessage;
    public static boolean mobsAttackGuards;
    public static boolean iMobAttackVillagers;
    public static boolean removeMuleOnCaravanEscort;
    public static boolean broadcastLordSlain;
    public static boolean enderIdolTeleport;
    public static boolean titanBoss;
    public static boolean pigBoss;
    public static boolean banditBoss;
    public static boolean golemBoss;
    public static boolean skeletonBoss;
    public static boolean spiderBoss;
    public static boolean mageBoss;
    public static boolean enderBoss;
    public static int unexpensiveRepLoss;
    public static int leashVillagerRepLoss;
    public static int fireGriefRepLoss;
    public static int lavaGriefRepLoss;
    public static int murderLivestockRepLoss;
    public static int abandonQuestRepLoss;
    public static int expensiveRepLoss;
    public static int murderRepLoss;
    public static int healthOfMobNeededToGainOneRep;
    public static int donateEmeraldRepGain;
    public static int donateBanditMaskRepGain;
    public static int recruitGuardRepGain;
    public static int returnFugitiveRepGain;
    public static int escortCaravanRepGain;
    public static int donateArtifactRepGain;
    public static int donateTrophyRepGain;
    public static boolean disableTreeChoppingQuest;
    public static boolean toastQuestCompletion;
    public static String scrollTradeItem;
    public static int scrollTradeAmount;
    public static int bannerTradeAmount;
    public static int maxTradeAmount;
    public static int tradeInventoryAmount;
    public static int destroyedVillagesNearSpawnDistance;
    public static boolean unregisterDestroyedVillages;
    public static boolean useBiomeSpecificProvinces;
    public static boolean unleashSandwhichHorrorOnVillages;
    public static boolean useIronBarsForHeadSpike;
    public static boolean specificEntityNames;
    public static boolean useDefaultVillagersOutsideOfProvince;
    public static boolean useDefaultVillagers;
    public static int banditMountChance;
    public static int goldenHorseArmorChance;
    public static int orcMountChance;
    public static boolean orcsAreNeutral;
    public static boolean loseReputationForCropGrief;
    public static boolean loseReputationForAnimalGrief;
    public static boolean loseReputationForBlockGrief;
    public static boolean showQuestCompletionAboveActionBar;
    public static boolean guardsHaveDialogue;
    public static boolean recruitBandits;
    public static boolean recruitVillagers;
    public static int zombieAttackVillageChance;
    public static int zombieRaiderVillagerChance;
    public static int provinceSiegeRate;
    public static int caravanSpawnRate;
    public static int shopKeeperSpawnChance;
    public static int banditSpawnRate;
    public static int fugitiveSpawnRate;
    public static int artifactDropRate;
    public static int disableMobSpawningNearVillage;
    public static int disableZombieSpawningNearVillage;
    public static String[] safePotionList;
    public static ArrayList<String> safePotions;
    public static String[] tradeList;
    public static ArrayList<Trade> trades;
    public static String[] gatedTradeList;
    public static ArrayList<GatedTrade> gatedTrades;
    public static String[] mobsList;
    public static ArrayList<KillMob> mobs;
    public static String[] donateList;
    public static ArrayList<Donate> donate;
    public static String[] raiderString_BROWN_MITHRIL;
    public static ArrayList<Raider> raiderList_BROWN_MITHRIL;
    public static String[] raiderString_GREEN_WILD;
    public static ArrayList<Raider> raiderList_GREEN_WILD;
    public static String[] raiderString_RED_BRIAR;
    public static ArrayList<Raider> raiderList_RED_BRIAR;
    public static String[] raiderString_BLACK_MOOR;
    public static ArrayList<Raider> raiderList_BLACK_MOOR;
    public static String[] raiderString_YELLOW_DAWN;
    public static ArrayList<Raider> raiderList_YELLOW_DAWN;
    public static String[] raiderString_BLUE_GLACIER;
    public static ArrayList<Raider> raiderList_BLUE_GLACIER;
    public static String[] banditShields;
    public static String[] banditOneHandedMeleeWeapons;
    public static String[] banditTwoHandedMeleeWeapons;
    public static String[] banditRangedWeapons;
    public static String[] banditShieldsPowerful;
    public static String[] banditOneHandedMeleeWeaponsPowerful;
    public static String[] banditTwoHandedMeleeWeaponsPowerful;
    public static String[] banditRangedWeaponsPowerful;
    public static String[] orcShields;
    public static String[] orcOneHandedMeleeWeapons;
    public static String[] orcTwoHandedMeleeWeapons;
    public static String[] orcRangedWeapons;
    public static String[] orcShieldsPowerful;
    public static String[] orcOneHandedMeleeWeaponsPowerful;
    public static String[] orcTwoHandedMeleeWeaponsPowerful;
    public static String[] orcRangedWeaponsPowerful;
    public static String[] enchantFirstBanditAndOrcMeleeWeapon;
    public static String[] enchantSecondBanditAndOrcMeleeWeapon;
    public static String[] enchantFirstBanditAndOrcShield;
    public static String[] enchantFirstBanditAndOrcRanged;
    public static String[] enchantSecondBanditAndOrcRanged;
    public static int enchantFirstBanditAndOrcChance;
    public static int enchantSecondBanditAndOrcChance;
    public static String guardWeapon_RED_BRIAR;
    public static String guardShield_RED_BRIAR;
    public static String guardWeapon_GREEN_WILD;
    public static String guardShield_GREEN_WILD;
    public static String guardWeapon_BROWN_MITHRIL;
    public static String guardShield_BROWN_MITHRIL;
    public static String guardWeapon_YELLOW_DAWN;
    public static String guardShield_YELLOW_DAWN;
    public static String guardWeapon_BLUE_GLACIER;
    public static String guardShield_BLUE_GLACIER;
    public static String guardWeapon_BLACK_MOOR;
    public static String guardShield_BLACK_MOOR;
    public static String greenName;
    public static String brownName;
    public static String redName;
    public static String blackName;
    public static String yellowName;
    public static String blueName;
    public static int banditSkins;
    public static int orcSkins;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ToroQuestConfiguration.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            Raider raider;
            String[] list;
            banditSkins = config.getInt("banditSkins", CATEGORY_SKINS, 36, 1, 5120, "The number of bandit skins in your Resource Folder (check mod description on CurseForge for details) that you wish to use. For example, in your folder you have bandit_1, bandit_2, bandit_3, bandit_4, bandit_5, then you would set this number to 5. Starts at bandit_1.");
            orcSkins = config.getInt("orcSkins", CATEGORY_SKINS, 16, 1, 5120, "The number of orc skins in your Resource Folder (check mod description on CurseForge for details) that you wish to use. For example, in your folder you have orc_1, orc_2, orc_3, then you would set this number to 3. Starts at orc_1.");
            useBiomeSpecificProvinces = config.getBoolean("useBiomeSpecificProvinces", CATEGORY_GEN, true, "If set to true, villages will generate their province based off the biome they are in, otherwise they will be random.  (I highly recommened you include the mod Mo' Villages so that villages spawn more frequently and in any biome. ***IMPORTANT*** If Biomes O' Plenty is installed I reccommend going through and changing the settings for each biome to canGenerateVillages=true. To have these changes persist, copy the files in the 'defaults' folder and paste them into the folder with the 'Put biome configs here' file so that the biome settings will not be overwritten! You can also use BiomeTweaker to allow villages to spawn in every biome!!!)");
            unregisterDestroyedVillages = config.getBoolean("unregisterDestroyedVillages", CATEGORY_GEN, true, "Village destoyed through destroyedVillagesNearSpawnDistance are unregistered and no longer show UI.");
            unleashSandwhichHorrorOnVillages = config.getBoolean("unleashSandwhichHorrorOnVillages", CATEGORY_GEN, true, "If set to true, a giant Sandwhich Horror comes through to destroy structures, grief chests, and eats all the poor innocent villagers in villages. Guards should just 'git gud' next time. #rekt");
            useIronBarsForHeadSpike = config.getBoolean("useIronBarsForHeadSpike", CATEGORY_GEN, true, "If set to true, use iron bars for the head spikes that generate in villages.");
            destroyedVillagesNearSpawnDistance = config.getInt("destroyedVillagesNearSpawnDistance", CATEGORY_GEN, 320, 0, Integer.MAX_VALUE, "Villages within X blocks of [0,0] will generate as ruined/raided/destoyed villages.");
            lanternResourceName = config.getString("lanternResourceName", CATEGORY_GEN, "futuremc:lantern", "Resource string for Lanterns that generate in villages. Some mods (futuremc or rustic) add lanterns so pick your fav.");
            replaceWoolLanternsWithActualLanterns = config.getBoolean("replaceWoolLanternsWithActualLanterns", CATEGORY_GEN, true, "Replaces the wool lanterns in villages with hanging lanterns. Uses the lanterns as the lanternResourceName option.");
            chainResourceName = config.getString("chainResourceName", CATEGORY_GEN, "futuremc:chain", "Resource string for Chains that generate in villages.");
            craftingTableResourceName = config.getString("craftingTableResourceName", CATEGORY_GEN, "minecraft:crafting_table", "Resource string for Crafting Tables that generate in villages. This setting is mostly for me, I change the crafting tables with thebetweenlands ones because the items show up on top which looks cool.");
            turkeyBlockResourceName = config.getString("turkeyBlockResourceName", CATEGORY_GEN, "betteranimalsplus:turkey_cooked", "Resource string for Turkey Blocks that generate in villages.");
            cakeBlockResourceName = config.getString("cakeBlockResourceName", CATEGORY_GEN, "minecraft:cake", "Resource string for Cake Blocks that generate in villages.");
            chandelierResourceName = config.getString("chandelierResourceName", CATEGORY_GEN, "rustic:chandelier", "Resource string for Chandelier that generate in villages.");
            candleResourceName = config.getString("candleResourceName", CATEGORY_GEN, "rustic:candle", "Resource string for Candle that generate in villages.");
            tableResourceName = config.getString("tableResourceName", CATEGORY_GEN, "rustic:table_oak", "Resource string for Tables that generate in villages.");
            chairResourceName = config.getString("chairResourceName", CATEGORY_GEN, "rustic:chair_spruce", "Resource string for Chairs that generate in villages.");
            replaceVillageChestsWithTrappedChests = config.getBoolean("replaceVillageChestsWithTrappedChests", CATEGORY_GEN, true, "Replace the chests that generate in villages with trapped chests. Stealing/ breaking a trapped chest will trigger a crime report. However, stealing/ breaking normal chests is not a crime! This is so players can place their usual normal chests in villages and open/use them without getting aggrod by every guard in sight. This setting replaces those normal chests that generate in villages with trapped ones to differentiate between (normal) player chests and (trapped) village chests.");
            enchantingTableResourceName = config.getString("enchantingTableResourceName", CATEGORY_GEN, "minecraft:enchanting_table", "Resource string for Enchanting Tables that generate in villages.");
            disableKeep = config.getBoolean("disableKeep", CATEGORY_GEN, false, "Disable this structure from village generation.");
            disableShop = config.getBoolean("disableShop", CATEGORY_GEN, false, "Disable this structure from village generation.");
            disableGuardTower = config.getBoolean("disableGuardTower", CATEGORY_GEN, false, "Disable this structure from village generation.");
            disableBarracks = config.getBoolean("disableBarracks", CATEGORY_GEN, false, "Disable this structure from village generation.");
            toroVillagerMateChance = config.getInt("toroVillagerMateChance", CATEGORY_MOBS, 1200, 1, Integer.MAX_VALUE, "Chance for villagers to mate (vanilla is 500). However, villagers no longer need to be 'willing' (enough food and/or enough trades), they only need a bed to mate.");
            villageDoorsModifier = config.getFloat("villageDoorsModifier", CATEGORY_MOBS, 0.4f, 0.0f, 8.0f, "If the number of (village doors) * villageDoorsModifier is less than the number of (villagers), then allow villagers to breed (vanilla is 0.35F, lower value means more villagers breeding, 0.5F means 2 villagers are allowed per valid village door. Set to 0.0F to disable breeding).");
            maxVillagersPerVillage = config.getInt("maxVillagersPerVillage", CATEGORY_MOBS, 20, 0, 256, "The number of villagers allowed in a village.");
            orcsAreNeutral = config.getBoolean("orcsAreNeutral", CATEGORY_MOBS, false, "Enable to make orcs neutral like pigmen.");
            mobsAttackGuards = config.getBoolean("mobsAttackGuards", CATEGORY_MOBS, true, "Enable to have mobs attack guards on sight.");
            iMobAttackVillagers = config.getBoolean("iMobAttackVillagers", CATEGORY_MOBS, true, "Enable to add have all IMobs attack villagers on sight.");
            useDefaultVillagersOutsideOfProvince = config.getBoolean("useDefaultVillagersOutsideOfProvince", CATEGORY_MOBS, true, "Enable to make default villagersspawn (instead of toro villagers) outside the bounds of a province. Enable this if you want to be able to trade with villagers that spawn from random structures such as Recurrent Complex.");
            useDefaultVillagers = config.getBoolean("useDefaultVillagers", CATEGORY_MOBS, false, "If you are using another village mod such as Minecraft Comes Alive, enable this to disable toro villagers and allow normal villager spawning.");
            banditsDropEmeralds = config.getBoolean("banditsDropEmeralds", CATEGORY_MOBS, true, "Enable to allow bandits a 1/3 chance to drop 1-3 Emeralds on death.");
            banditsUseBoats = config.getBoolean("banditsUseBoats", CATEGORY_MOBS, true, "Enable to allow bandits to use boats to make them a deadly threat on water.");
            banditsDropPotions = config.getInt("banditsDropPotions", CATEGORY_MOBS, 6, 0, 128, "Chance ( 1 out of X ) for bandits to drop 1 Potion on death. Set to 0 to disable.");
            banditsDropMasks = config.getBoolean("banditsDropMasks", CATEGORY_MOBS, true, "Enable to allow orcs to drop their masks on death, which can be worn or turned in for reputation.");
            steamGolemsDropLoot = config.getBoolean("steamGolemsDropLoot", CATEGORY_MOBS, true, "Enable to allow Steam Golems to drop loot.");
            orcsDropEmeralds = config.getBoolean("orcsDropEmeralds", CATEGORY_MOBS, true, "Enable to allow orcs a 1/3 chance to drop 1-4 Emeralds on death.");
            orcsDropMasks = config.getBoolean("orcsDropMasks", CATEGORY_MOBS, false, "Enable to allow ors to drop their masks on death, which can be worn or turned in for reputation. If this is true, they will become neutral to players wearing masks as well.");
            banditHandsDropChance = config.getFloat("banditHandsDropChance", CATEGORY_MOBS, 0.3f, 0.0f, 1.0f, "Chance for bandits to drop their held items on death.");
            banditArmorDropChance = config.getFloat("banditArmorDropChance", CATEGORY_MOBS, 0.1f, 0.0f, 1.0f, "Chance for bandits to drop their armor on death. Does nothing if banditsHaveArmorForSpartanWeaponry is set to false.");
            guardHandsDropChance = config.getFloat("guardHandsDropChance", CATEGORY_MOBS, 0.3f, 0.0f, 1.0f, "Chance for guards to drop their held items on death.");
            guardArmorDropChance = config.getFloat("guardArmorDropChance", CATEGORY_MOBS, 0.1f, 0.0f, 1.0f, "Chance for guards to drop their armor on death. Does nothing if guardsHaveArmorForSpartanWeaponry is set to false.");
            renderGuardCape = config.getBoolean("renderGuardCape", CATEGORY_MOBS, true, "Enable to allow cape to be rendered/ visible on guards. Disabling this will very slightly improve performance on the client.");
            renderArrowLayer = config.getBoolean("renderArrowLayer", CATEGORY_MOBS, true, "Enable to allow arrows to be rendered/ visible on guards, bandits, and orc. Disabling this will very slightly improve performance on the client.");
            renderBanditMask = config.getBoolean("renderBanditMask", CATEGORY_MOBS, true, "Enable to allow mask to be rendered/ visible on bandits.");
            renderOrcMask = config.getBoolean("renderOrcMask", CATEGORY_MOBS, false, "Enable to allow mask to be rendered/ visible on orcs.");
            banditsHaveArmorForSpartanWeaponry = config.getBoolean("banditsHaveArmorForSpartanWeaponry", CATEGORY_MOBS, true, "Enable to have sabers, rapiers, and warhammers deal the correct damage against bandits and orcs. This setting, when true, adds leather armor to bandits (which is not rendered! Meaning it will be invisible). However, if banditArmorDropChance is higher than 0, they will be able to drop leather armor.");
            guardsHaveArmorForSpartanWeaponry = config.getBoolean("guardsHaveArmorForSpartanWeaponry", CATEGORY_MOBS, true, "Enable to have sabers, rapiers, warhammers, and hammers deal the correct damage against guards. This setting, when true, adds chainmail armor to guards (which is not rendered! Meaning it will be invisible). However, if guardArmorDropChance is higher than 0, they will be able to drop chainmail armor.");
            removeMuleOnCaravanEscort = config.getBoolean("removeMuleOnCaravanEscort", CATEGORY_MOBS, false, "Setting this to true despawns the caravan's mule after the caravan has been escorted.");
            guardsHaveDialogue = config.getBoolean("guardsHaveDialogue", CATEGORY_MOBS, true, "Enable to allow guards to speak in the chat. I worked very hard adding all that dialogue so shame on you if this is set to false. But I get it, sometimes dialogue really doesn't fit in minecraft.");
            guardSpeakChance = config.getFloat("guardSpeakChance", CATEGORY_MOBS, 0.3f, 0.0f, 1.0f, "Chance for guards to speak to players who are near them. The value 0.3f means a 30% chance to speak, and if they do not, their ability to speak passively will be put on a cooldown.");
            guardDamageBaseMultiplierToMobs = config.getFloat("guardDamageBaseMultiplierToMobs", CATEGORY_MOBS, 1.0f, 0.0f, 16.0f, "Guard base multiplier to mobs, use this to increase or decrease damage guards deal to mobs,");
            guardDamageBaseMultiplierToPlayers = config.getFloat("guardDamageBaseMultiplierToPlayers", CATEGORY_MOBS, 0.7f, 0.25f, 16.0f, "Guard base multiplier to players, use this to increase or decrease damage guards deal to players.");
            trophyTitanAdditionalGuardDamageMulitiplier = config.getFloat("trophyTitanAdditionalGuardDamageMulitiplier", CATEGORY_MOBS, 1.5f, 1.0f, 16.0f, "Guard damage is muliplied by this amount (default 1.5) to mobs in provinces with the titan trophy active.");
            guardDamageBaseMultiplierToMobsOutsideProvinceOrToBosses = config.getFloat("guardDamageBaseMultiplierToMobsOutsideProvinceOrToBosses", CATEGORY_MOBS, 0.6f, 0.0f, 1.0f, "Guard damage is multiplied by this value while outside a province or when fighting bosses. This is useful if you want to prevent the effectiveness of players using guards to 'cheese' bosses.");
            minBaseHealthToBeConsideredBossMob = config.getInt("minBaseHealthToBeConsideredBossMob", CATEGORY_MOBS, 500, 0, 2560, "When a mob has at least minBaseHealthToBeConsideredBossMob health, they will be considered a 'boss'. This is useful for mods with powerful creatures you don't want players to 'cheese' with guards.");
            guardBaseHealth = config.getInt("guardBaseHealth", CATEGORY_MOBS, 30, 1, 256, "Base HP of guards.");
            guardArmor = config.getInt("guardArmor", CATEGORY_MOBS, 0, 0, 20, "Guard armor value.");
            guardAttackDamage = config.getFloat("guardAttackDamage", CATEGORY_MOBS, 5.0f, 0.0f, 256.0f, "Guard attack damage value.");
            guardArmorToughness = config.getInt("guardArmorToughness", CATEGORY_MOBS, 8, 0, 20, "Guard armor toughness value.");
            banditBaseHealth = config.getInt("banditBaseHealth", CATEGORY_MOBS, 20, 1, 256, "Base HP of bandits.");
            banditAttackDamage = config.getFloat("banditAttackDamage", CATEGORY_MOBS, 4.0f, 0.0f, 256.0f, "Bandit attack damage value.");
            banditArmor = config.getInt("banditArmor", CATEGORY_MOBS, 0, 0, 20, "Armor value of bandits.");
            banditArmorToughness = config.getInt("banditArmorToughness", CATEGORY_MOBS, 0, 0, 20, "Armor toughness value of orcs.");
            orcBaseHealth = config.getInt("orcBaseHealth", CATEGORY_MOBS, 24, 1, 256, "Base HP of orcs.");
            orcArmor = config.getInt("orcArmor", CATEGORY_MOBS, 0, 0, 20, "Armor value of orcs.");
            orcAttackDamage = config.getFloat("orcAttackDamage", CATEGORY_MOBS, 4.0f, 0.0f, 256.0f, "Orc attack damage value.");
            orcArmorToughness = config.getInt("orcArmorToughness", CATEGORY_MOBS, 0, 0, 20, "Armor toughness value of orcs.");
            banditMountChance = config.getInt("banditMountChance", CATEGORY_MOBS, 10, 0, 100, "The chance (out of 10) for a group of non-village-raiding bandits to spawn as archers on horse mounts. Set to 0 to disable.");
            goldenHorseArmorChance = config.getInt("goldenHorseArmorChance", CATEGORY_MOBS, 30, 0, 100, "The chance (out of 10) for a bandit mount to spawn with golden horse armor. Set to 0 to disable.");
            orcMountChance = config.getInt("orcMountChance", CATEGORY_MOBS, 0, 0, 100, "The chance (out of 10) for a group of non-village-raiding orcs to spawn as archers on horse mounts. Set to 0 to disable.");
            banditAndOrcFleeHealthPercentageBase = config.getFloat("banditAndOrcFleeHealthPercentageBase", CATEGORY_MOBS, 0.15f, 0.0f, 1.0f, "Base percentage of health that will cause orcs & bandits to flee until they heal up. 0.15F is 15% of their maximum health.");
            banditAndOrcFleeHealthPercentageRange = config.getFloat("banditAndOrcFleeHealthPercentageRange", CATEGORY_MOBS, 0.15f, 0.0f, 1.0f, "Random percentage that is added to the base flee amount for orcs & bandits. By default, bandits will flee randomly when below a random percentage between 15% to 30% of their maximum health.");
            maxSpawnHeight = config.getInt("maxSpawnHeight", CATEGORY_SPAWNING, 144, 0, 256, "DO NOT TOUCH. Max spawn height of toroquest entities, ender idol, & scroll teleport. Also used for checking villagers and structures for creating ruined villages.");
            minSpawnHeight = config.getInt("minSpawnHeight", CATEGORY_SPAWNING, 48, 0, 256, "DO NOT TOUCH. Min spawn height of toroquest entities, ender idol, & scroll teleport. Also used for checking villagers and structures for creating ruined villages.");
            disableMobSpawningNearVillage = config.getInt("disableMobSpawningNearVillage", CATEGORY_SPAWNING, 76, 0, 104, "Disable mob spawns within X blocks from the village center. The higher the number, the further from the center of a province mobs will spawn. 208 blocks is the total length of a province. Setting this to 104 means mobs can NOT spawn anywhere in a province. Setting this to 0 disables this feature and mobs can spawn anywhere - RIP villages!");
            disableZombieSpawningNearVillage = config.getInt("disableZombieSpawningNearVillage", CATEGORY_SPAWNING, 76, 0, 104, "Disable zombie spawns within X blocks from the village center. The higher the number, the further from the center of a province mobs will spawn. 208 blocks is the total length of a province. Setting this to 104 means zombies can NOT spawn anywhere in a province. Setting this to 0 disables this feature and zombies can spawn anywhere.");
            fugitiveSpawnRate = config.getInt("fugitiveSpawnRate", CATEGORY_SPAWNING, 8, 0, 100, "every 1200 ticks/ every minute, the chance out of 100 for a random village (with a player visiting or nearby) to spawn a fugitive. This chance increases by 1 for each other player online, up to a max of fugitiveSpawnRate. Setting to 0 will disable spawning. NOTE: there are 24000 ticks per day/night cycle. These fugitives will not despawn, although there is a max of 4 that can be in a village!");
            caravanSpawnRate = config.getInt("caravanSpawnRate", CATEGORY_SPAWNING, 10, 0, 100, "every 1200 ticks/ every minute, the chance out of 100 for a random player to have a caravan spawned near them. This chance increases by 2 for each other player online, up to a max of caravanSpawnRate*2. Setting to 0 will disable spawning. NOTE: there are 24000 ticks per day/night cycle. These caravans will despawn, but will most likely die before they do. Caravans only spawn in the daytime.");
            banditSpawnRate = config.getInt("banditSpawnRate", CATEGORY_SPAWNING, 8, 0, 100, "every 1200 ticks/ every minute, the chance out of 100 for a random player to have bandits spawned near them. This chance increases by 2 for each other player online, up to a max of banditSpawnRate*2. Setting to 0 will disable spawning. NOTE: there are 24000 ticks per day/night cycle. These bandits eventually despawn.");
            shopKeeperSpawnChance = config.getInt("shopKeeperSpawnChance", CATEGORY_SPAWNING, 3, 0, 100, "The chance out of 100 for a villager to be spawned with the shopkeeper profession. Shopkeepers will seek out vacant shopkeeper stalls!");
            unexpensiveRepLoss = config.getInt("unexpensiveRepLoss", CATEGORY_REPUTATION, 1, 0, 3000, "The amount of rep you will lose for destroying un-expensive village blocks such as crops or wood/stone blocks (when your reputation is not high enough).");
            leashVillagerRepLoss = config.getInt("leashVillagerRepLoss", CATEGORY_REPUTATION, 5, 0, 3000, "The amount of rep you will lose for placing fire in a province (when your reputation is not high enough).");
            fireGriefRepLoss = config.getInt("fireGriefRepLoss", CATEGORY_REPUTATION, 5, 0, 3000, "The amount of rep you will lose for placing fire in a province (when your reputation is not high enough).");
            lavaGriefRepLoss = config.getInt("lavaGriefRepLoss", CATEGORY_REPUTATION, 10, 0, 3000, "The amount of rep you will lose for placing lava in a province (when your reputation is not high enough).");
            murderLivestockRepLoss = config.getInt("murderLivestockRepLoss", CATEGORY_REPUTATION, 10, 0, 3000, "The amount of rep you will lose for butchering livestock (when your reputation is not high enough).");
            expensiveRepLoss = config.getInt("expensiveRepLoss", CATEGORY_REPUTATION, 10, 0, 3000, "The amount of rep you will lose for destroying expensive village blocks such as bookshelves, doors, gold blocks, or stealing from villager chests (when your reputation is not high enough).");
            abandonQuestRepLoss = config.getInt("abandonQuestRepLoss", CATEGORY_REPUTATION, 10, 0, 3000, "The amount of rep you will lose for abandoning a quest.");
            healthOfMobNeededToGainOneRep = config.getInt("healthOfMobNeededToGainOneRep", CATEGORY_REPUTATION, 50, 0, 3000, "The amount of health from mobs killed that will net you one reputation. For example, if healthOfMobNeededToGainOneRep is set to 50, a mob with 75 health will give you 1 reputation with a 25/50 chance to give another 1 reputation.");
            donateEmeraldRepGain = config.getInt("donateEmeraldRepGain", CATEGORY_REPUTATION, 1, 1, 3000, "The amount of rep you will gain for donating emeralds to a village lord.");
            donateBanditMaskRepGain = config.getInt("donateBanditMaskRepGain", CATEGORY_REPUTATION, 4, 0, 3000, "The amount of rep you will gain for donating bandit masks to a village lord.");
            recruitGuardRepGain = config.getInt("recruitGuardRepGain", CATEGORY_REPUTATION, 2, 0, 3000, "The amount of rep you will gain for recruiting guards.");
            returnFugitiveRepGain = config.getInt("returnFugitiveRepGain", CATEGORY_REPUTATION, 8, 0, 3000, "The amount of rep you will gain for capturing fugitives with a lead and returning them to guards.");
            escortCaravanRepGain = config.getInt("escortCaravanRepGain", CATEGORY_REPUTATION, 12, 0, 3000, "The amount of rep you will gain for escorting caravans to a province. This number is increased by 25% per mule escorted.");
            donateArtifactRepGain = config.getInt("donateArtifactRepGain", CATEGORY_REPUTATION, 25, 0, 3000, "The amount of rep you will gain for donating lost artifacts to a village lord.");
            donateTrophyRepGain = config.getInt("donateTrophyRepGain", CATEGORY_REPUTATION, 25, 0, 3000, "The amount of rep you will gain for donating legendary trophies to a village lord.");
            loseReputationForCropGrief = config.getBoolean("loseReputationForCropGrief", CATEGORY_REPUTATION, true, "If set to true and a player's reputation is below 50, they will lose reputation for griefing crops.");
            loseReputationForAnimalGrief = config.getBoolean("loseReputationForAnimalGrief", CATEGORY_REPUTATION, true, "If set to true and a player's reputation is below 100, they will lose reputation for butchering animals.");
            loseReputationForBlockGrief = config.getBoolean("loseReputationForBlockGrief", CATEGORY_REPUTATION, true, "If set to true and a player's reputation is below 250, they will lose reputation for griefing villages.");
            safePotionList = config.getStringList("safePotionList", CATEGORY_REPUTATION, new String[]{"water", "regeneration", "healing", "breathing", "swiftness", "strength", "resistance", "leaping", "vision", "invisibility", "luck", "purifying"}, "Safe and unharmful potions that will not cause reputation loss when throwing them at guards or villagers.");
            bossHealthMultiplier = config.getFloat("bossHealthMultiplier", CATEGORY_BOSSES, 1.0f, 0.01f, 100.0f, "ToroQuest boss health multipler");
            bossAttackDamageMultiplier = config.getFloat("bossAttackDamageMultiplier", CATEGORY_BOSSES, 1.0f, 0.01f, 100.0f, "ToroQuest boss damage multipler");
            titanBoss = config.getBoolean("titanBoss", CATEGORY_BOSSES, true, "Enable to allow Grave Titan boss quest to generate.");
            banditBoss = config.getBoolean("banditBoss", CATEGORY_BOSSES, true, "Enable to allow  Bandit boss quest to generate.");
            pigBoss = config.getBoolean("pigBoss", CATEGORY_BOSSES, true, "Enable to allow Zombie Pigman boss quest to generate.");
            golemBoss = config.getBoolean("golemBoss", CATEGORY_BOSSES, true, "Enable to allow Steam Golem boss quest to generate.");
            skeletonBoss = config.getBoolean("skeletonBoss", CATEGORY_BOSSES, true, "Enable to allow Wither Skeleton boss quest to generate.");
            spiderBoss = config.getBoolean("spiderBoss", CATEGORY_BOSSES, true, "Enable to allow Spider Boss boss quest to generate.");
            mageBoss = config.getBoolean("mageBoss", CATEGORY_BOSSES, true, "Enable to allow Mage boss quest to generate.");
            enderBoss = config.getBoolean("enderBoss", CATEGORY_BOSSES, true, "Enable to allow Ender boss quest to generate.");
            recruitBandits = config.getBoolean("recruitBandits", CATEGORY, true, "If set to true, players can use Recruitment Papers on bribed (with emeralds) Bandits to recruit them as Guards.");
            recruitVillagers = config.getBoolean("recruitVillagers", CATEGORY, true, "If set to true, players can use Recruitment Papers on Villagers to recruit them as Guards.");
            useCrownToCreateNewProvinces = config.getBoolean("useCrownToCreateNewProvinces", CATEGORY, true, "If set to true, players can create new provinces using the crown on a Guard.");
            removeProvinceOnLordDeath = config.getBoolean("removeProvinceOnLordDeath", CATEGORY, true, "If set to true, provinces are removed when the Village Lord of the province dies.");
            artifactDropRate = config.getInt("artifactDropRate", CATEGORY, 10, 0, 2000, "Drop rate of lost artifacts. X out of 2000 mobs will drop an artifact on death, and X out of 8000 dirt/stone/sand blocks will drop an artifact on harvest. Set to 0 to disable.");
            showQuestCompletionAboveActionBar = config.getBoolean("showQuestCompletionAboveActionBar", CATEGORY, true, "If set to true, the Quest Complete! notification will appear above the action bar instead of in chat.");
            showProvinceEnterTitle = config.getBoolean("showProvinceEnterTitle", CATEGORY, true, "If set to true, show province name/house title message when entering a province.");
            sendRepLevelMessage = config.getBoolean("sendRepLevelMessage", CATEGORY, true, "If set to true, show the reputation level message that appears at certain reputation level thresholds (at 50, 100, 250, 500, 1000, 2000, 3000)");
            enderIdolTeleport = config.getBoolean("enderIdolTeleport", CATEGORY, true, "If set to true, the ender idol item will save you (similar to totem of undying) and teleport you on death, instead of having you respawn with all of your items and experience after a death. Set to true if you have other inventory death mods such as corpse complex, as there may be inventory dupe interactions.");
            broadcastLordSlain = config.getBoolean("broadcastLordSlain", CATEGORY, true, "Set to true to have a message be broadcasted to all players that a village lord has been slain.");
            anyAnimalForBreedQuest = config.getBoolean("anyAnimalForBreedQuest", CATEGORY, false, "Set to true if you want to have all animals count for the breed quest. Set to true of you have mods installed that include many extra animals, such as Animania.");
            disableTreeChoppingQuest = config.getBoolean("disableTreeChoppingQuest", CATEGORY, false, "Set to true if you have DynamicTrees installed and have the option for felling an entire tree (removes tree chopping quest).");
            cartographerMapTrade = config.getBoolean("cartographerMapTrade", CATEGORY_TRADES, true, "Set true to torovillager enable map trade.");
            coinTradeSounds = config.getBoolean("coinTradeSounds", CATEGORY_TRADES, true, "Set true to enable torovillager trade sound (coins sound).");
            villagerUniqueShopInventoryVarients = config.getInt("villagerUniqueShopInventoryVarients", CATEGORY_TRADES, 4, 0, 256, "The maximum number for villager sub-profession / varient IDs. If set to 4 (meaning the ID/varients range from 0 to 4) then for each profession there are 5 IDs/varients that each can have different options of trades that a profession can offer. For example: a blacksmith with ID 0 or 1 could sell iron swords, a blacksmith with ID 3 could buy iron ingots, and a blacksmith with ID 4 could sell shields. YOU MUST MANUALLY CONFIGURE TORO VILLAGER TRADES IF YOU PLAN ON CHANGING THIS SETTING!");
            gatedTradeList = config.getStringList("gatedTradeList", CATEGORY_TRADES, new String[]{"minecraft:diamond,1,x,minecraft:emerald,16,x,0,blacksmith,x=minecraft:emerald,16,x,minecraft:diamond,1", "minecraft:diamond,1,x,minecraft:emerald,16,x,1000,blacksmith,0=minecraft:emerald,16,x,minecraft:diamond,1", "minecraft:blaze_powder,9,x,minecraft:emerald,1,x,50,cleric,1=minecraft:emerald,1,x,minecraft:blaze_powder,9", "minecraft:ghast_tear,1,x,minecraft:emerald,11,x,500,cleric,1=minecraft:emerald,11,x,minecraft:ghast_tear,1", "minecraft:dragon_breath,1,x,minecraft:emerald,1,x,1000,cleric,1=minecraft:emerald,1,x,minecraft:dragon_breath,1", "minecraft:nether_wart,16,x,minecraft:emerald,1,x,250,cleric,4=minecraft:emerald,1,x,minecraft:nether_wart,16"}, "");
            tradeList = config.getStringList("tradeList", CATEGORY_TRADES, new String[]{"minecraft:emerald,1,x,minecraft:beetroot_seeds,24,x,x,farmer,0", "minecraft:beetroot_seeds,24,x,minecraft:emerald,1,x,x,farmer,0", "minecraft:emerald,1,x,minecraft:beetroot,20,x,x,farmer,0", "minecraft:beetroot,20,x,minecraft:emerald,1,x,x,farmer,0", "minecraft:emerald,1,x,minecraft:carrot,20,x,50,farmer,0", "minecraft:carrot,20,x,minecraft:emerald,1,x,50,farmer,0", "minecraft:emerald,1,x,minecraft:potato,20,x,100,farmer,0", "minecraft:potato,20,x,minecraft:emerald,1,x,100,farmer,0", "minecraft:emerald,1,x,minecraft:wheat_seeds,24,x,x,farmer,1", "minecraft:wheat_seeds,24,x,minecraft:emerald,1,x,x,farmer,1", "minecraft:emerald,1,x,minecraft:wheat,16,x,x,farmer,1", "minecraft:wheat,16,x,minecraft:emerald,1,x,x,farmer,1", "minecraft:emerald,1,x,minecraft:reeds,24,x,x,farmer,2", "minecraft:reeds,24,x,minecraft:emerald,1,x,x,farmer,2", "minecraft:emerald,1,x,minecraft:pumpkin,6,x,x,farmer,3", "minecraft:pumpkin,6,x,minecraft:emerald,1,x,x,farmer,3", "minecraft:emerald,1,x,minecraft:melon,24,x,100,farmer,3", "minecraft:melon,24,x,minecraft:emerald,1,x,100,farmer,3", "minecraft:emerald,1,x,minecraft:apple,6,x,x,farmer,4", "minecraft:apple,6,x,minecraft:emerald,1,x,x,farmer,4", "minecraft:sapling,12,x,minecraft:emerald,1,x,100,farmer,4", "minecraft:emerald,1,x,minecraft:sapling,12,x,100,farmer,4", "minecraft:fish,3,x,minecraft:emerald,1,x,x,fisherman,x", "minecraft:fish:1,2,x,minecraft:emerald,1,x,50,fisherman,x", "minecraft:fish:2,1,x,minecraft:emerald,1,x,100,fisherman,x", "minecraft:fish:3,1,x,minecraft:emerald,8,x,250,fisherman,x", "minecraft:emerald,8,x,minecraft:enchanted_book,1,x,50,fisherman,0,minecraft:lure~1", "minecraft:emerald,16,x,minecraft:enchanted_book,1,x,250,fisherman,0,minecraft:lure~2", "minecraft:emerald,32,x,minecraft:enchanted_book,1,x,500,fisherman,0,minecraft:lure~3", "minecraft:emerald,64,x,minecraft:enchanted_book,1,x,1000,fisherman,0,minecraft:lure~4", "minecraft:emerald,128,x,minecraft:enchanted_book,1,x,3000,fisherman,0,minecraft:lure~5", "minecraft:emerald,8,x,minecraft:enchanted_book,1,x,50,fisherman,1,minecraft:luck_of_the_sea~1", "minecraft:emerald,16,x,minecraft:enchanted_book,1,x,250,fisherman,1,minecraft:luck_of_the_sea~2", "minecraft:emerald,32,x,minecraft:enchanted_book,1,x,500,fisherman,1,minecraft:luck_of_the_sea~3", "minecraft:emerald,64,x,minecraft:enchanted_book,1,x,1000,fisherman,1,minecraft:luck_of_the_sea~4", "minecraft:emerald,128,x,minecraft:enchanted_book,1,x,3000,fisherman,1,minecraft:luck_of_the_sea~5", "minecraft:emerald,1,x,minecraft:bow,1,x,x,fletcher,x", "minecraft:emerald,1,x,minecraft:arrow,20,x,x,fletcher,x", "minecraft:string,12,x,minecraft:emerald,1,x,50,fletcher,x", "minecraft:feather,32,x,minecraft:emerald,1,x,50,fletcher,x", "minecraft:flint,8,x,minecraft:emerald,1,x,50,fletcher,x", "minecraft:emerald,4,x,minecraft:tipped_arrow,8,x,x,fletcher,x,minecraft:weakness", "minecraft:emerald,6,x,minecraft:tipped_arrow,8,x,200,fletcher,x,minecraft:slowness", "minecraft:emerald,6,x,minecraft:tipped_arrow,8,x,200,fletcher,x,minecraft:instant_healing", "minecraft:emerald,8,x,minecraft:tipped_arrow,8,x,400,fletcher,x,minecraft:instant_harming", "minecraft:emerald,8,x,minecraft:tipped_arrow,8,x,400,fletcher,x,minecraft:poison", "minecraft:emerald,10,x,minecraft:tipped_arrow,8,x,600,fletcher,x,minecraft:strong_poison", "minecraft:emerald,10,x,minecraft:tipped_arrow,8,x,600,fletcher,x,minecraft:strong_instant_healing", "minecraft:log,16,x,minecraft:emerald,1,x,100,fletcher,x", "minecraft:log:1,16,x,minecraft:emerald,1,x,100,fletcher,x", "minecraft:log:2,16,x,minecraft:emerald,1,x,100,fletcher,x", "minecraft:log:3,16,x,minecraft:emerald,1,x,100,fletcher,x", "minecraft:log2,16,x,minecraft:emerald,1,x,100,fletcher,x", "minecraft:log2:1,16,x,minecraft:emerald,1,x,100,fletcher,x", "minecraft:emerald,8,x,minecraft:enchanted_book,1,x,50,fletcher,1,minecraft:power~1", "minecraft:emerald,16,x,minecraft:enchanted_book,1,x,250,fletcher,1,minecraft:power~2", "minecraft:emerald,24,x,minecraft:enchanted_book,1,x,500,fletcher,1,minecraft:power~3", "minecraft:emerald,40,x,minecraft:enchanted_book,1,x,1000,fletcher,1,minecraft:power~4", "minecraft:emerald,64,x,minecraft:enchanted_book,1,x,2000,fletcher,1,minecraft:power~5", "minecraft:emerald,256,x,minecraft:enchanted_book,1,x,3000,fletcher,1,minecraft:power~6", "minecraft:emerald,8,x,minecraft:enchanted_book,1,x,50,fletcher,2,minecraft:punch~1", "minecraft:emerald,16,x,minecraft:enchanted_book,1,x,250,fletcher,2,minecraft:punch~2", "minecraft:emerald,32,x,minecraft:enchanted_book,1,x,500,fletcher,2,minecraft:punch~3", "minecraft:emerald,64,x,minecraft:enchanted_book,1,x,1000,fletcher,2,minecraft:punch~4", "minecraft:emerald,96,x,minecraft:enchanted_book,1,x,2000,fletcher,2,minecraft:punch~5", "minecraft:emerald,128,x,minecraft:enchanted_book,1,x,3000,fletcher,2,minecraft:punch~2", "minecraft:emerald,64,x,minecraft:enchanted_book,1,x,1000,fletcher,3,minecraft:infinity~1", "minecraft:emerald,40,x,minecraft:enchanted_book,0,YELLOW,500,fletcher,4,minecraft:flame~1", "minecraft:paper,24,x,minecraft:emerald,1,x,x,librarian,x", "minecraft:enchanted_book,1,x,minecraft:emerald,2,x,x,librarian,x", "minecraft:emerald,6,x,minecraft:bookshelf,3,x,x,librarian,x", "minecraft:filled_map,1,x,minecraft:emerald,2,x,x,cartographer,x", "minecraft:rotten_flesh,20,x,minecraft:emerald,1,x,x,cleric,0", "minecraft:gold_ingot,3,x,minecraft:emerald,1,x,100,cleric,0", "minecraft:bone,12,x,minecraft:emerald,1,x,50,cleric,0", "minecraft:emerald,1,x,minecraft:bone,12,x,50,cleric,0", "minecraft:emerald,1,x,minecraft:potion,1,x,x,cleric,0,minecraft:healing~minecraft:potion", "minecraft:emerald,1,x,minecraft:potion,1,x,x,cleric,0,minecraft:healing~minecraft:splash_potion", "minecraft:emerald,2,x,minecraft:potion,1,x,1000,cleric,0,minecraft:healing~minecraft:lingering_potion", "minecraft:emerald,1,x,minecraft:ender_pearl,1,x,250,cleric,1", "minecraft:emerald,3,x,minecraft:potion,1,x,x,cleric,1,minecraft:regeneration~minecraft:potion", "minecraft:emerald,3,x,minecraft:potion,1,x,x,cleric,1,minecraft:regeneration~minecraft:splash_potion", "minecraft:emerald,4,x,minecraft:potion,1,x,1000,cleric,1,minecraft:regeneration~minecraft:lingering_potion", "minecraft:emerald,1,x,minecraft:spider_eye,10,x,x,cleric,2", "minecraft:emerald,1,x,minecraft:gunpowder,8,x,50,cleric,2", "minecraft:emerald,1,x,minecraft:rabbit_foot,1,x,250,cleric,2", "minecraft:emerald,1,x,minecraft:slime_ball,2,x,500,cleric,2", "minecraft:emerald,3,x,minecraft:potion,1,x,x,cleric,2,minecraft:swiftness~minecraft:potion", "minecraft:emerald,3,x,minecraft:potion,1,x,x,cleric,2,minecraft:swiftness~minecraft:splash_potion", "minecraft:emerald,4,x,minecraft:potion,1,x,1000,cleric,2,minecraft:swiftness~minecraft:lingering_potion", "minecraft:emerald,1,x,minecraft:yellow_flower,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:1,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:2,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:3,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:4,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:5,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:6,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:7,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:red_flower:8,8,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:double_plant:1,3,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:double_plant:4,3,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:double_plant:5,3,x,x,cleric,3", "minecraft:emerald,1,x,minecraft:experience_bottle,1,x,1000,cleric,3", "minecraft:sugar,36,x,minecraft:emerald,1,x,x,cleric,4", "minecraft:brown_mushroom,10,x,minecraft:emerald,1,x,50,cleric,4", "minecraft:emerald,1,x,minecraft:brown_mushroom,10,x,50,cleric,4", "minecraft:red_mushroom,10,x,minecraft:emerald,1,x,100,cleric,4", "minecraft:emerald,1,x,minecraft:red_mushroom,10,x,100,cleric,4", "minecraft:emerald,1,x,minecraft:potion,1,x,x,cleric,4,minecraft:poison~minecraft:splash_potion", "minecraft:emerald,2,x,minecraft:potion,1,x,1000,cleric,4,minecraft:poison~minecraft:lingering_potion", "minecraft:emerald,2,x,minecraft:potion,1,x,x,cleric,4,minecraft:harming~minecraft:splash_potion", "minecraft:emerald,3,x,minecraft:potion,1,x,1000,cleric,4,minecraft:harming~minecraft:lingering_potion", "minecraft:glass_bottle,48,x,minecraft:emerald,1,x,50,cleric,x", "minecraft:redstone,5,x,minecraft:emerald,1,x,250,cleric,x", "minecraft:glowstone_dust,16,x,minecraft:emerald,1,x,500,cleric,x", "minecraft:emerald,2,x,minecraft:iron_boots,1,x,x,armor,x", "minecraft:emerald,3,x,minecraft:iron_leggings,1,x,x,armor,x", "minecraft:emerald,2,x,minecraft:iron_helmet,1,x,x,armor,x", "minecraft:emerald,4,x,minecraft:iron_chestplate,1,x,x,armor,x", "minecraft:emerald,1,x,minecraft:chainmail_boots,1,x,100,armor,x", "minecraft:emerald,2,x,minecraft:chainmail_leggings,1,x,100,armor,x", "minecraft:emerald,1,x,minecraft:chainmail_helmet,1,x,100,armor,x", "minecraft:emerald,3,x,minecraft:chainmail_chestplate,1,x,100,armor,x", "minecraft:iron_ingot,2,x,minecraft:emerald,1,x,x,armor,x", "minecraft:emerald,16,x,minecraft:enchanted_book,0,BLUE,x,armor,x,minecraft:aqua_affinity~1", "minecraft:emerald,8,x,minecraft:enchanted_book,1,BLUE,50,armor,x,minecraft:respiration~1", "minecraft:emerald,16,x,minecraft:enchanted_book,1,BLUE,250,armor,x,minecraft:respiration~2", "minecraft:emerald,32,x,minecraft:enchanted_book,1,BLUE,500,armor,x,minecraft:respiration~3", "minecraft:emerald,128,x,minecraft:enchanted_book,1,BLUE,3000,armor,x,minecraft:respiration~4", "minecraft:emerald,12,x,minecraft:enchanted_book,2,BLUE,50,armor,x,minecraft:frost_walker~1", "minecraft:emerald,24,x,minecraft:enchanted_book,2,BLUE,250,armor,x,minecraft:frost_walker~2", "minecraft:emerald,64,x,minecraft:enchanted_book,2,BLUE,3000,armor,x,minecraft:frost_walker~3", "minecraft:emerald,8,x,minecraft:enchanted_book,3,BLUE,50,armor,x,minecraft:depth_strider~1", "minecraft:emerald,16,x,minecraft:enchanted_book,3,BLUE,250,armor,x,minecraft:depth_strider~2", "minecraft:emerald,32,x,minecraft:enchanted_book,3,BLUE,500,armor,x,minecraft:depth_strider~3", "minecraft:emerald,128,x,minecraft:enchanted_book,3,BLUE,3000,armor,x,minecraft:depth_strider~4", "minecraft:emerald,24,x,minecraft:enchanted_book,1,RED,500,armor,x,minecraft:thorns~1", "minecraft:emerald,48,x,minecraft:enchanted_book,1,RED,1000,armor,x,minecraft:thorns~2", "minecraft:emerald,96,x,minecraft:enchanted_book,1,RED,2000,armor,x,minecraft:thorns~3", "minecraft:emerald,192,x,minecraft:enchanted_book,1,RED,3000,armor,x,minecraft:thorns~4", "minecraft:emerald,14,x,minecraft:enchanted_book,1,YELLOW,250,armor,1,minecraft:fire_protection~1", "minecraft:emerald,28,x,minecraft:enchanted_book,1,YELLOW,500,armor,1,minecraft:fire_protection~2", "minecraft:emerald,42,x,minecraft:enchanted_book,1,YELLOW,1000,armor,1,minecraft:fire_protection~3", "minecraft:emerald,56,x,minecraft:enchanted_book,1,YELLOW,2000,armor,1,minecraft:fire_protection~4", "minecraft:emerald,112,x,minecraft:enchanted_book,1,YELLOW,3000,armor,1,minecraft:fire_protection~5", "minecraft:emerald,8,x,minecraft:enchanted_book,2,YELLOW,250,armor,1,minecraft:blast_protection~1", "minecraft:emerald,16,x,minecraft:enchanted_book,2,YELLOW,500,armor,1,minecraft:blast_protection~2", "minecraft:emerald,24,x,minecraft:enchanted_book,2,YELLOW,1000,armor,1,minecraft:blast_protection~3", "minecraft:emerald,32,x,minecraft:enchanted_book,2,YELLOW,2000,armor,1,minecraft:blast_protection~4", "minecraft:emerald,128,x,minecraft:enchanted_book,2,YELLOW,3000,armor,1,minecraft:blast_protection~5", "minecraft:emerald,24,x,minecraft:enchanted_book,1,BROWN,250,armor,1,minecraft:protection~1", "minecraft:emerald,48,x,minecraft:enchanted_book,1,BROWN,500,armor,1,minecraft:protection~2", "minecraft:emerald,96,x,minecraft:enchanted_book,1,BROWN,1000,armor,1,minecraft:protection~3", "minecraft:emerald,192,x,minecraft:enchanted_book,1,BROWN,2000,armor,1,minecraft:protection~4", "minecraft:emerald,256,x,minecraft:enchanted_book,1,BROWN,3000,armor,1,minecraft:protection~5", "minecraft:emerald,1,x,minecraft:iron_sword,1,x,x,weapon,x", "minecraft:iron_ingot,2,x,minecraft:emerald,1,x,x,weapon,x", "minecraft:emerald,24,x,minecraft:enchanted_book,2,YELLOW,250,weapon,1,minecraft:fire_aspect~1", "minecraft:emerald,48,x,minecraft:enchanted_book,2,YELLOW,1000,weapon,1,minecraft:fire_aspect~2", "minecraft:emerald,128,x,minecraft:enchanted_book,2,YELLOW,3000,weapon,1,minecraft:fire_aspect~3", "minecraft:emerald,8,x,minecraft:enchanted_book,3,YELLOW,50,weapon,1,minecraft:smite~1", "minecraft:emerald,16,x,minecraft:enchanted_book,3,YELLOW,250,weapon,1,minecraft:smite~2", "minecraft:emerald,24,x,minecraft:enchanted_book,3,YELLOW,500,weapon,1,minecraft:smite~3", "minecraft:emerald,36,x,minecraft:enchanted_book,3,YELLOW,1000,weapon,1,minecraft:smite~4", "minecraft:emerald,64,x,minecraft:enchanted_book,3,YELLOW,2000,weapon,1,minecraft:smite~5", "minecraft:emerald,128,x,minecraft:enchanted_book,3,YELLOW,3000,weapon,1,minecraft:smite~6", "minecraft:emerald,12,x,minecraft:enchanted_book,1,BROWN,250,weapon,1,minecraft:unbreaking~1", "minecraft:emerald,24,x,minecraft:enchanted_book,1,BROWN,500,weapon,1,minecraft:unbreaking~2", "minecraft:emerald,48,x,minecraft:enchanted_book,1,BROWN,1000,weapon,1,minecraft:unbreaking~3", "minecraft:emerald,128,x,minecraft:enchanted_book,1,BROWN,3000,weapon,1,minecraft:unbreaking~4", "minecraft:iron_pickaxe,1,x,minecraft:emerald,1,x,x,tool,0", "minecraft:emerald,1,x,minecraft:coal,14,x,x,tool,0", "minecraft:emerald,1,x,minecraft:iron_ingot,2,x,50,tool,0", "minecraft:emerald,1,x,minecraft:gold_ingot,3,x,100,tool,0", "minecraft:emerald,1,x,minecraft:redstone,5,x,250,tool,0", "minecraft:emerald,1,x,minecraft:dye:4,3,x,500,tool,0", "minecraft:emerald,10,x,minecraft:diamond,1,x,1000,tool,0", "minecraft:iron_pickaxe,1,x,minecraft:emerald,1,x,x,tool,1", "minecraft:emerald,1,x,minecraft:cobblestone,64,x,x,tool,1", "minecraft:emerald,1,x,minecraft:stone:1,64,x,100,tool,1", "minecraft:emerald,1,x,minecraft:stone:3,64,x,100,tool,1", "minecraft:emerald,1,x,minecraft:stone:5,64,x,100,tool,1", "minecraft:emerald,1,x,minecraft:obsidian,12,x,500,tool,1", "minecraft:emerald,1,x,minecraft:quartz,16,x,500,tool,1", "minecraft:emerald,1,x,minecraft:netherbrick,32,x,250,tool,1", "minecraft:emerald,1,x,minecraft:end_stone,16,x,250,tool,1", "minecraft:emerald,1,x,minecraft:glowstone,2,x,500,tool,1", "minecraft:emerald,1,x,minecraft:iron_pickaxe,1,x,x,tool,2", "minecraft:emerald,1,x,minecraft:stonebrick,32,x,x,tool,2", "minecraft:stonebrick,32,x,minecraft:emerald,1,x,x,tool,2", "minecraft:iron_axe,1,x,minecraft:emerald,1,x,x,tool,3", "minecraft:emerald,1,x,minecraft:log,16,x,x,tool,3", "minecraft:emerald,1,x,minecraft:log:1,16,x,x,tool,3", "minecraft:emerald,1,x,minecraft:log:2,16,x,x,tool,3", "minecraft:emerald,1,x,minecraft:log:3,16,x,x,tool,3", "minecraft:emerald,1,x,minecraft:log2,16,x,x,tool,3", "minecraft:emerald,1,x,minecraft:log2:1,16,x,x,tool,3", "minecraft:emerald,1,x,minecraft:iron_shovel,1,x,x,tool,4", "minecraft:emerald,1,x,minecraft:dirt,64,x,x,tool,4", "minecraft:emerald,1,x,minecraft:sand,64,x,50,tool,4", "minecraft:emerald,1,x,minecraft:gravel,32,x,100,tool,4", "minecraft:emerald,1,x,minecraft:clay,16,x,100,tool,4", "minecraft:emerald,1,x,minecraft:red_sand,64,x,500,tool,4", "minecraft:dirt,64,x,minecraft:emerald,1,x,x,tool,4", "minecraft:sand,64,x,minecraft:emerald,1,x,50,tool,4", "minecraft:gravel,32,x,minecraft:emerald,1,x,100,tool,4", "minecraft:clay,16,x,minecraft:emerald,1,x,100,tool,4", "minecraft:red_sand,64,x,minecraft:emerald,1,x,500,tool,4", "minecraft:emerald,1,x,minecraft:cooked_beef,10,x,x,butcher,x", "minecraft:emerald,1,x,minecraft:cooked_porkchop,10,x,x,butcher,x", "minecraft:emerald,1,x,minecraft:cooked_mutton,12,x,x,butcher,x", "minecraft:emerald,1,x,minecraft:cooked_chicken,14,x,x,butcher,x", "minecraft:emerald,1,x,minecraft:cooked_rabbit,16,x,x,butcher,x", "minecraft:beef,10,x,minecraft:emerald,1,x,x,butcher,x", "minecraft:porkchop,10,x,minecraft:emerald,1,x,x,butcher,x", "minecraft:mutton,12,x,minecraft:emerald,1,x,x,butcher,x", "minecraft:chicken,14,x,minecraft:emerald,1,x,x,butcher,x", "minecraft:rabbit,16,x,minecraft:emerald,1,x,x,butcher,x", "minecraft:emerald,1,x,minecraft:leather,2,x,x,leather,x", "minecraft:rabbit_hide,2,x,minecraft:emerald,1,x,x,leather,0", "minecraft:string,12,x,minecraft:emerald,1,x,x,leather,1", "minecraft:emerald,1,x,minecraft:leather_boots,1,x,x,leather,x", "minecraft:emerald,2,x,minecraft:leather_leggings,1,x,x,leather,x", "minecraft:emerald,1,x,minecraft:leather_helmet,1,x,x,leather,x", "minecraft:emerald,3,x,minecraft:leather_chestplate,1,x,x,leather,x", "minecraft:emerald,1,x,toroquest:toro_leather,5,x,100,leather,2", "minecraft:emerald,16,x,minecraft:saddle,1,x,250,leather,3", "minecraft:emerald,32,x,minecraft:golden_horse_armor,1,x,500,leather,3", "minecraft:emerald,64,x,minecraft:iron_horse_armor,1,x,1000,leather,3", "minecraft:emerald,96,x,minecraft:diamond_horse_armor,1,x,2000,leather,3", "minecraft:wool,16,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool,16,x,x,shepherd,x", "minecraft:wool:14,16,x,minecraft:emerald,1,RED,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool:14,16,RED,x,shepherd,x", "minecraft:wool:13,16,x,minecraft:emerald,1,GREEN,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool:13,16,GREEN,x,shepherd,x", "minecraft:wool:9,16,x,minecraft:emerald,1,BLUE,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool:9,16,BLUE,x,shepherd,x", "minecraft:wool:15,16,x,minecraft:emerald,1,BLACK,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool:15,16,BLACK,x,shepherd,x", "minecraft:wool:4,16,x,minecraft:emerald,1,YELLOW,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool:4,16,YELLOW,x,shepherd,x", "minecraft:wool:12,16,x,minecraft:emerald,1,BROWN,x,shepherd,x", "minecraft:emerald,1,x,minecraft:wool:12,16,BROWN,x,shepherd,x", "minecraft:emerald,1,x,minecraft:string,12,x,x,shepherd,x", "minecraft:wheat,16,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:shears,2,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:egg,16,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:emerald,1,x,minecraft:egg,16,x,x,shepherd,x", "minecraft:emerald,1,x,minecraft:feather,28,x,x,shepherd,x", "minecraft:wheat_seeds,24,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:melon_seeds,24,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:beetroot_seeds,24,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:pumpkin_seeds,24,x,minecraft:emerald,1,x,x,shepherd,x", "minecraft:poisonous_potato,1,x,minecraft:emerald,1,x,x,nitwit,0", "minecraft:emerald,3,x,minecraft:emerald,1,x,x,nitwit,1", "minecraft:anvil:2,1,x,minecraft:emerald,12,x,x,nitwit,2", "minecraft:bedrock,1,x,minecraft:emerald,6,x,x,nitwit,3", "minecraft:emerald,5,x,minecraft:jukebox,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_13,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_cat,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_blocks,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_chirp,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_far,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_mall,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_mellohi,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_stal,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_strad,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_ward,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_11,1,x,x,nitwit,4", "minecraft:emerald,64,x,minecraft:record_wait,1,x,x,nitwit,4", "minecraft:emerald,5,x,toroquest:recruitment_papers,1,x,0,shopkeeper,x", "minecraft:emerald,3,x,minecraft:experience_bottle,1,x,x,shopkeeper,x", "minecraft:emerald,5,x,minecraft:lead,1,x,x,shopkeeper,x", "minecraft:emerald,64,x,toroquest:city_key,1,x,500,shopkeeper,x", "toroquest:trophy_titan,1,x,toroquest:ender_idol,2,x,1000,shopkeeper,x", "toroquest:legendary_bandit_helmet,1,x,toroquest:ender_idol,2,x,1200,shopkeeper,x", "toroquest:trophy_pig,1,x,toroquest:ender_idol,2,x,1400,shopkeeper,x", "toroquest:trophy_skeleton,1,x,toroquest:ender_idol,2,x,1600,shopkeeper,x", "toroquest:trophy_spider,1,x,toroquest:ender_idol,2,x,1800,shopkeeper,x", "toroquest:trophy_archmage,1,x,toroquest:ender_idol,2,x,2000,shopkeeper,x", "toroquest:trophy_beholder,1,x,toroquest:ender_idol,2,x,2200,shopkeeper,x"}, "A list of trades for villagers. Follow the format to add trades (do not include spaces, it is shown like this for readability).\n\nFor NORMAL ITEMS, use the following format:\n  modId:itemToSell  , amount , modId:secondItemToSell , modId:itemToBuy:damageValue , amount , province , minRepRequired ,   job    , jobVarient\n  minecraft:emerald ,   1    ,            x           ,     minecraft:wool:14       ,   16   ,     x    ,       100      , shepherd ,      4\n\nFor ENCHANTED ITEMS, you can add as many additional enchantments as you like using the following format:\n  modId:itemToSell  , amount , modId:secondItemToSell , modId:enchantedItem:damageValue , amount , province , minRepRequired ,     job    , jobVarient ~ enchantedItemDisplayName ~ modId:enchantment ~ power ~   modId:enchantment   ~   power\n  minecraft:emerald ,   1    ,            x           ,     minecraft:diamond_sword     ,   1    ,  YELLOW  ,      2000      ,    weapon  ,      0     ~        Sun Blade         ~  minecraft:smite  ~   3   ~  minecraft:sharpness  ~     5\n\nFor ENCHANTED BOOKS, use the following format:\n  minecraft:emerald ,   8    ,            x           ,   minecraft:enchanted_book      ,    1   ,     x    ,        50      ,  fisherman ,      0     ,  minecraft:lure  ~  1\n\nFor POTIONS, use the following format:\n  modId:itemToSell  , amount , modId:secondItemToSell ,      modId:potionToBuy      , amount , province , minRepRequired ,   job    , jobVarient  ,    potionEffect       ~        potionType         \n  minecraft:emerald ,   1    ,            x           ,       minecraft:potion      ,   1    ,    x     ,        x       ,  cleric  ,      0      ,  minecraft:healing    ~    minecraft:splash_potion\n\nBelow are example inputs for trade variables. Visit  https://www.minecraftinfo.com/idnamelist.htm  OR  https://minecraftitemids.com/  for help with item IDs and damage values\n\nmodId:itemToSell           minecraft:wheat, minecraft:stone, toroquest:recruitment_papers\namount                       1, 2, 3, 64\nmodId:secondItemToSell       x, minecraft:wheat, minecraft:stone, toroquest:recruitment_papers  (x means do not include a second sell item)\nmodId:itemToBuy:damageValue  minecraft:wheat, minecraft:stone:1, minecraft:log:2, minecraft:log\namount                       1, 2, 3, 64\nprovince                     x, GREEN, BROWN, RED, BLUE, YELLOW, BLACK  (x means no province requirement)\nminRepRequired               x, -50, 0, 100, 3000  (x means no rep requirement)\njob                          x, farmer, fisherman, shepherd, fletcher, librarian, cartographer, cleric, armor, weapon, tool, butcher, leather, nitwit, shopkeeper  (x means no job requirement)\njobVarient                   x, 0, 1, 2, 3, 4  (x means no job varient requirement. The number of varients can be increased in config)\n\nVillagers will not trade with players at or below -50 rep. Prices are not improved for the player past 3000.");
            scrollTradeItem = config.getString("scrollTradeItem", CATEGORY_TRADES, "minecraft:emerald", "The item you will use to trade for a shopkeeper's teleport scroll. Delete this text to disable trade.");
            scrollTradeAmount = config.getInt("scrollTradeAmount", CATEGORY_TRADES, 3, 0, 128, "The amount of scrollTradeItem a shopkeeper's teleport scroll will cost you. Set to 0 to disable this trade.");
            bannerTradeAmount = config.getInt("bannerTradeAmount", CATEGORY_TRADES, 2, 0, 128, "The amount of scrollTradeItem a shopkeeper's banner will cost you. Set to 0 to disable this trade.");
            maxTradeAmount = config.getInt("maxTradeAmount", CATEGORY_TRADES, 6, 1, 99999, "The maximum amount of trades you can complete before that recipe is locked until it is refreshed. Shops are refreshed every 5 minutes. The minimum number of trades before a recipe is locked is always capped at 1.");
            tradeInventoryAmount = config.getInt("tradeInventoryAmount", CATEGORY_TRADES, 32, 1, 99999, "The amount of emeralds you can trade before that recipe is locked. For example, if you make 2 trades where you sell 10 fish for 20 emeralds (totaling 40 emeralds), that trade will be locked until it is refreshed. Shops are refreshed every 5 minutes.");
            showGatedTradesAsLocked = config.getBoolean("showGatedTradesAsLocked", CATEGORY_TRADES, true, "Show gated trades as locked recipies (red X) in the villager trading UI before the player actually unlocks them.");
            zombieAttackVillageChance = config.getInt("zombieAttackVillageChance", CATEGORY_RAIDS, 25, 0, 100, "The chance (out of 100) for zombies that spawn near a province to siege it (these raiding zombies will only replace VANILLA zombies that spawn, so you may need to increase this number if you have mods that add more zombie types). Set to 0 to disable.");
            zombieRaiderVillagerChance = config.getInt("zombieRaiderVillagerChance", CATEGORY_RAIDS, 25, 0, 100, "The chance (out of 100) for normal raider zombies that spawn near a province to become a zombie villager instead. Set to 0 to disable.");
            provinceSiegeRate = config.getInt("provinceSiegeRate", CATEGORY_RAIDS, 8, 0, 100, "every 1200 ticks/ every minute, the chance out of 100 for a random village (with a player visiting or nearby) to spawn a siege. This chance increases by 2 for each other player online, up to a max of provinceSiegeRate*2. Setting to 0 will disable spawning. NOTE: there are 24000 ticks per day/night cycle. These mobs eventually despawn.");
            configRaiderSiegeChance = config.getInt("configRaiderSiegeChance", CATEGORY_RAIDS, 40, 0, 100, "The chance (out of 100) to have custom raiders spawn, instead of bandits/wolves/zombies when a raid happens. These custom raiders can be configured for each House (raiderString_RED_BRIAR, raiderString_YELLOW_DAWN, raiderString_GREEN_WILD...)");
            for (String s : raiderString_RED_BRIAR = config.getStringList("raiderString_RED_BRIAR", CATEGORY_RAIDS, new String[]{"its_meow.betteranimalsplus.common.entity.EntityFeralWolf~0~1.2~2~3~x", "its_meow.betteranimalsplus.common.entity.EntityFeralWolf~500~1.2~4~9~x"}, "House Briar (Red) raiders. FORMAT: entityResourceName~minReputationToRaid~raidSpeed~minAmountToSpawn~maxAmountToSpawn~timeType\n\n entityResourceName is the resource path to the entity -- minReputationToRaid is the minimum amount of reputation required for this entity to spawn in a raid -- raidSpeed is the movement speed of the AI task that is added to the entity so it can path find to a village, this will usually be 1.0 -- minAmountToSpawn is the minimum amount of this entity that can spawn in a raid -- maxAmountToSpawn is the maximum amount of this entity that can spawn in a raid -- timeType determines at what time can the entity spawn, 'night' = restricted to night raids only, 'day' = restricted to day raids only, 'x' = both night & day raids")) {
                try {
                    list = s.split("~");
                    raider = new Raider();
                    raider.entityResourceName = list[0];
                    raider.minReputationRequired = Integer.parseInt(list[1]);
                    raider.raidSpeed = Float.parseFloat(list[2]);
                    raider.minSpawn = Integer.parseInt(list[3]);
                    raider.maxSpawn = Integer.parseInt(list[4]);
                    raider.timeType = list[5];
                    raiderList_RED_BRIAR.add(raider);
                }
                catch (Exception e) {
                    System.out.print("raiderString_RED_BRIAR config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            raiderString_YELLOW_DAWN = config.getStringList("raiderString_YELLOW_DAWN", CATEGORY_RAIDS, new String[]{"minecraft.entity.monster.EntityHusk~0~1.0~5~13~x"}, "House Dawn (Yellow) raiders. FORMAT: entityResourceName~minReputationToRaid~raidSpeed~minAmountToSpawn~maxAmountToSpawn~timeType");
            for (String s : raiderString_YELLOW_DAWN) {
                try {
                    list = s.split("~");
                    raider = new Raider();
                    raider.entityResourceName = list[0];
                    raider.minReputationRequired = Integer.parseInt(list[1]);
                    raider.raidSpeed = Float.parseFloat(list[2]);
                    raider.minSpawn = Integer.parseInt(list[3]);
                    raider.maxSpawn = Integer.parseInt(list[4]);
                    raider.timeType = list[5];
                    raiderList_YELLOW_DAWN.add(raider);
                }
                catch (Exception e) {
                    System.out.print("raiderString_YELLOW_DAWN config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            raiderString_GREEN_WILD = config.getStringList("raiderString_GREEN_WILD", CATEGORY_RAIDS, new String[]{"its_meow.betteranimalsplus.common.entity.EntityFeralWolf~0~1.2~2~3~x", "its_meow.betteranimalsplus.common.entity.EntityFeralWolf~500~1.2~4~9~x"}, "House Wild (Green) raiders. FORMAT: entityResourceName~minReputationToRaid~raidSpeed~minAmountToSpawn~maxAmountToSpawn~timeType");
            for (String s : raiderString_GREEN_WILD) {
                try {
                    list = s.split("~");
                    raider = new Raider();
                    raider.entityResourceName = list[0];
                    raider.minReputationRequired = Integer.parseInt(list[1]);
                    raider.raidSpeed = Float.parseFloat(list[2]);
                    raider.minSpawn = Integer.parseInt(list[3]);
                    raider.maxSpawn = Integer.parseInt(list[4]);
                    raider.timeType = list[5];
                    raiderList_GREEN_WILD.add(raider);
                }
                catch (Exception e) {
                    System.out.print("raiderString_GREEN_WILD config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            raiderString_BLUE_GLACIER = config.getStringList("raiderString_BLUE_GLACIER", CATEGORY_RAIDS, new String[]{"its_meow.betteranimalsplus.common.entity.EntityFeralWolf~0~1.2~2~3~x", "its_meow.betteranimalsplus.common.entity.EntityFeralWolf~500~1.2~4~9~x"}, "House Glacier (Blue) raiders. FORMAT: entityResourceName~minReputationToRaid~raidSpeed~minAmountToSpawn~maxAmountToSpawn~timeType");
            for (String s : raiderString_BLUE_GLACIER) {
                try {
                    list = s.split("~");
                    raider = new Raider();
                    raider.entityResourceName = list[0];
                    raider.minReputationRequired = Integer.parseInt(list[1]);
                    raider.raidSpeed = Float.parseFloat(list[2]);
                    raider.minSpawn = Integer.parseInt(list[3]);
                    raider.maxSpawn = Integer.parseInt(list[4]);
                    raider.timeType = list[5];
                    raiderList_BLUE_GLACIER.add(raider);
                }
                catch (Exception e) {
                    System.out.print("raiderString_BLUE_GLACIER config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            raiderString_BROWN_MITHRIL = config.getStringList("raiderString_BROWN_MITHRIL", CATEGORY_RAIDS, new String[]{"its_meow.betteranimalsplus.common.entity.EntityFeralWolf~0~1.2~2~3~x", "its_meow.betteranimalsplus.common.entity.EntityFeralWolf~500~1.2~4~9~x"}, "House Mithril (Brown) raiders. FORMAT: entityResourceName~minReputationToRaid~raidSpeed~minAmountToSpawn~maxAmountToSpawn~timeType");
            for (String s : raiderString_BROWN_MITHRIL) {
                try {
                    list = s.split("~");
                    raider = new Raider();
                    raider.entityResourceName = list[0];
                    raider.minReputationRequired = Integer.parseInt(list[1]);
                    raider.raidSpeed = Float.parseFloat(list[2]);
                    raider.minSpawn = Integer.parseInt(list[3]);
                    raider.maxSpawn = Integer.parseInt(list[4]);
                    raider.timeType = list[5];
                    raiderList_BROWN_MITHRIL.add(raider);
                }
                catch (Exception e) {
                    System.out.print("raiderString_BROWN_MITHRIL config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            raiderString_BLACK_MOOR = config.getStringList("raiderString_MOOR_BLACK", CATEGORY_RAIDS, new String[]{"thebetweenlands.common.entity.mobs.EntitySwampHag~0~1.0~6~10~x", "minecraft.entity.monster.EntityWitch~0~1.0~4~6~x", "thebetweenlands.common.entity.mobs.EntityPeatMummy~250~1.0~4~6~x", "thebetweenlands.common.entity.mobs.EntityStalker~500~1.0~3~5~x"}, "House Moor (Black) raiders. FORMAT: entityResourceName~minReputationToRaid~raidSpeed~minAmountToSpawn~maxAmountToSpawn~timeType");
            for (String s : raiderString_BLACK_MOOR) {
                try {
                    list = s.split("~");
                    raider = new Raider();
                    raider.entityResourceName = list[0];
                    raider.minReputationRequired = Integer.parseInt(list[1]);
                    raider.raidSpeed = Float.parseFloat(list[2]);
                    raider.minSpawn = Integer.parseInt(list[3]);
                    raider.maxSpawn = Integer.parseInt(list[4]);
                    raider.timeType = list[5];
                    raiderList_BLACK_MOOR.add(raider);
                }
                catch (Exception e) {
                    System.out.print("raiderString_BLACK_MOOR config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            banditOneHandedMeleeWeapons = config.getStringList("banditOneHandedMeleeWeapons", CATEGORY_WEAPONS, new String[]{"minecraft:iron_sword", "minecraft:iron_axe", "spartanweaponry:caestus", "spartanweaponry:caestus_studded", "spartanweaponry:hammer_iron", "spartanweaponry:mace_iron", "spartanweaponry:saber_iron", "spartanweaponry:katana_iron", "spartanweaponry:rapier_iron", "spartanweaponry:warhammer_iron", "spartanweaponry:battleaxe_iron", "spartanweaponry:longsword_iron"}, "One-handed melee weapons that bandits will spawn with.");
            banditTwoHandedMeleeWeapons = config.getStringList("banditTwoHandedMeleeWeapons", CATEGORY_WEAPONS, new String[]{"minecraft:iron_sword", "minecraft:iron_axe", "spartanweaponry:spear_iron", "spartanweaponry:longsword_iron", "spartanweaponry:battleaxe_iron", "spartanweaponry:greatsword_iron", "spartanweaponry:glaive_iron", "spartanweaponry:halberd_iron"}, "Two-handed melee weapons that bandits will spawn with.");
            banditRangedWeapons = config.getStringList("banditRangedWeapons", CATEGORY_WEAPONS, new String[]{"minecraft:bow"}, "Ranged weapons that bandits will spawn with (crossbows currently do not work).");
            banditShields = config.getStringList("banditShields", CATEGORY_WEAPONS, new String[]{"minecraft:shield", "spartanshields:shield_basic_wood", "spartanshields:shield_basic_stone", "spartanshields:shield_basic_iron", "spartanshields:shield_basic_gold", "spartanshields:shield_basic_obsidian"}, "Shields that bandits will spawn with.");
            orcOneHandedMeleeWeapons = config.getStringList("orcOneHandedMeleeWeapons", CATEGORY_WEAPONS, new String[]{"minecraft:stone_sword", "minecraft:stone_axe", "spartanweaponry:caestus", "spartanweaponry:caestus_studded", "spartanweaponry:club_wood", "spartanweaponry:club_studded", "spartanweaponry:hammer_stone", "spartanweaponry:mace_stone", "spartanweaponry:saber_stone", "spartanweaponry:katana_stone", "spartanweaponry:warhammer_stone", "spartanweaponry:battleaxe_stone", "spartanweaponry:longsword_stone"}, "One-handed melee weapons that orcs will spawn with.");
            orcTwoHandedMeleeWeapons = config.getStringList("orcTwoHandedMeleeWeapons", CATEGORY_WEAPONS, new String[]{"minecraft:stone_sword", "minecraft:stone_axe", "spartanweaponry:spear_stone", "spartanweaponry:longsword_stone", "spartanweaponry:battleaxe_stone", "spartanweaponry:greatsword_stone", "spartanweaponry:glaive_stone", "spartanweaponry:halberd_stone"}, "Two-handed melee weapons that orcs will spawn with.");
            orcRangedWeapons = config.getStringList("orcRangedWeapons", CATEGORY_WEAPONS, new String[]{"spartanweaponry:longbow_wood", "spartanweaponry:longbow_leather", "spartanweaponry:longbow_iron"}, "Ranged weapons that orcs will spawn with (crossbows currently do not work).");
            orcShields = config.getStringList("orcShields", CATEGORY_WEAPONS, new String[]{"spartanshields:shield_tower_wood", "spartanshields:shield_tower_stone", "spartanshields:shield_tower_iron", "spartanshields:shield_tower_gold", "spartanshields:shield_tower_obsidian"}, "Shields that orcs will spawn with.");
            banditOneHandedMeleeWeaponsPowerful = config.getStringList("banditOneHandedMeleeWeaponsPowerful", CATEGORY_WEAPONS, new String[]{"minecraft:iron_sword", "minecraft:iron_axe", "spartanweaponry:caestus", "spartanweaponry:caestus_studded", "spartanweaponry:hammer_iron", "spartanweaponry:mace_iron", "spartanweaponry:saber_iron", "spartanweaponry:katana_iron", "spartanweaponry:rapier_iron", "spartanweaponry:warhammer_iron", "spartanweaponry:battleaxe_iron", "spartanweaponry:longsword_iron"}, "Powerful One-handed melee weapons that bandits will spawn with.");
            banditTwoHandedMeleeWeaponsPowerful = config.getStringList("banditTwoHandedMeleeWeaponsPowerful", CATEGORY_WEAPONS, new String[]{"minecraft:iron_sword", "minecraft:iron_axe", "spartanweaponry:spear_iron", "spartanweaponry:longsword_iron", "spartanweaponry:battleaxe_iron", "spartanweaponry:greatsword_iron", "spartanweaponry:glaive_iron", "spartanweaponry:halberd_iron"}, "Powerful Two-handed melee weapons that bandits will spawn with.");
            banditRangedWeaponsPowerful = config.getStringList("banditRangedWeaponsPowerful", CATEGORY_WEAPONS, new String[]{"minecraft:bow"}, "Powerful Ranged weapons that bandits will spawn with (crossbows currently do not work).");
            banditShieldsPowerful = config.getStringList("banditShieldsPowerful", CATEGORY_WEAPONS, new String[]{"minecraft:shield", "spartanshields:shield_basic_wood", "spartanshields:shield_basic_stone", "spartanshields:shield_basic_iron", "spartanshields:shield_basic_gold", "spartanshields:shield_basic_obsidian"}, "Powerful Shields that bandits will spawn with.");
            orcOneHandedMeleeWeaponsPowerful = config.getStringList("orcOneHandedMeleeWeaponsPowerful", CATEGORY_WEAPONS, new String[]{"minecraft:stone_sword", "minecraft:stone_axe", "spartanweaponry:caestus", "spartanweaponry:caestus_studded", "spartanweaponry:club_wood", "spartanweaponry:club_studded", "spartanweaponry:hammer_stone", "spartanweaponry:mace_stone", "spartanweaponry:saber_stone", "spartanweaponry:katana_stone", "spartanweaponry:warhammer_stone", "spartanweaponry:battleaxe_stone", "spartanweaponry:longsword_stone"}, "Powerful One-handed melee weapons that orcs will spawn with.");
            orcTwoHandedMeleeWeaponsPowerful = config.getStringList("orcTwoHandedMeleeWeaponsPowerful", CATEGORY_WEAPONS, new String[]{"minecraft:stone_sword", "minecraft:stone_axe", "spartanweaponry:spear_stone", "spartanweaponry:longsword_stone", "spartanweaponry:battleaxe_stone", "spartanweaponry:greatsword_stone", "spartanweaponry:glaive_stone", "spartanweaponry:halberd_stone"}, "Powerful Two-handed melee weapons that orcs will spawn with.");
            orcRangedWeaponsPowerful = config.getStringList("orcRangedWeaponsPowerful", CATEGORY_WEAPONS, new String[]{"spartanweaponry:longbow_wood", "spartanweaponry:longbow_leather", "spartanweaponry:longbow_iron"}, "Powerful Ranged weapons that orcs will spawn with (crossbows currently do not work).");
            orcShieldsPowerful = config.getStringList("orcShieldsPowerful", CATEGORY_WEAPONS, new String[]{"spartanshields:shield_tower_wood", "spartanshields:shield_tower_stone", "spartanshields:shield_tower_iron", "spartanshields:shield_tower_gold", "spartanshields:shield_tower_obsidian"}, "Powerful Shields that orcs will spawn with.");
            enchantFirstBanditAndOrcMeleeWeapon = config.getStringList("enchantFirstBanditAndOrcMeleeWeapon", CATEGORY_WEAPONS, new String[]{"minecraft:sharpness,2", "minecraft:sharpness,4", "minecraft:smite,4", "minecraft:bane_of_arthropods,4", "minecraft:knockback,4", "minecraft:looting,2", "minecraft:sweeping,3"}, "First enchant that bandits will spawn with. Format is - modid:enchant,level (add duplicate of the same enchant to increase its chance)");
            enchantSecondBanditAndOrcMeleeWeapon = config.getStringList("enchantSecondBanditAndOrcMeleeWeapon", CATEGORY_WEAPONS, new String[]{"minecraft:unbreaking,4", "minecraft:unbreaking,4", "minecraft:unbreaking,4", "minecraft:fire_aspect,2"}, "Second enchant that bandits will spawn with. Format is - modid:enchant,level (add duplicate of the same enchant to increase its chance)");
            enchantFirstBanditAndOrcRanged = config.getStringList("enchantFirstBanditAndOrcRanged", CATEGORY_WEAPONS, new String[]{"minecraft:power,2", "minecraft:power,5", "minecraft:punch,5", "minecraft:flame,1", "minecraft:flame,1"}, "First enchant that bandits will spawn with. Format is - modid:enchant,level (add duplicate of the same enchant to increase its chance)");
            enchantSecondBanditAndOrcRanged = config.getStringList("enchantSecondBanditAndOrcRanged", CATEGORY_WEAPONS, new String[]{"minecraft:unbreaking,4", "minecraft:unbreaking,4", "minecraft:unbreaking,4", "minecraft:infinity,1"}, "Second enchant that bandits will spawn with. Format is - modid:enchant,level (add duplicate of the same enchant to increase its chance)");
            enchantFirstBanditAndOrcShield = config.getStringList("enchantFirstBanditAndOrcShield", CATEGORY_WEAPONS, new String[]{"minecraft:unbreaking,4"}, "First enchant that bandits will spawn with. Format is - modid:enchant,level (add duplicate of the same enchant to increase its chance)");
            mobsList = config.getStringList("mobsList", CATEGORY_MOBS, new String[]{"\u00a7lArachnophobia\u00a7r~EntitySpider~Spiders~10~20~0.8~x~0~I HATE spiders. @p, you must slay the infestation of these vile creatures at once!", "\u00a7lUndead Rising\u00a7r~EntityZombie,EntitySkeleton~Undead~10~20~0.8~x~0~Countless undead have risen from fallen villagers after the recent bandit attacks. @p, cut down any walking corpses you see and lay their souls to rest.", "\u00a7lBand of Bandits\u00a7r~EntitySentry~Bandits~4~8~3.0~x~250~The bandit attacks have getting worse, @p. Cut them down.", "\u00a76\u00a7lDragon Sighting\u00a7r~EntityDragon~Dragon~1~1~64.0~x~1000~My scouts have reported a dragon not too far from here! Go, slay it at once! Before it catches scent of the village!"}, "Custom configuration for the Kill Mobs quest. You may add your own quests with modded enemies:\n questTitle~mobToKill~mobDisplayName~minimumNumberOfKills~maximimumNumberOfKills~EmeraldsPerKill~ProvinceAllowed~minReputationRequired~lordDialogue\n(ProvinceAllowed: x, RED, YELLOW, BLUE, BROWN, BLACK)\n\u00a7lGreat Hunt\u00a7r~EntityBear~Bear~1~1~32.0~BROWN,GREEN~50~Hunt a bear!\nProvinceAllowed can include multiple provinces (unlike the villager trade format)");
            donateList = config.getStringList("donateList", CATEGORY_REPUTATION, new String[]{"betteranimalsplus:wolfhead~15", "betteranimalsplus:wolfhead_1~15", "betteranimalsplus:wolfhead_2~15", "betteranimalsplus:wolfhead_3~15", "betteranimalsplus:wolfhead_4~15", "betteranimalsplus:wolfhead_5~15", "betteranimalsplus:wolfhead_6~15", "betteranimalsplus:reindeerhead~15", "betteranimalsplus:reindeerhead_1~15", "betteranimalsplus:reindeerhead_2~15", "betteranimalsplus:reindeerhead_3~15", "betteranimalsplus:reindeerhead_4~15", "betteranimalsplus:moosehead~15", "betteranimalsplus:moosehead_1~15", "betteranimalsplus:moosehead_2~15", "betteranimalsplus:moosehead_3~15", "betteranimalsplus:moosehead_4~15", "betteranimalsplus:hirschgeistskull~25", "betteranimalsplus:hirschgeistskull_1~25", "betteranimalsplus:foxhead~10", "betteranimalsplus:foxhead_1~10", "betteranimalsplus:foxhead_2~10", "betteranimalsplus:foxhead_3~10", "betteranimalsplus:foxhead_4~10", "betteranimalsplus:deerhead~10", "betteranimalsplus:deerhead_1~10", "betteranimalsplus:deerhead_2~10", "betteranimalsplus:deerhead_3~10", "betteranimalsplus:deerhead_4~10", "betteranimalsplus:boarhead~10", "betteranimalsplus:boarhead_1~10", "betteranimalsplus:boarhead_2~10", "betteranimalsplus:boarhead_3~10", "betteranimalsplus:boarhead_4~10", "betteranimalsplus:coyotehead~10", "betteranimalsplus:coyotehead_1~10", "betteranimalsplus:bearhead~20", "betteranimalsplus:bearhead_1~20", "betteranimalsplus:bearhead_2~20", "betteranimalsplus:bearhead_3~20"}, "Custom configuration for donating items: \nitemToDonate~repGain");
            enchantFirstBanditAndOrcChance = config.getInt("enchantFirstBanditAndOrcChance", CATEGORY_SPAWNING, 20, 0, 100, "X chance out of 100 for the first enchant to be applied to weapon/ shield/ bow.");
            enchantSecondBanditAndOrcChance = config.getInt("enchantSecondBanditAndOrcChance", CATEGORY_SPAWNING, 60, 0, 100, "X chance out of 100 for an additional enchant to be applied to weapon/ shield/ bow (NOTE: this second enchant only has a chance to be applied if the first enchant is applied).");
            guardWeapon_RED_BRIAR = config.getString("guardWeapon_RED_BRIAR", CATEGORY_WEAPONS, "minecraft:iron_sword", "Weapons that House Briar guards use. Cannot be blank or invalid, as weapons are built into the AI. Accepts weapons from other mods. Example - - - spartanweaponry:saber_iron");
            guardShield_RED_BRIAR = config.getString("guardShield_RED_BRIAR", CATEGORY_WEAPONS, "minecraft:shield", "Shields that House Briar guards use. Cannot be blank or invalid, as shields are built into the AI. Accepts sheilds from other mods. Example - - - spartanshields:shield_tower_wood");
            guardWeapon_GREEN_WILD = config.getString("guardWeapon_GREEN_WILD", CATEGORY_WEAPONS, "minecraft:iron_sword", "Weapons that House Wild guards use. Cannot be blank or invalid, as weapons are built into the AI. Accepts weapons from other mods. Example - - - spartanweaponry:saber_iron");
            guardShield_GREEN_WILD = config.getString("guardShield_GREEN_WILD", CATEGORY_WEAPONS, "minecraft:shield", "Shields that House Wild guards use. Cannot be blank or invalid, as shields are built into the AI. Accepts sheilds from other mods. Example - - - spartanshields:shield_tower_wood");
            guardWeapon_BROWN_MITHRIL = config.getString("guardWeapon_BROWN_MITHRIL", CATEGORY_WEAPONS, "minecraft:iron_sword", "Weapons that House Mithril guards use. Cannot be blank or invalid, as weapons are built into the AI. Accepts weapons from other mods. Example - - - spartanweaponry:saber_iron");
            guardShield_BROWN_MITHRIL = config.getString("guardShield_BROWN_MITHRIL", CATEGORY_WEAPONS, "minecraft:shield", "Shields that House Mithril guards use. Cannot be blank or invalid, as shields are built into the AI. Accepts sheilds from other mods. Example - - - spartanshields:shield_tower_wood");
            guardWeapon_BLUE_GLACIER = config.getString("guardWeapon_BLUE_GLACIER", CATEGORY_WEAPONS, "minecraft:iron_sword", "Weapons that House Glacier guards use. Cannot be blank or invalid, as weapons are built into the AI. Accepts weapons from other mods. Example - - - spartanweaponry:saber_iron");
            guardShield_BLUE_GLACIER = config.getString("guardShield_BLUE_GLACIER", CATEGORY_WEAPONS, "minecraft:shield", "Shields that House Glacier guards use. Cannot be blank or invalid, as shields are built into the AI. Accepts sheilds from other mods. Example - - - spartanshields:shield_tower_wood");
            guardWeapon_YELLOW_DAWN = config.getString("guardWeapon_YELLOW_DAWN", CATEGORY_WEAPONS, "minecraft:iron_sword", "Weapons that House Dawn guards use. Cannot be blank or invalid, as weapons are built into the AI. Accepts weapons from other mods. Example - - - spartanweaponry:saber_iron");
            guardShield_YELLOW_DAWN = config.getString("guardShield_YELLOW_DAWN", CATEGORY_WEAPONS, "minecraft:shield", "Shields that House Dawn guards use. Cannot be blank or invalid, as shields are built into the AI. Accepts sheilds from other mods. Example - - - spartanshields:shield_tower_wood");
            guardWeapon_BLACK_MOOR = config.getString("guardWeapon_BLACK_MOOR", CATEGORY_WEAPONS, "minecraft:iron_sword", "Weapons that House Moor guards use. Cannot be blank or invalid, as weapons are built into the AI. Accepts weapons from other mods. Example - - - spartanweaponry:saber_iron");
            guardShield_BLACK_MOOR = config.getString("guardShield_BLACK_MOOR", CATEGORY_WEAPONS, "minecraft:shield", "Shields that House Moor guards use. Cannot be blank or invalid, as shields are built into the AI. Accepts sheilds from other mods. Example - - - spartanshields:shield_tower_wood");
            greenName = config.getString("greenName", CATEGORY_REPUTATION, "Wild", "Name for House, I need this setting for when I am unable to get the client name translations for Houses.");
            brownName = config.getString("brownName", CATEGORY_REPUTATION, "Mithril", "Name for House, I need this setting for when I am unable to get the client name translations for Houses.");
            redName = config.getString("redName", CATEGORY_REPUTATION, "Briar", "Name for House, I need this setting for when I am unable to get the client name translations for Houses.");
            blackName = config.getString("blackName", CATEGORY_REPUTATION, "Moor", "Name for House, I need this setting for when I am unable to get the client name translations for Houses.");
            yellowName = config.getString("yellowName", CATEGORY_REPUTATION, "Dawn", "Name for House, I need this setting for when I am unable to get the client name translations for Houses.");
            blueName = config.getString("blueName", CATEGORY_REPUTATION, "Glacier", "Name for House, I need this setting for when I am unable to get the client name translations for Houses.");
            for (String s : gatedTradeList) {
                try {
                    list = s.split("=");
                    String[] first = list[0].split(",");
                    String[] second = list[1].split(",");
                    GatedTrade trade = new GatedTrade();
                    trade.sellName = first[0];
                    trade.sellAmount = Integer.parseInt(first[1]);
                    trade.sellOptional = first[2];
                    trade.buyName = first[3];
                    trade.buyAmount = Integer.parseInt(first[4]);
                    trade.province = first[5];
                    trade.minimunRepRequired = first[6];
                    trade.job = first[7];
                    trade.varient = first[8];
                    try {
                        trade.enchantment = first[9];
                    }
                    catch (Exception e) {
                        trade.enchantment = null;
                    }
                    trade.gatedSellName = second[0];
                    trade.gatedSellAmount = Integer.parseInt(second[1]);
                    trade.gatedSellOptional = second[2];
                    trade.gatedBuyName = second[3];
                    trade.gatedBuyAmount = Integer.parseInt(second[4]);
                    try {
                        trade.gatedEnchantment = second[5];
                    }
                    catch (Exception e) {
                        trade.gatedEnchantment = null;
                    }
                    gatedTrades.add(trade);
                }
                catch (Exception e) {
                    System.out.print("Gated trades config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            for (String s : tradeList) {
                try {
                    list = s.split(",");
                    Trade trade = new Trade();
                    trade.sellName = list[0];
                    trade.sellAmount = Integer.parseInt(list[1]);
                    trade.sellOptional = list[2];
                    trade.buyName = list[3];
                    trade.buyAmount = Integer.parseInt(list[4]);
                    trade.province = list[5];
                    trade.minimunRepRequired = list[6];
                    trade.job = list[7];
                    trade.varient = list[8];
                    try {
                        trade.enchantment = list[9];
                    }
                    catch (Exception e) {
                        trade.enchantment = null;
                    }
                    trades.add(trade);
                }
                catch (Exception e) {
                    System.out.print("Trades config incorrect format! It follows a strict format. Error:" + e);
                }
            }
            for (String s : mobsList) {
                try {
                    list = s.split("~");
                    KillMob mob = new KillMob();
                    mob.title = list[0];
                    mob.mobName = list[1];
                    mob.mobDisplayName = list[2];
                    mob.minKills = Integer.parseInt(list[3]);
                    mob.maxKills = Integer.parseInt(list[4]);
                    mob.emeraldsPerKill = Double.parseDouble(list[5]);
                    mob.provinceAllowed = list[6];
                    mob.minRepRequired = Integer.parseInt(list[7]);
                    mob.acceptChat = list[8];
                    mobs.add(mob);
                }
                catch (Exception e) {
                    System.out.print("Mobs config incorrect format! It follows a strict format. Error:" + e + s);
                }
            }
            for (String s : donateList) {
                try {
                    list = s.split("~");
                    Donate d = new Donate();
                    d.item = Item.func_111206_d((String)list[0]);
                    d.rep = Integer.parseInt(list[1]);
                    if (d.item == null) continue;
                    donate.add(d);
                }
                catch (Exception e) {
                    System.out.print("Donate config incorrect format! It follows a strict format. Error:" + e + s);
                }
            }
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("toroquest")) {
            ToroQuestConfiguration.loadConfiguration();
        }
    }

    static {
        useCrownToCreateNewProvinces = true;
        removeProvinceOnLordDeath = true;
        coinTradeSounds = true;
        bossHealthMultiplier = 1.0f;
        bossAttackDamageMultiplier = 1.0f;
        banditBaseHealth = 20;
        banditAttackDamage = 4.0f;
        banditArmor = 0;
        banditArmorToughness = 0;
        orcBaseHealth = 24;
        orcAttackDamage = 5.0f;
        orcArmor = 0;
        orcArmorToughness = 0;
        banditAndOrcFleeHealthPercentageBase = 0.15f;
        banditAndOrcFleeHealthPercentageRange = 0.15f;
        banditAndOrcKnockBackResistance = 0.25f;
        guardKnockBackResistance = 0.25f;
        showGatedTradesAsLocked = true;
        guardSpeakChance = 0.3f;
        guardBaseHealth = 40;
        guardAttackDamage = 5.0f;
        guardArmor = 0;
        guardArmorToughness = 8;
        guardDamageBaseMultiplierToMobs = 1.0f;
        guardDamageBaseMultiplierToPlayers = 0.7f;
        trophyTitanAdditionalGuardDamageMulitiplier = 1.5f;
        guardDamageBaseMultiplierToMobsOutsideProvinceOrToBosses = 0.6f;
        minBaseHealthToBeConsideredBossMob = 500;
        configRaiderSiegeChance = 35;
        disableKeep = false;
        disableShop = false;
        disableGuardTower = false;
        disableBarracks = false;
        maxSpawnHeight = 144;
        minSpawnHeight = 48;
        villagerUniqueShopInventoryVarients = 4;
        toroVillagerMateChance = 1200;
        villageDoorsModifier = 0.4f;
        maxVillagersPerVillage = 20;
        replaceWoolLanternsWithActualLanterns = true;
        turkeyBlockResourceName = "betteranimalsplus:turkey_cooked";
        cakeBlockResourceName = "minecraft:cake";
        chandelierResourceName = "rustic:chandelier";
        candleResourceName = "rustic:candle";
        tableResourceName = "rustic:table_oak";
        chairResourceName = "rustic:chair_spruce";
        lanternResourceName = "rustic:iron_lantern";
        chainResourceName = "rustic:chain";
        craftingTableResourceName = "minecraft:crafting_table";
        enchantingTableResourceName = "minecraft:enchanting_table";
        replaceVillageChestsWithTrappedChests = true;
        toastReputationLevels = true;
        banditArmorDropChance = 0.1f;
        banditHandsDropChance = 0.3f;
        guardArmorDropChance = 0.1f;
        guardHandsDropChance = 0.3f;
        banditsUseBoats = true;
        banditsDropEmeralds = true;
        banditsDropMasks = true;
        orcsDropEmeralds = true;
        orcsDropMasks = false;
        steamGolemsDropLoot = true;
        anyAnimalForBreedQuest = false;
        cartographerMapTrade = true;
        banditsDropPotions = 6;
        renderGuardCape = true;
        renderArrowLayer = true;
        renderBanditMask = true;
        renderOrcMask = false;
        banditsHaveArmorForSpartanWeaponry = true;
        guardsHaveArmorForSpartanWeaponry = true;
        showProvinceEnterTitle = true;
        sendRepLevelMessage = true;
        mobsAttackGuards = true;
        iMobAttackVillagers = true;
        removeMuleOnCaravanEscort = false;
        broadcastLordSlain = true;
        enderIdolTeleport = true;
        titanBoss = true;
        pigBoss = true;
        banditBoss = true;
        golemBoss = true;
        skeletonBoss = true;
        spiderBoss = true;
        mageBoss = true;
        enderBoss = true;
        unexpensiveRepLoss = 1;
        leashVillagerRepLoss = 5;
        fireGriefRepLoss = 5;
        lavaGriefRepLoss = 10;
        murderLivestockRepLoss = 10;
        abandonQuestRepLoss = 10;
        expensiveRepLoss = 10;
        murderRepLoss = 100;
        healthOfMobNeededToGainOneRep = 50;
        donateEmeraldRepGain = 1;
        donateBanditMaskRepGain = 4;
        recruitGuardRepGain = 2;
        returnFugitiveRepGain = 8;
        escortCaravanRepGain = 12;
        donateArtifactRepGain = 25;
        donateTrophyRepGain = 25;
        disableTreeChoppingQuest = false;
        toastQuestCompletion = true;
        scrollTradeItem = "minecraft:emerald";
        scrollTradeAmount = 3;
        bannerTradeAmount = 2;
        maxTradeAmount = 6;
        tradeInventoryAmount = 32;
        destroyedVillagesNearSpawnDistance = 320;
        unregisterDestroyedVillages = true;
        useBiomeSpecificProvinces = true;
        unleashSandwhichHorrorOnVillages = true;
        useIronBarsForHeadSpike = true;
        specificEntityNames = true;
        useDefaultVillagersOutsideOfProvince = true;
        useDefaultVillagers = false;
        banditMountChance = 10;
        goldenHorseArmorChance = 30;
        orcMountChance = 0;
        orcsAreNeutral = false;
        loseReputationForCropGrief = true;
        loseReputationForAnimalGrief = true;
        loseReputationForBlockGrief = true;
        showQuestCompletionAboveActionBar = true;
        guardsHaveDialogue = true;
        recruitBandits = true;
        recruitVillagers = true;
        zombieAttackVillageChance = 25;
        zombieRaiderVillagerChance = 25;
        provinceSiegeRate = 8;
        caravanSpawnRate = 10;
        shopKeeperSpawnChance = 3;
        banditSpawnRate = 8;
        fugitiveSpawnRate = 8;
        artifactDropRate = 10;
        disableMobSpawningNearVillage = 76;
        disableZombieSpawningNearVillage = 76;
        safePotionList = new String[0];
        safePotions = new ArrayList();
        tradeList = new String[0];
        trades = new ArrayList();
        gatedTradeList = new String[0];
        gatedTrades = new ArrayList();
        mobsList = new String[0];
        mobs = new ArrayList();
        donateList = new String[0];
        donate = new ArrayList();
        raiderString_BROWN_MITHRIL = new String[0];
        raiderList_BROWN_MITHRIL = new ArrayList();
        raiderString_GREEN_WILD = new String[0];
        raiderList_GREEN_WILD = new ArrayList();
        raiderString_RED_BRIAR = new String[0];
        raiderList_RED_BRIAR = new ArrayList();
        raiderString_BLACK_MOOR = new String[0];
        raiderList_BLACK_MOOR = new ArrayList();
        raiderString_YELLOW_DAWN = new String[0];
        raiderList_YELLOW_DAWN = new ArrayList();
        raiderString_BLUE_GLACIER = new String[0];
        raiderList_BLUE_GLACIER = new ArrayList();
        banditShields = new String[0];
        banditOneHandedMeleeWeapons = new String[0];
        banditTwoHandedMeleeWeapons = new String[0];
        banditRangedWeapons = new String[0];
        banditShieldsPowerful = new String[0];
        banditOneHandedMeleeWeaponsPowerful = new String[0];
        banditTwoHandedMeleeWeaponsPowerful = new String[0];
        banditRangedWeaponsPowerful = new String[0];
        orcShields = new String[0];
        orcOneHandedMeleeWeapons = new String[0];
        orcTwoHandedMeleeWeapons = new String[0];
        orcRangedWeapons = new String[0];
        orcShieldsPowerful = new String[0];
        orcOneHandedMeleeWeaponsPowerful = new String[0];
        orcTwoHandedMeleeWeaponsPowerful = new String[0];
        orcRangedWeaponsPowerful = new String[0];
        enchantFirstBanditAndOrcMeleeWeapon = new String[0];
        enchantSecondBanditAndOrcMeleeWeapon = new String[0];
        enchantFirstBanditAndOrcShield = new String[0];
        enchantFirstBanditAndOrcRanged = new String[0];
        enchantSecondBanditAndOrcRanged = new String[0];
        enchantFirstBanditAndOrcChance = 20;
        enchantSecondBanditAndOrcChance = 60;
        guardWeapon_RED_BRIAR = "minecraft:iron_sword";
        guardShield_RED_BRIAR = "minecraft:shield";
        guardWeapon_GREEN_WILD = "minecraft:iron_sword";
        guardShield_GREEN_WILD = "minecraft:shield";
        guardWeapon_BROWN_MITHRIL = "minecraft:iron_sword";
        guardShield_BROWN_MITHRIL = "minecraft:shield";
        guardWeapon_YELLOW_DAWN = "minecraft:iron_sword";
        guardShield_YELLOW_DAWN = "minecraft:shield";
        guardWeapon_BLUE_GLACIER = "minecraft:iron_sword";
        guardShield_BLUE_GLACIER = "minecraft:shield";
        guardWeapon_BLACK_MOOR = "minecraft:iron_sword";
        guardShield_BLACK_MOOR = "minecraft:shield";
        greenName = "Wild";
        brownName = "Mithril";
        redName = "Briar";
        blackName = "Moor";
        yellowName = "Dawn";
        blueName = "Glacier";
        banditSkins = 36;
        orcSkins = 16;
    }

    public static class Raider {
        public String entityResourceName = "";
        public int minReputationRequired = 0;
        public float raidSpeed = 0.0f;
        public int minSpawn = 0;
        public int maxSpawn = 0;
        public String timeType = "x";
    }

    public static class KillMob {
        public String title = "";
        public String mobName = "";
        public String mobDisplayName = "";
        public int minKills = 0;
        public int maxKills = 0;
        public double emeraldsPerKill = 0.0;
        public String provinceAllowed = "";
        public int minRepRequired = 0;
        public String acceptChat = "";
    }

    public static class GatedTrade {
        public String sellName = "";
        public int sellAmount = 0;
        public String sellOptional = "";
        public String buyName = "";
        public int buyAmount = 0;
        public String minimunRepRequired = "";
        public String province = "";
        public String job = "";
        public String varient = "";
        public String enchantment = null;
        public String gatedSellName = "";
        public int gatedSellAmount = 0;
        public String gatedSellOptional = "";
        public String gatedBuyName = "";
        public int gatedBuyAmount = 0;
        public String gatedEnchantment = null;
    }

    public static class Trade {
        public String sellName = "";
        public int sellAmount = 0;
        public String sellOptional = "";
        public String buyName = "";
        public int buyAmount = 0;
        public String minimunRepRequired = "";
        public String province = "";
        public String job = "";
        public String varient = "";
        public String enchantment = null;
    }

    public static class Donate {
        public Item item = null;
        public int rep = 0;
    }
}

