/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestDelegator {
    private QuestData data;

    public QuestDelegator(QuestData data) {
        this.setData(data);
    }

    public Quest getTypedQuest(QuestData data) {
        if (data == null) {
            throw new NullPointerException("quest data is null");
        }
        return Quests.getQuestForId(data.getQuestType());
    }

    public List<ItemStack> complete(List<ItemStack> in) {
        return this.getTypedQuest(this.data).complete(this.data, in);
    }

    public String getTitle() {
        return this.getTypedQuest(this.data).getTitle(this.data);
    }

    public String getDescription() {
        return this.getTypedQuest(this.data).getDescription(this.data);
    }

    public QuestData getData() {
        return this.data;
    }

    public void setData(QuestData data) {
        if (data == null) {
            this.reject(null);
            throw new NullPointerException("quest delegator was set with a null");
        }
        this.data = data;
    }

    public List<ItemStack> reject(List<ItemStack> in) {
        return this.getTypedQuest(this.data).reject(this.data, in);
    }

    public List<ItemStack> accept(List<ItemStack> in) {
        return this.getTypedQuest(this.data).accept(this.data, in);
    }
}

