/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMapCentered
extends ItemMap {
    public ItemMapCentered() {
        this.func_77627_a(true);
    }

    public static ItemStack setupNewMap(World worldIn, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack((Item)Items.field_151098_aY, 1, worldIn.func_72841_b("map"));
        String s = "map_" + itemstack.func_77960_j();
        MapData mapdata = new MapData(s);
        worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        ItemMapCentered.calcMapCenter(mapdata, worldX, worldZ, mapdata.field_76197_d);
        mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    public static void calcMapCenter(MapData mapdata, double x, double z, int mapScale) {
        int i = 1 << mapScale;
        int j = MathHelper.func_76128_c((double)(x / (double)i));
        int k = MathHelper.func_76128_c((double)(z / (double)i));
        mapdata.field_76201_a = j * i + i / 2;
        mapdata.field_76199_b = k * i + i / 2;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static MapData loadMapData(int mapId, World worldIn) {
        String s = "map_" + mapId;
        return (MapData)worldIn.func_72943_a(MapData.class, s);
    }

    @Nullable
    public MapData func_77873_a(ItemStack stack, World worldIn) {
        String s = "map_" + stack.func_77960_j();
        MapData mapdata = (MapData)worldIn.func_72943_a(MapData.class, s);
        if (mapdata == null && !worldIn.field_72995_K) {
            stack.func_77964_b(worldIn.func_72841_b("map"));
            s = "map_" + stack.func_77960_j();
            mapdata = new MapData(s);
            mapdata.field_76197_d = (byte)3;
            mapdata.func_176054_a((double)worldIn.func_72912_H().func_76079_c(), (double)worldIn.func_72912_H().func_76074_e(), (int)mapdata.field_76197_d);
            mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
            mapdata.func_76185_a();
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public void func_77872_a(World worldIn, Entity viewer, MapData data) {
        if (worldIn.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int i = 1 << data.field_76197_d;
            int j = data.field_76201_a;
            int k = data.field_76199_b;
            int l = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)j)) / i + 64;
            int i1 = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)k)) / i + 64;
            int j1 = 128 / i;
            if (worldIn.field_73011_w.func_177495_o()) {
                j1 /= 2;
            }
            MapData.MapInfo mapdata$mapinfo = data.func_82568_a((EntityPlayer)viewer);
            ++mapdata$mapinfo.field_82569_d;
            boolean flag = false;
            for (int k1 = l - j1 + 1; k1 < l + j1; ++k1) {
                if ((k1 & 0xF) != (mapdata$mapinfo.field_82569_d & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    byte b1;
                    byte b0;
                    MapColor mapcolor;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i2 = k1 - l;
                    int j2 = l1 - i1;
                    boolean flag1 = i2 * i2 + j2 * j2 > (j1 - 2) * (j1 - 2);
                    int k2 = (j / i + k1 - 64) * i;
                    int l2 = (k / i + l1 - 64) * i;
                    HashMultiset multiset = HashMultiset.create();
                    Chunk chunk = worldIn.func_175726_f(new BlockPos(k2, 0, l2));
                    if (chunk.func_76621_g()) continue;
                    int i3 = k2 & 0xF;
                    int j3 = l2 & 0xF;
                    int k3 = 0;
                    double d1 = 0.0;
                    if (worldIn.field_73011_w.func_177495_o()) {
                        int l3 = k2 + l2 * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT).func_185909_g((IBlockAccess)worldIn, BlockPos.field_177992_a), 10);
                        } else {
                            multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE).func_185909_g((IBlockAccess)worldIn, BlockPos.field_177992_a), 100);
                        }
                        d1 = 100.0;
                    } else {
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                        for (int i4 = 0; i4 < i; ++i4) {
                            for (int j4 = 0; j4 < i; ++j4) {
                                int k4 = chunk.func_76611_b(i4 + i3, j4 + j3) + 1;
                                IBlockState iblockstate = Blocks.field_150350_a.func_176223_P();
                                if (k4 <= 1) {
                                    iblockstate = Blocks.field_150357_h.func_176223_P();
                                } else {
                                    do {
                                        iblockstate = chunk.func_186032_a(i4 + i3, --k4, j4 + j3);
                                        blockpos$mutableblockpos.func_181079_c((chunk.field_76635_g << 4) + i4 + i3, k4, (chunk.field_76647_h << 4) + j4 + j3);
                                    } while (iblockstate.func_185909_g((IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos) == MapColor.field_151660_b && k4 > 0);
                                    if (k4 > 0 && iblockstate.func_185904_a().func_76224_d()) {
                                        IBlockState iblockstate1;
                                        int l4 = k4 - 1;
                                        do {
                                            iblockstate1 = chunk.func_186032_a(i4 + i3, l4--, j4 + j3);
                                            ++k3;
                                        } while (l4 > 0 && iblockstate1.func_185904_a().func_76224_d());
                                    }
                                }
                                d1 += (double)k4 / (double)(i * i);
                                multiset.add((Object)iblockstate.func_185909_g((IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos));
                            }
                        }
                    }
                    k3 /= i * i;
                    double d2 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4;
                    int i5 = 1;
                    if (d2 > 0.6) {
                        i5 = 2;
                    }
                    if (d2 < -0.6) {
                        i5 = 0;
                    }
                    if ((mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.field_151660_b)) == MapColor.field_151662_n) {
                        d2 = (double)k3 * 0.1 + (double)(k1 + l1 & 1) * 0.2;
                        i5 = 1;
                        if (d2 < 0.5) {
                            i5 = 2;
                        }
                        if (d2 > 0.9) {
                            i5 = 0;
                        }
                    }
                    d0 = d1;
                    if (l1 < 0 || i2 * i2 + j2 * j2 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0 || (b0 = data.field_76198_e[k1 + l1 * 128]) == (b1 = (byte)(mapcolor.field_76290_q * 4 + i5))) continue;
                    data.field_76198_e[k1 + l1 * 128] = b1;
                    data.func_176053_a(k1, l1);
                    flag = true;
                }
            }
        }
    }

    public static void renderBiomePreviewMap(World worldIn, ItemStack map) {
        MapData mapdata;
        if (map.func_77973_b() instanceof ItemMapCentered && (mapdata = ((ItemMapCentered)map.func_77973_b()).func_77873_a(map, worldIn)) != null && worldIn.field_73011_w.getDimension() == mapdata.field_76200_c) {
            int i = 1 << mapdata.field_76197_d;
            int j = mapdata.field_76201_a;
            int k = mapdata.field_76199_b;
            Biome[] abiome = worldIn.func_72959_q().func_76931_a((Biome[])null, (j / i - 64) * i, (k / i - 64) * i, 128 * i, 128 * i, false);
            for (int l = 0; l < 128; ++l) {
                for (int i1 = 0; i1 < 128; ++i1) {
                    int j1 = l * i;
                    int k1 = i1 * i;
                    Biome biome = abiome[j1 + k1 * 128 * i];
                    MapColor mapcolor = MapColor.field_151660_b;
                    int l1 = 3;
                    int i2 = 8;
                    if (l > 0 && i1 > 0 && l < 127 && i1 < 127) {
                        if (abiome[(l - 1) * i + (i1 - 1) * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[(l - 1) * i + (i1 + 1) * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[(l - 1) * i + i1 * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[(l + 1) * i + (i1 - 1) * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[(l + 1) * i + (i1 + 1) * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[(l + 1) * i + i1 * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[l * i + (i1 - 1) * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (abiome[l * i + (i1 + 1) * i * 128 * i].func_185355_j() >= 0.0f) {
                            --i2;
                        }
                        if (biome.func_185355_j() < 0.0f) {
                            mapcolor = MapColor.field_151676_q;
                            if (i2 > 7 && i1 % 2 == 0) {
                                l1 = (l + (int)(MathHelper.func_76126_a((float)((float)i1 + 0.0f)) * 7.0f)) / 8 % 5;
                                if (l1 == 3) {
                                    l1 = 1;
                                } else if (l1 == 4) {
                                    l1 = 0;
                                }
                            } else if (i2 > 7) {
                                mapcolor = MapColor.field_151660_b;
                            } else if (i2 > 5) {
                                l1 = 1;
                            } else if (i2 > 3) {
                                l1 = 0;
                            } else if (i2 > 1) {
                                l1 = 0;
                            }
                        } else if (i2 > 0) {
                            mapcolor = MapColor.field_151650_B;
                            l1 = i2 > 3 ? 1 : 3;
                        }
                    }
                    if (mapcolor == MapColor.field_151660_b) continue;
                    mapdata.field_76198_e[l + i1 * 128] = (byte)(mapcolor.field_76290_q * 4 + l1);
                    mapdata.func_176053_a(l, i1);
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            MapData mapdata = this.func_77873_a(stack, worldIn);
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                mapdata.func_76191_a(entityplayer, stack);
            }
            if (isSelected || entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack) {
                this.func_77872_a(worldIn, entityIn, mapdata);
            }
        }
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
        return this.func_77873_a(stack, worldIn).func_176052_a(stack, worldIn, player);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null) {
            if (nbttagcompound.func_150297_b("map_scale_direction", 99)) {
                ItemMapCentered.scaleMap(stack, worldIn, nbttagcompound.func_74762_e("map_scale_direction"));
                nbttagcompound.func_82580_o("map_scale_direction");
            } else if (nbttagcompound.func_74767_n("map_tracking_position")) {
                ItemMapCentered.enableMapTracking(stack, worldIn);
                nbttagcompound.func_82580_o("map_tracking_position");
            }
        }
    }

    protected static void scaleMap(ItemStack p_185063_0_, World p_185063_1_, int p_185063_2_) {
        MapData mapdata = Items.field_151098_aY.func_77873_a(p_185063_0_, p_185063_1_);
        p_185063_0_.func_77964_b(p_185063_1_.func_72841_b("map"));
        MapData mapdata1 = new MapData("map_" + p_185063_0_.func_77960_j());
        if (mapdata != null) {
            mapdata1.field_76197_d = (byte)MathHelper.func_76125_a((int)(mapdata.field_76197_d + p_185063_2_), (int)0, (int)4);
            mapdata1.field_186210_e = mapdata.field_186210_e;
            mapdata1.func_176054_a((double)mapdata.field_76201_a, (double)mapdata.field_76199_b, (int)mapdata1.field_76197_d);
            mapdata1.field_76200_c = mapdata.field_76200_c;
            mapdata1.func_76185_a();
            p_185063_1_.func_72823_a("map_" + p_185063_0_.func_77960_j(), (WorldSavedData)mapdata1);
        }
    }

    protected static void enableMapTracking(ItemStack p_185064_0_, World p_185064_1_) {
        MapData mapdata = Items.field_151098_aY.func_77873_a(p_185064_0_, p_185064_1_);
        p_185064_0_.func_77964_b(p_185064_1_.func_72841_b("map"));
        MapData mapdata1 = new MapData("map_" + p_185064_0_.func_77960_j());
        mapdata1.field_186210_e = true;
        if (mapdata != null) {
            mapdata1.field_76201_a = mapdata.field_76201_a;
            mapdata1.field_76199_b = mapdata.field_76199_b;
            mapdata1.field_76197_d = mapdata.field_76197_d;
            mapdata1.field_76200_c = mapdata.field_76200_c;
            mapdata1.func_76185_a();
            p_185064_1_.func_72823_a("map_" + p_185064_0_.func_77960_j(), (WorldSavedData)mapdata1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            MapData mapdata;
            MapData mapData = mapdata = worldIn == null ? null : this.func_77873_a(stack, worldIn);
            if (mapdata != null) {
                tooltip.add(I18n.func_74837_a((String)"filled_map.scale", (Object[])new Object[]{1 << mapdata.field_76197_d}));
                tooltip.add(I18n.func_74837_a((String)"filled_map.level", (Object[])new Object[]{mapdata.field_76197_d, 4}));
            } else {
                tooltip.add(I18n.func_74838_a((String)"filled_map.unknown"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColor(ItemStack p_190907_0_) {
        NBTTagCompound nbttagcompound = p_190907_0_.func_179543_a("display");
        if (nbttagcompound != null && nbttagcompound.func_150297_b("MapColor", 99)) {
            int i = nbttagcompound.func_74762_e("MapColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return -12173266;
    }
}

