/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestTradeWithVillagers
extends QuestBase
implements Quest {
    public static QuestTradeWithVillagers INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestTradeWithVillagers();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    public void onTrade(EntityPlayer player) {
        if (player == null) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        this.handleTrade(player, province);
    }

    private void handleTrade(EntityPlayer player, Province province) {
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            try {
                quest.setData(data);
                quest.province = province;
                if (!this.perform(quest)) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean perform(DataWrapper quest) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!quest.isApplicable()) {
            return false;
        }
        if (!quest.getData().getCompleted().booleanValue()) {
            quest.setCurrentAmount(quest.getCurrentAmount() + 1);
            quest.getData().getPlayer().func_146105_b((ITextComponent)new TextComponentString("Completed " + MathHelper.func_76125_a((int)quest.getCurrentAmount(), (int)0, (int)quest.getTargetAmount()) + "/" + quest.getTargetAmount() + " Trades"), true);
            if (quest.getCurrentAmount() >= quest.getTargetAmount()) {
                quest.getData().setCompleted(true);
                QuestTradeWithVillagers.chatCompletedQuest(quest.getData());
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        List<ItemStack> rewards;
        Province province = QuestTradeWithVillagers.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getChatStack().equals("")) {
                quest.setChatStack("trade.incomplete", quest.getPlayer(), null);
                this.setData(quest);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(quest.getPlayer(), quest.getCiv(), QuestTradeWithVillagers.getRewardRep(quest));
        if (PlayerCivilizationCapabilityImpl.get(quest.getPlayer()).getReputation(quest.getCiv()) >= 2000 && !quest.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestTradeWithVillagers.getRewardRep(quest) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                quest.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(quest.getPlayer().field_70170_p, quest.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), quest.getPlayer().field_70163_u, quest.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        if ((rewards = QuestTradeWithVillagers.getRewardItems(quest)) != null) {
            items.addAll(rewards);
        }
        quest.setChatStack("trade.complete", quest.getPlayer(), null);
        this.setData(quest);
        return items;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        data.setChatStack("trade.accept", data.getPlayer(), null);
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("trade.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.trade_villagers.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.trade_villagers.description");
        s.append("|").append(q.getTargetAmount());
        s.append("|").append(this.getProvinceName(data.getPlayer(), data.getProvinceId()));
        s.append("|").append(q.getCurrentAmount());
        s.append("|").append("\n\n");
        s.append("|").append(QuestTradeWithVillagers.listItems(QuestTradeWithVillagers.getRewardItems(q.getData())) + ",\n");
        s.append("|").append(QuestTradeWithVillagers.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = new Random();
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        int roll = rand.nextInt(MathHelper.func_76125_a((int)(rep / 100), (int)1, (int)5)) * 2 + 4;
        int em = roll + 2;
        q.setRewardRep(em * 2);
        if (rep >= 3000) {
            em *= 2;
        }
        q.setCurrentAmount(0);
        q.setTargetAmount(roll);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestTradeWithVillagers.setRewardItems(q.getData(), rewardItems);
        this.setData(q.getData());
        return q.getData();
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();
        private Province province;

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Province getProvinceHuntedIn() {
            return this.province;
        }

        public void setProvinceHuntedIn(Province provinceHuntedIn) {
            this.province = provinceHuntedIn;
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }

        private boolean isApplicable() {
            return this.isCorrectQuest() && this.isInCorrectProvince();
        }

        private boolean isCorrectQuest() {
            return this.data.getQuestType() == ID;
        }

        private boolean isInCorrectProvince() {
            return this.data.getProvinceId().equals(this.getProvinceHuntedIn().id);
        }
    }
}

