/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public class QuestMine
extends QuestBase
implements Quest {
    public static QuestMine INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestMine();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    public void perform(QuestData quest, int count) {
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getPlayer().field_70170_p.field_72995_K) {
                return;
            }
            if (quest.getQuestType() != ID) {
                return;
            }
            quest.getiData().put("amount", quest.getiData().get("amount") + count);
            quest.getPlayer().func_146105_b((ITextComponent)new TextComponentString("Gathered " + MathHelper.func_76125_a((int)quest.getiData().get("amount"), (int)0, (int)quest.getiData().get("target")) + "/" + quest.getiData().get("target") + " Resources"), true);
            if (quest.getiData().get("amount") >= quest.getiData().get("target")) {
                quest.setCompleted(true);
                QuestMine.chatCompletedQuest(quest);
            }
        }
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        Province province = QuestMine.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        if (in == null || data == null) {
            return null;
        }
        List<ItemStack> givenItems = QuestMine.copyItems(in);
        DataWrapper q = new DataWrapper().setData(data);
        int target = q.getTargetAmount();
        int total = 0;
        for (ItemStack item : givenItems) {
            if (!this.isCorrectBlock(data.getPlayer(), item.func_77973_b(), q.getBlockType())) continue;
            item.func_190920_e(MathHelper.func_76125_a((int)((total += item.func_190916_E()) - target), (int)0, (int)item.func_190916_E()));
        }
        if (total < target) {
            if (data.getChatStack().equals("")) {
                int requiredLeft = target - total;
                switch (q.getBlockType()) {
                    case 0: {
                        data.setChatStack("mine.logresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 1: {
                        data.setChatStack("mine.dirtresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 2: {
                        data.setChatStack("mine.stoneresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 3: {
                        data.setChatStack("mine.coalresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 4: {
                        data.setChatStack("mine.redstoneresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 5: {
                        data.setChatStack("mine.obsidianresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 6: {
                        data.setChatStack("mine.glowstoneresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 7: {
                        data.setChatStack("mine.lapisresource.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 8: {
                        data.setChatStack("mine.diamondresource.incomplete", data.getPlayer(), "" + requiredLeft);
                    }
                }
            }
            this.setData(data);
            return null;
        }
        if (q.getCurrentAmount() < q.getTargetAmount()) {
            if (data.getChatStack().equals("")) {
                int requiredLeft = q.getTargetAmount() - q.getCurrentAmount();
                switch (q.getBlockType()) {
                    case 0: {
                        data.setChatStack("mine.loggathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 1: {
                        data.setChatStack("mine.dirtgathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 2: {
                        data.setChatStack("mine.stonegathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 3: {
                        data.setChatStack("mine.coalgathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 4: {
                        data.setChatStack("mine.redstonegathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 5: {
                        data.setChatStack("mine.obsidiangathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 6: {
                        data.setChatStack("mine.glowstonegathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 7: {
                        data.setChatStack("mine.lapisgathered.incomplete", data.getPlayer(), "" + requiredLeft);
                        break;
                    }
                    case 8: {
                        data.setChatStack("mine.diamondgathered.incomplete", data.getPlayer(), "" + requiredLeft);
                    }
                }
            }
            this.setData(data);
            return null;
        }
        givenItems = QuestMine.removeEmptyItemStacks(givenItems);
        QuestMine.addRewardItems(data, givenItems);
        EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestMine.getRewardRep(data));
        if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestMine.getRewardRep(data) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        data.setChatStack("mine.complete", data.getPlayer(), null);
        data.setCompleted(true);
        this.setData(data);
        return givenItems;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (in == null) {
            data.setChatStack("mine.reject", data.getPlayer(), null);
            this.setData(data);
            return null;
        }
        data.setChatStack("mine.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        switch (data.getiData().get("block_type")) {
            case 0: {
                data.setChatStack("mine.log.accept", data.getPlayer(), null);
                break;
            }
            case 1: {
                data.setChatStack("mine.dirt.accept", data.getPlayer(), null);
                break;
            }
            case 2: {
                data.setChatStack("mine.stone.accept", data.getPlayer(), null);
                break;
            }
            case 3: {
                data.setChatStack("mine.coal.accept", data.getPlayer(), null);
                break;
            }
            case 4: {
                data.setChatStack("mine.redstone.accept", data.getPlayer(), null);
                break;
            }
            case 5: {
                data.setChatStack("mine.obsidian.accept", data.getPlayer(), null);
                break;
            }
            case 6: {
                data.setChatStack("mine.glowstone.accept", data.getPlayer(), null);
                break;
            }
            case 7: {
                data.setChatStack("mine.lapis.accept", data.getPlayer(), null);
                break;
            }
            case 8: {
                data.setChatStack("mine.diamond.accept", data.getPlayer(), null);
            }
        }
        this.setData(data);
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        int type = q.getBlockType();
        if (type == 0) {
            return "quests.chop.title";
        }
        if (type == 1) {
            return "quests.dig.title";
        }
        return "quests.mine.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        int block = q.getBlockType();
        String resource = "";
        switch (block) {
            case 0: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.log.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 1: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.dirt.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 2: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.stone.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 3: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.coal.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 4: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.redstone.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 5: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.obsidian.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 6: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.glowstone.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 7: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.lapis.itemname", (Object[])new Object[0]).func_150254_d();
                break;
            }
            case 8: {
                resource = TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.diamond.itemname", (Object[])new Object[0]).func_150254_d();
            }
        }
        StringBuilder s = new StringBuilder();
        if (block == 0) {
            s.append("quests.chop.description");
        } else if (block == 1) {
            s.append("quests.dig.description");
        } else {
            s.append("quests.mine.description");
        }
        s.append("|").append(q.getTargetAmount());
        s.append("|").append("\u00a7l" + resource + "\u00a7r");
        s.append("|").append("\n\n");
        s.append("|").append(QuestMine.listItems(QuestMine.getRewardItems(q.getData())) + ",\n");
        s.append("|").append(QuestMine.getRewardRep(q.getData()));
        return s.toString();
    }

    public boolean isCorrectBlock(EntityPlayer player, Item item, int i) {
        switch (i) {
            case 0: {
                Block b = Block.func_149634_a((Item)item);
                return b instanceof BlockLog;
            }
            case 1: {
                Block b = Block.func_149634_a((Item)item);
                return b instanceof BlockDirt || b instanceof BlockGrass;
            }
            case 2: {
                Block b = Block.func_149634_a((Item)item);
                return b.func_176223_P().func_185904_a() == Material.field_151576_e && b.func_176223_P().func_185917_h();
            }
            case 3: {
                return item == Items.field_151044_h;
            }
            case 4: {
                return item == Items.field_151137_ax;
            }
            case 5: {
                Block b = Block.func_149634_a((Item)item);
                return b instanceof BlockObsidian;
            }
            case 6: {
                if (player.field_70170_p.func_175624_G().func_82747_f() == 0) {
                    return false;
                }
                return item == Items.field_151114_aO;
            }
            case 7: {
                if (player.field_70163_u > 60.0) {
                    return false;
                }
                return item == Item.func_111206_d((String)"minecraft:dye:4");
            }
            case 8: {
                return item == Items.field_151045_i;
            }
        }
        return false;
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province questProvince) {
        Random rand = new Random();
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(questProvince.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(questProvince.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(questProvince.civilization);
        int blockType = rand.nextInt(4);
        if (rep >= 750) {
            blockType = rand.nextInt(9);
        } else if (rep >= 500) {
            blockType = rand.nextInt(7);
        } else if (rep >= 250) {
            blockType = rand.nextInt(5);
        }
        if (questProvince.civilization == CivilizationType.SUN) {
            if (blockType < 2) {
                blockType = rand.nextInt(2) + 2;
            }
        } else if (blockType == 0 && ToroQuestConfiguration.disableTreeChoppingQuest) {
            blockType = rand.nextInt(3) + 1;
        }
        q.setBlockType(blockType);
        double roll = 0.0;
        int em = 0;
        switch (blockType) {
            case 0: {
                roll = (rand.nextInt(2) + 2) * 64;
                em = (int)Math.round(roll / 8.0);
                break;
            }
            case 1: {
                roll = (rand.nextInt(3) + 2) * 64;
                em = (int)Math.round(roll / 16.0);
                break;
            }
            case 2: {
                roll = (rand.nextInt(3) + 2) * 64;
                em = (int)Math.round(roll / 16.0);
                break;
            }
            case 3: {
                roll = (rand.nextInt(3) + 2) * 8;
                em = (int)Math.round(roll / 3.0) + 4;
                break;
            }
            case 4: {
                roll = (rand.nextInt(4) + 3) * 8;
                em = (int)Math.round(roll / 3.0) + 8;
                break;
            }
            case 5: {
                roll = (rand.nextInt(4) + 2) * 8;
                em = (int)Math.round(roll) + 2;
                break;
            }
            case 6: {
                roll = (rand.nextInt(5) + 4) * 8;
                em = (int)Math.round(roll / 4.0) + 8;
                break;
            }
            case 7: {
                roll = (rand.nextInt(5) + 6) * 2;
                em = (int)Math.round(roll) + 12;
                break;
            }
            case 8: {
                roll = 1.0;
                em = 24;
            }
        }
        q.setRewardRep(em * 2);
        if (rep >= 3000) {
            em *= 2;
        }
        q.setCurrentAmount(0);
        q.setTargetAmount((int)roll);
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>(1);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        rewards.add(emeralds);
        QuestMine.setRewardItems(q.getData(), rewards);
        this.setData(q.getData());
        return q.getData();
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();

        public int coalesce(Integer integer, int i) {
            if (integer == null) {
                return i;
            }
            return integer;
        }

        public void setBlockType(int blockType) {
            this.data.getiData().put("block_type", blockType);
        }

        public Integer getBlockType() {
            return this.i(this.data.getiData().get("block_type"));
        }

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

