/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public class QuestKillMobs
extends QuestBase
implements Quest {
    public static QuestKillMobs INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestKillMobs();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source == null || source.func_76346_g() == null) {
            return;
        }
        EntityPlayer player = null;
        if (!(source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        player = (EntityPlayer)source.func_76346_g();
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)event.getEntity();
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            try {
                quest.setData(data);
                if (data.getsData().get("mobString") == null) {
                    if (!(victim instanceof EntityMob) && !(victim instanceof IMob)) continue;
                    this.perform(quest);
                    continue;
                }
                String km = data.getsData().get("mobString");
                for (String k : km.split(",")) {
                    if (victim.getClass().getSimpleName().equals(k)) {
                        this.perform(quest);
                        continue;
                    }
                    if (victim.getClass().getSuperclass().getSimpleName().equals(k)) {
                        this.perform(quest);
                        continue;
                    }
                    if (!victim.getClass().getSuperclass().getSuperclass().getSimpleName().equals(k)) continue;
                    this.perform(quest);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private boolean perform(DataWrapper quest) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (quest.getData().getQuestType() != ID) {
            return false;
        }
        quest.setCurrentAmount(quest.getCurrentAmount() + 1);
        quest.getData().getPlayer().func_146105_b((ITextComponent)new TextComponentString("Slain " + MathHelper.func_76125_a((int)quest.getCurrentAmount(), (int)0, (int)quest.getTargetAmount()) + "/" + quest.getTargetAmount() + " " + quest.getMobDisplay()), true);
        if (!quest.getData().getCompleted().booleanValue() && quest.getCurrentAmount() >= quest.getTargetAmount()) {
            quest.getData().setCompleted(true);
            QuestKillMobs.chatCompletedQuest(quest.getData());
        }
        return true;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        Province province = QuestKillMobs.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getChatStack().equals("")) {
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)quest.getPlayer(), (String)"quests.killmobs.monsters", (Object[])new Object[0]).func_150254_d();
                if (quest.getsData().get("mobString") != null) {
                    s = quest.getsData().get("mobDisplay");
                }
                quest.setChatStack("killmobs.incomplete", quest.getPlayer(), s);
                this.setData(quest);
            }
            return null;
        }
        List<ItemStack> rewards = QuestKillMobs.getRewardItems(quest);
        if (rewards != null) {
            items.addAll(rewards);
        }
        String s = TextComponentHelper.createComponentTranslation((ICommandSender)quest.getPlayer(), (String)"quests.killmobs.monsters", (Object[])new Object[0]).func_150254_d();
        if (quest.getsData().get("mobString") != null) {
            s = quest.getsData().get("mobDisplay");
        }
        quest.setChatStack("killmobs.complete", quest.getPlayer(), s);
        EventHandlers.adjustPlayerRep(quest.getPlayer(), quest.getCiv(), QuestKillMobs.getRewardRep(quest));
        if (PlayerCivilizationCapabilityImpl.get(quest.getPlayer()).getReputation(quest.getCiv()) >= 2000 && !quest.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestKillMobs.getRewardRep(quest) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                quest.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(quest.getPlayer().field_70170_p, quest.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), quest.getPlayer().field_70163_u, quest.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        this.setData(quest);
        return items;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        if (data.getsData().get("mobString") == null) {
            data.setChatStack("killmobs.reject", data.getPlayer(), TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.killmobs.monsters", (Object[])new Object[0]).func_150254_d());
        } else {
            data.setChatStack("killmobs.reject", data.getPlayer(), data.getsData().get("mobDisplay"));
        }
        data.getPlayer().func_71053_j();
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        if (data.getsData().get("mobString") == null) {
            data.setChatStack("killmobs.accept", data.getPlayer(), null);
        } else {
            data.setChatStackString(data.getsData().get("mobAccept"), data.getPlayer(), data.getsData().get("mobString"));
        }
        this.setData(data);
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        if (data.getsData().get("mobString") == null) {
            return "quests.killmobs.title";
        }
        return data.getsData().get("mobTitle");
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.killmobs.description");
        s.append("|").append(q.getTargetAmount());
        if (data.getsData().get("mobString") == null) {
            s.append("|").append("monsters");
        } else {
            String km = data.getsData().get("mobDisplay");
            if (q.getTargetAmount() == 1) {
                s.append("|").append(km);
            } else {
                s.append("|").append(km);
            }
        }
        s.append("|").append(q.getCurrentAmount() + "\n\n");
        s.append("|").append(QuestKillMobs.listKillMobItems(QuestKillMobs.getRewardItems(q.getData())) + ",\n");
        s.append("|").append(QuestKillMobs.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        int custom;
        Random rand = new Random();
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int roll = rand.nextInt(8) * 4 + 12;
        int em = (int)Math.round((double)roll / 3.0) + 4;
        q.setMobString(null);
        q.setMobDisplay(null);
        q.setMobAccept(null);
        q.setMobTitle(null);
        int n = custom = ToroQuestConfiguration.mobs.isEmpty() ? -1 : rand.nextInt(ToroQuestConfiguration.mobs.size());
        if (custom >= 0) {
            ToroQuestConfiguration.KillMob km = ToroQuestConfiguration.mobs.get(custom);
            if (km.minRepRequired <= PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) && (km.provinceAllowed.equals("x") || km.provinceAllowed.equals(CivilizationType.tradeName(province.getCiv())))) {
                roll = km.minKills + rand.nextInt(1 + km.maxKills - km.minKills);
                if (roll % 2 == 1 && roll != km.maxKills && roll != km.minKills) {
                    ++roll;
                }
                em = (int)Math.round(km.emeraldsPerKill * (double)roll);
                q.setMobString(km.mobName);
                q.setMobDisplay(km.mobDisplayName);
                q.setMobAccept(km.acceptChat);
                q.setMobTitle(km.title);
            } else {
                ArrayList<ToroQuestConfiguration.KillMob> list = new ArrayList<ToroQuestConfiguration.KillMob>(ToroQuestConfiguration.mobs);
                Collections.shuffle(list);
                for (ToroQuestConfiguration.KillMob c : list) {
                    if (c.minRepRequired > PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) || !c.provinceAllowed.equals("x") && !c.provinceAllowed.equals(CivilizationType.tradeName(province.getCiv()))) continue;
                    roll = c.minKills + rand.nextInt(1 + c.maxKills - c.minKills);
                    if (roll % 2 == 1 && roll != c.maxKills && roll != c.minKills) {
                        ++roll;
                    }
                    em = (int)Math.round(c.emeraldsPerKill * (double)roll);
                    q.setMobString(c.mobName);
                    q.setMobDisplay(c.mobDisplayName);
                    q.setMobAccept(c.acceptChat);
                    q.setMobTitle(c.title);
                    break;
                }
            }
        }
        q.setCurrentAmount(0);
        q.setRewardRep(em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        q.setTargetAmount(roll);
        if (em > 64) {
            ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>(1);
            rewardItems.add(new ItemStack(Blocks.field_150475_bE, em /= 9));
            QuestKillMobs.setRewardItems(q.getData(), rewardItems);
        } else {
            ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
            ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
            rewardItems.add(emeralds);
            QuestKillMobs.setRewardItems(q.getData(), rewardItems);
        }
        this.setData(q.getData());
        return q.getData();
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public String getMobAccept() {
            return this.data.getsData().get("mobAccept");
        }

        public void setMobAccept(String c) {
            this.data.getsData().put("mobAccept", c);
        }

        public String getMobTitle() {
            return this.data.getsData().get("mobTitle");
        }

        public void setMobTitle(String c) {
            this.data.getsData().put("mobTitle", c);
        }

        public String getMobString() {
            return this.data.getsData().get("mobString");
        }

        public void setMobString(String c) {
            this.data.getsData().put("mobString", c);
        }

        public String getMobDisplay() {
            return this.data.getsData().get("mobDisplay");
        }

        public void setMobDisplay(String c) {
            this.data.getsData().put("mobDisplay", c);
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

