/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.ItemMapCentered;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.entities.EntityPigLord;
import net.torocraft.toroquest.generation.WorldGenPlacer;

public class QuestKillBossZombiePig
extends QuestBase
implements Quest {
    public static int ID;
    public static QuestKillBossZombiePig INSTANCE;
    protected final String entityName = "toroquest:toroquest_pig_lord";
    protected final int emeraldAmount = 4;

    public static void init(int id) {
        INSTANCE = new QuestKillBossZombiePig();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        Province province = QuestKillBossZombiePig.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        if (!data.getCompleted().booleanValue()) {
            if (data.getChatStack().equals("")) {
                data.setChatStack("legendary_pig.incomplete", data.getPlayer(), null);
                this.setData(data);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestKillBossZombiePig.getRewardRep(data));
        if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestKillBossZombiePig.getRewardRep(data) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        data.setChatStack("legendary_pig.complete", data.getPlayer(), null);
        in.addAll(QuestKillBossZombiePig.getRewardItems(data));
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("legendary_pig.reject", data.getPlayer(), null);
        data.getPlayer().func_71053_j();
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        try {
            BlockPos pos = this.searchForSuitableLocation(data, 1100, 40);
            int tries = 6;
            while (tries > 0 && pos == null) {
                pos = this.searchForSuitableLocation(data, 1200 - --tries * 20, 40);
            }
            if (pos == null) {
                this.setData(data);
                this.reject(data, in);
                return in;
            }
            this.setSpawnPosition(data, pos);
            WorldGenPlacer.genPigPortal(data.getPlayer().field_70170_p, pos.func_177958_n(), pos.func_177952_p());
            ItemStack itemstack = ItemMapCentered.setupNewMap(data.getPlayer().field_70170_p, pos.func_177958_n(), pos.func_177952_p(), (byte)4, true, true);
            ItemMapCentered.renderBiomePreviewMap(data.getPlayer().field_70170_p, itemstack);
            MapData.func_191094_a((ItemStack)itemstack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
            itemstack.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.legendary_pig.map", (Object[])new Object[0]).func_150254_d() + "\u00a7r");
            in.add(itemstack);
            data.setChatStack("legendary_pig.accept", data.getPlayer(), null);
            this.setData(data);
        }
        catch (Exception e) {
            this.setData(data);
            this.reject(data, in);
            return in;
        }
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        return "quests.legendary_pig.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.legendary_pig.description");
        if (this.getSpawnPosition(data) != null) {
            s.append("|").append(" at \u00a7lLocation:\u00a7r [" + QuestKillBossZombiePig.getDirections(QuestKillBossZombiePig.getProvincePosition(QuestKillBossZombiePig.getQuestProvince(data)), this.getSpawnPosition(data)) + "]\n\n");
        } else {
            s.append("|").append("\n\n");
        }
        s.append("|").append(QuestKillBossZombiePig.listItemsBlocks(QuestKillBossZombiePig.getRewardItems(data)) + "\n");
        s.append("|").append(QuestKillBossZombiePig.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        QuestData data = new QuestData();
        data.setCiv(province.civilization);
        data.setPlayer(player);
        data.setProvinceId(province.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        QuestKillBossZombiePig.setRewardRep(data, 72);
        int em = 4;
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>(1);
        reward.add(this.getEmeraldReward(em));
        QuestKillBossZombiePig.setRewardItems(data, reward);
        this.setData(data);
        return data;
    }

    @SubscribeEvent
    public void checkkills(LivingDeathEvent event) {
        Entity victim = event.getEntity();
        if (!(victim instanceof EntityPigLord)) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null || source.func_76346_g() == null) {
            return;
        }
        List playerList = victim.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(victim.func_180425_c()).func_72314_b(512.0, 128.0, 512.0), (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return true;
            }
        });
        if (playerList.size() < 1 && source.func_76346_g() instanceof EntityPlayer) {
            playerList.add((EntityPlayer)source.func_76346_g());
        }
        for (EntityPlayer player : playerList) {
            Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
            for (QuestData data : quests) {
                if (ID != data.getQuestType()) continue;
                data.setCompleted(true);
                QuestKillBossZombiePig.chatCompletedQuest(data);
            }
            player.func_145747_a((ITextComponent)new TextComponentString(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"quests.legendary_pig.slain", (Object[])new Object[0]).func_150254_d()));
        }
    }
}

