/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestGather
extends QuestBase
implements Quest {
    public static QuestGather INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestGather();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        QuestData data = new QuestData();
        data.setCiv(province.civilization);
        data.setPlayer(player);
        data.setProvinceId(province.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>();
        int em = 12;
        QuestGather.setRewardRep(data, em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        reward.add(new ItemStack(Items.field_151166_bC, em));
        QuestGather.setRewardItems(data, reward);
        this.setData(data);
        return data;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.gather.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.gather.description");
        s.append("|").append("\n\n");
        s.append("|").append(QuestGather.listItems(QuestGather.getRewardItems(data)) + ",\n");
        s.append("|").append(QuestGather.getRewardRep(data));
        return s.toString();
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        data.setChatStack("gather.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        data.setChatStack("gather.accept", data.getPlayer(), null);
        data.setCompleted(true);
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> items) {
        Province province = QuestGather.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        if (items == null || items.isEmpty()) {
            if (data.getChatStack() == "") {
                data.setChatStack("gather.incomplete", data.getPlayer(), null);
                this.setData(data);
            }
            return null;
        }
        int amount = 0;
        for (ItemStack item : items) {
            if (!item.func_77948_v() || item.func_77985_e()) continue;
            ++amount;
        }
        if (amount < 4) {
            if (data.getChatStack() == "") {
                data.setChatStack("gather.incomplete", data.getPlayer(), null);
                this.setData(data);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestGather.getRewardRep(data));
        if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestGather.getRewardRep(data) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        data.setChatStack("gather.complete", data.getPlayer(), null);
        data.setCompleted(true);
        this.setData(data);
        return QuestGather.getRewardItems(data);
    }
}

