/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.QuestFarm;
import net.torocraft.toroquest.civilization.quests.util.ItemMapCentered;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestEnemySpiderPit
extends QuestBase
implements Quest {
    public static int ID;
    public static QuestEnemySpiderPit INSTANCE;
    Random rand = new Random();

    public static void init(int id) {
        INSTANCE = new QuestEnemySpiderPit();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        Province province = QuestEnemySpiderPit.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        int i = 0;
        for (ItemStack item : in) {
            try {
                if (item.func_77978_p().func_74779_i("provinceHeirloom").equals(data.getProvinceId().toString())) {
                    data.setCompleted(true);
                    in.remove(i);
                    EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestEnemySpiderPit.getRewardRep(data));
                    if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
                        int j;
                        for (int ii = QuestEnemySpiderPit.getRewardRep(data) * 2; ii > 0; ii -= j) {
                            j = EntityXPOrb.func_70527_a((int)ii);
                            data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
                        }
                    }
                    data.setChatStack("spider_pit.complete", data.getPlayer(), null);
                    this.setData(data);
                    in.addAll(QuestEnemySpiderPit.getRewardItems(data));
                    return in;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        if (data.getChatStack() == "") {
            data.setChatStack("spider_pit.incomplete", data.getPlayer(), null);
            this.setData(data);
        }
        return null;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("spider_pit.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        BlockPos pos = this.searchForSuitableLocation(data, 400, -20);
        int tries = 6;
        while (tries > 0 && pos == null) {
            pos = this.searchForSuitableLocation(data, 500 - --tries * 20, -20);
        }
        if (pos == null) {
            this.setData(data);
            this.reject(data, in);
            return in;
        }
        this.setSpawnPosition(data, pos);
        this.placeDungeonRoom(data.getPlayer().field_70170_p, data, pos.func_177958_n(), pos.func_177952_p());
        ItemStack itemstack = ItemMapCentered.setupNewMap(data.getPlayer().field_70170_p, pos.func_177958_n(), pos.func_177952_p(), (byte)3, true, true);
        ItemMapCentered.renderBiomePreviewMap(data.getPlayer().field_70170_p, itemstack);
        MapData.func_191094_a((ItemStack)itemstack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
        itemstack.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.spider_pit.map", (Object[])new Object[0]).func_150254_d() + "\u00a7r");
        in.add(itemstack);
        data.setChatStack("spider_pit.accept", data.getPlayer(), null);
        this.setData(data);
        return in;
    }

    private void placeDungeonRoom(World world, QuestData data, int xCenter, int zCenter) {
        int z;
        int x;
        BlockPos pos;
        int halfX = this.rand.nextInt(6) + 6;
        int halfZ = this.rand.nextInt(6) + 6;
        int height = this.rand.nextInt(3) + 8;
        int xMin = xCenter - halfX;
        int zMin = zCenter - halfZ;
        int yMin = 40;
        int xMax = xCenter + halfX;
        int zMax = zCenter + halfZ;
        int yMax = yMin + height;
        boolean lava = false;
        Random rand = new Random();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x2 = xMin; x2 <= xMax; ++x2) {
                for (int z2 = zMin; z2 <= zMax; ++z2) {
                    IBlockState block;
                    if (rand.nextInt(3) == 0 && (x2 == xMin || x2 == xMax || z2 == zMax || z2 == zMin || y == yMax || y == yMin)) {
                        if (rand.nextInt(50) == 0) {
                            block = Blocks.field_150412_bA.func_176223_P();
                        } else if (!lava && rand.nextInt(50) == 0) {
                            lava = true;
                            block = Blocks.field_150353_l.func_176223_P();
                        } else {
                            block = rand.nextInt(4) == 0 ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED) : (rand.nextInt(4) == 0 ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY) : Blocks.field_150417_aV.func_176223_P());
                        }
                    } else if (y == yMin) {
                        if (rand.nextInt(3) == 0) {
                            block = Blocks.field_150333_U.func_176223_P();
                        } else {
                            block = Blocks.field_150350_a.func_176223_P();
                            world.func_175656_a(new BlockPos(x2, y - 1, z2), Blocks.field_150321_G.func_176223_P());
                        }
                    } else {
                        block = Blocks.field_150350_a.func_176223_P();
                    }
                    pos = new BlockPos(x2, y, z2);
                    world.func_175656_a(pos, block);
                }
            }
        }
        for (x = xMin; x < xMax; ++x) {
            for (z = zMin; z < zMax; ++z) {
                if (rand.nextInt(MathHelper.func_76130_a((int)(z - zMin)) * 4 + 1) == 0) {
                    pos = new BlockPos(x, yMax - 2 + rand.nextInt(3), z);
                    world.func_175656_a(pos, Blocks.field_150321_G.func_176223_P());
                }
                if (rand.nextInt(MathHelper.func_76130_a((int)(x - xMin)) * 16 + 1) != 0) continue;
                pos = new BlockPos(x, yMin + 1 - rand.nextInt(2), z);
                world.func_175656_a(pos, Blocks.field_150321_G.func_176223_P());
            }
        }
        for (x = xMin; x < xMax; ++x) {
            for (z = zMin; z < zMax; ++z) {
                if (rand.nextInt(75) != 0) continue;
                pos = new BlockPos(x, yMin, z);
                this.placeChest(world, pos);
            }
        }
        for (int i = 0; height > i; ++i) {
            int y = yMin + i;
            if (rand.nextInt(16) != 0) {
                world.func_175656_a(new BlockPos(xCenter, y, zCenter), Blocks.field_150417_aV.func_176223_P());
            }
            if (rand.nextInt(16) != 0) {
                world.func_175656_a(new BlockPos(xCenter - 1, y, zCenter), Blocks.field_150417_aV.func_176223_P());
            } else {
                world.func_175656_a(new BlockPos(xCenter - 1, y, zCenter), Blocks.field_150390_bg.func_176223_P());
            }
            if (rand.nextInt(16) != 0) {
                world.func_175656_a(new BlockPos(xCenter, y, zCenter - 1), Blocks.field_150417_aV.func_176223_P());
            } else {
                world.func_175656_a(new BlockPos(xCenter, y, zCenter - 1), Blocks.field_150390_bg.func_176223_P());
            }
            if (rand.nextInt(16) == 0) continue;
            world.func_175656_a(new BlockPos(xCenter - 1, y, zCenter - 1), Blocks.field_150417_aV.func_176223_P());
        }
        this.addToroSpawner(data, data.getPlayer().func_130014_f_(), new BlockPos(xCenter + 1, yMin + 1, zCenter), this.getDefaultEnemies(data));
        this.placeQuestChest(world, data, new BlockPos(xCenter + 1, yMin, zCenter));
    }

    protected void placeChest(World world, BlockPos placementPos) {
        world.func_175656_a(placementPos, Blocks.field_150447_bR.func_176223_P());
        TileEntity tileentity = world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186422_d, world.field_73012_v.nextLong());
        }
        world.func_175656_a(placementPos.func_177977_b(), Blocks.field_150348_b.func_176223_P());
        if (this.rand.nextBoolean()) {
            world.func_175656_a(placementPos.func_177979_c(2), Blocks.field_150335_W.func_176223_P());
        }
        world.func_175656_a(placementPos.func_177979_c(3), Blocks.field_150348_b.func_176223_P());
    }

    protected void placeQuestChest(World world, QuestData data, BlockPos placementPos) {
        world.func_175656_a(placementPos, Blocks.field_150486_ae.func_176223_P());
        TileEntity tileentity = world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            for (int i = this.rand.nextInt(6) + 6; i > 0; --i) {
                ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(27), new ItemStack(Items.field_151074_bl, this.rand.nextInt(3) + 1));
                if (this.rand.nextInt(3) == 0) {
                    ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(27), new ItemStack(Items.field_151166_bC, 1));
                    continue;
                }
                if (this.rand.nextInt(3) == 0) {
                    ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(27), new ItemStack(Blocks.field_150321_G, 1));
                    continue;
                }
                ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(27), new ItemStack(Items.field_151166_bC, 5));
            }
            Item item = Items.field_151113_aN;
            ItemStack itemstack = new ItemStack(item, 1);
            itemstack.func_77983_a("provinceHeirloom", (NBTBase)new NBTTagString(data.getProvinceId().toString()));
            itemstack.func_151001_c("\u00a7eAncient Heirloom\u00a7r");
            try {
                itemstack.func_77966_a(null, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((TileEntityChest)tileentity).func_70299_a(15, itemstack);
        }
        world.func_175656_a(placementPos.func_177977_b(), Blocks.field_150348_b.func_176223_P());
    }

    private void addToroSpawner(QuestData data, World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(new BlockPos(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()));
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(16);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(5);
        } else {
            System.out.println("tile entity is missing");
        }
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        return "quests.spider_pit.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.spider_pit.description");
        if (this.getSpawnPosition(data) != null) {
            s.append("|").append(" at \u00a7lLocation:\u00a7r [" + QuestEnemySpiderPit.getDirections(QuestEnemySpiderPit.getProvincePosition(QuestEnemySpiderPit.getQuestProvince(data)), this.getSpawnPosition(data)) + "]\n\n");
        } else {
            s.append("|").append("\n\n");
        }
        s.append("|").append(QuestEnemySpiderPit.listItems(QuestEnemySpiderPit.getRewardItems(data)) + ",\n");
        s.append("|").append(QuestEnemySpiderPit.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        QuestFarm.DataWrapper q = new QuestFarm.DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setProvinceName(province.name);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int em = 20;
        QuestEnemySpiderPit.setRewardRep(this.data, em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>(1);
        reward.add(new ItemStack(Items.field_151166_bC, em));
        QuestEnemySpiderPit.setRewardItems(q.getData(), reward);
        this.setData(q.getData());
        return q.getData();
    }

    private List<String> getDefaultEnemies(QuestData data) {
        ArrayList<String> entity = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            entity.add("minecraft:spider");
        }
        return entity;
    }
}

