/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.ItemMapCentered;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.entities.EntityConstructQuest;

public class QuestEnemyGolem
extends QuestBase
implements Quest {
    public static int ID;
    public static QuestEnemyGolem INSTANCE;
    Random rand = new Random();
    IBlockState clay = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
    protected final int emeraldAmount = 5;

    public static void init(int id) {
        INSTANCE = new QuestEnemyGolem();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        Province province = QuestEnemyGolem.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        if (!data.getCompleted().booleanValue()) {
            if (data.getChatStack() == "") {
                data.setChatStack("steam_golem.incomplete", data.getPlayer(), null);
                this.setData(data);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestEnemyGolem.getRewardRep(data));
        if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 3000 && !data.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int ii = QuestEnemyGolem.getRewardRep(data) * 2; ii > 0; ii -= j) {
                j = EntityXPOrb.func_70527_a((int)ii);
                data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        data.setChatStack("steam_golem.complete", data.getPlayer(), null);
        in.addAll(QuestEnemyGolem.getRewardItems(data));
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("steam_golem.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        try {
            BlockPos pos = this.searchForSuitableLocation(data, 600, -30);
            int tries = 6;
            while (tries > 0 && pos == null) {
                pos = this.searchForSuitableLocation(data, 700 - --tries * 20, -30);
            }
            if (pos == null) {
                this.setData(data);
                this.reject(data, in);
                return in;
            }
            this.setSpawnPosition(data, pos);
            this.placeDungeonRoom(data.getPlayer().field_70170_p, data, pos.func_177958_n(), pos.func_177952_p());
            ItemStack itemstack = ItemMapCentered.setupNewMap(data.getPlayer().field_70170_p, pos.func_177958_n(), pos.func_177952_p(), (byte)3, true, true);
            ItemMapCentered.renderBiomePreviewMap(data.getPlayer().field_70170_p, itemstack);
            MapData.func_191094_a((ItemStack)itemstack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
            itemstack.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.steam_golem.map", (Object[])new Object[0]).func_150254_d() + "\u00a7r");
            in.add(itemstack);
            data.setChatStack("steam_golem.accept", data.getPlayer(), null);
            this.setData(data);
        }
        catch (Exception e) {
            this.setData(data);
            this.reject(data, in);
            return in;
        }
        return in;
    }

    private void placeDungeonRoom(World world, QuestData data, int xCenter, int zCenter) {
        int z;
        int x;
        BlockPos pos;
        int halfX = this.rand.nextInt(5) + 10;
        int halfZ = this.rand.nextInt(5) + 15;
        int height = this.rand.nextInt(3) + 9;
        int xMin = xCenter - halfX;
        int zMin = zCenter - halfZ;
        int yMin = 40;
        int xMax = xCenter + halfX;
        int zMax = zCenter + halfZ;
        int yMax = yMin + height;
        boolean lava = false;
        Random rand = new Random();
        for (int y = yMin; y <= yMax; ++y) {
            lava = false;
            for (int x2 = xMin; x2 <= xMax; ++x2) {
                for (int z2 = zMin; z2 <= zMax; ++z2) {
                    IBlockState block;
                    if (rand.nextInt(3) == 0 && (x2 == xMin || x2 == xMax || z2 == zMax || z2 == zMin || y == yMax || y == yMin)) {
                        if (rand.nextInt(50) == 0) {
                            block = Blocks.field_150412_bA.func_176223_P();
                        } else if (rand.nextInt(50) == 0) {
                            block = Blocks.field_150352_o.func_176223_P();
                        } else if (!lava && rand.nextInt(150) == 0) {
                            lava = true;
                            block = Blocks.field_150353_l.func_176223_P();
                        } else {
                            block = rand.nextInt(4) == 0 ? (rand.nextInt(8) == 0 ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED) : (rand.nextInt(4) == 0 ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED) : (rand.nextInt(4) == 0 ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY) : Blocks.field_150417_aV.func_176223_P()))) : Blocks.field_150348_b.func_176223_P();
                        }
                    } else if ((x2 == xMin || x2 == xMax) && y == yMin + height / 2) {
                        block = Blocks.field_150411_aY.func_176223_P();
                    } else if ((z2 == zMin || z2 == zMax) && y == yMin + height / 2) {
                        block = Blocks.field_150411_aY.func_176223_P();
                    } else if (y == yMin) {
                        if (rand.nextInt(8) == 0) {
                            block = rand.nextInt(4) == 0 ? Blocks.field_150390_bg.func_176223_P().func_185907_a(Rotation.CLOCKWISE_90) : (rand.nextInt(4) == 0 ? Blocks.field_150390_bg.func_176223_P().func_185907_a(Rotation.COUNTERCLOCKWISE_90) : (rand.nextInt(4) == 0 ? Blocks.field_150390_bg.func_176223_P().func_185907_a(Rotation.CLOCKWISE_180) : Blocks.field_150390_bg.func_176223_P().func_185907_a(Rotation.NONE)));
                        } else if (rand.nextInt(4) == 0) {
                            block = Blocks.field_150417_aV.func_176223_P();
                        } else if (rand.nextInt(4) == 0) {
                            block = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                        } else if (rand.nextInt(4) == 0) {
                            block = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
                        } else {
                            block = Blocks.field_150350_a.func_176223_P();
                            world.func_175656_a(new BlockPos(x2, y - 1, z2), Blocks.field_189877_df.func_176223_P());
                        }
                    } else {
                        block = Blocks.field_150350_a.func_176223_P();
                    }
                    pos = new BlockPos(x2, y, z2);
                    world.func_175656_a(pos, block);
                }
            }
        }
        for (x = xMin; x < xMax; ++x) {
            for (z = zMin; z < zMax; ++z) {
                if (!rand.nextBoolean() || z % 4 != 0) continue;
                pos = new BlockPos(x, yMax, z);
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150348_b.func_176223_P());
                world.func_180501_a(pos, Blocks.field_150445_bS.func_176223_P(), 1);
            }
        }
        for (x = xMin; x < xMax; ++x) {
            for (z = zMin; z < zMax; ++z) {
                if (rand.nextInt(100) != 0) continue;
                pos = new BlockPos(x, yMin, z);
                this.placeChest(world, pos);
            }
        }
        this.placePillar(yMin, height, xCenter, zCenter, world);
        this.placePillar(yMin, height, xMin + 1, zCenter - 4, world);
        this.placePillar(yMin, height, xMin + 5, zCenter + 2, world);
        this.placePillar(yMin, height, xCenter - 2, zMax - 5, world);
        this.placePillar(yMin, height, xCenter + 2, zMax - 5, world);
        this.placePillar(yMin, height, xCenter - 5, zCenter + 5, world);
        this.addToroSpawner(data, data.getPlayer().func_130014_f_(), new BlockPos(xCenter + 1, yMin + 1, zCenter), this.getDefaultEnemies(data));
    }

    public void placePillar(int yMin, int height, int xCenter, int zCenter, World world) {
        for (int i = 0; height > i; ++i) {
            int y = yMin + i;
            world.func_175656_a(new BlockPos(xCenter, y, zCenter), this.clay);
            world.func_175656_a(new BlockPos(xCenter - 1, y, zCenter), this.clay);
            world.func_175656_a(new BlockPos(xCenter, y, zCenter - 1), this.clay);
            world.func_175656_a(new BlockPos(xCenter - 1, y, zCenter - 1), this.clay);
        }
    }

    protected void placeChest(World world, BlockPos placementPos) {
        world.func_175656_a(placementPos, Blocks.field_150447_bR.func_176223_P());
        TileEntity tileentity = world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            if (this.rand.nextInt(3) == 0) {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186426_h, world.field_73012_v.nextLong());
            } else {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186423_e, world.field_73012_v.nextLong());
            }
        }
        world.func_175656_a(placementPos.func_177977_b(), Blocks.field_150348_b.func_176223_P());
        if (this.rand.nextInt(3) == 0) {
            world.func_175656_a(placementPos.func_177979_c(2), Blocks.field_150335_W.func_176223_P());
        }
        world.func_175656_a(placementPos.func_177979_c(3), Blocks.field_150348_b.func_176223_P());
    }

    private void addToroSpawner(QuestData data, World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(new BlockPos(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()));
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(40);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(5);
            spawner.addEntityTag(data.getQuestId().toString());
            spawner.addEntityTag("golem_quest");
            spawner.func_70296_d();
        } else {
            EntityConstructQuest e = new EntityConstructQuest(world);
            e.func_70107_b((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o() + 1, (double)blockpos.func_177952_p() + 0.5);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
            System.out.println("tile entity is missing");
        }
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        return "quests.steam_golem.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.steam_golem.description");
        if (this.getSpawnPosition(data) != null) {
            s.append("|").append(" at \u00a7lLocation:\u00a7r [" + QuestEnemyGolem.getDirections(QuestEnemyGolem.getProvincePosition(QuestEnemyGolem.getQuestProvince(data)), this.getSpawnPosition(data)) + "]\n\n");
        } else {
            s.append("|").append("\n\n");
        }
        s.append("|").append(QuestEnemyGolem.listItems(QuestEnemyGolem.getRewardItems(data)) + ",\n");
        s.append("|").append(QuestEnemyGolem.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        QuestData data = new QuestData();
        data.setCiv(province.civilization);
        data.setProvinceName(province.name);
        data.setPlayer(player);
        data.setProvinceId(province.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        QuestEnemyGolem.setRewardRep(data, 90);
        int em = 5;
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 2000) {
            em *= 2;
        }
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>(1);
        reward.add(new ItemStack(Blocks.field_150475_bE, em));
        QuestEnemyGolem.setRewardItems(data, reward);
        this.setData(data);
        return data;
    }

    private List<String> getDefaultEnemies(QuestData data) {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_construct_quest");
        return entity;
    }

    @SubscribeEvent
    public void checkkills(LivingDeathEvent event) {
        Entity victim = event.getEntity();
        if (!(victim instanceof EntityConstructQuest)) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null || source.func_76346_g() == null) {
            return;
        }
        List playerList = victim.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(victim.func_180425_c()).func_72314_b(512.0, 128.0, 512.0), (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return true;
            }
        });
        if (playerList.size() < 1 && source.func_76346_g() instanceof EntityPlayer) {
            playerList.add((EntityPlayer)source.func_76346_g());
        }
        for (EntityPlayer player : playerList) {
            Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
            for (QuestData data : quests) {
                if (ID != data.getQuestType()) continue;
                data.setCompleted(true);
                QuestEnemyGolem.chatCompletedQuest(data);
            }
            player.func_145747_a((ITextComponent)new TextComponentString(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"quests.steam_golem.slain", (Object[])new Object[0]).func_150254_d()));
        }
    }
}

