/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.ItemMapCentered;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.entities.EntitySentry;

public class QuestEnemyEncampment
extends QuestBase
implements Quest {
    public static int ID;
    public static QuestEnemyEncampment INSTANCE;
    private static final int hutHalfWidth = 4;
    private static final int mobCount = 9;
    private static final int minKillsRequired = 6;

    public static void init(int id) {
        INSTANCE = new QuestEnemyEncampment();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        Province province = QuestEnemyEncampment.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(data.getProvinceId()) || data == null) {
            return null;
        }
        if (!data.getCompleted().booleanValue()) {
            int kills = QuestEnemyEncampment.getKills(data);
            if (kills >= 6) {
                data.setCompleted(true);
                EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestEnemyEncampment.getRewardRep(data));
                if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
                    int j;
                    for (int i = QuestEnemyEncampment.getRewardRep(data) * 2; i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
                    }
                }
                data.setChatStack("enemy_encampment.complete", data.getPlayer(), null);
                in.addAll(QuestEnemyEncampment.getRewardItems(data));
                this.setData(data);
                return in;
            }
            int count = this.countEntities(data);
            int tiles = this.countTiles(data);
            if (kills > 1 && count - kills < 6 || tiles == 0) {
                data.setCompleted(true);
                EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestEnemyEncampment.getRewardRep(data));
                if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
                    int j;
                    for (int i = QuestEnemyEncampment.getRewardRep(data) * 2; i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
                    }
                }
                data.setChatStack("enemy_encampment.help", data.getPlayer(), null);
                in.addAll(QuestEnemyEncampment.getRewardItems(data));
                this.setData(data);
                return in;
            }
            if (kills < 1) {
                data.setChatStack("enemy_encampment.nokills", data.getPlayer(), null);
                this.setData(data);
                return null;
            }
            if (kills > 0) {
                data.setChatStack("enemy_encampment.incomplete", data.getPlayer(), null);
                this.setData(data);
                return null;
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestEnemyEncampment.getRewardRep(data));
        if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(data.getCiv()) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestEnemyEncampment.getRewardRep(data) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        data.setChatStack("enemy_encampment.complete", data.getPlayer(), null);
        in.addAll(QuestEnemyEncampment.getRewardItems(data));
        this.setData(data);
        return in;
    }

    private int countEntities(final QuestData data) {
        try {
            Predicate<EntitySentry> filter = new Predicate<EntitySentry>(){

                public boolean apply(EntitySentry entity) {
                    return entity.func_184216_O().contains("encampment_quest") && entity.func_184216_O().contains(data.getQuestId().toString());
                }
            };
            return data.getPlayer().field_70170_p.func_175647_a(EntitySentry.class, new AxisAlignedBB(this.getSpawnPosition(data)).func_72321_a(64.0, 64.0, 64.0), (Predicate)filter).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int countTiles(QuestData data) {
        try {
            int tiles = 0;
            BlockPos pos = this.getSpawnPosition(data);
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            int s = 12;
            for (int xx = x - s; x + s >= xx; ++xx) {
                for (int yy = 48; yy <= 96; ++yy) {
                    for (int zz = z - s; z + s >= zz; ++zz) {
                        TileEntity tileentity = data.getPlayer().field_70170_p.func_175625_s(new BlockPos(xx, yy, zz));
                        if (!(tileentity instanceof TileEntityToroSpawner)) continue;
                        ++tiles;
                    }
                }
            }
            return tiles;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("enemy_encampment.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        try {
            int tries = 6;
            BlockPos pos = this.searchForSuitableLocation(data, 300, 20);
            boolean hutBuilt = this.buildHut(data, pos);
            while (!hutBuilt && tries > 0) {
                pos = this.searchForSuitableLocation(data, 400 - --tries * 20, 20);
                hutBuilt = this.buildHut(data, pos);
            }
            this.setSpawnPosition(data, pos);
            ItemStack itemstack = ItemMapCentered.setupNewMap(data.getPlayer().field_70170_p, pos.func_177958_n(), pos.func_177952_p(), (byte)3, true, true);
            ItemMapCentered.renderBiomePreviewMap(data.getPlayer().field_70170_p, itemstack);
            MapData.func_191094_a((ItemStack)itemstack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
            itemstack.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quests.bandit_camp.map", (Object[])new Object[0]).func_150254_d() + "\u00a7r");
            this.addToroSpawner(data, data.getPlayer().func_130014_f_(), pos, this.getEnemyType(data));
            in.add(itemstack);
            data.setChatStack("enemy_encampment.accept", data.getPlayer(), null);
            this.setData(data);
        }
        catch (Exception e) {
            this.reject(data, in);
        }
        return in;
    }

    @Override
    public BlockPos findSurface(World world, int x, int z, boolean force) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        while (pos.func_177956_o() > 0) {
            IBlockState blockState = world.func_180495_p(pos);
            if (QuestEnemyEncampment.isLiquid(blockState)) {
                return null;
            }
            if (!force && EventHandlers.isStructureBlock(blockState)) {
                return null;
            }
            if (QuestEnemyEncampment.isGroundBlock(blockState)) break;
            pos = pos.func_177977_b();
        }
        return pos.func_177984_a();
    }

    @Override
    public BlockPos randomLocation(QuestData data, int range, boolean force, int occupiedRange) {
        BlockPos pos = super.randomLocation(data, range, force, occupiedRange);
        if (force) {
            return pos;
        }
        if (pos == null) {
            return null;
        }
        if (this.getLocalMinimum(data, pos)) {
            return pos;
        }
        return null;
    }

    public boolean getLocalMinimum(QuestData data, BlockPos pos) {
        int w = 6;
        int max = 0;
        int min = 256;
        for (int x = -w; x <= w; ++x) {
            for (int z = -w; z <= w; ++z) {
                int y = this.findSurface(data.getPlayer().field_70170_p, pos.func_177958_n() + x, pos.func_177952_p() + z, true).func_177956_o();
                max = Math.max(y, max);
                min = Math.min(y, min);
            }
        }
        return max - min <= 6;
    }

    private boolean buildHut(QuestData data, BlockPos pos) {
        World world = data.getPlayer().func_130014_f_();
        if (pos == null) {
            return false;
        }
        int w = 4;
        for (int x = -w; x <= w; ++x) {
            for (int y = -3; y <= w; ++y) {
                for (int z = -w; z <= w; ++z) {
                    BlockPos pointer = pos.func_177982_a(x, y, z);
                    IBlockState block = world.func_180495_p(pointer);
                    if (QuestEnemyEncampment.isGroundBlock(block)) continue;
                    if (y < 0) {
                        world.func_175656_a(pointer, Blocks.field_150346_d.func_176223_P());
                    }
                    if (y + Math.abs(z) == w) {
                        if (x % 2 == 0) {
                            world.func_175656_a(pointer, Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
                            continue;
                        }
                        if (x % 4 == 0) {
                            world.func_175656_a(pointer, Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW));
                            continue;
                        }
                        world.func_175656_a(pointer, Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK));
                        continue;
                    }
                    if (z == 0 && (x == w || x == -w)) {
                        world.func_175656_a(pointer, Blocks.field_180406_aS.func_176223_P());
                        continue;
                    }
                    if (x != 0 || y != 0 || z != 0) continue;
                    pointer = pos.func_177982_a(x + w / 2, y, z - 1);
                    world.func_175656_a(pointer, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
                    TileEntity chest = world.func_175625_s(pointer);
                    ((TileEntityChest)chest).func_189404_a(LootTableList.field_186423_e, world.field_73012_v.nextLong());
                    pointer = pos.func_177982_a(x + w * 2, 0, z);
                    pointer = this.findSurface(world, pointer.func_177958_n(), pointer.func_177952_p(), true);
                    world.func_175656_a(pointer.func_177979_c(2), Blocks.field_189877_df.func_176223_P());
                    world.func_175656_a(pointer.func_177977_b(), Blocks.field_189877_df.func_176223_P());
                    world.func_175656_a(pointer, Blocks.field_150480_ab.func_176223_P());
                    world.func_175656_a(pointer.func_177982_a(-1, 0, 0), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
                    world.func_175656_a(pointer.func_177982_a(1, 0, 0), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
                    world.func_175656_a(pointer.func_177982_a(0, 0, -1), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
                    world.func_175656_a(pointer.func_177982_a(0, 0, 1), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
                    world.func_175656_a(pointer.func_177982_a(-1, -1, 0), Blocks.field_150347_e.func_176223_P());
                    world.func_175656_a(pointer.func_177982_a(1, -1, 0), Blocks.field_150347_e.func_176223_P());
                    world.func_175656_a(pointer.func_177982_a(0, -1, -1), Blocks.field_150347_e.func_176223_P());
                    world.func_175656_a(pointer.func_177982_a(0, -1, 1), Blocks.field_150347_e.func_176223_P());
                    pointer = pos.func_177982_a(x + w * 2 + 3, y, z + 3);
                    pointer = this.findSurface(world, pointer.func_177958_n(), pointer.func_177952_p(), true);
                    world.func_175656_a(pointer, Blocks.field_150364_r.func_176223_P());
                    pointer = pos.func_177982_a(x + w * 2 + 2, y, z - 3);
                    pointer = this.findSurface(world, pointer.func_177958_n(), pointer.func_177952_p(), true);
                    world.func_175656_a(pointer, Blocks.field_150364_r.func_176223_P());
                    pointer = pos.func_177982_a(x + w * 2 - 3, y, z + 2);
                    pointer = this.findSurface(world, pointer.func_177958_n(), pointer.func_177952_p(), true);
                    world.func_175656_a(pointer, Blocks.field_150364_r.func_176223_P());
                }
            }
        }
        return true;
    }

    private void addToroSpawner(QuestData data, World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(56);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(16);
            spawner.addEntityTag(data.getQuestId().toString());
            spawner.addEntityTag("encampment_quest");
        } else {
            System.out.println("tile entity is missing");
        }
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        return "quests.enemy_encampment.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.enemy_encampment.description");
        s.append("|").append(this.getEnemyNames(data));
        if (this.getSpawnPosition(data) != null) {
            s.append("|").append(" at \u00a7lLocation:\u00a7r [" + QuestEnemyEncampment.getDirections(QuestEnemyEncampment.getProvincePosition(QuestEnemyEncampment.getQuestProvince(data)), this.getSpawnPosition(data)) + "]\n\n");
        } else {
            s.append("|").append("\n\n");
        }
        s.append("|").append(QuestEnemyEncampment.listItems(QuestEnemyEncampment.getRewardItems(data)) + "\n");
        s.append("|").append(QuestEnemyEncampment.getRewardRep(data));
        return s.toString();
    }

    private String getEnemyNames(QuestData data) {
        String name = this.getEnemyType(data).get(0);
        try {
            Entity entity = TileEntityToroSpawner.getEntityForId(data.getPlayer().field_70170_p, name);
            return entity.func_70005_c_();
        }
        catch (Exception e) {
            System.out.println("failed to get name of entity [" + name + "] : " + e.getMessage());
            return "unknown enemy";
        }
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        QuestData data = new QuestData();
        data.setCiv(province.civilization);
        data.setPlayer(player);
        data.setProvinceId(province.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        this.chooseEnemyType(data);
        int em = 20;
        int rep = em * 2;
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>(1);
        reward.add(new ItemStack(Items.field_151166_bC, em));
        QuestEnemyEncampment.setRewardRep(data, rep);
        QuestEnemyEncampment.setRewardItems(data, reward);
        this.setData(data);
        return data;
    }

    public static Integer getKills(QuestData data) {
        return QuestEnemyEncampment.coalesce(QuestEnemyEncampment.i(data.getiData().get("kills")), 0);
    }

    private static Integer coalesce(Integer i, int j) {
        if (i == null) {
            return j;
        }
        return i;
    }

    public static void incrementKills(QuestData data) {
        data.getiData().put("kills", QuestEnemyEncampment.getKills(data) + 1);
        data.getPlayer().func_146105_b((ITextComponent)new TextComponentString("Slain " + MathHelper.func_76125_a((int)QuestEnemyEncampment.getKills(data), (int)0, (int)6) + "/" + 6 + " Bandits"), true);
    }

    @SubscribeEvent
    public void checkkills(LivingDeathEvent event) {
        EntityLivingBase victim = (EntityLivingBase)event.getEntity();
        if (!victim.func_184216_O().contains("encampment_quest")) {
            return;
        }
        EntityPlayer player = null;
        DamageSource source = event.getSource();
        if (!(source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        player = (EntityPlayer)source.func_76346_g();
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        for (QuestData data : quests) {
            if (data.getCompleted().booleanValue() || ID != data.getQuestType() || !victim.func_184216_O().contains(data.getQuestId().toString())) continue;
            QuestEnemyEncampment.incrementKills(data);
            if (QuestEnemyEncampment.getKills(data) >= 6) {
                data.setCompleted(true);
                QuestEnemyEncampment.chatCompletedQuest(data);
            }
            return;
        }
    }

    private void chooseEnemyType(QuestData data) {
        ArrayList<String> enemies = new ArrayList<String>();
        if (this.rand.nextBoolean()) {
            for (int i = 0; i < 9; ++i) {
                enemies.add("toroquest:toroquest_sentry");
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                enemies.add("toroquest:toroquest_orc");
            }
        }
        this.setEnemyType(data, enemies);
    }

    private List<String> getEnemyType(QuestData data) {
        ArrayList<String> enemies = new ArrayList<String>();
        NBTTagCompound c = QuestEnemyEncampment.getCustomNbtTag(data);
        try {
            NBTTagList list = (NBTTagList)c.func_74781_a("encampment_quest");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                enemies.add(list.func_150307_f(i));
            }
            return enemies;
        }
        catch (Exception e) {
            System.out.println("Failed to load enemy types: " + e.getMessage());
            return this.getDefaultEnemies(data);
        }
    }

    private List<String> getDefaultEnemies(QuestData data) {
        ArrayList<String> entity = new ArrayList<String>();
        if (this.rand.nextBoolean()) {
            for (int i = 0; i < 9; ++i) {
                entity.add("toroquest:toroquest_sentry");
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                entity.add("toroquest:toroquest_orc");
            }
        }
        return entity;
    }

    private void setEnemyType(QuestData data, List<String> enemies) {
        NBTTagCompound c = QuestEnemyEncampment.getCustomNbtTag(data);
        NBTTagList list = new NBTTagList();
        for (String enemy : enemies) {
            list.func_74742_a((NBTBase)new NBTTagString(enemy));
        }
        c.func_74782_a("encampment_quest", (NBTBase)list);
    }
}

