/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestCourier
extends QuestBase
implements Quest {
    public static QuestCourier INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestCourier();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        Province province = QuestCourier.loadProvince(data.getPlayer().field_70170_p, data.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(data.getProvinceId())) {
            return null;
        }
        Province deliverToProvince = this.getDeliverToProvince(data);
        if (deliverToProvince == null) {
            return null;
        }
        ItemStack note = null;
        boolean correctNote = false;
        for (ItemStack item : in) {
            if (item.func_77973_b() != Item.func_111206_d((String)"toroquest:lord_reply")) continue;
            note = item;
            if (!item.func_77942_o()) continue;
            try {
                String fromProvinceID;
                String questId = item.func_77978_p().func_74779_i("questId");
                if (questId != null) {
                    if (!questId.equals(data.getQuestId().toString())) continue;
                    correctNote = true;
                }
                if ((fromProvinceID = item.func_77978_p().func_74779_i("fromProvinceID")) == null) continue;
                if (fromProvinceID.equals(data.getProvinceId().toString())) {
                    correctNote = true;
                    break;
                }
                correctNote = false;
            }
            catch (Exception e) {
                correctNote = false;
            }
        }
        if (note == null) {
            data.setChatStack("courier.incomplete", data.getPlayer(), deliverToProvince.name);
            return null;
        }
        if (!correctNote) {
            data.setChatStack("courier.wrong", data.getPlayer(), deliverToProvince.name);
            return null;
        }
        note.func_190920_e(0);
        in.remove(note);
        List<ItemStack> rewards = QuestCourier.getRewardItems(data);
        EventHandlers.adjustPlayerRep(data.getPlayer(), data.getCiv(), QuestCourier.getRewardRep(data));
        if (PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getReputation(province.civilization) >= 2000 && !data.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestCourier.getRewardRep(data) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                data.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(data.getPlayer().field_70170_p, data.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), data.getPlayer().field_70163_u, data.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        if (rewards != null) {
            in.addAll(rewards);
        }
        data.setChatStack("courier.complete", data.getPlayer(), deliverToProvince.name);
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        Province deliverToProvince = this.getDeliverToProvince(data);
        data.setChatStack("courier.reject", data.getPlayer(), deliverToProvince.name);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        Province deliverToProvince = this.getDeliverToProvince(data);
        ItemStack itemStack = new ItemStack(Item.func_111206_d((String)"toroquest:lord_note"));
        BlockPos pos = new BlockPos(deliverToProvince.chunkX * 16, 0, deliverToProvince.chunkZ * 16);
        itemStack.func_151001_c("Royal Letter, to Lord of " + deliverToProvince.getName() + " at [" + QuestCourier.getDirections(pos) + "]");
        itemStack.func_77983_a("toProvinceID", (NBTBase)new NBTTagString(deliverToProvince.id.toString()));
        itemStack.func_77983_a("fromProvinceID", (NBTBase)new NBTTagString(data.getProvinceId().toString()));
        itemStack.func_77983_a("questId", (NBTBase)new NBTTagString(data.getQuestId().toString()));
        in.add(itemStack);
        data.setChatStack("courier.accept", data.getPlayer(), deliverToProvince.getName());
        this.setData(data);
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.courier.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        Province deliverToProvince = this.getDeliverToProvince(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.courier.description");
        s.append("|").append(deliverToProvince.name);
        s.append("|").append("\n\n");
        s.append("|").append(QuestCourier.listItems(QuestCourier.getRewardItems(data)) + ",\n");
        s.append("|").append(QuestCourier.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province questProvince) {
        Province deliverToProvince = QuestCourier.chooseRandomProvince(questProvince, player.field_70170_p, true);
        if (deliverToProvince == null) {
            deliverToProvince = questProvince;
        }
        QuestData data = new QuestData();
        data.setCiv(questProvince.civilization);
        data.setPlayer(player);
        data.setProvinceId(questProvince.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        this.setDeliverToProvinceId(data, deliverToProvince.id);
        QuestCourier.setDistance(data, (int)Math.round(player.func_180425_c().func_185332_f(deliverToProvince.chunkX * 16, (int)player.field_70163_u, deliverToProvince.chunkZ * 16)));
        int roll = Math.round(QuestCourier.getDistance(data) / 60) + 4;
        int em = MathHelper.func_76125_a((int)roll, (int)8, (int)32);
        int rep = em * 2;
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(questProvince.civilization) >= 3000) {
            em *= 2;
        }
        QuestCourier.setRewardRep(data, rep);
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>(1);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        rewards.add(emeralds);
        QuestCourier.setRewardItems(data, rewards);
        this.setData(data);
        return data;
    }

    private void setDeliverToProvinceId(QuestData data, UUID id) {
        data.getsData().put("deliverTo", id.toString());
    }

    private Province getDeliverToProvince(QuestData data) {
        Province p = QuestCourier.getProvinceById(data.getPlayer().field_70170_p, data.getsData().get("deliverTo"));
        if (p == null && (p = QuestBase.chooseRandomProvince(null, data.getPlayer().field_70170_p, true)) == null) {
            p = QuestBase.chooseRandomProvince(null, data.getPlayer().field_70170_p, false);
        }
        return p;
    }

    public static Integer getDistance(QuestData data) {
        return QuestCourier.i(data.getiData().get("distance"));
    }

    public static void setDistance(QuestData data, Integer distance) {
        data.getiData().put("distance", distance);
    }
}

