/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.entities.EntityFugitive;

public class QuestCaptureFugitives
extends QuestBase
implements Quest {
    public static QuestCaptureFugitives INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestCaptureFugitives();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    public void onReturn(EntityPlayer player) {
        if (player == null) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        this.handleReturn(player, province);
    }

    private void handleReturn(EntityPlayer player, Province province) {
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            try {
                quest.setData(data);
                quest.province = province;
                if (!this.perform(quest)) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean perform(DataWrapper quest) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!quest.isApplicable()) {
            return false;
        }
        if (!quest.getData().getCompleted().booleanValue()) {
            quest.setCurrentAmount(quest.getCurrentAmount() + 1);
            quest.getData().getPlayer().func_146105_b((ITextComponent)new TextComponentString("Captured " + MathHelper.func_76125_a((int)quest.getCurrentAmount(), (int)0, (int)quest.getTargetAmount()) + "/" + quest.getTargetAmount() + " Fugitives"), true);
            if (quest.getCurrentAmount() >= quest.getTargetAmount()) {
                quest.getData().setCompleted(true);
                QuestCaptureFugitives.chatCompletedQuest(quest.getData());
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        List<ItemStack> rewards;
        Province province = QuestCaptureFugitives.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getChatStack() == "") {
                quest.setChatStack("capture_fugitives.incomplete", quest.getPlayer(), quest.getCiv().getDisplayName(quest.getPlayer()));
                this.setData(quest);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(quest.getPlayer(), quest.getCiv(), QuestCaptureFugitives.getRewardRep(quest));
        if (PlayerCivilizationCapabilityImpl.get(quest.getPlayer()).getReputation(province.civilization) >= 2000 && !quest.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestCaptureFugitives.getRewardRep(quest) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                quest.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(quest.getPlayer().field_70170_p, quest.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), quest.getPlayer().field_70163_u, quest.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        if ((rewards = QuestCaptureFugitives.getRewardItems(quest)) != null) {
            items.addAll(rewards);
        }
        quest.setChatStack("capture_fugitives.complete", quest.getPlayer(), quest.getCiv().getDisplayName(quest.getPlayer()));
        this.setData(quest);
        return items;
    }

    @Override
    public List<ItemStack> reject(QuestData quest, List<ItemStack> items) {
        if (quest.getCompleted().booleanValue()) {
            return null;
        }
        boolean toolIncluded = false;
        int emeraldRemainingCount = 5;
        for (ItemStack item : items) {
            if (!(item.func_77973_b() instanceof ItemLead)) continue;
            toolIncluded = true;
            item.func_190918_g(1);
        }
        if (!toolIncluded) {
            for (ItemStack item : items) {
                if (item.func_190926_b() || item.func_77973_b() != Items.field_151166_bC || item.func_190916_E() < 5) continue;
                int decBy = Math.min(item.func_190916_E(), emeraldRemainingCount);
                emeraldRemainingCount -= decBy;
                item.func_190918_g(decBy);
            }
        }
        if (!toolIncluded && emeraldRemainingCount > 0) {
            quest.setChatStack("rejectreturnitem", quest.getPlayer(), quest.getCiv().getDisplayName(quest.getPlayer()));
            this.setData(quest);
            return null;
        }
        quest.setChatStack("capture_fugitives.reject", quest.getPlayer(), quest.getCiv().getDisplayName(quest.getPlayer()));
        this.setData(quest);
        quest.getPlayer().func_71053_j();
        return items;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        this.spawnFugitives(data.getPlayer().func_130014_f_(), data.getPlayer());
        ItemStack itemstack = new ItemStack(Items.field_151058_ca, 1);
        itemstack.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"item.fugitive_bindings.name", (Object[])new Object[0]).func_150254_d() + "\u00a7r");
        in.add(itemstack);
        data.setChatStack("capture_fugitives.accept", data.getPlayer(), data.getCiv().getDisplayName(data.getPlayer()));
        this.setData(data);
        return in;
    }

    private void spawnFugitives(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        try {
            int localFugitiveCount;
            BlockPos spawnPos;
            BlockPos loc;
            int z;
            int x;
            int range;
            double angle;
            int villageCenterZ;
            int villageCenterX;
            Province province;
            for (int tries = 5; tries > 0; --tries) {
                if (world.field_73011_w.getDimension() != 0 || (province = CivilizationUtil.getProvinceAt(world, player.field_70176_ah, player.field_70164_aj)) == null) continue;
                villageCenterX = province.getCenterPosX();
                villageCenterZ = province.getCenterPosZ();
                angle = this.rand.nextDouble() * Math.PI * 2.0;
                range = 20 + this.rand.nextInt(32);
                x = (int)(Math.cos(angle) * (double)range);
                z = (int)(Math.sin(angle) * (double)range);
                loc = new BlockPos(x += villageCenterX, EventHandlers.MAX_SPAWN_HEIGHT, z += villageCenterZ);
                spawnPos = EventHandlers.findSpawnLocationFrom(world, loc);
                if (spawnPos == null || !world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(spawnPos).func_72314_b(16.0, 10.0, 16.0)).isEmpty() || (localFugitiveCount = world.func_72872_a(EntityFugitive.class, new AxisAlignedBB(spawnPos).func_72314_b(90.0, 45.0, 90.0)).size()) > 4) continue;
                if (localFugitiveCount == 4) {
                    this.spawnFugitive(world, spawnPos, player);
                    continue;
                }
                if (localFugitiveCount < 2) {
                    this.spawnFugitive(world, spawnPos, player);
                    this.spawnFugitive(world, spawnPos, player);
                }
                this.spawnFugitive(world, spawnPos, player);
                this.spawnFugitive(world, spawnPos, player);
                return;
            }
            province = CivilizationUtil.getProvinceAt(world, player.field_70176_ah, player.field_70164_aj);
            if (province == null) {
                return;
            }
            villageCenterX = province.getCenterPosX();
            villageCenterZ = province.getCenterPosZ();
            angle = this.rand.nextDouble() * Math.PI * 2.0;
            range = 20 + this.rand.nextInt(32);
            x = (int)(Math.cos(angle) * (double)range);
            z = (int)(Math.sin(angle) * (double)range);
            loc = new BlockPos(x += villageCenterX, EventHandlers.MAX_SPAWN_HEIGHT, z += villageCenterZ);
            spawnPos = EventHandlers.findSpawnLocationFrom(world, loc);
            if (spawnPos == null) {
                return;
            }
            if (!world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(spawnPos).func_72314_b(16.0, 10.0, 16.0)).isEmpty()) {
                return;
            }
            localFugitiveCount = world.func_72872_a(EntityFugitive.class, new AxisAlignedBB(spawnPos).func_72314_b(90.0, 45.0, 90.0)).size();
            if (localFugitiveCount > 4) {
                return;
            }
            this.addToroSpawner(player.func_130014_f_(), spawnPos, this.getDefaultEnemies());
        }
        catch (Exception e) {
            System.out.println("ERROR SPAWNING EntityFugitive: " + e);
            return;
        }
    }

    private void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(40);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(5);
            spawner.func_70296_d();
        } else {
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            entity.add("toroquest:toroquest_fugitive");
        }
        return entity;
    }

    public void spawnFugitive(World world, BlockPos spawnPos, EntityPlayer player) {
        EntityFugitive e = new EntityFugitive(world);
        e.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)e);
        e.func_70624_b((EntityLivingBase)player);
    }

    public BlockPos searchForSuitableLocation(QuestData data) {
        int i;
        BlockPos pos = null;
        for (i = 0; i < 100 && (pos = this.randomLocation(data, this.rand, this.rand.nextInt(16) + 16 + i, false)) == null; ++i) {
        }
        if (pos == null) {
            for (i = 0; i < 10 && (pos = this.randomLocation(data, this.rand, this.rand.nextInt(64) + 16, true)) == null; ++i) {
            }
        }
        return pos;
    }

    public BlockPos randomLocation(QuestData data, Random random, int range, boolean force) {
        Province province = QuestCaptureFugitives.getQuestProvince(data);
        EntityPlayer player = data.getPlayer();
        if (province == null || player == null) {
            return null;
        }
        double angle = this.rand.nextDouble() * Math.PI * 2.0;
        int x = (int)(Math.cos(angle) * (double)range);
        int z = (int)(Math.sin(angle) * (double)range);
        x = (int)((double)x + player.field_70165_t);
        z = (int)((double)z + player.field_70161_v);
        BlockPos pos = this.findSurface(player.field_70170_p, x, z, force);
        if (force) {
            return pos;
        }
        if (pos == null) {
            return null;
        }
        province = CivilizationUtil.getProvinceAt(player.field_70170_p, x / 16, z / 16);
        if (province == null) {
            return null;
        }
        if (data.getPlayer().field_70170_p.func_175636_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0)) {
            return null;
        }
        return pos;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.capture_fugitives.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.capture_fugitives.description");
        s.append("|").append(q.getTargetAmount());
        s.append("|").append(this.getProvinceName(data.getPlayer(), data.getProvinceId()));
        s.append("|").append(q.getCurrentAmount() + "\n\n");
        s.append("|").append(QuestCaptureFugitives.listItems(QuestCaptureFugitives.getRewardItems(q.getData())) + ",\n");
        s.append("|").append(QuestCaptureFugitives.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = new Random();
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int roll = rand.nextInt(3) + 2;
        int em = roll * 3 + 4;
        q.setRewardRep(em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        q.setCurrentAmount(0);
        q.setTargetAmount(roll);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestCaptureFugitives.setRewardItems(q.getData(), rewardItems);
        this.setData(q.getData());
        return q.getData();
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();
        private Province province;

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Province getProvinceHuntedIn() {
            return this.province;
        }

        public void setProvinceHuntedIn(Province provinceHuntedIn) {
            this.province = provinceHuntedIn;
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }

        private boolean isApplicable() {
            return this.isCorrectQuest() && this.isInCorrectProvince();
        }

        private boolean isCorrectQuest() {
            return this.data.getQuestType() == ID;
        }

        private boolean isInCorrectProvince() {
            return this.data.getProvinceId().equals(this.getProvinceHuntedIn().id);
        }
    }
}

