/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestCaptureEntity
extends QuestBase
implements Quest {
    public static int ID;
    public static QuestCaptureEntity INSTANCE;

    public static void init(int id) {
        INSTANCE = new QuestCaptureEntity();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        Province province = QuestCaptureEntity.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getChatStack() == "") {
                quest.setChatStack("capture_entity.incomplete", quest.getPlayer(), null);
                this.setData(quest);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(quest.getPlayer(), quest.getCiv(), QuestCaptureEntity.getRewardRep(quest));
        if (PlayerCivilizationCapabilityImpl.get(quest.getPlayer()).getReputation(province.civilization) >= 2000 && !quest.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestCaptureEntity.getRewardRep(quest) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                quest.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(quest.getPlayer().field_70170_p, quest.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), quest.getPlayer().field_70163_u, quest.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        quest.setChatStack("capture_entity.complete", quest.getPlayer(), null);
        List<ItemStack> rewards = QuestCaptureEntity.getRewardItems(quest);
        if (rewards != null) {
            items.addAll(rewards);
        }
        this.setData(quest);
        return items;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        if (in == null) {
            if (data.getChatStack() == "") {
                data.setChatStack("rejectreturnitem", data.getPlayer(), null);
                this.setData(data);
            }
            return null;
        }
        List<ItemStack> givenItems = QuestCaptureEntity.copyItems(in);
        boolean toolIncluded = false;
        int emeraldRemainingCount = 5;
        for (ItemStack item : givenItems) {
            if (!(item.func_77973_b() instanceof ItemLead)) continue;
            toolIncluded = true;
            item.func_190918_g(1);
        }
        if (!toolIncluded) {
            for (ItemStack item : givenItems) {
                if (item.func_190926_b() || item.func_77973_b() != Items.field_151166_bC || item.func_190916_E() < 5) continue;
                int decBy = Math.min(item.func_190916_E(), emeraldRemainingCount);
                emeraldRemainingCount -= decBy;
                item.func_190918_g(decBy);
            }
        }
        if (!toolIncluded && emeraldRemainingCount > 0) {
            data.setChatStack("rejectreturnitem", data.getPlayer(), null);
            this.setData(data);
            return null;
        }
        data.setChatStack("capture_entity.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return givenItems;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        try {
            BlockPos pos = this.searchForSuitableLocation(data, 320, 0);
            this.setSpawnPosition(data, pos);
            Boolean spawnBandits = this.rand.nextBoolean();
            this.addToroSpawner(data, data.getPlayer().func_130014_f_(), this.getSpawnPosition(data), this.getDefaultEnemies(data, spawnBandits));
            try {
                if (spawnBandits.booleanValue()) {
                    data.setChatStack("capture_entity.acceptbandits", data.getPlayer(), null);
                } else {
                    data.setChatStack("capture_entity.acceptnobandits", data.getPlayer(), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setData(data);
            ItemStack itemstack = new ItemStack(Items.field_151058_ca, 1);
            itemstack.func_151001_c(TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"item.sheep_bindings.name", (Object[])new Object[0]).func_150254_d() + "\u00a7r");
            in.add(itemstack);
        }
        catch (Exception e) {
            this.reject(data, in);
        }
        return in;
    }

    private List<String> getDefaultEnemies(QuestData data, Boolean spawnBandits) {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("minecraft:sheep");
        if (spawnBandits.booleanValue()) {
            entity.add("toroquest:toroquest_sentry");
            entity.add("toroquest:toroquest_sentry");
            entity.add("toroquest:toroquest_sentry");
        }
        return entity;
    }

    public boolean onReturn(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return false;
        }
        return this.handleReturn(player, province);
    }

    private boolean handleReturn(EntityPlayer player, Province province) {
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            try {
                if (data == null) continue;
                quest.setData(data);
                quest.province = province;
                return this.perform(quest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean perform(DataWrapper quest) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!quest.getData().getCompleted().booleanValue()) {
            quest.getData().setCompleted(true);
            QuestCaptureEntity.chatCompletedQuest(quest.getData());
            return true;
        }
        return false;
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        q.setCurrentAmount(0);
        q.setTargetAmount(1);
        int em = 22;
        q.setRewardRep(em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        q.setCurrentAmount(0);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestCaptureEntity.setRewardItems(q.getData(), rewardItems);
        this.setData(q.getData());
        return q.getData();
    }

    private void addToroSpawner(QuestData data, World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(64);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(16);
            spawner.addEntityTag(data.getQuestId().toString());
            spawner.addEntityTag("capture_quest");
            int color = 0;
            switch (data.getCiv()) {
                case FIRE: {
                    color = 1;
                    break;
                }
                case EARTH: {
                    color = 2;
                    break;
                }
                case WIND: {
                    color = 3;
                    break;
                }
                case WATER: {
                    color = 4;
                    break;
                }
                case MOON: {
                    color = 5;
                    break;
                }
                case SUN: {
                    color = 6;
                    break;
                }
                default: {
                    color = 0;
                }
            }
            spawner.setExtra(color);
            spawner.func_70296_d();
        } else {
            System.out.println("tile entity is missing");
        }
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        return "quests.capture_entity.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        if (this.getSpawnPosition(data) == null) {
            s.append("quests.capture_entity.description_null");
        } else {
            s.append("quests.capture_entity.description");
            s.append("|").append("at \u00a7lLocation:\u00a7r [" + QuestCaptureEntity.getDirections(QuestCaptureEntity.getProvincePosition(QuestCaptureEntity.getQuestProvince(data)), this.getSpawnPosition(data)) + "]");
            s.append("|").append("\n\n");
            s.append("|").append(QuestCaptureEntity.listItems(QuestCaptureEntity.getRewardItems(data)) + ",\n");
            s.append("|").append(QuestCaptureEntity.getRewardRep(data));
        }
        return s.toString();
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();
        private Province province;

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Province getProvinceHuntedIn() {
            return this.province;
        }

        public void setProvinceHuntedIn(Province provinceHuntedIn) {
            this.province = provinceHuntedIn;
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

