/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestBuild
extends QuestBase
implements Quest {
    public static QuestBuild INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestBuild();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    public boolean perform(DataWrapper quest) {
        if (!quest.getData().getCompleted().booleanValue()) {
            quest.setCurrentAmount(quest.getCurrentAmount() + 1);
            quest.getData().getPlayer().func_146105_b((ITextComponent)new TextComponentString("Placed " + MathHelper.func_76125_a((int)quest.getCurrentAmount(), (int)0, (int)quest.getTargetAmount()) + "/" + quest.getTargetAmount() + " Stone"), true);
            if (quest.getCurrentAmount() >= quest.getTargetAmount()) {
                quest.setCurrentAmount(quest.getTargetAmount());
                quest.getData().setCompleted(true);
                QuestBuild.chatCompletedQuest(quest.getData());
            }
        }
        return true;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.build.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.build.description");
        s.append("|").append(this.getProvinceName(data.getPlayer(), data.getProvinceId()));
        s.append("|").append(q.getCurrentAmount());
        s.append("|").append(q.getTargetAmount());
        s.append("|").append("\n\n");
        s.append("|").append(QuestBuild.listItems(QuestBuild.getRewardItems(data)) + ",\n");
        s.append("|").append(q.getRewardRep());
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = new Random();
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int roll = rand.nextInt(3) * 64 + 128;
        int em = (int)Math.round((double)roll / 32.0) + 6;
        q.setRewardRep(em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        q.setCurrentAmount(0);
        q.setTargetAmount(roll);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestBuild.setRewardItems(q.getData(), rewardItems);
        this.setData(q.getData());
        return q.getData();
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("build.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        data.setChatStack("build.accept", data.getPlayer(), null);
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        List<ItemStack> rewards;
        Province province = QuestBuild.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getChatStack().equals("")) {
                quest.setChatStack("build.incomplete", quest.getPlayer(), null);
                this.setData(quest);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(quest.getPlayer(), quest.getCiv(), QuestBuild.getRewardRep(quest));
        if (PlayerCivilizationCapabilityImpl.get(quest.getPlayer()).getReputation(province.civilization) >= 2000 && !quest.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestBuild.getRewardRep(quest) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                quest.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(quest.getPlayer().field_70170_p, quest.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), quest.getPlayer().field_70163_u, quest.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        if ((rewards = QuestBuild.getRewardItems(quest)) != null) {
            items.addAll(rewards);
        }
        quest.setChatStack("build.complete", quest.getPlayer(), null);
        this.setData(quest);
        return items;
    }

    public static class DataWrapper {
        QuestData data = new QuestData();

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Integer getProvinceFarmedIn() {
            return this.i(this.data.getiData().get("province"));
        }

        public void setProvinceFarmedIn(Integer provinceFarmedIn) {
            this.data.getiData().put("province", provinceFarmedIn);
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }

        public boolean isBuildQuest() {
            return this.data.getQuestType() == ID;
        }

        public boolean isInCorrectProvince(Province provinceFarmedIn) {
            return this.data.getProvinceId().equals(provinceFarmedIn.id);
        }
    }
}

