/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public class QuestBreed
extends QuestBase
implements Quest {
    public static QuestBreed INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestBreed();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    public void onBreed(EntityPlayer player, EntityAnimal animal) {
        if (player == null || animal == null) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        this.handleBreed(player, province, animal);
    }

    private void handleBreed(EntityPlayer player, Province province, EntityAnimal animal) {
        if (player == null || province == null || animal == null) {
            return;
        }
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            try {
                quest.setData(data);
                quest.province = province;
                int animalType = 0;
                if (animal instanceof EntityChicken) {
                    animalType = 1;
                } else if (animal instanceof EntityPig) {
                    animalType = 2;
                } else if (animal instanceof EntitySheep) {
                    animalType = 3;
                } else if (animal instanceof EntityCow) {
                    animalType = 4;
                }
                if (quest.getAnimalType() != 0 && quest.getAnimalType() != animalType || !this.perform(quest)) continue;
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    private boolean perform(DataWrapper quest) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!quest.isApplicable()) {
            return false;
        }
        if (!quest.getData().getCompleted().booleanValue()) {
            quest.setCurrentAmount(quest.getCurrentAmount() + 1);
            quest.getData().getPlayer().func_146105_b((ITextComponent)new TextComponentString(MathHelper.func_76125_a((int)quest.getCurrentAmount(), (int)0, (int)quest.getTargetAmount()) + "/" + quest.getTargetAmount()), true);
            if (quest.getCurrentAmount() >= quest.getTargetAmount()) {
                quest.getData().setCompleted(true);
                QuestBreed.chatCompletedQuest(quest.getData());
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        List<ItemStack> rewards;
        Province province = QuestBreed.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        if (!quest.getCompleted().booleanValue()) {
            if (quest.getChatStack() == "") {
                quest.setChatStack("breed.incomplete", quest.getPlayer(), null);
                this.setData(quest);
            }
            return null;
        }
        EventHandlers.adjustPlayerRep(quest.getPlayer(), quest.getCiv(), QuestBreed.getRewardRep(quest));
        if (PlayerCivilizationCapabilityImpl.get(quest.getPlayer()).getReputation(province.civilization) >= 2000 && !quest.getPlayer().field_70170_p.field_72995_K) {
            int j;
            for (int i = QuestBreed.getRewardRep(quest) * 2; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                quest.getPlayer().field_70170_p.func_72838_d((Entity)new EntityXPOrb(quest.getPlayer().field_70170_p, quest.getPlayer().field_70165_t + (double)((this.rand.nextInt(2) * 2 - 1) * 2), quest.getPlayer().field_70163_u, quest.getPlayer().field_70161_v + (double)((this.rand.nextInt(2) * 2 - 1) * 2), j));
            }
        }
        if ((rewards = QuestBreed.getRewardItems(quest)) != null) {
            items.addAll(rewards);
        }
        quest.setChatStack("breed.complete", quest.getPlayer(), null);
        this.setData(quest);
        return items;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        switch (QuestBreed.i(data.getiData().get("animalType"))) {
            case 0: {
                data.setChatStack("breed.acceptany", data.getPlayer(), null);
                break;
            }
            case 1: {
                data.setChatStack("breed.acceptchicken", data.getPlayer(), null);
                break;
            }
            case 2: {
                data.setChatStack("breed.acceptpig", data.getPlayer(), null);
                break;
            }
            case 3: {
                data.setChatStack("breed.acceptsheep", data.getPlayer(), null);
                break;
            }
            case 4: {
                data.setChatStack("breed.acceptcow", data.getPlayer(), null);
            }
        }
        this.setData(data);
        return in;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        if (data.getCompleted().booleanValue()) {
            return null;
        }
        data.setChatStack("breed.reject", data.getPlayer(), null);
        this.setData(data);
        data.getPlayer().func_71053_j();
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.breed.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        String animalType = "livestock";
        switch (QuestBreed.i(data.getiData().get("animalType"))) {
            case 0: {
                animalType = "livestock";
                break;
            }
            case 1: {
                animalType = "chickens";
                break;
            }
            case 2: {
                animalType = "pigs";
                break;
            }
            case 3: {
                animalType = "sheep";
                break;
            }
            case 4: {
                animalType = "cows";
                break;
            }
            default: {
                animalType = "livestock";
            }
        }
        s.append("quests.breed.description");
        s.append("|").append(q.getTargetAmount());
        s.append("|").append(animalType);
        s.append("|").append(this.getProvinceName(data.getPlayer(), data.getProvinceId()));
        s.append("|").append(q.getCurrentAmount() + "\n\n");
        s.append("|").append(QuestBreed.listItems(QuestBreed.getRewardItems(q.getData())) + ",\n");
        s.append("|").append(QuestBreed.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = new Random();
        DataWrapper q = new DataWrapper();
        q.getData().setCiv(province.civilization);
        q.getData().setPlayer(player);
        q.getData().setProvinceId(province.id);
        q.getData().setQuestId(UUID.randomUUID());
        q.getData().setQuestType(ID);
        q.getData().setCompleted(false);
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        if (rep < 0) {
            rep = 0;
        }
        if (rep < 200 || ToroQuestConfiguration.anyAnimalForBreedQuest) {
            q.setAnimalType(0);
        } else {
            q.setAnimalType(rand.nextInt(5));
        }
        int roll = MathHelper.func_76125_a((int)(rand.nextInt(5) * 2 + 4 + Math.round(rep / 200) * 2), (int)8, (int)24);
        int em = Math.round(roll / 3) + 6;
        q.setRewardRep(em * 2);
        if (PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization) >= 3000) {
            em *= 2;
        }
        q.setCurrentAmount(0);
        q.setTargetAmount(roll);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, em);
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestBreed.setRewardItems(q.getData(), rewardItems);
        this.setData(q.getData());
        return q.getData();
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();
        private Province province;

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Province getProvinceHuntedIn() {
            return this.province;
        }

        public void setProvinceHuntedIn(Province provinceHuntedIn) {
            this.province = provinceHuntedIn;
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        public Integer getAnimalType() {
            return this.i(this.data.getiData().get("animalType"));
        }

        public void setAnimalType(Integer type) {
            this.data.getiData().put("animalType", type);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }

        private boolean isApplicable() {
            return this.isCorrectQuest() && this.isInCorrectProvince();
        }

        private boolean isCorrectQuest() {
            return this.data.getQuestType() == ID;
        }

        private boolean isInCorrectProvince() {
            return this.data.getProvinceId().equals(this.getProvinceHuntedIn().id);
        }
    }
}

