/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.ToroQuestTriggers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public abstract class QuestBase
implements Quest {
    public Random rand = new Random();
    protected QuestData data;

    protected static ItemStack createMetaBlockStack(Block block, int meta, int amount) {
        ItemStack s = new ItemStack(block, amount);
        s.func_77964_b(meta);
        return s;
    }

    protected static Province loadProvince(World world, BlockPos pos) {
        return CivilizationUtil.getProvinceAt(world, pos.func_177958_n() / 16, pos.func_177952_p() / 16);
    }

    public static void chat(QuestData data, String message) {
        EntityPlayer player = data.getPlayer();
        if (player == null) {
            return;
        }
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7lVillage Lord\u00a7r: " + message));
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191243_bm, SoundCategory.VOICE, 0.9f, 1.1f);
    }

    public static void chat(EntityPlayer player, String provinceName, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7lVillage Lord\u00a7r: " + message));
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191243_bm, SoundCategory.VOICE, 0.9f, 1.1f);
    }

    public static void chatCompletedQuest(QuestData data) {
        if (data.getPlayer() instanceof EntityPlayerMP && ToroQuestConfiguration.toastQuestCompletion) {
            ToroQuestTriggers.QUEST_ACHIEVEMENT.trigger((EntityPlayerMP)data.getPlayer());
        }
        data.getPlayer().func_146105_b((ITextComponent)TextComponentHelper.createComponentTranslation((ICommandSender)data.getPlayer(), (String)"quest.quest_complete_message", (Object[])new Object[0]), ToroQuestConfiguration.showQuestCompletionAboveActionBar);
        data.getPlayer().field_70170_p.func_184148_a((EntityPlayer)null, data.getPlayer().field_70165_t, data.getPlayer().field_70163_u, data.getPlayer().field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.1f, 1.1f);
    }

    protected static String listItems(List<ItemStack> rewardItems) {
        if (rewardItems == null || rewardItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ItemStack item : rewardItems) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (item.func_77973_b() == Items.field_151166_bC) {
                sb.append(item.func_190916_E() + " ");
                sb.append(item.func_82833_r());
                if (item.func_190916_E() <= 1) continue;
                sb.append("s");
                continue;
            }
            if (item.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150475_bE)) continue;
            sb.append(item.func_190916_E() * 9 + " ");
            sb.append(new ItemStack(Items.field_151166_bC).func_82833_r());
            if (item.func_190916_E() <= 1) continue;
            sb.append("s");
        }
        return sb.toString();
    }

    public ItemStack getEmeraldReward(int em) {
        ItemStack iStack = new ItemStack(Items.field_151166_bC, em);
        if (em > iStack.func_77976_d()) {
            return iStack;
        }
        return new ItemStack(Item.func_150898_a((Block)Blocks.field_150475_bE), em / 9);
    }

    protected static String listKillMobItems(List<ItemStack> rewardItems) {
        if (rewardItems == null || rewardItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ItemStack item : rewardItems) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (item.func_77973_b() == Items.field_151166_bC) {
                sb.append(item.func_190916_E() + " ");
                sb.append(item.func_82833_r());
                if (item.func_77973_b() != Items.field_151166_bC || item.func_190916_E() <= 1) continue;
                sb.append("s");
                continue;
            }
            sb.append(item.func_190916_E() * 9 + " ");
            sb.append(new ItemStack(Items.field_151166_bC, 1).func_82833_r());
            sb.append("s");
        }
        return sb.toString();
    }

    protected static String listItemsBlocks(List<ItemStack> rewardItems) {
        if (rewardItems == null || rewardItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ItemStack item : rewardItems) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(item.func_190916_E() * 9 + " ");
            sb.append(new ItemStack(Items.field_151166_bC, 1).func_82833_r());
            sb.append("s");
        }
        return sb.toString();
    }

    protected static List<ItemStack> removeItems(List<ItemStack> requiredIn, List<ItemStack> itemsIn) throws InsufficientItems {
        List<ItemStack> givenItems = QuestBase.copyItems(itemsIn);
        List<ItemStack> requiredItems = QuestBase.copyItems(requiredIn);
        for (ItemStack givenItem : givenItems) {
            for (ItemStack requiredItem : requiredItems) {
                QuestBase.handleStackDecrement(requiredItem, givenItem);
            }
        }
        for (ItemStack remainingRequired : requiredItems) {
            if (remainingRequired.func_190916_E() <= 0) continue;
            throw new InsufficientItems(remainingRequired.func_190916_E() + " " + remainingRequired.func_82833_r());
        }
        return givenItems;
    }

    protected static void handleStackDecrement(ItemStack requiredItem, ItemStack givenItem) {
        if (!QuestBase.equals(requiredItem, givenItem)) {
            return;
        }
        if (requiredItem.func_190916_E() < 1 || givenItem.func_190916_E() < 1) {
            return;
        }
        int decrementBy = Math.min(requiredItem.func_190916_E(), givenItem.func_190916_E());
        requiredItem.func_190918_g(decrementBy);
        givenItem.func_190918_g(decrementBy);
    }

    protected static boolean equals(ItemStack requiredItem, ItemStack givenItem) {
        return requiredItem.func_77973_b() == givenItem.func_77973_b();
    }

    protected static List<ItemStack> copyItems(List<ItemStack> itemsIn) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : itemsIn) {
            items.add(stack.func_77946_l());
        }
        return items;
    }

    protected static void setRewardItems(QuestData data, List<ItemStack> rewards) {
        QuestBase.setItemsToNbt(data, "rewards", rewards);
    }

    protected static void setRequiredItems(QuestData data, List<ItemStack> required) {
        QuestBase.setItemsToNbt(data, "required", required);
    }

    protected static List<ItemStack> getRequiredItems(QuestData data) {
        return QuestBase.getItemsFromNbt(data, "required");
    }

    protected static List<ItemStack> getRewardItems(QuestData data) {
        return QuestBase.getItemsFromNbt(data, "rewards");
    }

    protected static List<ItemStack> getItemsFromNbt(QuestData data, String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        NBTTagCompound c = QuestBase.getCustomNbtTag(data);
        try {
            NBTTagList list = (NBTTagList)c.func_74781_a(name);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                items.add(new ItemStack(list.func_150305_b(i)));
            }
            return items;
        }
        catch (Exception e) {
            return QuestBase.getDefaultItems(name);
        }
    }

    protected static List<ItemStack> getDefaultItems(String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(Items.field_151166_bC, 5));
        return items;
    }

    protected static void setItemsToNbt(QuestData data, String name, List<ItemStack> items) {
        NBTTagCompound c = QuestBase.getCustomNbtTag(data);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : items) {
            NBTTagCompound cStack = new NBTTagCompound();
            stack.func_77955_b(cStack);
            list.func_74742_a((NBTBase)cStack);
        }
        c.func_74782_a(name, (NBTBase)list);
    }

    protected static NBTTagCompound getCustomNbtTag(QuestData data) {
        try {
            return (NBTTagCompound)data.getCustom();
        }
        catch (Exception e) {
            NBTTagCompound c = new NBTTagCompound();
            data.setCustom((NBTBase)c);
            return c;
        }
    }

    protected static Integer getRewardRep(QuestData data) {
        return QuestBase.i(data.getiData().get("rep"));
    }

    protected static Integer getTargetAmount(QuestData data) {
        return QuestBase.i(data.getiData().get("target"));
    }

    protected static void setRewardRep(QuestData data, Integer rewardRep) {
        data.getiData().put("rep", rewardRep);
    }

    protected static Integer i(Object o) {
        try {
            return (Integer)o;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockLiquid || blockState == Blocks.field_150355_j || blockState == Blocks.field_150358_i || blockState == Blocks.field_150353_l || blockState == Blocks.field_150356_k;
    }

    protected static boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockLeaves || blockState.func_177230_c() instanceof BlockLog || blockState.func_177230_c() instanceof BlockBush || blockState.func_177230_c() instanceof BlockSlab) {
            return false;
        }
        return blockState.func_185914_p();
    }

    protected static String getDirections(BlockPos from, BlockPos to) {
        if (from == null || to == null) {
            return "";
        }
        int x = to.func_177958_n() / 10;
        int z = to.func_177952_p() / 10;
        return (x *= 10) + ", " + (z *= 10);
    }

    protected static String getDirections(BlockPos pos) {
        if (pos == null) {
            return "";
        }
        int x = pos.func_177958_n() / 10;
        int z = pos.func_177952_p() / 10;
        return (x *= 10) + ", " + (z *= 10);
    }

    protected static Province getQuestProvince(QuestData data) {
        return QuestBase.getProvinceById(data.getPlayer().field_70170_p, data.getProvinceId());
    }

    protected static BlockPos getProvincePosition(Province province) {
        return new BlockPos(province.chunkX * 16, 80, province.chunkZ * 16);
    }

    protected static List<Province> getAllProvinces(World world) {
        return CivilizationsWorldSaveData.get(world).getProvinces();
    }

    protected static Province getProvinceById(World world, String id) {
        try {
            return QuestBase.getProvinceById(world, UUID.fromString(id));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Province getProvinceById(World world, UUID id) {
        for (Province p : QuestBase.getAllProvinces(world)) {
            if (!p.id.equals(id)) continue;
            return p;
        }
        return null;
    }

    protected String getProvinceName(EntityPlayer player, UUID provinceId) {
        Province province = QuestBase.getProvinceById(player.field_70170_p, provinceId);
        if (province == null) {
            return "";
        }
        return province.name;
    }

    protected static QuestData getQuestById(EntityPlayer player, String questId) {
        try {
            return QuestBase.getQuestById(player, UUID.fromString(questId));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static QuestData getQuestById(EntityPlayer player, UUID questId) {
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        if (quests == null) {
            return null;
        }
        for (QuestData data : quests) {
            if (data.getQuestId() == null || !data.getQuestId().equals(questId)) continue;
            return data;
        }
        return null;
    }

    public static List<ItemStack> removeEmptyItemStacks(List<ItemStack> givenItems) {
        ArrayList<ItemStack> itemsToReturn = new ArrayList<ItemStack>();
        for (ItemStack item : givenItems) {
            if (item.func_190926_b()) continue;
            itemsToReturn.add(item);
        }
        return itemsToReturn;
    }

    protected static void addRewardItems(QuestData data, List<ItemStack> givenItems) {
        if (QuestBase.getRewardItems(data) == null || givenItems == null) {
            return;
        }
        givenItems.addAll(QuestBase.getRewardItems(data));
    }

    public static Province chooseRandomProvince(Province exclude, World world, boolean mustHaveLord) {
        List<Province> provinces = QuestBase.getAllProvinces(world);
        if (provinces.size() < 1) {
            return null;
        }
        Collections.shuffle(provinces);
        for (Province p : provinces) {
            if (exclude != null && p.id.equals(exclude.id) || mustHaveLord && !p.hasLord) continue;
            return p;
        }
        return null;
    }

    public static Province chooseClosestProvince(EntityPlayer player, CivilizationType include, World world, boolean mustHaveLord) {
        List<Province> provinces = QuestBase.getAllProvinces(world);
        double distance = -1.0;
        Province province = null;
        if (provinces.size() < 1) {
            return null;
        }
        for (Province p : provinces) {
            double contest;
            if (include != null && p.civilization != include || mustHaveLord && !p.hasLord || !((contest = Math.abs(player.field_70165_t - (double)p.getCenterPosX()) + Math.abs(player.field_70161_v - (double)p.getCenterPosZ())) < distance) && !(distance < 0.0)) continue;
            province = p;
            distance = contest;
        }
        return province;
    }

    public BlockPos searchForSuitableLocation(QuestData data, int range, int occupiedRange) {
        int i;
        BlockPos pos = null;
        for (i = 0; i < 100 && (pos = this.randomLocation(data, range, false, occupiedRange)) == null; ++i) {
        }
        if (pos == null) {
            for (i = 0; i < 10 && (pos = this.randomLocation(data, range * 2, true, occupiedRange)) == null; ++i) {
            }
        }
        return pos;
    }

    public BlockPos randomLocation(QuestData data, int range, boolean force, int occupiedRange) {
        BlockPos pos;
        block17: {
            int z;
            int x;
            block16: {
                EntityPlayer player = data.getPlayer();
                if (player == null) {
                    return null;
                }
                range = this.rand.nextInt(range / 2) + range / 2;
                double angle = this.rand.nextDouble() * Math.PI * 2.0;
                x = (int)(Math.cos(angle) * (double)range);
                z = (int)(Math.sin(angle) * (double)range);
                x = (int)((double)x + player.field_70165_t);
                z = (int)((double)z + player.field_70161_v);
                if (!force && !player.field_70170_p.func_190526_b(x, z)) {
                    return null;
                }
                pos = this.findSurface(player.field_70170_p, x, z, force);
                if (force) {
                    return pos;
                }
                if (pos == null) {
                    return null;
                }
                Province province = CivilizationUtil.getProvinceAt(player.field_70170_p, x / 16, z / 16);
                if (province == null) {
                    province = CivilizationUtil.getProvinceAt(player.field_70170_p, x / 16 + 2, z / 16 + 2);
                }
                if (province == null) {
                    province = CivilizationUtil.getProvinceAt(player.field_70170_p, x / 16 + 2, z / 16 - 2);
                }
                if (province == null) {
                    province = CivilizationUtil.getProvinceAt(player.field_70170_p, x / 16 - 2, z / 16 + 2);
                }
                if (province == null) {
                    province = CivilizationUtil.getProvinceAt(player.field_70170_p, x / 16 - 2, z / 16 - 2);
                }
                if (province != null) {
                    return null;
                }
                if (data.getPlayer().field_70170_p.func_175636_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 48.0)) {
                    return null;
                }
                if (occupiedRange >= 0) break block16;
                int s = -occupiedRange / 2;
                for (int xx = x - s; x + s >= xx; ++xx) {
                    for (int yy = 0; yy <= ToroQuestConfiguration.minSpawnHeight; ++yy) {
                        for (int zz = z - s; z + s >= zz; ++zz) {
                            TileEntity tileentity = data.getPlayer().field_70170_p.func_175625_s(new BlockPos(xx, yy, zz));
                            if (!(tileentity instanceof TileEntityChest)) continue;
                            return null;
                        }
                    }
                }
                break block17;
            }
            if (occupiedRange <= 0) break block17;
            int s = occupiedRange / 2;
            for (int xx = x - s; x + s >= xx; ++xx) {
                for (int yy = ToroQuestConfiguration.minSpawnHeight; yy <= ToroQuestConfiguration.maxSpawnHeight; ++yy) {
                    for (int zz = z - s; z + s >= zz; ++zz) {
                        TileEntity tileentity = data.getPlayer().field_70170_p.func_175625_s(new BlockPos(xx, yy, zz));
                        if (!(tileentity instanceof TileEntityChest)) continue;
                        return null;
                    }
                }
            }
        }
        return pos;
    }

    public BlockPos findSurface(World world, int x, int z, boolean force) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        while (pos.func_177956_o() > 0) {
            IBlockState blockState = world.func_180495_p(pos);
            if (!force && (QuestBase.isLiquid(blockState) || EventHandlers.isStructureBlock(blockState))) {
                return null;
            }
            if (QuestBase.isGroundBlock(blockState)) break;
            pos = pos.func_177977_b();
        }
        return pos.func_177984_a();
    }

    public void addToroSpawner(QuestData data, World world, BlockPos blockpos, String tag, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(64);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(16);
            spawner.addEntityTag(data.getQuestId().toString());
            spawner.addEntityTag(tag);
        } else {
            System.out.println("tile entity is missing");
        }
    }

    public BlockPos getSpawnPosition(QuestData data) {
        NBTTagCompound c = QuestBase.getCustomNbtTag(data);
        if (!c.func_74767_n("locationFound")) {
            return null;
        }
        return new BlockPos(c.func_74762_e("pos_x"), c.func_74762_e("pos_y"), c.func_74762_e("pos_z"));
    }

    public void setSpawnPosition(QuestData data, BlockPos pos) {
        NBTTagCompound c = QuestBase.getCustomNbtTag(data);
        c.func_74768_a("pos_x", pos.func_177958_n());
        c.func_74768_a("pos_y", pos.func_177956_o());
        c.func_74768_a("pos_z", pos.func_177952_p());
        c.func_74757_a("locationFound", true);
    }

    protected void setData(QuestData data) {
        this.data = data;
    }

    public static class InsufficientItems
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InsufficientItems(String message) {
            super(message);
        }
    }
}

