/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.player;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationEvent;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ReputationLevel;
import net.torocraft.toroquest.civilization.player.PlayerCivilization;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.QuestBreed;
import net.torocraft.toroquest.civilization.quests.QuestBuild;
import net.torocraft.toroquest.civilization.quests.QuestCaptureEntity;
import net.torocraft.toroquest.civilization.quests.QuestCaptureFugitives;
import net.torocraft.toroquest.civilization.quests.QuestCourier;
import net.torocraft.toroquest.civilization.quests.QuestEnemyEncampment;
import net.torocraft.toroquest.civilization.quests.QuestEnemyGolem;
import net.torocraft.toroquest.civilization.quests.QuestEnemySpiderPit;
import net.torocraft.toroquest.civilization.quests.QuestFarm;
import net.torocraft.toroquest.civilization.quests.QuestGather;
import net.torocraft.toroquest.civilization.quests.QuestKillBossArchmage;
import net.torocraft.toroquest.civilization.quests.QuestKillBossBanditLord;
import net.torocraft.toroquest.civilization.quests.QuestKillBossBastion;
import net.torocraft.toroquest.civilization.quests.QuestKillBossGraveTitan;
import net.torocraft.toroquest.civilization.quests.QuestKillBossMonolithEye;
import net.torocraft.toroquest.civilization.quests.QuestKillBossSpiderLord;
import net.torocraft.toroquest.civilization.quests.QuestKillBossZombiePig;
import net.torocraft.toroquest.civilization.quests.QuestKillMobs;
import net.torocraft.toroquest.civilization.quests.QuestMine;
import net.torocraft.toroquest.civilization.quests.QuestRecruit;
import net.torocraft.toroquest.civilization.quests.QuestTradeWithVillagers;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.QuestDelegator;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessagePlayerCivilizationSetInCiv;
import net.torocraft.toroquest.network.message.MessageSetPlayerReputation;

public class PlayerCivilizationCapabilityImpl
extends PlayerCivilization
implements PlayerCivilizationCapability {
    @CapabilityInject(value=PlayerCivilizationCapability.class)
    public static Capability<PlayerCivilizationCapability> INSTANCE = null;
    Random rand = new Random();
    private final EntityPlayer player;

    public static void register() {
        CapabilityManager.INSTANCE.register(PlayerCivilizationCapability.class, (Capability.IStorage)new PlayerCivilization.PlayerCivilizationStorage(), (Callable)new Callable<PlayerCivilizationCapability>(){

            @Override
            public PlayerCivilizationCapability call() throws Exception {
                return null;
            }
        });
    }

    private QuestData generateNextQuestFor(Province province) {
        QuestData q;
        CivilizationDataAccessor worldData;
        int rep = this.getReputation(province.civilization);
        ArrayList<QuestBase> possibleQuests = new ArrayList<QuestBase>();
        possibleQuests.add(QuestTradeWithVillagers.INSTANCE);
        possibleQuests.add(QuestKillMobs.INSTANCE);
        possibleQuests.add(QuestMine.INSTANCE);
        if (rep >= 50) {
            possibleQuests.add(QuestFarm.INSTANCE);
        }
        if (rep >= 100) {
            possibleQuests.add(QuestRecruit.INSTANCE);
        }
        if (rep >= 250) {
            if (QuestBase.chooseRandomProvince(province, this.player.field_70170_p, true) != null) {
                possibleQuests.add(QuestCourier.INSTANCE);
            }
            possibleQuests.add(QuestBreed.INSTANCE);
            possibleQuests.add(QuestCaptureFugitives.INSTANCE);
            possibleQuests.add(QuestBuild.INSTANCE);
            possibleQuests.add(QuestKillMobs.INSTANCE);
            if (rep <= 500) {
                possibleQuests.add(QuestBuild.INSTANCE);
            }
            if (this.rand.nextBoolean()) {
                possibleQuests.add(QuestCaptureEntity.INSTANCE);
            } else {
                possibleQuests.add(QuestGather.INSTANCE);
            }
        }
        if (rep >= 500) {
            possibleQuests.add(QuestEnemyEncampment.INSTANCE);
            possibleQuests.add(QuestEnemySpiderPit.INSTANCE);
        }
        if (rep >= 1000 && this.rand.nextBoolean() && (worldData = CivilizationsWorldSaveData.get(this.player.field_70170_p)) != null) {
            boolean flag = false;
            if (!worldData.hasTrophyTitan(province.id) && ToroQuestConfiguration.titanBoss) {
                possibleQuests.add(QuestKillBossGraveTitan.INSTANCE);
                flag = true;
            }
            if (rep >= 1200 && !worldData.hasTrophyBandit(province.id) && ToroQuestConfiguration.banditBoss) {
                possibleQuests.add(QuestKillBossBanditLord.INSTANCE);
                flag = true;
            }
            if (rep >= 1400 && !worldData.hasTrophyPig(province.id) && ToroQuestConfiguration.pigBoss) {
                possibleQuests.add(QuestKillBossZombiePig.INSTANCE);
                flag = true;
            }
            if (rep >= 1600 && !worldData.hasTrophyLord(province.id) && ToroQuestConfiguration.golemBoss) {
                possibleQuests.add(QuestEnemyGolem.INSTANCE);
                flag = true;
            }
            if (rep >= 1800 && !worldData.hasTrophySkeleton(province.id) && ToroQuestConfiguration.skeletonBoss) {
                possibleQuests.add(QuestKillBossBastion.INSTANCE);
                flag = true;
            }
            if (rep >= 2000 && !worldData.hasTrophyMage(province.id) && ToroQuestConfiguration.mageBoss) {
                possibleQuests.add(QuestKillBossArchmage.INSTANCE);
                flag = true;
            }
            if (rep >= 2200 && !worldData.hasTrophySpider(province.id) && ToroQuestConfiguration.spiderBoss) {
                possibleQuests.add(QuestKillBossSpiderLord.INSTANCE);
                flag = true;
            }
            if (rep >= 2500 && !worldData.hasTrophyBeholder(province.id) && ToroQuestConfiguration.enderBoss) {
                possibleQuests.add(QuestKillBossMonolithEye.INSTANCE);
                flag = true;
            }
            if (!flag) {
                if (rep > 2500) {
                    rep = 2500;
                }
                switch (this.rand.nextInt(1 + (rep - 1000) / 200)) {
                    case 0: {
                        if (!ToroQuestConfiguration.titanBoss) break;
                        possibleQuests.add(QuestKillBossGraveTitan.INSTANCE);
                        break;
                    }
                    case 1: {
                        if (!ToroQuestConfiguration.banditBoss) break;
                        possibleQuests.add(QuestKillBossBanditLord.INSTANCE);
                        break;
                    }
                    case 2: {
                        if (!ToroQuestConfiguration.pigBoss) break;
                        possibleQuests.add(QuestKillBossZombiePig.INSTANCE);
                        break;
                    }
                    case 3: {
                        if (!ToroQuestConfiguration.golemBoss) break;
                        possibleQuests.add(QuestEnemyGolem.INSTANCE);
                        break;
                    }
                    case 4: {
                        if (!ToroQuestConfiguration.skeletonBoss) break;
                        possibleQuests.add(QuestKillBossBastion.INSTANCE);
                        break;
                    }
                    case 5: {
                        if (!ToroQuestConfiguration.mageBoss) break;
                        possibleQuests.add(QuestKillBossArchmage.INSTANCE);
                        break;
                    }
                    case 6: {
                        if (!ToroQuestConfiguration.spiderBoss) break;
                        possibleQuests.add(QuestKillBossSpiderLord.INSTANCE);
                        break;
                    }
                    case 7: {
                        if (!ToroQuestConfiguration.enderBoss) break;
                        possibleQuests.add(QuestKillBossMonolithEye.INSTANCE);
                    }
                }
            }
        }
        if ((q = ((Quest)possibleQuests.get(this.rand.nextInt(possibleQuests.size()))).generateQuestFor(this.player, province)) == null) {
            ArrayList fallbackQuests = new ArrayList();
            possibleQuests.add(QuestTradeWithVillagers.INSTANCE);
            q = ((Quest)fallbackQuests.get(this.rand.nextInt(fallbackQuests.size()))).generateQuestFor(this.player, province);
        }
        this.nextQuests.add(q);
        return q;
    }

    public PlayerCivilizationCapabilityImpl(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void setReputation(CivilizationType civ, int amount) {
        if (civ == null) {
            return;
        }
        this.reputations.put(civ, amount);
        if (!this.player.func_130014_f_().field_72995_K) {
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetPlayerReputation(civ, amount), (EntityPlayerMP)this.player);
            MinecraftForge.EVENT_BUS.post((Event)new CivilizationEvent.ReputationChange(this.player, civ, amount));
        }
    }

    @Override
    public void adjustReputation(CivilizationType civ, int amount) {
        if (civ == null) {
            return;
        }
        if (this.reputations.get((Object)civ) == null) {
            this.reputations.put(civ, 0);
        }
        this.setReputation(civ, (Integer)this.reputations.get((Object)civ) + amount);
    }

    @Override
    public void syncClient() {
        if (!this.player.func_130014_f_().field_72995_K) {
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayerCivilizationSetInCiv(this.inCiv), (EntityPlayerMP)this.player);
            for (Map.Entry entry : this.reputations.entrySet()) {
                ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetPlayerReputation((CivilizationType)((Object)entry.getKey()), (Integer)entry.getValue()), (EntityPlayerMP)this.player);
            }
        }
    }

    @Override
    public ReputationLevel getReputationLevel(CivilizationType civ) {
        return ReputationLevel.fromReputation(this.getReputation(civ));
    }

    @Override
    public int getReputation(CivilizationType civ) {
        return this.i((Integer)this.reputations.get((Object)civ));
    }

    @Override
    public void updatePlayerLocation(int chunkX, int chunkZ) {
        Province prev = this.inCiv;
        Province curr = CivilizationUtil.getProvinceAt(this.player.field_70170_p, chunkX, chunkZ);
        if (PlayerCivilizationCapabilityImpl.equals(prev, curr)) {
            return;
        }
        this.setInCivilization(curr);
        if (!this.player.func_130014_f_().field_72995_K) {
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayerCivilizationSetInCiv(this.inCiv), (EntityPlayerMP)this.player);
        }
        if (prev != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CivilizationEvent.Leave(this.player, prev));
        }
        if (curr != null) {
            PlayerCivilizationCapabilityImpl.get(this.player).setInCivilization(curr);
            MinecraftForge.EVENT_BUS.post((Event)new CivilizationEvent.Enter(this.player, curr));
        }
    }

    @Override
    public void setInCivilization(Province civ) {
        this.inCiv = civ;
    }

    private static boolean equals(Province a, Province b) {
        CivilizationType civA = PlayerCivilizationCapabilityImpl.getCivilization(a);
        CivilizationType civB = PlayerCivilizationCapabilityImpl.getCivilization(b);
        if (civA == null && civB == null) {
            return true;
        }
        if (civA == null || civB == null) {
            return false;
        }
        return civA.equals((Object)civB);
    }

    private static CivilizationType getCivilization(Province a) {
        if (a == null) {
            return null;
        }
        return a.civilization;
    }

    @Override
    public Province getInCivilization() {
        return this.inCiv;
    }

    public String toString() {
        return "Player Civilization Info: " + this.player.func_70005_c_() + ": IN_CIV[" + this.inCiv + "]";
    }

    private int i(Integer integer) {
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static PlayerCivilizationCapability get(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return (PlayerCivilizationCapability)player.getCapability(INSTANCE, null);
    }

    @Override
    public Set<QuestData> getCurrentQuests() {
        return this.quests;
    }

    private boolean removeQuest(QuestData quest) {
        return this.quests.remove(quest);
    }

    @Override
    public QuestData getCurrentQuestFor(Province province) {
        for (QuestData q : this.getCurrentQuests()) {
            if (!q.getProvinceId().equals(province.id)) continue;
            return q;
        }
        return null;
    }

    @Override
    public QuestData getNextQuestFor(Province province) {
        for (QuestData q : this.nextQuests) {
            if (!q.getProvinceId().equals(province.id)) continue;
            return q;
        }
        return this.generateNextQuestFor(province);
    }

    @Override
    public List<ItemStack> acceptQuest(List<ItemStack> in) {
        Province province = this.getInCivilization();
        if (province == null) {
            return null;
        }
        if (this.getCurrentQuestFor(province) != null) {
            return null;
        }
        QuestData data = this.getNextQuestFor(province);
        this.quests.add(data);
        this.nextQuests.remove(data);
        return new QuestDelegator(data).accept(in);
    }

    @Override
    public List<ItemStack> rejectQuest(List<ItemStack> in) {
        Province province = this.getInCivilization();
        if (province == null) {
            return null;
        }
        QuestData data = this.getCurrentQuestFor(province);
        if (data == null) {
            return null;
        }
        List<ItemStack> out = new QuestDelegator(data).reject(in);
        if (out == null) {
            return null;
        }
        int rep = this.getReputation(province.civilization);
        if (this.removeQuest(data)) {
            int loss = ToroQuestConfiguration.abandonQuestRepLoss;
            if (rep >= loss) {
                this.adjustReputation(province.civilization, -loss);
            } else if (rep > 0 && rep < loss) {
                this.adjustReputation(province.civilization, -rep);
            }
            return out;
        }
        return null;
    }

    @Override
    public List<ItemStack> completeQuest(List<ItemStack> in) {
        Province province = this.getInCivilization();
        if (province == null) {
            return null;
        }
        QuestData data = this.getCurrentQuestFor(province);
        if (data == null) {
            return null;
        }
        List<ItemStack> reward = new QuestDelegator(data).complete(in);
        if (reward == null) {
            return null;
        }
        if (!this.removeQuest(data)) {
            return null;
        }
        Integer n = this.completedQuests;
        Integer n2 = this.completedQuests = Integer.valueOf(this.completedQuests + 1);
        if (this.completedQuestsByProvince.get(province.id) == null) {
            this.completedQuestsByProvince.put(province.id, 0);
        }
        this.completedQuestsByProvince.put(province.id, (Integer)this.completedQuestsByProvince.get(province.id) + 1);
        return reward;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }
}

