/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import java.util.Random;
import net.torocraft.toroquest.civilization.CivilizationType;

public class ProvinceNames {
    private static final String[] START_X = new String[]{"foreck", "lok", "vvarden", "rotn", "eagle", "wolf", "wolfe", "drift", "razer", "razor", "widow", "vvarz", "vvel", "sunken", "ender", "wither", "neth", "skel", "stev", "king", "duke", "baron", "aro", "arow", "fort", "angel", "demon", "daemon", "rother", "davon", "narn", "blen", "dews", "raven", "ravens", "ror", "nor", "falk", "wind", "mor", "mark", "wyver", "boar", "dragon", "alc", "farn", "fourne", "strath", "jed", "bar", "dale", "cael", "hals", "calen", "ha", "dagger", "swift", "far", "gloom", "hero", "might", "mid", "modan", "loch", "mal", "vy", "vor", "vvar", "vir", "vyn", "mor", "went", "bear", "hartl", "ter", "terg", "swan", "doon", "mas", "high", "fae", "new", "first", "hinter", "north", "south", "east", "west", "way", "liver", "sky", "brer", "ez", "skol", "breeze", "wind", "val", "fjor", "forn", "wither", "stoh", "grog", "elder", "dunn", "sin", "rod", "soar", "wilt", "wult", "ad", "small", "sult", "sword", "ox", "mount", "old", "new", "blood", "hinter", "north", "south", "east", "west", "way", "kul", "lys", "mar", "rael"};
    private static final String[] END_X = new String[]{"mend", "lot", "lock", "herst", "vvast", "vast", "gar", "ggar", "garr", "hook", "ille", "ath", "kath", "thal", "end", "tome", "crown", "mare", "song", "foss", "ghost", "gost", "clod", "cloud", "azan", "wall", "aron", "aslahti", "pridd", "iston", "kirkey", "might", "age", "spirit", "ison", "odon", "ury", "brine", "ax", "axe", "barrow", "bell", "bend", "bert", "borne", "brand", "brawn", "break", "bridge", "burg", "burgh", "bury", "bus", "by", "caste", "castle", "cast", "caster", "cester", "chester", "glen", "eglos", "cost", "crest", "cry", "dale", "deep", "deft", "hunt", "ingham", "keld", "del", "bell", "dell", "delve", "den", "dyn", "dence", "denfel", "dew", "diff", "ding", "don", "down", "worthy", "worth", "werth", "bydder", "ledo", "never", "meld", "hyth", "fall", "falls", "fare", "fast", "fel", "feld", "fell", "field", "fields", "ford", "forge", "fray", "ruther", "ouver", "gan", "gard", "garde", "gas", "gate", "gend", "glade", "glen", "gow", "grasp", "heim", "gaard", "spear", "syde", "kyln", "kyrk", "lynd", "dren", "drova", "guard", "gulch", "hal", "ham", "hamm", "hammer", "haven", "head", "heart", "hearth", "heath", "helm", "sted", "steed", "steen", "lend", "dust", "edge", "hill", "hold", "hollow", "breth", "morag", "yeld", "yeild", "fen", "nite", "night", "holm", "horn", "hal", "heel", "hall", "haal", "holme", "hull", "kin", "spear", "knox", "kiln", "keg", "post", "holde", "kirk", "kled", "kneel", "heart", "ley", "gatnon", "rin", "glen", "dydd", "land", "lands", "keep", "deep", "ling", "hallow", "lull", "mar", "gale", "march", "mark", "mead", "lry", "meet", "mer", "mere", "mert", "mery", "end", "erilon", "scar", "ward", "mond", "mont", "moon", "moar", "more", "moth", "mourn", "mouth", "myr", "nard", "ox", "ston", "rother", "hol", "path", "stow", "vein", "breach", "pass", "phia", "phis", "pike", "pole", "polis", "pool", "port", "post", "quarin", "veldt", "ver", "vik", "borne", "las", "den", "quay", "rage", "ran", "rest", "rester", "ridge", "burgh", "rift", "sby", "rith", "road", "roads", "sten", "stin", "stine", "stoe", "erston", "ron", "rora", "ross", "rough", "run", "ern", "wit", "sa", "sall", "sas", "atel", "scape", "set", "sey", "side", "son", "wik", "will", "fair", "combe", "peak", "lance", "point", "spell", "sham", "shaw", "shawl", "shade", "brow", "shayd", "bellows", "sheen", "shelter", "shield", "shire", "erton", "vault", "valt", "wich", "stone", "storm", "sunder", "ta", "taed", "ten", "ther", "thorn", "thorps", "thral", "tin", "tine", "fair", "fare", "hand", "tol", "tomb", "ton", "vail", "vale", "valley", "saw", "var", "veld", "sper", "skull", "stall", "star", "stead", "yta", "zyrn", "eve", "mantle", "host", "ville", "cliff", "rock", "lyrock", "ving", "vist", "vsor", "vyr", "war", "watch", "way", "well", "wen", "threl", "wick", "clae", "rell", "rel", "riel", "spur", "cath", "walk", "wych", "runn", "mora", "morag", "wytch", "widge", "wright", "wulf", "wyck", "ysaf", "lens", "kil"};
    private static final String[] START_EARTH = new String[]{"green", "wild", "maple", "pine", "oak", "oaken", "willow", "tangle", "primal", "brush", "lumber", "thrag", "strong", "elder", "verdure", "virid", "emerald", "moss", "ash", "emerald", "wilder", "timber", "tangle", "summer", "vvild", "copse", "elm", "willow", "birch", "ashen", "lumber", "mid", "elf", "elven", "brent", "bright"};
    private static final String[] END_EARTH = new String[]{"weald", "glade", "lush", "copse", "thicket", "clave", "garden", "fern", "wood", "woods", "bark", "forest", "leaf", "peak", "vale", "glade", "lot", "land", "grove", "stand", "wilds", "hill"};
    private static final String[] EARTH = new String[]{"sycamore", "elfsong", "daggerford", "lumber", "notch", "leilon", "orchard", "lumber", "timber", "arbor", "arbour", "alcove", "arborvitae", "bower", "labyrinth", "lombardy", "viburnum", "arrowwood", "sycamore", "laurel", "sequoia", "maidenhair", "maple", "adansonia", "cordata", "caprea", "tilia", "quercus", "hemlock", "camphor", "yggdrassil"};
    private static final String[] START_WIND = new String[]{"hammer", "bryn", "oxen", "steel", "sunder", "smolder", "thunder", "sky", "boulder", "grey", "gray", "brow", "stone", "iron", "tin", "copper", "silver", "slate", "high", "bronze", "clay", "shale", "granite", "coal", "slate", "flint", "silt", "high", "sulfur", "grey", "ash", "sky", "high"};
    private static final String[] END_WIND = new String[]{"steed", "keep", "born", "smith", "smoke", "brow", "crown", "ridge", "heights", "pinnacle", "rise", "fist", "bluff", "summit", "slopes", "land", "planes", "smith", "fall", "forge", "reach", "rise", "brick", "burg", "clif", "cliff", "peak", "cliffe", "rock", "brick", "bleak", "break", "hill", "hills", "mont", "rize", "gate"};
    private static final String[] WIND = new String[]{"whiterock", "blackrock", "blackcliff", "anvil", "adamantine", "agate", "coade", "boulder", "alps", "zenith", "summit", "shale", "chisel", "quarry", "grotto", "forge", "apex", "bronn", "sunder", "skyreach", "thunder", "flint", "hammer", "haven", "forge", "ironhill"};
    private static final String[] START_FIRE = new String[]{"spring", "tangle", "vine", "vyne", "red", "spring", "clover", "thorn", "petal", "flora", "floral", "bloom", "rose", "lila", "aloe", "aster", "calla", "crimson", "anther", "prim", "flax", "sweet", "fox", "far", "vast"};
    private static final String[] END_FIRE = new String[]{"thorn", "glade", "garden", "grove", "cone", "seed", "stem", "bloom", "meadow", "meadows", "fern", "field", "fields", "glen", "dale", "vale", "plains", "crown", "reath", "briar", "land", "brier", "valley", "acer", "shrub", "acre", "bloom", "blossom", "haven", "heath", "hearth", "garden", "flats"};
    private static final String[] FIRE = new String[]{"edelweiss", "leilon", "amaranth", "hydrangea", "daffodil", "azalea", "virrose", "floret", "anther", "allium", "azela", "perennial", "avens", "yucca", "hawthorn", "crimson", "scarlet", "eglantine", "vera", "acer", "aloe", "hibiscus", "calluna", "heather", "lonicera", "malenocarpa", "weigela", "lantana", "daphne", "peony", "bloom", "talon", "sage", "yarrow", "aster", "iris", "lavender", "prim", "calla", "lily", "laurel", "silverleaf", "anemone", "ivy", "amaryllis", "camellia", "maidenhair", "alstroemeria", "bleedingheart", "purslane", "coreopsis", "blossom", "clematis", "vernal", "vinca", "weigela", "phlox", "alyssum", "dahlias", "forsythia", "foxglove", "spirea", "meadow", "lombardy", "thistle", "marigold", "lilac", "coppice", "bosquet", "garnet", "thornhill", "harvest"};
    private static final String[] START_WATER = new String[]{"bryn", "water", "ivar", "sno", "snow", "drift", "flur", "bliz", "sleet", "storm", "bleak", "alf", "sleet", "white", "pale", "winter", "freeze", "frost", "cold", "winter", "river", "shiver", "kirk", "surj", "nov", "thor", "dew", "sunke", "ice", "glace", "glacier", "bleak", "numb", "glacial", "wolf", "polar", "novi", "hers", "ulf"};
    private static final String[] END_WATER = new String[]{"shander", "crest", "stead", "sted", "burg", "jarl", "berg", "heim", "rime", "kir", "dner", "dnar", "grasp", "gate", "watch", "bite", "fjord", "gard", "guard", "vik", "vin", "kild", "igrad", "graft", "hild", "hold", "hearth", "ford", "weld", "whelm", "kyr", "thaw", "post", "fort", "watch", "well", "rift", "run", "scape", "weald", "snap", "fall", "igrad", "ridge"};
    private static final String[] WATER = new String[]{"luskan", "targos", "caer-konig", "caer-dineval", "bremen", "brynshander", "hindarsfjall", "bremervoord", "velen", "ulfhednar", "odin", "thor", "loki", "hersir", "alfheim", "berserkir", "ice", "rime", "solitude", "coldsnap", "shatter", "frigid", "solitude", "wintergrasp", "vigrar", "sapphire", "haithabu", "nidaros", "bjorgvin", "dyflin", "vadrejford", "kirkjuvagr", "fjord", "vellir", "burrrg", "berrrg", "shiver", "weald", "bite", "fjord", "thaw", "frost", "blizzard", "berksard", "birka", "roskilde", "reykjavik", "jorvik", "wulfir", "brattahild", "leirvik", "vallenkyr", "fyresdal", "undvik", "skillige", "aard", "yrden", "verglas", "myrkr", "forndom", "vaknan", "ivar", "herja", "domadagr", "skapanir", "munarvagr", "novigrad", "slumber", "wolfir"};
    private static final String[] SUN = new String[]{"llux", "ssol", "igni", "bllaze", "buurn", "szaand", "rajtle", "aarid", "ssun", "smuulder", "sstar", "sspaer", "sznaayke", "fyyre", "qysous", "dhune", "dune", "menso", "dehru", "qiszu", "acnudet", "eksoudos", "kuzutmaty", "medje", "apkhelzum", "bastet", "amon", "nefaru", "retzu", "djoser", "khufu", "ikhnaton", "vizier", "dehno", "farsathis", "ahkn", "ashruzum", "gessyty", "clyssena", "sakrubenu", "shekha", "kizutjer", "besuthis", "hatshepsut", "thutmose", "amenhotep", "nefertiti", "neknenutjer", "kerbezum", "nekhsaihdet", "sakdjuta", "hebsousut", "kusdjeris", "bbehdfu", "akso", "medtutaten", "akhenaten", "tutankhamun", "naphurureya", "djedsa", "shetneisma", "acdjuhdet", "mmddjumunein", "kutepis", "shasous", "cusdjuyut", "sshasasiris", "nabefu", "ramses", "xerxes", "cleopatra", "amenophis", "qisbusir", "behretaten", "sett", "ra", "osiris", "thoth", "ptah", "hathor", "anubis"};
    private static final String[] START_MOON = new String[]{"rot", "wailing", "fallen", "soul", "ash", "salt", "blight", "swamp", "peat", "peats", "corpse", "rot", "weap", "stilt", "pitch", "copse", "shamble", "ink", "soot", "wilt", "dark", "bog", "mud", "musk", "shadow", "ahsen", "bitter", "blight", "fog", "weeping", "black", "gilt", "black", "scar", "night", "luster", "ink", "mirk", "murk", "moor", "mourn", "quag", "barren", "ghast", "bleak", "dead", "sump", "marsh", "sump", "glade", "slough", "musk", "gloom", "moon", "dusk", "shade", "willow", "luster", "lily", "ghost", "death"};
    private static final String[] END_MOON = new String[]{"gunk", "cove", "mist", "deep", "smog", "marsh", "burg", "fen", "fens", "basin", "borg", "cove", "quag", "basin", "pond", "keg", "well", "dam", "morg", "warg", "wail", "muck", "clog"};
    private static final String[] MOON = new String[]{"barren", "decay", "silt", "scythe", "end", "quiteus", "gloom", "hadean", "soot", "ruin", "woe", "weap", "ink", "ash", "stygian", "lament", "luster", "abyss", "wetland", "fens", "fen", "ash", "willows", "scar", "sorrow", "ghostmarsh", "wilt", "shade", "blight", "hallow", "shamble", "will-o", "ghast", "dread", "lanquish", "phlegm", "hollow", "dusk", "shade", "bittermarsh", "ghast"};

    public static String random(Random rand, CivilizationType civ) {
        StringBuilder buf = new StringBuilder();
        if (civ == null) {
            buf.append(ProvinceNames.choose(rand, START_X));
            buf.append(ProvinceNames.choose(rand, END_X));
        } else {
            switch (civ) {
                case EARTH: {
                    if (rand.nextInt(4) == 0) {
                        if (rand.nextBoolean()) {
                            buf.append(ProvinceNames.choose(rand, START_EARTH));
                        } else {
                            buf.append(ProvinceNames.choose(rand, START_X));
                        }
                        if (rand.nextBoolean()) {
                            buf.append(ProvinceNames.choose(rand, END_EARTH));
                            break;
                        }
                        buf.append(ProvinceNames.choose(rand, END_X));
                        break;
                    }
                    buf.append(ProvinceNames.choose(rand, EARTH));
                    break;
                }
                case WIND: {
                    if (rand.nextInt(16) == 0) {
                        buf.append(ProvinceNames.choose(rand, WIND));
                        break;
                    }
                    if (rand.nextBoolean()) {
                        buf.append(ProvinceNames.choose(rand, START_WIND));
                    } else {
                        buf.append(ProvinceNames.choose(rand, START_X));
                    }
                    if (rand.nextBoolean()) {
                        buf.append(ProvinceNames.choose(rand, END_WIND));
                        break;
                    }
                    buf.append(ProvinceNames.choose(rand, END_X));
                    break;
                }
                case FIRE: {
                    if (rand.nextInt(4) == 0) {
                        buf.append(ProvinceNames.choose(rand, START_FIRE));
                        if (rand.nextBoolean()) {
                            buf.append(ProvinceNames.choose(rand, END_FIRE));
                            break;
                        }
                        buf.append(ProvinceNames.choose(rand, END_X));
                        break;
                    }
                    buf.append(ProvinceNames.choose(rand, FIRE));
                    break;
                }
                case WATER: {
                    if (rand.nextInt(6) == 0) {
                        buf.append(ProvinceNames.choose(rand, WATER));
                        break;
                    }
                    if (rand.nextInt(3) == 0) {
                        buf.append(ProvinceNames.choose(rand, START_X));
                    } else {
                        buf.append(ProvinceNames.choose(rand, START_WATER));
                    }
                    if (rand.nextInt(6) == 0) {
                        buf.append(ProvinceNames.choose(rand, END_WATER));
                        break;
                    }
                    buf.append(ProvinceNames.choose(rand, END_X));
                    break;
                }
                case SUN: {
                    buf.append(ProvinceNames.choose(rand, SUN));
                    break;
                }
                case MOON: {
                    if (rand.nextBoolean()) {
                        if (rand.nextBoolean()) {
                            buf.append(ProvinceNames.choose(rand, START_MOON));
                        } else {
                            buf.append(ProvinceNames.choose(rand, START_X));
                        }
                        if (rand.nextInt(3) == 0) {
                            buf.append(ProvinceNames.choose(rand, END_MOON));
                            break;
                        }
                        buf.append(ProvinceNames.choose(rand, END_X));
                        break;
                    }
                    buf.append(ProvinceNames.choose(rand, MOON));
                    break;
                }
                default: {
                    buf.append(ProvinceNames.choose(rand, START_X));
                    buf.append(ProvinceNames.choose(rand, END_X));
                }
            }
        }
        String name = buf.toString();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String choose(Random rand, String[] parts) {
        return parts[rand.nextInt(parts.length)];
    }
}

