/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.BiomeDictionary;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ProvinceNames;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public class CivilizationsWorldSaveData
extends WorldSavedData
implements CivilizationDataAccessor {
    private static final String DATA_NAME = "toroquest_civilizations";
    public static final int RADIUS = 6;
    public World world;
    private List<Province> provinces = new ArrayList<Province>();

    public CivilizationsWorldSaveData() {
        super(DATA_NAME);
    }

    public CivilizationsWorldSaveData(String name) {
        super(name);
    }

    @Override
    public synchronized Province register(int chunkX, int chunkZ, boolean worldGenerated) {
        Province province = this.atLocation(chunkX, chunkZ);
        if (province != null) {
            this.updateExistingProvince(province, chunkX, chunkZ);
        } else {
            province = this.buildNewProvince(chunkX, chunkZ, worldGenerated);
        }
        this.func_76185_a();
        return province;
    }

    protected Province buildNewProvince(int chunkX, int chunkZ, boolean worldGenerated) {
        int i;
        int i2;
        if (this.world.field_72995_K) {
            return null;
        }
        BlockPos block = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        if (worldGenerated && ToroQuestConfiguration.unregisterDestroyedVillages && (i2 = ToroQuestConfiguration.destroyedVillagesNearSpawnDistance) > 0 && Math.abs(block.func_177958_n()) < i2 && Math.abs(block.func_177952_p()) < i2) {
            return null;
        }
        Province province = new Province();
        if (ToroQuestConfiguration.useBiomeSpecificProvinces) {
            Biome biome = this.world.func_180494_b(block);
            Set biomeType = BiomeDictionary.getTypes((Biome)biome);
            province.civilization = biomeType.contains(BiomeDictionary.Type.SNOWY) || biome.func_150559_j() ? CivilizationType.WATER : (biomeType.contains(BiomeDictionary.Type.JUNGLE) ? (biomeType.contains(BiomeDictionary.Type.DENSE) ? CivilizationType.EARTH : CivilizationType.SUN) : (biomeType.contains(BiomeDictionary.Type.MOUNTAIN) ? CivilizationType.WIND : (biomeType.contains(BiomeDictionary.Type.SWAMP) || biome.field_76760_I.field_76833_y > 0 || biomeType.contains(BiomeDictionary.Type.MUSHROOM) || biome.field_76760_I.field_76807_J > 0 || biomeType.contains(BiomeDictionary.Type.DEAD) || biomeType.contains(BiomeDictionary.Type.WASTELAND) || biomeType.contains(BiomeDictionary.Type.SPOOKY) || biomeType.contains(BiomeDictionary.Type.WET) && biomeType.contains(BiomeDictionary.Type.LUSH) ? CivilizationType.MOON : ((biomeType.contains(BiomeDictionary.Type.MESA) || biomeType.contains(BiomeDictionary.Type.PLAINS) || biomeType.contains(BiomeDictionary.Type.BEACH) || biomeType.contains(BiomeDictionary.Type.SANDY) || biomeType.contains(BiomeDictionary.Type.SAVANNA)) && biomeType.contains(BiomeDictionary.Type.HOT) ? CivilizationType.SUN : (biomeType.contains(BiomeDictionary.Type.FOREST) || biomeType.contains(BiomeDictionary.Type.DENSE) ? CivilizationType.EARTH : (biomeType.contains(BiomeDictionary.Type.HOT) || biomeType.contains(BiomeDictionary.Type.MESA) ? CivilizationType.SUN : (biome.func_185353_n() < 0.4f && (biomeType.contains(BiomeDictionary.Type.BEACH) || biomeType.contains(BiomeDictionary.Type.OCEAN) || biomeType.contains(BiomeDictionary.Type.RIVER) || biomeType.contains(BiomeDictionary.Type.WATER)) ? CivilizationType.WATER : (biomeType.contains(BiomeDictionary.Type.HILLS) ? CivilizationType.WIND : (biomeType.contains(BiomeDictionary.Type.PLAINS) ? CivilizationType.FIRE : (biome.func_185353_n() > 0.7f ? CivilizationType.SUN : (biome.func_185353_n() < 0.4f ? CivilizationType.WATER : CivilizationType.MOON)))))))))));
        }
        if (province.civilization == null) {
            province.civilization = this.randomCivilizationType();
        }
        UUID id = UUID.randomUUID();
        List<Province> provinces = CivilizationsWorldSaveData.get(this.world).getProvinces();
        boolean repeat = false;
        for (i = 0; i < 10; ++i) {
            for (Province p : this.provinces) {
                if (!p.getUUID().equals(id)) continue;
                id = UUID.randomUUID();
                repeat = true;
                break;
            }
            if (!repeat) break;
        }
        String name = ProvinceNames.random(this.world.field_73012_v, province.civilization);
        repeat = false;
        for (i = 0; i < 10; ++i) {
            for (Province p : this.provinces) {
                if (!p.getName().equals(name)) continue;
                name = ProvinceNames.random(this.world.field_73012_v, province.getCiv());
                repeat = true;
                break;
            }
            if (!repeat) break;
        }
        province.setName(name);
        province.id = id;
        province.chunkX = chunkX;
        province.chunkZ = chunkZ;
        province.lowerVillageBoundX = chunkX - 3;
        province.upperVillageBoundX = chunkX + 3;
        province.lowerVillageBoundZ = chunkZ - 3;
        province.upperVillageBoundZ = chunkZ + 3;
        province.computeSize();
        this.addProvinceToSaveData(province);
        return province;
    }

    @Override
    public Province atLocation(final int chunkX, final int chunkZ) {
        Iterator<Province> iterator;
        Collection<Province> provinces = this.scan(chunkX, chunkZ);
        if (provinces == null || provinces.isEmpty()) {
            return null;
        }
        if (provinces.size() == 1 && (iterator = provinces.iterator()).hasNext()) {
            Province border = iterator.next();
            return border;
        }
        ArrayList<Province> list = new ArrayList<Province>(provinces);
        Collections.sort(list, new Comparator<Province>(){

            @Override
            public int compare(Province a, Province b) {
                double d1;
                double d0 = CivilizationsWorldSaveData.this.chunkDistanceSq(chunkX, chunkZ, a.chunkX, a.chunkZ);
                return d0 < (d1 = (double)CivilizationsWorldSaveData.this.chunkDistanceSq(chunkX, chunkZ, b.chunkX, b.chunkZ)) ? -1 : (d0 > d1 ? 1 : 0);
            }
        });
        return (Province)list.get(0);
    }

    public int chunkDistanceSq(int aX, int aZ, int bX, int bZ) {
        int x = aX - bX;
        int z = aZ - bZ;
        return x * x + z * z;
    }

    private Collection<Province> scan(int chunkX, int chunkZ) {
        return this.sequentialScan(chunkX, chunkZ);
    }

    private Collection<Province> sequentialScan(int chunkX, int chunkZ) {
        int lowerX = chunkX - 6;
        int upperX = chunkX + 6;
        int lowerZ = chunkZ - 6;
        int upperZ = chunkZ + 6;
        ArrayList<Province> subset = new ArrayList<Province>();
        for (Province p : this.provinces) {
            if (p.chunkX < lowerX || p.chunkX > upperX || p.chunkZ < lowerZ || p.chunkZ > upperZ) continue;
            subset.add(p);
        }
        return subset;
    }

    @Override
    public void setProvinceHasLord(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.hasLord = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean provinceHasLord(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.hasLord;
        }
        return false;
    }

    @Override
    public void setTrophyPig(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.zombiepigTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophyPig(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.zombiepigTrophy;
        }
        return false;
    }

    @Override
    public void setTrophyMage(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.mageTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophyMage(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.mageTrophy;
        }
        return false;
    }

    @Override
    public void setTrophyBandit(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.banditTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophyBandit(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.banditTrophy;
        }
        return false;
    }

    @Override
    public void setTrophySpider(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.spiderTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophySpider(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.spiderTrophy;
        }
        return false;
    }

    @Override
    public void setTrophySkeleton(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.skeletonTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophySkeleton(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.skeletonTrophy;
        }
        return false;
    }

    @Override
    public void setTrophyTitan(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.titanTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophyTitan(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.titanTrophy;
        }
        return false;
    }

    @Override
    public void setTrophyBeholder(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.beholderTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophyBeholder(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.beholderTrophy;
        }
        return false;
    }

    @Override
    public void setTrophyLord(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.lordTrophy = hasLord;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean hasTrophyLord(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.lordTrophy;
        }
        return false;
    }

    protected CivilizationType randomCivilizationType() {
        return CivilizationType.values()[this.world.field_73012_v.nextInt(CivilizationType.values().length)];
    }

    private synchronized void updateExistingProvince(Province province, int chunkX, int chunkZ) {
        province.addToBoundsAndRecenter(chunkX, chunkZ);
    }

    private synchronized void addProvinceToSaveData(Province province) {
        this.provinces.add(province);
    }

    public void func_76184_a(NBTTagCompound t) {
        NBTTagList list;
        try {
            list = (NBTTagList)t.func_74781_a("provinces");
        }
        catch (Exception e) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Province province = new Province();
            province.readNBT(list.func_150305_b(i));
            if (province.id == null) {
                province.id = UUID.randomUUID();
                System.out.println("----- adding missing province ID");
                this.func_76185_a();
            }
            if (province.name == null || province.name.trim().length() == 0) {
                province.name = ProvinceNames.random(this.world.field_73012_v, province.civilization);
                System.out.println("----- adding missing province name");
                this.func_76185_a();
            }
            this.addProvinceToSaveData(province);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound t) {
        NBTTagList list = new NBTTagList();
        for (Province p : this.provinces) {
            list.func_74742_a((NBTBase)p.writeNBT());
        }
        t.func_74782_a("provinces", (NBTBase)list);
        return t;
    }

    public static CivilizationDataAccessor get(World world) {
        MapStorage storage = world.func_175693_T();
        CivilizationsWorldSaveData instance = (CivilizationsWorldSaveData)storage.func_75742_a(CivilizationsWorldSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new CivilizationsWorldSaveData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        instance.world = world;
        return instance;
    }

    @Override
    public List<Province> getProvinces() {
        ArrayList<Province> copy = new ArrayList<Province>();
        copy.addAll(this.provinces);
        return copy;
    }

    @Override
    public void setName(UUID provinceId, String name) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.name = name;
            p.writeNBT();
            this.func_76185_a();
            return;
        }
    }
}

