/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public enum CivilizationType {
    EARTH,
    WIND,
    FIRE,
    WATER,
    MOON,
    SUN,
    RAIDED;


    public String getUnlocalizedName() {
        return "civilization." + this.toString().toLowerCase() + ".name";
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getDisplayName(EntityPlayer player) {
        return TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)this.getUnlocalizedName(), (Object[])new Object[0]).func_150254_d();
    }

    public static String tradeName(CivilizationType s) {
        switch (s) {
            case FIRE: {
                return "RED";
            }
            case EARTH: {
                return "GREEN";
            }
            case WIND: {
                return "BROWN";
            }
            case WATER: {
                return "BLUE";
            }
            case SUN: {
                return "YELLOW";
            }
            case MOON: {
                return "BLACK";
            }
        }
        return "";
    }

    public static String configHouseName(CivilizationType civ) {
        switch (civ) {
            case EARTH: {
                return ToroQuestConfiguration.greenName;
            }
            case WIND: {
                return ToroQuestConfiguration.brownName;
            }
            case FIRE: {
                return ToroQuestConfiguration.redName;
            }
            case WATER: {
                return ToroQuestConfiguration.blueName;
            }
            case SUN: {
                return ToroQuestConfiguration.yellowName;
            }
            case MOON: {
                return ToroQuestConfiguration.blackName;
            }
        }
        return "";
    }

    public String getFriendlyEnteringMessage(Province province) {
        return I18n.func_135052_a((String)"civilization.entering.friendly", (Object[])new Object[]{province.getName(), this.getLocalizedName()});
    }

    public String getNeutralEnteringMessage(Province province) {
        return I18n.func_135052_a((String)"civilization.entering.neutral", (Object[])new Object[]{province.getName(), this.getLocalizedName()});
    }

    public String getHostileEnteringMessage(Province province) {
        return I18n.func_135052_a((String)"civilization.entering.hostile", (Object[])new Object[]{province.getName(), this.getLocalizedName()});
    }

    public String getFriendlyLeavingMessage(Province province) {
        return I18n.func_135052_a((String)"civilization.leaving.friendly", (Object[])new Object[]{province.getName(), this.getLocalizedName()});
    }

    public String getNeutralLeavingMessage(Province province) {
        return I18n.func_135052_a((String)"civilization.leaving.neutral", (Object[])new Object[]{province.getName(), this.getLocalizedName()});
    }

    public String getHostileLeavingMessage(Province province) {
        return I18n.func_135052_a((String)"civilization.leaving.hostile", (Object[])new Object[]{province.getName(), this.getLocalizedName()});
    }
}

