/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ReputationLevel;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.configuration.ConfigurationHandler;
import net.torocraft.toroquest.util.Hud;
import net.torocraft.toroquest.util.ToroGuiUtils;

public class CivilizationOverlayHandler
extends Hud {
    String displayPosition = ConfigurationHandler.repDisplayPosition;
    public final int PADDING_FROM_EDGE_X = -8;
    public final int PADDING_FROM_EDGE_Y = -8;
    int screenWidth;
    int screenHeight;
    public static float PI = (float)Math.PI;
    public float titleTimer = PI;

    public CivilizationOverlayHandler(Minecraft mc) {
        super(mc, -32, -41);
    }

    @Override
    public void render(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player.field_71093_bK != 0) {
            this.titleTimer = PI;
            return;
        }
        Province civ = PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getInCivilization();
        if (civ == null || civ.civilization == null) {
            this.titleTimer = PI;
            return;
        }
        this.displayPosition = ConfigurationHandler.repDisplayPosition;
        if ("OFF".equals(this.displayPosition)) {
            this.titleTimer = PI;
            return;
        }
        this.drawCurrentCivilizationIcon(civ, player);
    }

    private void drawCurrentCivilizationIcon(Province civ, EntityPlayerSP player) {
        this.drawReputationText(civ, player);
        this.drawCivilizationBadge(civ.civilization);
        this.drawTitleText(civ, player);
    }

    private void drawReputationText(Province civ, EntityPlayerSP player) {
        int textX = this.determineTextX();
        int textY = this.determineIconY();
        ReputationLevel rep = PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputationLevel(civ.civilization);
        int color = 0xFFFFFF;
        switch (rep) {
            case EXILED: {
                color = 0x550000;
                break;
            }
            case HATED: {
                color = 0xAA0000;
                break;
            }
            case HOSTILE: {
                color = 0xFF5555;
                break;
            }
            case UNFRIENDLY: {
                color = 0xFF5555;
                break;
            }
            case NEUTRAL: {
                color = 0xFFFF55;
                break;
            }
            case FRIENDLY: {
                color = 0x55FF55;
                break;
            }
            case HONORED: {
                color = 0x55FF55;
                break;
            }
            case RENOWNED: {
                color = 5303904;
                break;
            }
            case EXALTED: {
                color = 43520;
                break;
            }
            case CHAMPION: {
                color = 0xFF55FF;
                break;
            }
            case HERO: {
                color = 0x55FFFF;
                break;
            }
            case LEGEND: {
                color = 0xFFAA00;
            }
        }
        if (this.displayPosition.contains("RIGHT")) {
            this.drawRightString("\u00a7lHouse " + civ.civilization.getLocalizedName(), textX -= 10, textY, 0xFFFFFF);
            this.drawRightString(civ.name, textX, textY += 10, 0xFFFFFF);
            this.drawRightString(rep.getLocalname(), textX, textY += 10, color);
            this.drawRightString("Reputation: " + Integer.toString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputation(civ.civilization), 10), textX, textY += 10, 0xFFFFFF);
        } else {
            if (this.displayPosition.contains("TOP")) {
                textX += 10;
            }
            this.drawString("\u00a7lHouse " + civ.civilization.getLocalizedName(), textX += 12, textY, 0xFFFFFF);
            this.drawString(civ.name, textX, textY += 10, 0xFFFFFF);
            this.drawString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputationLevel(civ.civilization).getLocalname(), textX, textY += 10, color);
            this.drawString("Reputation: " + Integer.toString(PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).getReputation(civ.civilization), 10), textX, textY += 10, 0xFFFFFF);
        }
    }

    private void drawTitleText(Province civ, EntityPlayerSP entityPlayer) {
        int titleX = (this.screenWidth - 256) / 2;
        if (this.titleTimer > 0.1f) {
            float alpha = MathHelper.func_76131_a((float)(MathHelper.func_76126_a((float)this.titleTimer) * 1.25f), (float)0.02f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.fontRenderer.func_175065_a(civ.getName(), (float)this.screenWidth / 4.0f - (float)this.fontRenderer.func_78256_a(civ.getName()) / 2.0f, 4.0f, CivilizationOverlayHandler.toHex(1.0f, 1.0f, 1.0f, alpha), true);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            ToroGuiUtils.drawOverlayTitle(this.mc, titleX, 8, 256, 0, 256, 256);
            GlStateManager.func_179121_F();
            this.titleTimer -= 0.0075f;
        }
    }

    public static int toHex(float r, float g, float b, float a) {
        return ((int)(a * 255.0f) & 0xFF) << 24 | ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public static float[] getRGBA(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    private void drawCivilizationBadge(CivilizationType civType) {
        int badgeX = this.determineBadgeX();
        int badgeY = this.determineIconY();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        ToroGuiUtils.drawOverlayIcon(this.mc, badgeX, badgeY, this.iconIndex(civType) * 32, 0, 32, 41);
        GlStateManager.func_179121_F();
    }

    private int determineTextX() {
        int x = 24;
        if (this.displayPosition.contains("RIGHT")) {
            x = this.screenWidth - -8 - 32;
        } else if (this.displayPosition.contains("TOP")) {
            x -= 10;
        }
        if (this.displayPosition.contains("CENTER")) {
            x = (this.screenWidth + 32 + -8) / 2;
        }
        return x + ConfigurationHandler.repDisplayX;
    }

    private int determineBadgeX() {
        int x = -8;
        x = this.displayPosition.contains("RIGHT") ? this.screenWidth - 32 : (x += 10);
        if (this.displayPosition.contains("CENTER")) {
            x = (this.screenWidth - 32) / 2;
        }
        return x + ConfigurationHandler.repDisplayX;
    }

    private int determineIconY() {
        int y = -8;
        y = this.displayPosition.contains("BOTTOM") ? this.screenHeight - 41 : (y += 10);
        return y + ConfigurationHandler.repDisplayY;
    }

    private int iconIndex(CivilizationType civ) {
        switch (civ) {
            case FIRE: {
                return 1;
            }
            case EARTH: {
                return 3;
            }
            case MOON: {
                return 2;
            }
            case SUN: {
                return 4;
            }
            case WIND: {
                return 5;
            }
            case WATER: {
                return 0;
            }
        }
        return 6;
    }
}

