/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.generation.village.util.VillagePieceBlockMap;

public class CivilizationGeneratorHandlers {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void aregisterNewCiviliationBorder(PopulateChunkEvent.Pre event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getWorld().field_73011_w != null && event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        if (!event.isHasVillageGenerated()) {
            return;
        }
        CivilizationUtil.registerNewCivilization(event.getWorld(), event.getChunkX(), event.getChunkZ());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void zregisterNewCiviliationBorderPost(PopulateChunkEvent.Post event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getWorld().field_73011_w != null && event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        if (!event.isHasVillageGenerated()) {
            return;
        }
        CivilizationUtil.registerNewCivilization(event.getWorld(), event.getChunkX(), event.getChunkZ());
        int x = event.getChunkX() * 16;
        int y = EventHandlers.MIN_SPAWN_HEIGHT;
        int z = event.getChunkZ() * 16;
        boolean destroyedVillage = ToroQuestConfiguration.destroyedVillagesNearSpawnDistance > 0 && Math.abs(x) < ToroQuestConfiguration.destroyedVillagesNearSpawnDistance && Math.abs(z) < ToroQuestConfiguration.destroyedVillagesNearSpawnDistance;
        boolean hasVillagerChunk = false;
        if (destroyedVillage) {
            List villagers = event.getWorld().func_72872_a(EntityVillager.class, new AxisAlignedBB((double)(x - 16), (double)y, (double)(z - 16), (double)(x + 16), (double)EventHandlers.MAX_SPAWN_HEIGHT, (double)(z + 16)));
            for (EntityVillager villager : villagers) {
                villager.func_70606_j(0.0f);
                villager.func_70106_y();
                hasVillagerChunk = true;
            }
        }
        for (int xx = 0; xx <= 16; ++xx) {
            for (int zz = 0; zz <= 16; ++zz) {
                block45: for (int yy = EventHandlers.MAX_SPAWN_HEIGHT; yy >= y; --yy) {
                    int maxDestroyedBlocks = 2;
                    BlockPos pos = new BlockPos((Vec3i)new BlockPos(x + xx, yy, z + zz));
                    Block b = event.getWorld().func_180495_p(pos).func_177230_c();
                    if (destroyedVillage) {
                        if (b instanceof BlockAir) continue;
                        if (b instanceof BlockGrass || b instanceof BlockSand || b instanceof BlockStone) {
                            if (!hasVillagerChunk || event.getRand().nextInt(80) != 0) continue;
                            if (event.getRand().nextInt(6) == 0) {
                                VillagePieceBlockMap.setBanditBanner(event.getWorld(), pos.func_177984_a());
                                continue;
                            }
                            if (!(event.getWorld().func_180495_p(pos.func_177982_a(1, 1, 0)).func_177230_c() instanceof BlockAir) || !(event.getWorld().func_180495_p(pos.func_177982_a(0, 1, 1)).func_177230_c() instanceof BlockAir) || !(event.getWorld().func_180495_p(pos.func_177982_a(-1, 1, 0)).func_177230_c() instanceof BlockAir) || !(event.getWorld().func_180495_p(pos.func_177982_a(0, 1, -1)).func_177230_c() instanceof BlockAir)) continue;
                            Rotation rotation = Rotation.NONE;
                            switch (event.getRand().nextInt(4)) {
                                case 0: {
                                    rotation = Rotation.NONE;
                                    break;
                                }
                                case 1: {
                                    rotation = Rotation.CLOCKWISE_90;
                                    break;
                                }
                                case 2: {
                                    rotation = Rotation.COUNTERCLOCKWISE_90;
                                    break;
                                }
                                case 3: {
                                    rotation = Rotation.CLOCKWISE_180;
                                }
                            }
                            event.getWorld().func_175656_a(pos.func_177981_b(2), Blocks.field_150465_bP.func_176223_P().func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)EnumFacing.UP).func_185907_a(rotation));
                            if (ToroQuestConfiguration.useIronBarsForHeadSpike) {
                                event.getWorld().func_175656_a(pos.func_177981_b(1), Blocks.field_150411_aY.func_176223_P());
                            } else {
                                event.getWorld().func_175656_a(pos.func_177981_b(1), Blocks.field_180407_aO.func_176223_P());
                            }
                            event.getWorld().func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                            continue;
                        }
                        if (b instanceof BlockChest) {
                            TileEntity tileentity = event.getWorld().func_175625_s(pos);
                            if (!(tileentity instanceof TileEntityChest)) continue;
                            ((TileEntityChest)tileentity).func_174888_l();
                            continue;
                        }
                        if (b.func_176223_P() == Blocks.field_150325_L.func_176223_P()) {
                            if (event.getWorld().func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockFence && (event.getWorld().func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c().func_176223_P() == Blocks.field_150478_aa.func_176223_P() || event.getWorld().func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c().func_176223_P() == Blocks.field_150478_aa.func_176223_P() || event.getWorld().func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c().func_176223_P() == Blocks.field_150478_aa.func_176223_P() || event.getWorld().func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c().func_176223_P() == Blocks.field_150478_aa.func_176223_P())) {
                                event.getWorld().func_175656_a(pos.func_177982_a(1, 0, 0), Blocks.field_150350_a.func_176223_P());
                                event.getWorld().func_175656_a(pos.func_177982_a(0, 0, 1), Blocks.field_150350_a.func_176223_P());
                                event.getWorld().func_175656_a(pos.func_177982_a(-1, 0, 0), Blocks.field_150350_a.func_176223_P());
                                event.getWorld().func_175656_a(pos.func_177982_a(0, 0, -1), Blocks.field_150350_a.func_176223_P());
                                event.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                                this.placeLantern(event.getWorld(), pos);
                                for (int i = 1; i <= 6; ++i) {
                                    if (event.getWorld().func_180495_p(pos.func_177982_a(0, -i, 0)).func_177230_c() instanceof BlockFence) {
                                        continue;
                                    }
                                    if (i <= 1) continue block45;
                                    event.getWorld().func_175656_a(pos.func_177982_a(0, -(--i), 0), Blocks.field_150463_bK.func_176223_P());
                                    continue block45;
                                }
                                continue;
                            }
                            event.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (b instanceof BlockBed || b instanceof BlockDoor || b instanceof BlockFurnace || b instanceof BlockAnvil || b instanceof BlockBrewingStand) {
                            event.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (b instanceof BlockPane) {
                            if (!event.getWorld().field_73012_v.nextBoolean()) continue;
                            event.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (maxDestroyedBlocks <= 0 || event.getWorld().field_73012_v.nextInt(8) != 0) continue;
                        if (b instanceof BlockGrassPath) {
                            event.getWorld().func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                            continue;
                        }
                        if (b.func_176223_P().func_185904_a() == Material.field_151578_c || b.func_176223_P().func_185904_a() == Material.field_151576_e || b.func_176223_P().func_185904_a() == Material.field_151595_p) {
                            maxDestroyedBlocks = (short)(maxDestroyedBlocks - 1);
                            continue;
                        }
                        event.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        maxDestroyedBlocks = (short)(maxDestroyedBlocks - 1);
                        continue;
                    }
                    if (b instanceof BlockChest && ToroQuestConfiguration.replaceVillageChestsWithTrappedChests) {
                        try {
                            BlockChest chest = (BlockChest)b;
                            if (chest.field_149956_a == BlockChest.Type.TRAP) continue;
                            TileEntity tile = event.getWorld().func_175625_s(pos);
                            ResourceLocation lootTable = null;
                            ArrayList<ItemStack> lootItems = new ArrayList<ItemStack>();
                            if (tile instanceof TileEntityChest) {
                                lootTable = ((TileEntityChest)tile).func_184276_b();
                                if (lootTable == null) {
                                    try {
                                        for (int i = 0; i < ((TileEntityChest)tile).func_70302_i_(); ++i) {
                                            ItemStack itemstack = ((TileEntityChest)tile).func_70304_b(i);
                                            if (itemstack == null) continue;
                                            lootItems.add(itemstack);
                                        }
                                    }
                                    catch (Exception i) {
                                        // empty catch block
                                    }
                                }
                                ((TileEntityChest)tile).func_174888_l();
                            }
                            IBlockState ib = event.getWorld().func_180495_p(pos);
                            PropertyDirection FACING = BlockHorizontal.field_185512_D;
                            EnumFacing enumfacing = (EnumFacing)ib.func_177229_b((IProperty)FACING);
                            event.getWorld().func_175656_a(pos, Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)enumfacing));
                            tile = event.getWorld().func_175625_s(pos);
                            if (!(tile instanceof TileEntityChest)) continue;
                            if (lootTable != null) {
                                ((TileEntityChest)tile).func_189404_a(lootTable, new Random().nextLong());
                                continue;
                            }
                            if (lootItems == null || lootItems.isEmpty()) continue;
                            try {
                                int i = 0;
                                for (ItemStack itemstack : lootItems) {
                                    ((TileEntityChest)tile).func_70299_a(i, itemstack);
                                    ++i;
                                }
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception chest) {}
                        continue;
                    }
                    if (b instanceof BlockFlowerPot) {
                        try {
                            CivilizationType civ = CivilizationUtil.getProvinceAt((World)event.getWorld(), (int)(x / 16), (int)(z / 16)).civilization;
                            TileEntityFlowerPot tileentityflowerpot = this.getFlowerPot(event.getWorld(), pos);
                            if (civ == null || tileentityflowerpot == null) continue;
                            switch (civ) {
                                case FIRE: {
                                    Item item = Item.func_150898_a((Block)Blocks.field_150328_O);
                                    ItemStack istack = new ItemStack(item);
                                    tileentityflowerpot.func_190614_a(istack);
                                    break;
                                }
                                case EARTH: {
                                    Item item = Item.func_150898_a((Block)Blocks.field_150329_H);
                                    ItemStack istack = new ItemStack(item);
                                    istack.func_77964_b(2);
                                    tileentityflowerpot.func_190614_a(istack);
                                    break;
                                }
                                case WATER: {
                                    Item item = Item.func_150898_a((Block)Blocks.field_150328_O);
                                    ItemStack istack = new ItemStack(item);
                                    istack.func_77964_b(1);
                                    tileentityflowerpot.func_190614_a(istack);
                                    break;
                                }
                                case MOON: {
                                    Item item = Item.func_150898_a((Block)Blocks.field_150338_P);
                                    ItemStack istack = new ItemStack(item);
                                    tileentityflowerpot.func_190614_a(istack);
                                    break;
                                }
                                case WIND: {
                                    Item item = Item.func_150898_a((Block)Blocks.field_150330_I);
                                    ItemStack istack = new ItemStack(item);
                                    tileentityflowerpot.func_190614_a(istack);
                                    break;
                                }
                                case SUN: {
                                    Item item = Item.func_150898_a((Block)Blocks.field_150434_aF);
                                    ItemStack istack = new ItemStack(item);
                                    tileentityflowerpot.func_190614_a(istack);
                                    break;
                                }
                            }
                            event.getWorld().func_184138_a(pos, b.func_176223_P(), b.func_176223_P(), 3);
                        }
                        catch (Exception civ) {}
                        continue;
                    }
                    if (b instanceof BlockBed) {
                        try {
                            CivilizationType civ = CivilizationUtil.getProvinceAt((World)event.getWorld(), (int)(x / 16), (int)(z / 16)).civilization;
                            TileEntityBed bed = this.getBed(event.getWorld(), pos);
                            if (civ == null || bed == null) continue;
                            switch (civ) {
                                case FIRE: {
                                    bed.func_193052_a(EnumDyeColor.RED);
                                    break;
                                }
                                case EARTH: {
                                    bed.func_193052_a(EnumDyeColor.GREEN);
                                    break;
                                }
                                case WATER: {
                                    bed.func_193052_a(EnumDyeColor.CYAN);
                                    break;
                                }
                                case MOON: {
                                    bed.func_193052_a(EnumDyeColor.BLACK);
                                    break;
                                }
                                case WIND: {
                                    bed.func_193052_a(EnumDyeColor.BROWN);
                                    break;
                                }
                                case SUN: {
                                    bed.func_193052_a(EnumDyeColor.YELLOW);
                                }
                            }
                            event.getWorld().func_184138_a(pos, b.func_176223_P(), b.func_176223_P(), 3);
                        }
                        catch (Exception civ) {}
                        continue;
                    }
                    if (b instanceof BlockBanner) {
                        try {
                            CivilizationType civ = CivilizationUtil.getProvinceAt((World)event.getWorld(), (int)(x / 16), (int)(z / 16)).civilization;
                            TileEntityBanner banner = this.getBanner(event.getWorld(), pos);
                            if (civ == null || banner == null) continue;
                            switch (civ) {
                                case FIRE: {
                                    banner.func_175112_a(VillagePieceBlockMap.getRedBanner(), true);
                                    break;
                                }
                                case EARTH: {
                                    banner.func_175112_a(VillagePieceBlockMap.getGreenBanner(), true);
                                    break;
                                }
                                case WATER: {
                                    banner.func_175112_a(VillagePieceBlockMap.getBlueBanner(), true);
                                    break;
                                }
                                case MOON: {
                                    banner.func_175112_a(VillagePieceBlockMap.getBlackBanner(), true);
                                    break;
                                }
                                case WIND: {
                                    banner.func_175112_a(VillagePieceBlockMap.getBrownBanner(), true);
                                    break;
                                }
                                case SUN: {
                                    banner.func_175112_a(VillagePieceBlockMap.getYellowBanner(), true);
                                }
                            }
                            event.getWorld().func_184138_a(pos, b.func_176223_P(), b.func_176223_P(), 3);
                        }
                        catch (Exception civ) {}
                        continue;
                    }
                    if (b.func_176223_P() != Blocks.field_150325_L.func_176223_P() || !(event.getWorld().func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockFence) || event.getWorld().func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c().func_176223_P() != Blocks.field_150478_aa.func_176223_P() && event.getWorld().func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c().func_176223_P() != Blocks.field_150478_aa.func_176223_P() && event.getWorld().func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c().func_176223_P() != Blocks.field_150478_aa.func_176223_P() && event.getWorld().func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c().func_176223_P() != Blocks.field_150478_aa.func_176223_P()) continue;
                    event.getWorld().func_175656_a(pos.func_177982_a(1, 0, 0), Blocks.field_150350_a.func_176223_P());
                    event.getWorld().func_175656_a(pos.func_177982_a(0, 0, 1), Blocks.field_150350_a.func_176223_P());
                    event.getWorld().func_175656_a(pos.func_177982_a(-1, 0, 0), Blocks.field_150350_a.func_176223_P());
                    event.getWorld().func_175656_a(pos.func_177982_a(0, 0, -1), Blocks.field_150350_a.func_176223_P());
                    event.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    this.placeLantern(event.getWorld(), pos);
                    for (int i = 1; i <= 6; ++i) {
                        if (event.getWorld().func_180495_p(pos.func_177982_a(0, -i, 0)).func_177230_c() instanceof BlockFence) {
                            continue;
                        }
                        if (i <= 1) continue block45;
                        event.getWorld().func_175656_a(pos.func_177982_a(0, -(--i), 0), Blocks.field_150463_bK.func_176223_P());
                        continue block45;
                    }
                }
            }
        }
    }

    private IBlockState getLantern() {
        IBlockState LA = Blocks.field_150426_aN.func_176223_P();
        try {
            LA = Block.func_149684_b((String)ToroQuestConfiguration.lanternResourceName).func_176223_P().func_177226_a((IProperty)PropertyDirection.func_177714_a((String)"facing"), (Comparable)EnumFacing.DOWN);
        }
        catch (Exception e0) {
            try {
                LA = Block.func_149684_b((String)ToroQuestConfiguration.lanternResourceName).func_176223_P();
            }
            catch (Exception e1) {
                try {
                    LA = Block.func_149684_b((String)"futuremc:lantern").func_176223_P().func_177226_a((IProperty)PropertyDirection.func_177714_a((String)"facing"), (Comparable)EnumFacing.DOWN);
                }
                catch (Exception e2) {
                    try {
                        LA = Block.func_149684_b((String)"futuremc:lantern").func_176223_P();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return LA;
    }

    private void placeLantern(World world, BlockPos pos) {
        IBlockState gp;
        int i;
        IBlockState fence = world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c().func_176223_P();
        for (i = 0; i < 8; ++i) {
            gp = world.func_180495_p(pos.func_177982_a(1, -i, 0)).func_177230_c().func_176223_P();
            if (gp == Blocks.field_150350_a.func_176223_P()) continue;
            if (gp != Blocks.field_185774_da.func_176223_P()) break;
            world.func_175656_a(pos.func_177982_a(0, 0, 0), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(1, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(2, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(2, 0, 0), this.getLantern());
            return;
        }
        for (i = 0; i < 8; ++i) {
            gp = world.func_180495_p(pos.func_177982_a(0, -i, 1)).func_177230_c().func_176223_P();
            if (gp == Blocks.field_150350_a.func_176223_P()) continue;
            if (gp != Blocks.field_185774_da.func_176223_P()) break;
            world.func_175656_a(pos.func_177982_a(0, 0, 0), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, 1), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, 2), fence);
            world.func_175656_a(pos.func_177982_a(0, 0, 2), this.getLantern());
            return;
        }
        for (i = 0; i < 8; ++i) {
            gp = world.func_180495_p(pos.func_177982_a(-1, -i, 0)).func_177230_c().func_176223_P();
            if (gp == Blocks.field_150350_a.func_176223_P()) continue;
            if (gp != Blocks.field_185774_da.func_176223_P()) break;
            world.func_175656_a(pos.func_177982_a(0, 0, 0), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(-1, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(-2, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(-2, 0, 0), this.getLantern());
            return;
        }
        for (i = 0; i < 8; ++i) {
            gp = world.func_180495_p(pos.func_177982_a(0, -i, -1)).func_177230_c().func_176223_P();
            if (gp == Blocks.field_150350_a.func_176223_P()) continue;
            if (gp != Blocks.field_185774_da.func_176223_P()) break;
            world.func_175656_a(pos.func_177982_a(0, 0, 0), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, 0), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, -1), fence);
            world.func_175656_a(pos.func_177982_a(0, 1, -2), fence);
            world.func_175656_a(pos.func_177982_a(0, 0, -2), this.getLantern());
            return;
        }
        world.func_175656_a(pos.func_177982_a(0, 0, 0), fence);
        world.func_175656_a(pos.func_177982_a(0, 1, 0), fence);
        world.func_175656_a(pos.func_177982_a(1, 1, 0), fence);
        world.func_175656_a(pos.func_177982_a(2, 1, 0), fence);
        world.func_175656_a(pos.func_177982_a(2, 0, 0), this.getLantern());
    }

    private TileEntityBanner getBanner(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityBanner ? (TileEntityBanner)tileentity : null;
    }

    private TileEntityFlowerPot getFlowerPot(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)tileentity : null;
    }

    private TileEntityBed getBed(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityBed ? (TileEntityBed)tileentity : null;
    }
}

