/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.entities.EntityVillageLord;

public class TileEntityToroSpawner
extends TileEntity
implements ITickable {
    protected int triggerDistance = 64;
    protected List<String> entityIds = new ArrayList<String>();
    protected int spawnRadius = 0;
    protected int extra = 0;
    protected List<String> entityTags = new ArrayList<String>();
    protected int ticksExisted = 0;

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    public void setTriggerDistance(int triggerDistance) {
        this.triggerDistance = triggerDistance;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public void setExtra(int c) {
        this.extra = c;
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagList list;
        super.func_145839_a(compound);
        this.triggerDistance = compound.func_74762_e("trigger_distance");
        this.spawnRadius = compound.func_74762_e("spawn_radius");
        this.extra = compound.func_74762_e("extra");
        this.entityIds = new ArrayList<String>();
        this.entityTags = new ArrayList<String>();
        try {
            list = (NBTTagList)compound.func_74781_a("entity_ids");
        }
        catch (Exception e) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.entityIds.add(list.func_150307_f(i));
        }
        try {
            list = (NBTTagList)compound.func_74781_a("entity_tags");
        }
        catch (Exception e) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.entityTags.add(list.func_150307_f(i));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("trigger_distance", this.triggerDistance);
        compound.func_74768_a("spawn_radius", this.spawnRadius);
        NBTTagList list = new NBTTagList();
        for (String id : this.entityIds) {
            list.func_74742_a((NBTBase)new NBTTagString(id));
        }
        compound.func_74782_a("entity_ids", (NBTBase)list);
        list = new NBTTagList();
        if (this.entityTags != null) {
            for (String id : this.entityTags) {
                list.func_74742_a((NBTBase)new NBTTagString(id));
            }
        }
        compound.func_74782_a("entity_tags", (NBTBase)list);
        compound.func_74768_a("extra", this.extra);
        return compound;
    }

    protected void storeItemStack(String key, ItemStack stack, NBTTagCompound compound) {
        if (stack == null) {
            return;
        }
        NBTTagCompound c = new NBTTagCompound();
        stack.func_77955_b(c);
        compound.func_74782_a(key, (NBTBase)c);
    }

    protected ItemStack readItemStack(String key, NBTTagCompound compound) {
        if (!compound.func_74764_b(key)) {
            return null;
        }
        return new ItemStack(compound.func_74775_l(key));
    }

    public void func_73660_a() {
        if (this.triggerDistance < 0) {
            return;
        }
        if ((this.triggerDistance == 0 || this.withinRange()) && this.func_174877_v() != null && this.func_174877_v() != BlockPos.field_177992_a) {
            this.triggerSpawner();
        }
    }

    protected void triggerSpawner() {
        for (String entityId : this.entityIds) {
            this.spawnCreature(entityId);
        }
        this.triggerDistance = -1;
        this.field_145850_b.func_175713_t(this.func_174877_v());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    public void spawnCreature(String entityID) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Entity entity = TileEntityToroSpawner.getEntityForId(this.func_145831_w(), entityID);
        if (!(entity instanceof EntityLivingBase)) {
            System.out.println("entity not EntityLivingBase: " + entityID);
            return;
        }
        this.spawnEntityLiving((EntityLiving)entity, this.findSuitableSpawnLocation());
    }

    public BlockPos findSuitableSpawnLocation() {
        Random rand = this.field_145850_b.field_73012_v;
        if (this.spawnRadius < 1) {
            return this.func_174877_v();
        }
        for (int i = 0; i < 16; ++i) {
            int z;
            int degrees;
            int distance = rand.nextInt(this.spawnRadius);
            int x = distance * (int)Math.round(Math.cos(Math.toRadians(degrees = rand.nextInt(360))));
            BlockPos pos = this.findSurface(x, z = distance * (int)Math.round(Math.sin(Math.toRadians(degrees))));
            if (pos == null) continue;
            return pos;
        }
        return this.func_174877_v();
    }

    public BlockPos findSurface(int x, int z) {
        BlockPos pos = this.func_174877_v().func_177982_a(x, -3, z);
        boolean groundFound = false;
        boolean[] airSpace = new boolean[]{false, false};
        for (int yOffset = 0; yOffset <= 16; ++yOffset) {
            IBlockState blockState = this.field_145850_b.func_180495_p(pos);
            if (this.isGroundBlock(blockState)) {
                groundFound = true;
                airSpace[0] = false;
                airSpace[1] = false;
            } else {
                if (airSpace[0] && airSpace[1] && groundFound) {
                    return pos.func_177977_b();
                }
                if (Blocks.field_150350_a.equals(blockState.func_177230_c())) {
                    if (airSpace[0]) {
                        airSpace[1] = true;
                    } else {
                        airSpace[0] = true;
                    }
                }
            }
            pos = pos.func_177984_a();
        }
        return null;
    }

    protected boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush || blockState.func_177230_c() == Blocks.field_150325_L) {
            return false;
        }
        return blockState.func_185914_p();
    }

    public static Entity getEntityForId(World world, String entityID) {
        String entityName;
        String domain;
        String[] parts = entityID.split(":");
        if (parts.length == 2) {
            domain = parts[0];
            entityName = parts[1];
        } else {
            domain = "minecraft";
            entityName = entityID;
        }
        return EntityList.func_188429_b((ResourceLocation)new ResourceLocation(domain, entityName), (World)world);
    }

    protected boolean spawnEntityLiving(EntityLiving entity, BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        entity.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)entity)), (IEntityLivingData)null);
        entity.func_110163_bv();
        if (this.entityTags != null) {
            for (String tag : this.entityTags) {
                entity.func_184211_a(tag);
            }
        }
        if (this.extra > 0) {
            if (entity instanceof EntityVillageLord) {
                this.field_145850_b.func_72838_d((Entity)entity);
                entity.func_70606_j(0.0f);
            } else if (entity instanceof EntitySheep) {
                EntitySheep sheep = (EntitySheep)entity;
                switch (this.extra) {
                    case 1: {
                        sheep.func_175512_b(EnumDyeColor.RED);
                        break;
                    }
                    case 2: {
                        sheep.func_175512_b(EnumDyeColor.GREEN);
                        break;
                    }
                    case 3: {
                        sheep.func_175512_b(EnumDyeColor.BLUE);
                        break;
                    }
                    case 4: {
                        sheep.func_175512_b(EnumDyeColor.BLACK);
                        break;
                    }
                    case 5: {
                        sheep.func_175512_b(EnumDyeColor.YELLOW);
                        break;
                    }
                    case 6: {
                        sheep.func_175512_b(EnumDyeColor.BROWN);
                        break;
                    }
                    default: {
                        sheep.func_175512_b(EnumDyeColor.WHITE);
                    }
                }
                sheep.func_110163_bv();
                sheep.func_96094_a("\u00a7e\u00a7l!");
                sheep.func_174805_g(true);
                sheep.func_184195_f(true);
                this.field_145850_b.func_72838_d((Entity)sheep);
            } else {
                this.field_145850_b.func_72838_d((Entity)entity);
            }
        } else {
            this.field_145850_b.func_72838_d((Entity)entity);
        }
        return true;
    }

    protected boolean withinRange() {
        return ++this.ticksExisted % 60 == 0 && this.playerNear();
    }

    public boolean playerNear() {
        for (EntityPlayer player : this.field_145850_b.field_73010_i) {
            if (!EntitySelectors.field_180132_d.apply((Object)player) || player.field_71093_bK != 0 || !(player.func_70092_e((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) <= (double)(this.triggerDistance * this.triggerDistance))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean func_183000_F() {
        return true;
    }

    public List<String> getEntityTags() {
        return this.entityTags;
    }

    public void setEntityTags(List<String> entityTags) {
        this.entityTags = entityTags;
    }

    public void addEntityTag(String tag) {
        if (this.entityTags == null) {
            this.entityTags = new ArrayList<String>();
        }
        this.entityTags.add(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 0.0;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public Block func_145838_q() {
        return Blocks.field_150350_a.func_176223_P().func_177230_c();
    }
}

