/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.ToroQuestTriggers;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ReputationLevel;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.QuestBreed;
import net.torocraft.toroquest.civilization.quests.QuestBuild;
import net.torocraft.toroquest.civilization.quests.QuestFarm;
import net.torocraft.toroquest.civilization.quests.QuestMine;
import net.torocraft.toroquest.civilization.quests.QuestRecruit;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityCaravan;
import net.torocraft.toroquest.entities.EntityFugitive;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityMonolithEye;
import net.torocraft.toroquest.entities.EntityOrc;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.EntityShopkeeper;
import net.torocraft.toroquest.entities.EntitySmartArrow;
import net.torocraft.toroquest.entities.EntityToroMob;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.EntityToroVillager;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.entities.EntityWolfRaider;
import net.torocraft.toroquest.entities.EntityZombieRaider;
import net.torocraft.toroquest.entities.EntityZombieVillagerRaider;
import net.torocraft.toroquest.entities.ai.EntityAIRaidDespawn;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessageRequestPlayerCivilizationSync;
import net.torocraft.toroquest.util.TaskRunner;

public class EventHandlers {
    public static Random rand = new Random();
    private int RAIDER_DISTANCE = ToroQuestConfiguration.disableMobSpawningNearVillage + 2 < 76 ? 76 : ToroQuestConfiguration.disableMobSpawningNearVillage + 2;
    private final String INITIAL_SPAWN_TAG = "initialSpawn";
    public static int MAX_SPAWN_HEIGHT = ToroQuestConfiguration.maxSpawnHeight;
    public static int MIN_SPAWN_HEIGHT = ToroQuestConfiguration.minSpawnHeight;
    public static int SPAWN_RANGE = MAX_SPAWN_HEIGHT - MIN_SPAWN_HEIGHT;
    public static final int timeFadeIn = 20;
    public static final int displayTime = 50;
    public static final int timeFadeOut = 20;
    protected int spawningTicks = 0;
    private Map<String, SavedInventory> stack = new HashMap<String, SavedInventory>();

    public static void repLevelMessage(EntityPlayer player, CivilizationType civ, int startRep, int afterRep) {
        ReputationLevel after;
        if (startRep > afterRep) {
            return;
        }
        ReputationLevel before = ReputationLevel.fromReputation(startRep);
        if (before == (after = ReputationLevel.fromReputation(afterRep))) {
            return;
        }
        if (after == ReputationLevel.FRIENDLY) {
            if (player instanceof EntityPlayerMP) {
                ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            }
        } else if (after == ReputationLevel.HONORED) {
            if (player instanceof EntityPlayerMP) {
                ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.HONORED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            }
        } else if (after == ReputationLevel.RENOWNED) {
            if (player instanceof EntityPlayerMP) {
                ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.HONORED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.RENOWNED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            }
        } else if (after == ReputationLevel.EXALTED) {
            if (player instanceof EntityPlayerMP) {
                ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.HONORED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.RENOWNED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.EXALTED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            }
        } else if (after == ReputationLevel.CHAMPION) {
            if (player instanceof EntityPlayerMP) {
                ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.HONORED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.RENOWNED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.EXALTED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.CHAMPION_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            }
        } else if (after == ReputationLevel.HERO) {
            if (player instanceof EntityPlayerMP) {
                ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.HONORED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.RENOWNED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.EXALTED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.CHAMPION_ACHIEVEMNT.trigger((EntityPlayerMP)player);
                ToroQuestTriggers.HERO_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            }
        } else if (after == ReputationLevel.LEGEND && player instanceof EntityPlayerMP) {
            ToroQuestTriggers.FRIENDLY_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            ToroQuestTriggers.HONORED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            ToroQuestTriggers.RENOWNED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            ToroQuestTriggers.EXALTED_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            ToroQuestTriggers.CHAMPION_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            ToroQuestTriggers.HERO_ACHIEVEMNT.trigger((EntityPlayerMP)player);
            ToroQuestTriggers.LEGEND_ACHIEVEMNT.trigger((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onDeath(PlayerEvent.Clone event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerCivilizationCapability newCap = PlayerCivilizationCapabilityImpl.get(event.getEntityPlayer());
        PlayerCivilizationCapability originalCap = PlayerCivilizationCapabilityImpl.get(event.getOriginal());
        if (originalCap == null) {
            return;
        }
        if (newCap == null) {
            throw new NullPointerException("missing player capability during clone");
        }
        newCap.readNBT((NBTBase)originalCap.writeNBT());
    }

    @SubscribeEvent
    public void onSave(PlayerEvent.SaveToFile event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerCivilizationCapability cap = PlayerCivilizationCapabilityImpl.get(event.getEntityPlayer());
        if (cap == null) {
            return;
        }
        NBTTagCompound civData = cap.writeNBT();
        if (civData == null || civData.func_74781_a("reputations") == null || ((NBTTagList)civData.func_74781_a("reputations")).func_74745_c() < 1) {
            return;
        }
        event.getEntityPlayer().getEntityData().func_74782_a("toroquest.playerCivilization", (NBTBase)civData);
    }

    @SubscribeEvent
    public void onLoad(PlayerEvent.LoadFromFile event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerCivilizationCapability cap = PlayerCivilizationCapabilityImpl.get(event.getEntityPlayer());
        if (cap == null) {
            return;
        }
        NBTTagCompound c = event.getEntityPlayer().getEntityData().func_74775_l("toroquest.playerCivilization");
        cap.readNBT((NBTBase)c);
    }

    @SubscribeEvent
    public void onEntityLoad(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getObject();
        event.addCapability(new ResourceLocation("toroquest", "playerCivilization"), (ICapabilityProvider)new PlayerCivilizationCapabilityProvider(player));
        this.syncClientCapability(player);
    }

    private void syncClientCapability(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            TaskRunner.queueTask(new SyncTask(), 30);
        }
    }

    public static void adjustPlayerRep(EntityPlayer player, int chunkX, int chunkZ, int value) {
        if (player == null || player.field_70170_p.field_72995_K || player.field_71093_bK != 0) {
            return;
        }
        Province province = CivilizationUtil.getProvinceAt(player.func_130014_f_(), chunkX, chunkZ);
        if (province == null) {
            return;
        }
        EventHandlers.adjustPlayerRep(player, province.civilization, value);
    }

    public static void adjustPlayerRep(EntityPlayer player, CivilizationType civ, int value) {
        int startRep;
        int afterRep;
        if (player == null || player.field_70170_p.field_72995_K || civ == null || player.field_71093_bK != 0) {
            return;
        }
        if (value < 0) {
            player.func_146105_b((ITextComponent)TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"text.toroquest.crime_reported", (Object[])new Object[0]), true);
        }
        if ((afterRep = (startRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(civ)) + value) < -3000) {
            PlayerCivilizationCapabilityImpl.get(player).setReputation(civ, -3000);
        } else {
            PlayerCivilizationCapabilityImpl.get(player).adjustReputation(civ, value);
        }
        EventHandlers.repLevelMessage(player, civ, startRep, afterRep);
    }

    public static void reportCrimeRep(EntityPlayer player, Province province, int value) {
        if (player == null || player.field_70170_p.field_72995_K || province == null || province.civilization == null || player.field_71093_bK != 0) {
            return;
        }
        player.func_146105_b((ITextComponent)TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"text.toroquest.crime_reported", (Object[])new Object[0]), true);
        CivilizationType civ = province.getCiv();
        int startRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(civ);
        int afterRep = startRep + value;
        if (afterRep < -3000) {
            PlayerCivilizationCapabilityImpl.get(player).setReputation(civ, -3000);
        } else {
            PlayerCivilizationCapabilityImpl.get(player).adjustReputation(civ, value);
        }
    }

    @SubscribeEvent
    public void checkKillInCivilization(LivingDeathEvent event) {
        List help;
        Province province;
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity s = source.func_76346_g();
        if (!(s instanceof EntityPlayer) || s.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)s;
        Entity e = event.getEntity();
        if (e == null || !(e instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)e;
        if (victim instanceof EntityMule && e instanceof EntityPlayer) {
            List caravans = victim.func_130014_f_().func_72872_a(EntityCaravan.class, victim.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
            for (EntityCaravan caravan : caravans) {
                if (((EntityMule)victim).func_110166_bE() != caravan) continue;
                caravan.setMurder((EntityPlayer)e);
            }
        }
        if ((province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization()) == null || province.civilization == null) {
            return;
        }
        if (victim instanceof IMob || victim instanceof EntityMob) {
            float hpr = victim.func_110138_aP() / (float)ToroQuestConfiguration.healthOfMobNeededToGainOneRep;
            if (hpr < 1.0f) {
                if (rand.nextFloat() < hpr) {
                    EventHandlers.adjustPlayerRep(player, province.civilization, 1);
                }
            } else {
                if (rand.nextFloat() < hpr % 1.0f) {
                    hpr += 1.0f;
                }
                EventHandlers.adjustPlayerRep(player, province.civilization, (int)hpr);
            }
        } else if (victim instanceof EntityVillager || victim instanceof EntityGuard) {
            World world = victim.field_70170_p;
            EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.murderRepLoss);
            List guards = world.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(20.0, 16.0, 20.0), (Predicate)new Predicate<EntityToroNpc>(){

                public boolean apply(@Nullable EntityToroNpc entity) {
                    return true;
                }
            });
            for (Object guard : guards) {
                ((EntityToroNpc)((Object)guard)).setMurder(player);
                guard.func_70624_b((EntityLivingBase)player);
            }
            List villagers = world.func_175647_a(EntityToroVillager.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(20.0, 16.0, 20.0), (Predicate)new Predicate<EntityToroVillager>(){

                public boolean apply(@Nullable EntityToroVillager entity) {
                    return true;
                }
            });
            for (EntityToroVillager villager : villagers) {
                villager.setMurder(player);
            }
        }
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        if (rep >= 100 || !ToroQuestConfiguration.loseReputationForAnimalGrief) {
            return;
        }
        if (victim instanceof EntityChicken || victim instanceof EntityHorse && !((EntityHorse)victim).func_110248_bS() && !((EntityHorse)victim).func_110257_ck() || victim instanceof EntityDonkey && (!((EntityDonkey)victim).func_110248_bS() || !((EntityDonkey)victim).func_110257_ck()) || victim instanceof EntityPig || victim instanceof EntitySheep || victim instanceof EntityCow || victim instanceof EntityMule) {
            boolean witnessed = this.villagersReportCrime(player.func_130014_f_(), player);
            help = player.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

                public boolean apply(@Nullable EntityToroNpc entity) {
                    return true;
                }
            });
            Collections.shuffle(help);
            boolean flag = false;
            for (EntityToroNpc entity : help) {
                if (!entity.func_70685_l((Entity)player)) continue;
                witnessed = true;
                entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                entity.setAnnoyed(player);
                entity.func_70624_b((EntityLivingBase)player);
                if (flag) continue;
                flag = true;
                entity.chat(entity, player, "butcher", null);
            }
            if (witnessed) {
                EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.murderLivestockRepLoss);
            }
        } else if (victim instanceof EntityIronGolem) {
            boolean witnessed = this.villagersReportCrime(player.func_130014_f_(), player);
            help = player.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

                public boolean apply(@Nullable EntityToroNpc entity) {
                    return true;
                }
            });
            Collections.shuffle(help);
            boolean flag = false;
            for (EntityToroNpc entity : help) {
                if (!entity.func_70685_l((Entity)player)) continue;
                witnessed = true;
                entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                entity.setAnnoyed(player);
                entity.func_70624_b((EntityLivingBase)player);
                if (flag) continue;
                flag = true;
                entity.chat(entity, player, "golemKill", null);
            }
            if (witnessed) {
                EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.murderLivestockRepLoss);
            }
        }
    }

    @SubscribeEvent
    public void handleEnteringProvince(EntityEvent.EnteringChunk event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).updatePlayerLocation(event.getNewChunkX(), event.getNewChunkZ());
    }

    @SideOnly(value=Side.CLIENT)
    public static TextComponentString leavingMessage(EntityPlayer player, Province province) {
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        String s = rep >= 50 ? province.civilization.getFriendlyLeavingMessage(province) : (rep <= -10 ? province.civilization.getHostileLeavingMessage(province) : province.civilization.getNeutralLeavingMessage(province));
        return new TextComponentString(s);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextComponentString enteringMessage(EntityPlayer player, Province province) {
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        String s = rep >= 10 ? province.civilization.getFriendlyEnteringMessage(province) : (rep <= -10 ? province.civilization.getHostileEnteringMessage(province) : province.civilization.getNeutralEnteringMessage(province));
        return new TextComponentString(s);
    }

    @SubscribeEvent
    public void breed(BabyEntitySpawnEvent event) {
        EntityPlayer e = event.getCausedByPlayer();
        if (e == null || e.field_70170_p.field_72995_K) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(e).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        if (!(event.getParentA() instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal animal = (EntityAnimal)event.getParentA();
        if (!(event.getParentB() instanceof EntityAnimal)) {
            return;
        }
        EntityPlayerMP playerA = ((EntityAnimal)event.getParentA()).func_191993_do();
        EntityPlayerMP playerB = ((EntityAnimal)event.getParentB()).func_191993_do();
        if (playerA != null) {
            if (rand.nextInt(3) == 0) {
                EventHandlers.adjustPlayerRep((EntityPlayer)playerA, event.getParentA().field_70176_ah, event.getParentA().field_70164_aj, 1);
            }
            try {
                QuestBreed.INSTANCE.onBreed(e, animal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        animal = (EntityAnimal)event.getParentB();
        if (playerB != null) {
            if (rand.nextInt(3) == 0) {
                EventHandlers.adjustPlayerRep((EntityPlayer)playerB, event.getParentB().field_70176_ah, event.getParentB().field_70164_aj, 1);
            }
            try {
                QuestBreed.INSTANCE.onBreed(e, animal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    @SubscribeEvent
    public void onBucketUse(FillBucketEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos blockPos = new BlockPos(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c);
        if (event.getEmptyBucket() == null) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        if (event.getEmptyBucket().func_77977_a().contains("Water")) {
            List mob = event.getWorld().func_175647_a(EntityToroMob.class, new AxisAlignedBB(blockPos).func_72314_b(6.0, 6.0, 6.0), (Predicate)new Predicate<EntityToroMob>(){

                public boolean apply(@Nullable EntityToroMob entity) {
                    return true;
                }
            });
            for (EntityToroMob m : mob) {
                if (!rand.nextBoolean()) continue;
                m.func_70624_b((EntityLivingBase)player);
            }
            List guards = event.getWorld().func_175647_a(EntityToroNpc.class, new AxisAlignedBB(blockPos).func_72314_b(4.0, 4.0, 4.0), (Predicate)new Predicate<EntityToroNpc>(){

                public boolean apply(@Nullable EntityToroNpc entity) {
                    return true;
                }
            });
            Collections.shuffle(guards);
            boolean flag = false;
            if (rep >= 250 || !ToroQuestConfiguration.loseReputationForBlockGrief) {
                for (EntityToroNpc entity : guards) {
                    if (!entity.func_70685_l((Entity)player) || flag) continue;
                    flag = true;
                    entity.chat(entity, player, "water", null);
                }
            } else {
                for (EntityToroNpc entity : guards) {
                    if (!entity.func_70685_l((Entity)player)) continue;
                    if (entity instanceof EntityVillageLord) {
                        entity.setAnnoyed(player);
                        ((EntityVillageLord)entity).callForHelp((EntityLivingBase)player);
                    } else if (entity.isAnnoyed()) {
                        if (!entity.inCombat()) {
                            entity.setAnnoyed(player);
                            entity.func_70624_b((EntityLivingBase)player);
                        }
                    } else {
                        entity.setAnnoyed(player);
                    }
                    if (flag) continue;
                    flag = true;
                    entity.chat(entity, player, "water", null);
                }
            }
            if (flag) {
                EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.unexpensiveRepLoss);
            }
        } else if (event.getEmptyBucket().func_77977_a().contains("Lava")) {
            boolean onVillager;
            List mob = event.getWorld().func_175647_a(EntityToroMob.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(6.0, 6.0, 6.0), (Predicate)new Predicate<EntityToroMob>(){

                public boolean apply(@Nullable EntityToroMob entity) {
                    return true;
                }
            });
            for (EntityToroMob m : mob) {
                m.func_70624_b((EntityLivingBase)player);
            }
            List help = event.getWorld().func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

                public boolean apply(@Nullable EntityToroNpc entity) {
                    return true;
                }
            });
            Collections.shuffle(help);
            boolean flag = false;
            boolean witnessed = false;
            boolean onGuard = !event.getWorld().func_175647_a(EntityToroNpc.class, new AxisAlignedBB(blockPos).func_72314_b(4.0, 4.0, 4.0), (Predicate)new Predicate<EntityToroNpc>(){

                public boolean apply(@Nullable EntityToroNpc entity) {
                    return true;
                }
            }).isEmpty();
            boolean bl = onVillager = !event.getWorld().func_175647_a(EntityVillager.class, new AxisAlignedBB(blockPos).func_72314_b(4.0, 4.0, 4.0), (Predicate)new Predicate<EntityVillager>(){

                public boolean apply(@Nullable EntityVillager entity) {
                    return true;
                }
            }).isEmpty();
            if (onGuard || onVillager) {
                witnessed = this.villagersReportCrime(event.getWorld(), player);
                for (EntityToroNpc entity : help) {
                    if (!entity.func_70685_l((Entity)player)) continue;
                    entity.setAnnoyed(player);
                    entity.func_70624_b((EntityLivingBase)player);
                    if (flag) continue;
                    flag = true;
                    entity.chat(entity, player, "lavaonperson", null);
                }
                EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.lavaGriefRepLoss);
            } else {
                if (rep >= 250 || !ToroQuestConfiguration.loseReputationForBlockGrief) {
                    for (EntityToroNpc entity : help) {
                        if (!entity.func_70685_l((Entity)player) || flag) continue;
                        flag = true;
                        if (!entity.actionReady()) continue;
                        entity.chat(entity, player, "lavaallowed", null);
                    }
                    return;
                }
                witnessed = this.villagersReportCrime(event.getWorld(), player);
                for (EntityToroNpc entity : help) {
                    if (!entity.func_70685_l((Entity)player)) continue;
                    witnessed = true;
                    entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                    entity.setAnnoyed(player);
                    entity.func_70624_b((EntityLivingBase)player);
                    if (flag) continue;
                    flag = true;
                    entity.chat(entity, player, "lavacrime", null);
                }
                if (witnessed) {
                    EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.lavaGriefRepLoss);
                }
            }
        }
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.EntityPlaceEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Block e = event.getState().func_177230_c();
        BlockPos blockPos = event.getPos();
        if (blockPos == null) {
            return;
        }
        Entity eventEntity = event.getEntity();
        if (eventEntity == null || !(eventEntity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)eventEntity;
        if (e instanceof IPlantable && !(e instanceof IShearable)) {
            try {
                QuestFarm.INSTANCE.onFarm(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (event.getPlacedBlock().func_185904_a() == Material.field_151576_e) {
            Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
            QuestBuild.DataWrapper quest = new QuestBuild.DataWrapper();
            for (QuestData data : quests) {
                Province province;
                quest.setData(data);
                if (!quest.isBuildQuest() || (province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization()) == null || province.civilization == null || !quest.isInCorrectProvince(province)) continue;
                QuestBuild.INSTANCE.perform(quest);
            }
        }
        if (!(e instanceof BlockFire) && !(e instanceof BlockTNT)) {
            return;
        }
        List mob = event.getWorld().func_175647_a(EntityToroMob.class, new AxisAlignedBB(blockPos).func_72314_b(6.0, 6.0, 6.0), (Predicate)new Predicate<EntityToroMob>(){

            public boolean apply(@Nullable EntityToroMob entity) {
                return true;
            }
        });
        for (EntityToroMob m : mob) {
            m.func_70624_b((EntityLivingBase)player);
        }
        boolean onGuard = !event.getWorld().func_175647_a(EntityToroNpc.class, new AxisAlignedBB(blockPos).func_72314_b(3.0, 3.0, 3.0), (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(@Nullable EntityToroNpc entity) {
                return true;
            }
        }).isEmpty();
        boolean onVillager = !event.getWorld().func_175647_a(EntityVillager.class, new AxisAlignedBB(blockPos).func_72314_b(3.0, 3.0, 3.0), (Predicate)new Predicate<EntityVillager>(){

            public boolean apply(@Nullable EntityVillager entity) {
                return true;
            }
        }).isEmpty();
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        List help = event.getWorld().func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(@Nullable EntityToroNpc entity) {
                return true;
            }
        });
        Collections.shuffle(help);
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        boolean witnessed = false;
        boolean flag = false;
        if (e instanceof BlockTNT) {
            for (EntityToroNpc entity : help) {
                if (!entity.func_70685_l((Entity)player)) continue;
                if (entity.isAnnoyed()) {
                    if (!entity.inCombat()) {
                        entity.setAnnoyed(player);
                        entity.func_70624_b((EntityLivingBase)player);
                    }
                } else {
                    entity.setAnnoyed(player);
                }
                if (flag) continue;
                flag = true;
                entity.chat(entity, player, "explosives", null);
            }
            witnessed = this.villagersReportCrime(event.getWorld(), player);
        } else if (onGuard || onVillager) {
            for (EntityToroNpc entity : help) {
                entity.setAnnoyed(player);
                if (!entity.inCombat()) {
                    entity.func_70624_b((EntityLivingBase)player);
                }
                if (flag) continue;
                flag = true;
                entity.chat(entity, player, "fireonperson", null);
            }
            witnessed = this.villagersReportCrime(event.getWorld(), player);
        } else if (rep < 250 && ToroQuestConfiguration.loseReputationForBlockGrief) {
            for (EntityToroNpc entity : help) {
                if (!entity.func_70685_l((Entity)player)) continue;
                witnessed = true;
                entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                if (entity.isAnnoyed()) {
                    if (!entity.inCombat()) {
                        entity.setAnnoyed(player);
                        entity.func_70624_b((EntityLivingBase)player);
                    }
                } else {
                    entity.setAnnoyed(player);
                }
                if (flag) continue;
                flag = true;
                entity.chat(entity, player, "firespread", null);
            }
            witnessed = this.villagersReportCrime(event.getWorld(), player);
        }
        if (witnessed) {
            EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.fireGriefRepLoss);
        }
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getHarvester() != null) {
            Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(event.getHarvester()).getCurrentQuests();
            for (QuestData data : quests) {
                try {
                    if (!data.getiData().containsKey("block_type")) continue;
                    int bt = data.getiData().get("block_type");
                    for (ItemStack drop : event.getDrops()) {
                        if (!QuestMine.INSTANCE.isCorrectBlock(data.getPlayer(), drop.func_77973_b(), bt)) continue;
                        QuestMine.INSTANCE.perform(data, drop.func_190916_E());
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    @SubscribeEvent
    public void grief(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getPlayer() == null || event.getPos() == null || event.getState() == null) {
            return;
        }
        Block block = event.getState().func_177230_c();
        Province province = PlayerCivilizationCapabilityImpl.get(event.getPlayer()).getInCivilization();
        if (rand.nextInt(8000) <= ToroQuestConfiguration.artifactDropRate && (block instanceof BlockStone || block instanceof BlockGrass || block instanceof BlockDirt || block instanceof BlockOre || block instanceof BlockGravel || block instanceof BlockClay || block instanceof BlockSand)) {
            World world = event.getWorld();
            block.func_180637_b(world, event.getPos(), 10);
            ItemStack stack = EventHandlers.randomStolenItem(world, province);
            if (stack == null) {
                return;
            }
            EntityItem entityitem = new EntityItem(world, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
        if (province == null || province.civilization == null) {
            return;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(event.getPlayer()).getReputation(province.civilization);
        if (rep >= 250 || !ToroQuestConfiguration.loseReputationForBlockGrief || event.getPlayer().func_70644_a(MobEffects.field_76441_p)) {
            return;
        }
        boolean valuable = false;
        boolean witnessed = false;
        boolean flag = false;
        if (EventHandlers.isBuilding(block)) {
            valuable = false;
            witnessed = this.villagersReportCrime(event.getWorld(), event.getPlayer());
        } else if (EventHandlers.isValuableBuilding(block)) {
            EntityToroNpc entity;
            Iterator iterator;
            valuable = true;
            witnessed = this.villagersReportCrime(event.getWorld(), event.getPlayer());
            List villageLord = event.getWorld().func_175647_a(EntityVillageLord.class, new AxisAlignedBB(event.getPlayer().func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityVillageLord>(){

                public boolean apply(@Nullable EntityVillageLord entity) {
                    return true;
                }
            });
            if (block instanceof BlockQuartz || block == Blocks.field_150340_R) {
                iterator = villageLord.iterator();
                if (iterator.hasNext()) {
                    entity = (EntityVillageLord)((Object)iterator.next());
                    entity.setAnnoyed(event.getPlayer());
                    ((EntityVillageLord)entity).chat(entity, event.getPlayer(), "throne", null);
                    flag = true;
                }
            } else {
                iterator = villageLord.iterator();
                if (iterator.hasNext()) {
                    entity = (EntityVillageLord)((Object)iterator.next());
                    entity.setAnnoyed(event.getPlayer());
                    ((EntityVillageLord)entity).chat(entity, event.getPlayer(), "crime", null);
                    flag = true;
                }
            }
        } else if (event.getState().func_177230_c() instanceof IPlantable && !(event.getState().func_177230_c() instanceof IShearable)) {
            List players = event.getWorld().func_72872_a(EntityPlayer.class, new AxisAlignedBB(event.getPos()).func_72314_b(6.0, 3.0, 6.0));
            for (EntityPlayer player : players) {
                List villagers = event.getWorld().func_175647_a(EntityVillager.class, new AxisAlignedBB(event.getPos()).func_72314_b(1.5, 1.5, 1.5), (Predicate)new Predicate<EntityVillager>(){

                    public boolean apply(@Nullable EntityVillager entity) {
                        return true;
                    }
                });
                if (!villagers.isEmpty()) continue;
                try {
                    QuestFarm.INSTANCE.destroyedCrop(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (rep >= 50 || !ToroQuestConfiguration.loseReputationForCropGrief || player.func_70644_a(MobEffects.field_76441_p)) continue;
                witnessed = this.villagersReportCrime(event.getWorld(), player);
                List help = event.getWorld().func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

                    public boolean apply(@Nullable EntityToroNpc entity) {
                        return true;
                    }
                });
                Collections.shuffle(help);
                for (EntityToroNpc entity : help) {
                    if (!entity.func_70685_l((Entity)player)) continue;
                    witnessed = true;
                    entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                    if (entity.isAnnoyed()) {
                        if (!entity.inCombat()) {
                            entity.setAnnoyed(player);
                            if (rand.nextBoolean()) {
                                entity.func_70624_b((EntityLivingBase)player);
                            }
                        }
                    } else {
                        entity.setAnnoyed(player);
                    }
                    if (flag || !entity.actionReady()) continue;
                    flag = true;
                    entity.chat(entity, player, "crops", null);
                }
                if (witnessed) {
                    EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.unexpensiveRepLoss);
                }
                return;
            }
        } else {
            return;
        }
        List help = event.getPlayer().field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(event.getPlayer().func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(@Nullable EntityToroNpc entity) {
                return true;
            }
        });
        Collections.shuffle(help);
        for (EntityToroNpc entity : help) {
            if (!entity.func_70685_l((Entity)event.getPlayer())) continue;
            witnessed = true;
            entity.func_70661_as().func_75497_a((Entity)event.getPlayer(), 0.6);
            if (!valuable) {
                if (entity.isAnnoyed()) {
                    if (!entity.inCombat()) {
                        entity.setAnnoyed(event.getPlayer());
                        entity.func_70624_b((EntityLivingBase)event.getPlayer());
                    }
                } else {
                    entity.setAnnoyed(event.getPlayer());
                }
                if (flag) continue;
                flag = true;
                entity.chat(entity, event.getPlayer(), "grief", null);
                continue;
            }
            entity.setAnnoyed(event.getPlayer());
            entity.func_70624_b((EntityLivingBase)event.getPlayer());
            if (flag) continue;
            flag = true;
            entity.chat(entity, event.getPlayer(), "grief", null);
        }
        if (witnessed) {
            if (!valuable) {
                EventHandlers.reportCrimeRep(event.getPlayer(), province, -ToroQuestConfiguration.unexpensiveRepLoss);
            } else {
                EventHandlers.reportCrimeRep(event.getPlayer(), province, -ToroQuestConfiguration.expensiveRepLoss);
            }
        }
    }

    private boolean villagersReportCrime(World world, EntityPlayer player) {
        List villagerList = world.func_175647_a(EntityToroVillager.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(12.0, 12.0, 12.0), (Predicate)new Predicate<EntityToroVillager>(){

            public boolean apply(@Nullable EntityToroVillager entity) {
                return true;
            }
        });
        Collections.shuffle(villagerList);
        boolean flag = false;
        for (EntityToroVillager villager : villagerList) {
            if (!villager.func_70685_l((Entity)player)) continue;
            if (!flag) {
                villager.reportToGuards(player);
                villager.func_184185_a(SoundEvents.field_187913_gm, 1.0f, 1.0f);
                flag = true;
            }
            villager.blockTrade();
        }
        return flag;
    }

    public static boolean isBuilding(Block block) {
        return block instanceof BlockPlanks || block.func_176223_P() == Blocks.field_150347_e.func_176223_P() || block.func_176223_P() == Blocks.field_150325_L.func_176223_P() || block.func_176223_P() == Blocks.field_150406_ce.func_176223_P() || block.func_176223_P() == Blocks.field_150417_aV.func_176223_P() || block.func_176223_P() == Blocks.field_150410_aZ.func_176223_P() || block.func_176223_P() == Blocks.field_185774_da.func_176223_P() || block.func_176223_P() == Blocks.field_150322_A.func_176223_P() || block.func_176223_P() == Blocks.field_150364_r.func_176223_P() || block.func_176223_P() == Blocks.field_150452_aw.func_176223_P() || block.func_176223_P() == Blocks.field_150478_aa.func_176223_P() || block instanceof BlockCarpet || block instanceof BlockFence || block instanceof BlockColored || block instanceof BlockLog || block instanceof BlockFlowerPot || block instanceof BlockSlab || block instanceof BlockStairs || block instanceof BlockLadder || block instanceof BlockTrapDoor || block instanceof BlockDoubleStoneSlab;
    }

    public static boolean isValuableBuilding(Block block) {
        return block.func_176223_P() == Blocks.field_150342_X.func_176223_P() || block.func_176223_P() == Blocks.field_150340_R.func_176223_P() || block.func_176223_P() == Blocks.field_150447_bR.func_176223_P() || block.func_176223_P() == Blocks.field_150475_bE.func_176223_P() || block instanceof BlockQuartz || block instanceof BlockCauldron || block instanceof BlockBanner || block.func_176223_P() == Blocks.field_150421_aI || block.func_176223_P() == Blocks.field_150370_cb.func_176223_P() || block instanceof BlockDoor || block instanceof BlockBed || block.func_176223_P() == Blocks.field_150467_bQ.func_176223_P();
    }

    public static boolean isCrop(Block block) {
        return block instanceof BlockCrops || block instanceof BlockStem || block.func_176223_P() == Blocks.field_150458_ak.func_176223_P();
    }

    @SubscribeEvent
    public void civTimer(TickEvent.WorldTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase) || event.world == null) {
            return;
        }
        if (event.world.field_72995_K || ++this.spawningTicks % 200 != 0) {
            return;
        }
        for (EntityPlayer p : event.world.field_73010_i) {
            int duration;
            CivilizationDataAccessor worldData;
            Province province = PlayerCivilizationCapabilityImpl.get(p).getInCivilization();
            if (province == null || (worldData = CivilizationsWorldSaveData.get(p.field_70170_p)) == null || (duration = PlayerCivilizationCapabilityImpl.get(p).getReputation(province.civilization) + 1) <= 50) continue;
            duration = MathHelper.func_76125_a((int)PlayerCivilizationCapabilityImpl.get(p).getReputation(province.civilization), (int)0, (int)3000) * 4;
            int power = 0;
            if (worldData.hasTrophyBeholder(province.id)) {
                power = 1;
            }
            if (worldData.hasTrophyMage(province.id)) {
                p.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration, power, true, false));
            }
            if (worldData.hasTrophyLord(province.id)) {
                p.func_70690_d(new PotionEffect(MobEffects.field_76429_m, duration, power, true, false));
            }
            if (worldData.hasTrophyPig(province.id)) {
                p.func_70690_d(new PotionEffect(MobEffects.field_76443_y, duration, power, true, false));
            }
            if (worldData.hasTrophyBandit(province.id)) {
                p.func_70690_d(new PotionEffect(MobEffects.field_76420_g, duration, power, true, false));
            }
            if (worldData.hasTrophySkeleton(province.id)) {
                p.func_70690_d(new PotionEffect(MobEffects.field_76428_l, duration, power, true, false));
            }
            if (!worldData.hasTrophySpider(province.id)) continue;
            p.func_70690_d(new PotionEffect(MobEffects.field_76430_j, duration, power, true, false));
            p.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration, power, true, false));
        }
        if (this.spawningTicks < 1200) {
            return;
        }
        this.spawningTicks = 0;
        int players = event.world.field_73010_i.size();
        if (players > 0) {
            if (ToroQuestConfiguration.banditSpawnRate > 0 && rand.nextInt(100) < ToroQuestConfiguration.banditSpawnRate + MathHelper.func_76125_a((int)((players - 1) * 2), (int)0, (int)ToroQuestConfiguration.banditSpawnRate)) {
                this.spawnBanditsNearPlayer(event.world);
            }
            if (ToroQuestConfiguration.caravanSpawnRate > 0 && (event.world.func_72820_D() <= 11000L || event.world.func_72820_D() >= 23000L) && rand.nextInt(100) < ToroQuestConfiguration.caravanSpawnRate + MathHelper.func_76125_a((int)((players - 1) * 2), (int)0, (int)ToroQuestConfiguration.caravanSpawnRate)) {
                this.spawnCaravanNearProvince(event.world);
            }
            if (ToroQuestConfiguration.provinceSiegeRate > 0 && rand.nextInt(100) < ToroQuestConfiguration.provinceSiegeRate + MathHelper.func_76125_a((int)((players - 1) * 2), (int)0, (int)ToroQuestConfiguration.provinceSiegeRate)) {
                this.spawnRaiders(event.world);
                if (rand.nextInt(4) == 0) {
                    this.spawnRaiders(event.world);
                }
            }
            if (ToroQuestConfiguration.fugitiveSpawnRate > 0 && rand.nextInt(100) < ToroQuestConfiguration.fugitiveSpawnRate + MathHelper.func_76125_a((int)(players - 1), (int)0, (int)ToroQuestConfiguration.fugitiveSpawnRate)) {
                this.spawnFugitives(event.world);
            }
        }
        try {
            for (EntityPlayer p : event.world.field_73010_i) {
                if (PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.EARTH) < 0) {
                    PlayerCivilizationCapabilityImpl.get(p).adjustReputation(CivilizationType.EARTH, (int)MathHelper.func_151237_a((double)((double)(-PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.EARTH)) / 30.0), (double)1.0, (double)100.0));
                }
                if (PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.FIRE) < 0) {
                    PlayerCivilizationCapabilityImpl.get(p).adjustReputation(CivilizationType.FIRE, (int)MathHelper.func_151237_a((double)((double)(-PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.FIRE)) / 30.0), (double)1.0, (double)100.0));
                }
                if (PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.MOON) < 0) {
                    PlayerCivilizationCapabilityImpl.get(p).adjustReputation(CivilizationType.MOON, (int)MathHelper.func_151237_a((double)((double)(-PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.MOON)) / 30.0), (double)1.0, (double)100.0));
                }
                if (PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.SUN) < 0) {
                    PlayerCivilizationCapabilityImpl.get(p).adjustReputation(CivilizationType.SUN, (int)MathHelper.func_151237_a((double)((double)(-PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.SUN)) / 30.0), (double)1.0, (double)100.0));
                }
                if (PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.WATER) < 0) {
                    PlayerCivilizationCapabilityImpl.get(p).adjustReputation(CivilizationType.WATER, (int)MathHelper.func_151237_a((double)((double)(-PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.WATER)) / 30.0), (double)1.0, (double)100.0));
                }
                if (PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.WIND) >= 0) continue;
                PlayerCivilizationCapabilityImpl.get(p).adjustReputation(CivilizationType.WIND, (int)MathHelper.func_151237_a((double)((double)(-PlayerCivilizationCapabilityImpl.get(p).getReputation(CivilizationType.WIND)) / 30.0), (double)1.0, (double)100.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void spawnCaravanNearProvince(World world) {
        if (world.field_72995_K) {
            return;
        }
        try {
            List players = world.field_73010_i;
            Collections.shuffle(players);
            int tries = 3;
            while (tries > 0) {
                --tries;
                for (EntityPlayer player : players) {
                    BlockPos loc;
                    BlockPos banditSpawnPos;
                    Province province;
                    Village village;
                    if (player.field_70170_p.field_73011_w.getDimension() != 0 || (village = world.func_175714_ae().func_176056_a(player.func_180425_c(), 320)) == null || (province = CivilizationUtil.getProvinceAt(world, village.func_180608_a().func_177958_n() / 16, village.func_180608_a().func_177952_p() / 16)) == null) continue;
                    int x = 0;
                    int z = 0;
                    if (CivilizationUtil.getProvinceAt(world, player.field_70176_ah, player.field_70164_aj) == null) {
                        double distance;
                        int playerX = (int)player.field_70165_t;
                        int playerZ = (int)player.field_70161_v;
                        double angle = rand.nextDouble() * Math.PI * 2.0;
                        int range = 25 + rand.nextInt(25);
                        x = (int)(Math.cos(angle) * (double)range);
                        z = (int)(Math.sin(angle) * (double)range);
                        for (int i = 0; !(8 <= i || (distance = (double)(Math.abs(province.getCenterPosX() - playerX) + Math.abs(province.getCenterPosZ() - playerZ))) < (double)(200 + i * 3) && distance > 140.0); ++i) {
                            x = (int)(Math.cos(angle) * (double)range);
                            z = (int)(Math.sin(angle) * (double)range);
                        }
                    } else {
                        double distance;
                        double angle = rand.nextDouble() * Math.PI * 2.0;
                        int range = 150 + rand.nextInt(80);
                        x = (int)(Math.cos(angle) * (double)range);
                        z = (int)(Math.sin(angle) * (double)range);
                        for (int i = 0; !(8 <= i || (distance = player.func_70011_f((double)x, player.field_70163_u, (double)z)) < (double)(50 + i * 3) && distance > 25.0); ++i) {
                            x = (int)(Math.cos(angle) * (double)range);
                            z = (int)(Math.sin(angle) * (double)range);
                        }
                    }
                    if ((banditSpawnPos = EventHandlers.findSpawnLocationFrom(world, loc = new BlockPos(x, MAX_SPAWN_HEIGHT, z))) == null || CivilizationUtil.getProvinceAt(world, banditSpawnPos.func_177958_n() / 16, banditSpawnPos.func_177952_p() / 16) != null || !world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(banditSpawnPos).func_72314_b(25.0, 10.0, 25.0)).isEmpty()) continue;
                    int i = rand.nextInt(3) + 1;
                    while (i > 0) {
                        --i;
                        EntityCaravan e = new EntityCaravan(world);
                        e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                        world.func_72838_d((Entity)e);
                        e.field_70133_I = true;
                        if (rand.nextBoolean()) {
                            if (rand.nextBoolean()) {
                                EntityGuard g = new EntityGuard(world, province);
                                g.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                                g.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151040_l, 1));
                                ItemStack istack = new ItemStack(Item.func_111206_d((String)"spartanshields:shield_tower_wood"));
                                if (istack != null && !istack.func_190926_b()) {
                                    g.func_184611_a(EnumHand.OFF_HAND, istack);
                                } else {
                                    g.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Items.field_185159_cQ, 1));
                                }
                                world.func_72838_d((Entity)g);
                                g.field_70133_I = true;
                                g.func_70661_as().func_75497_a((Entity)player, 0.6);
                                g.func_70624_b((EntityLivingBase)player);
                                g.func_70624_b(null);
                            } else {
                                e.addCaravan();
                                if (rand.nextBoolean()) {
                                    e.addCaravan();
                                }
                            }
                        }
                        e.func_70661_as().func_75497_a((Entity)player, 0.6);
                        e.func_70624_b((EntityLivingBase)player);
                        e.func_70624_b(null);
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR SPAWNING EntityCaravan: " + e);
            return;
        }
    }

    protected void spawnBanditsNearPlayer(World world) {
        if (world.field_72995_K) {
            return;
        }
        try {
            List players = world.field_73010_i;
            Collections.shuffle(players);
            int tries = 3;
            while (tries > 0) {
                --tries;
                for (EntityPlayer player : players) {
                    int playerPosZ;
                    int playerPosX;
                    if (player.field_70170_p.field_73011_w.getDimension() != 0 || CivilizationUtil.getProvinceAt(world, (playerPosX = (int)player.field_70165_t) / 16, (playerPosZ = (int)player.field_70161_v) / 16) != null) continue;
                    int range = 40 + rand.nextInt(20);
                    double angle = rand.nextDouble() * Math.PI * 2.0;
                    int x = (int)(Math.cos(angle) * (double)range);
                    int z = (int)(Math.sin(angle) * (double)range);
                    BlockPos banditSpawnPos = EventHandlers.findSpawnLocationFrom(world, new BlockPos(x += playerPosX, MAX_SPAWN_HEIGHT, z += playerPosZ));
                    if (banditSpawnPos == null || CivilizationUtil.getProvinceAt(world, banditSpawnPos.func_177958_n() / 16, banditSpawnPos.func_177952_p() / 16) != null || !world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(banditSpawnPos).func_72314_b(25.0, 10.0, 25.0)).isEmpty()) continue;
                    int amountToSpawn = rand.nextInt((int)MathHelper.func_76131_a((float)MathHelper.func_76129_c((float)player.field_71068_ca), (float)1.0f, (float)7.0f)) + 1;
                    if (ToroQuestConfiguration.orcsAreNeutral || rand.nextBoolean()) {
                        boolean cavalry = rand.nextInt(100) < ToroQuestConfiguration.banditMountChance;
                        for (int i = amountToSpawn; i > 0; --i) {
                            EntitySentry e;
                            if (cavalry && world.func_175678_i(banditSpawnPos)) {
                                e = new EntitySentry(world);
                                e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                                world.func_72838_d((Entity)e);
                                e.despawnTick();
                                e.field_70133_I = true;
                                e.func_70624_b((EntityLivingBase)player);
                                e.setMount();
                                e.func_70014_b(new NBTTagCompound());
                                continue;
                            }
                            e = new EntitySentry(world, playerPosX * 2 - banditSpawnPos.func_177958_n(), playerPosZ * 2 - banditSpawnPos.func_177952_p());
                            e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                            world.func_72838_d((Entity)e);
                            e.despawnTick();
                            e.field_70133_I = true;
                            e.func_70624_b((EntityLivingBase)player);
                            e.func_70014_b(new NBTTagCompound());
                        }
                    } else {
                        boolean cavalry = rand.nextInt(100) < ToroQuestConfiguration.orcMountChance;
                        for (int i = amountToSpawn; i > 0; --i) {
                            EntityOrc e;
                            if (cavalry && world.func_175678_i(banditSpawnPos)) {
                                e = new EntityOrc(world);
                                e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                                world.func_72838_d((Entity)e);
                                e.despawnTick();
                                e.field_70133_I = true;
                                e.func_70624_b((EntityLivingBase)player);
                                e.setMount();
                                continue;
                            }
                            e = new EntityOrc(world, playerPosX * 2 - banditSpawnPos.func_177958_n(), playerPosZ * 2 - banditSpawnPos.func_177952_p());
                            e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                            world.func_72838_d((Entity)e);
                            e.despawnTick();
                            e.field_70133_I = true;
                            e.func_70624_b((EntityLivingBase)player);
                        }
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR SPAWNING EntityBandit: " + e);
            return;
        }
    }

    private int getRandomRaiderDistance() {
        return rand.nextInt(105) - 52;
    }

    protected void spawnRaiders(World world) {
        if (world.field_72995_K) {
            return;
        }
        try {
            List players = world.field_73010_i;
            Collections.shuffle(players);
            int tries = 3;
            while (tries > 0) {
                --tries;
                for (EntityPlayer player : players) {
                    BlockPos loc;
                    BlockPos banditSpawnPos;
                    Province province;
                    if (player.field_70170_p.field_73011_w.getDimension() != 0 || (province = CivilizationUtil.getProvinceAt(world, player.field_70176_ah, player.field_70164_aj)) == null) continue;
                    int xdif = player.func_180425_c().func_177958_n() - province.getCenterPosX();
                    int zdif = player.func_180425_c().func_177952_p() - province.getCenterPosZ();
                    int x = province.getCenterPosX();
                    int z = province.getCenterPosZ();
                    if (xdif > 0) {
                        if (zdif > 0) {
                            if (rand.nextBoolean()) {
                                x -= this.getRandomRaiderDistance();
                                z -= this.RAIDER_DISTANCE;
                            } else {
                                x -= this.RAIDER_DISTANCE;
                                z -= this.getRandomRaiderDistance();
                            }
                        } else if (rand.nextBoolean()) {
                            x -= this.RAIDER_DISTANCE;
                            z += this.getRandomRaiderDistance();
                        } else {
                            x -= this.getRandomRaiderDistance();
                            z += this.RAIDER_DISTANCE;
                        }
                    } else if (zdif > 0) {
                        if (rand.nextBoolean()) {
                            x += this.getRandomRaiderDistance();
                            z -= this.RAIDER_DISTANCE;
                        } else {
                            x += this.RAIDER_DISTANCE;
                            z -= this.getRandomRaiderDistance();
                        }
                    } else if (rand.nextBoolean()) {
                        x += this.getRandomRaiderDistance();
                        z += this.RAIDER_DISTANCE;
                    } else {
                        x += this.RAIDER_DISTANCE;
                        z += this.getRandomRaiderDistance();
                    }
                    if ((banditSpawnPos = EventHandlers.findSpawnLocationFrom(world, loc = new BlockPos(x, MAX_SPAWN_HEIGHT, z))) == null || !world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(banditSpawnPos).func_72314_b(25.0, 10.0, 25.0)).isEmpty()) continue;
                    int rep = Math.abs(PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization));
                    boolean isNightTime = world.func_72820_D() >= 13000L && world.func_72820_D() <= 21000L;
                    switch (province.getCiv()) {
                        case FIRE: {
                            if (rand.nextInt(100) < ToroQuestConfiguration.configRaiderSiegeChance) {
                                if (!this.spawnRaider(ToroQuestConfiguration.raiderList_RED_BRIAR, rep, banditSpawnPos, province, player, world, isNightTime)) {
                                    this.spawnWolves(world, banditSpawnPos, rep, player, province);
                                }
                            } else if (isNightTime && rand.nextBoolean()) {
                                this.spawnZombies(world, banditSpawnPos, rep, player, province);
                            } else {
                                this.spawnBandits(world, banditSpawnPos, province, player);
                            }
                            return;
                        }
                        case EARTH: {
                            if (rand.nextInt(100) < ToroQuestConfiguration.configRaiderSiegeChance) {
                                if (!this.spawnRaider(ToroQuestConfiguration.raiderList_GREEN_WILD, rep, banditSpawnPos, province, player, world, isNightTime)) {
                                    this.spawnWolves(world, banditSpawnPos, rep, player, province);
                                }
                            } else if (isNightTime && rand.nextBoolean()) {
                                this.spawnZombies(world, banditSpawnPos, rep, player, province);
                            } else {
                                this.spawnBandits(world, banditSpawnPos, province, player);
                            }
                            return;
                        }
                        case MOON: {
                            if (rand.nextInt(100) < ToroQuestConfiguration.configRaiderSiegeChance) {
                                if (!this.spawnRaider(ToroQuestConfiguration.raiderList_BLACK_MOOR, rep, banditSpawnPos, province, player, world, isNightTime)) {
                                    this.spawnWitches(world, banditSpawnPos, rep, player, province);
                                }
                            } else if (isNightTime && rand.nextBoolean()) {
                                this.spawnZombies(world, banditSpawnPos, rep, player, province);
                            } else {
                                this.spawnBandits(world, banditSpawnPos, province, player);
                            }
                            return;
                        }
                        case SUN: {
                            if (rand.nextInt(100) < ToroQuestConfiguration.configRaiderSiegeChance) {
                                if (!this.spawnRaider(ToroQuestConfiguration.raiderList_YELLOW_DAWN, rep, banditSpawnPos, province, player, world, isNightTime)) {
                                    this.spawnHusks(world, banditSpawnPos, rep, player, province);
                                }
                            } else if (rand.nextBoolean()) {
                                this.spawnHusks(world, banditSpawnPos, rep, player, province);
                            } else {
                                this.spawnBandits(world, banditSpawnPos, province, player);
                            }
                            return;
                        }
                        case WIND: {
                            if (rand.nextInt(100) < ToroQuestConfiguration.configRaiderSiegeChance) {
                                if (!this.spawnRaider(ToroQuestConfiguration.raiderList_BROWN_MITHRIL, rep, banditSpawnPos, province, player, world, isNightTime)) {
                                    this.spawnWolves(world, banditSpawnPos, rep, player, province);
                                }
                            } else if (isNightTime && rand.nextBoolean()) {
                                this.spawnZombies(world, banditSpawnPos, rep, player, province);
                            } else {
                                this.spawnBandits(world, banditSpawnPos, province, player);
                            }
                            return;
                        }
                        case WATER: {
                            if (rand.nextInt(100) < ToroQuestConfiguration.configRaiderSiegeChance) {
                                if (!this.spawnRaider(ToroQuestConfiguration.raiderList_BLUE_GLACIER, rep, banditSpawnPos, province, player, world, isNightTime)) {
                                    this.spawnWolves(world, banditSpawnPos, rep, player, province);
                                }
                            } else if (isNightTime && rand.nextBoolean()) {
                                this.spawnZombies(world, banditSpawnPos, rep, player, province);
                            } else {
                                this.spawnBandits(world, banditSpawnPos, province, player);
                            }
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("TOROQUEST ERROR SPAWNING: " + e);
            return;
        }
    }

    public void spawnBandits(World world, BlockPos banditSpawnPos, Province province, EntityPlayer player) {
        if (world.func_72872_a(EntityToroMob.class, new AxisAlignedBB(banditSpawnPos).func_72314_b(32.0, 16.0, 32.0)).size() > 3) {
            return;
        }
        int rep = Math.abs(PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization));
        int count = rand.nextInt(MathHelper.func_76125_a((int)((rep + 700) / 200), (int)3, (int)9)) + 1;
        if (ToroQuestConfiguration.orcsAreNeutral || rand.nextBoolean()) {
            for (int i = count; i > 0; --i) {
                EntitySentry e = new EntitySentry(world, (province.getCenterPosX() + player.func_180425_c().func_177958_n()) / 2, (province.getCenterPosZ() + player.func_180425_c().func_177952_p()) / 2);
                e.despawnTick();
                e.field_70133_I = true;
                e.func_70624_b((EntityLivingBase)player);
                e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)e);
                e.field_70175_ag = true;
                e.func_70014_b(new NBTTagCompound());
            }
        } else {
            for (int i = count; i > 0; --i) {
                EntityOrc e = new EntityOrc(world, (province.getCenterPosX() + player.func_180425_c().func_177958_n()) / 2, (province.getCenterPosZ() + player.func_180425_c().func_177952_p()) / 2);
                e.despawnTick();
                e.field_70133_I = true;
                e.func_70624_b((EntityLivingBase)player);
                e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)e);
                e.field_70175_ag = true;
                e.func_70014_b(new NBTTagCompound());
            }
        }
    }

    public void spawnZombies(World world, BlockPos banditSpawnPos, int rep, EntityPlayer player, Province province) {
        for (int i = rand.nextInt(MathHelper.func_76125_a((int)((rep + 350) / 100), (int)4, (int)8)) + 5; i > 0; --i) {
            IMob e;
            if (ToroQuestConfiguration.zombieRaiderVillagerChance > rand.nextInt(100)) {
                e = new EntityZombieVillagerRaider(world, (province.getCenterPosX() + player.func_180425_c().func_177958_n()) / 2, (province.getCenterPosZ() + player.func_180425_c().func_177952_p()) / 2);
                e.field_70133_I = true;
                e.func_70624_b((EntityLivingBase)player);
                e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
                e.field_70175_ag = true;
                world.func_72838_d((Entity)e);
                continue;
            }
            e = new EntityZombieRaider(world, (province.getCenterPosX() + player.func_180425_c().func_177958_n()) / 2, (province.getCenterPosZ() + player.func_180425_c().func_177952_p()) / 2);
            e.field_70133_I = true;
            e.func_70624_b((EntityLivingBase)player);
            e.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
            e.field_70175_ag = true;
            world.func_72838_d((Entity)e);
        }
    }

    public void spawnHusks(World w, BlockPos bsp, int rep, EntityPlayer p, Province province) {
        for (int i = rand.nextInt(MathHelper.func_76125_a((int)((rep + 350) / 100), (int)4, (int)8)) + 5; i > 0; --i) {
            EntityHusk creature = new EntityHusk(w);
            creature.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRaidDespawn((EntityCreature)creature, (Integer)((province.getCenterPosX() + p.func_180425_c().func_177958_n()) / 2), (Integer)((province.getCenterPosZ() + p.func_180425_c().func_177952_p()) / 2), 1.0));
            creature.func_110163_bv();
            creature.getEntityData().func_74768_a("despawnTimer", 100);
            creature.getEntityData().func_74776_a("raidSpeed", 1.0f);
            creature.getEntityData().func_74768_a("raidX", province.getCenterPosX() + rand.nextInt(33) - 16);
            creature.getEntityData().func_74768_a("raidZ", province.getCenterPosZ() + rand.nextInt(33) - 16);
            creature.field_70133_I = true;
            creature.func_70624_b((EntityLivingBase)p);
            creature.func_70107_b((double)bsp.func_177958_n() + 0.5, (double)bsp.func_177956_o() + 0.1, (double)bsp.func_177952_p() + 0.5);
            w.func_72838_d((Entity)creature);
            creature.field_70175_ag = true;
            creature.func_70014_b(new NBTTagCompound());
        }
    }

    public void spawnWitches(World w, BlockPos bsp, int rep, EntityPlayer p, Province province) {
        for (int i = rand.nextInt(MathHelper.func_76125_a((int)((Math.abs(rep) + 500) / 200), (int)2, (int)6)) + 3; i > 0; --i) {
            EntityWitch creature = new EntityWitch(w);
            creature.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRaidDespawn((EntityCreature)creature, (Integer)((province.getCenterPosX() + p.func_180425_c().func_177958_n()) / 2), (Integer)((province.getCenterPosZ() + p.func_180425_c().func_177952_p()) / 2), 1.0));
            creature.func_110163_bv();
            creature.getEntityData().func_74768_a("despawnTimer", 100);
            creature.getEntityData().func_74776_a("raidSpeed", 1.0f);
            creature.getEntityData().func_74768_a("raidX", province.getCenterPosX() + rand.nextInt(33) - 16);
            creature.getEntityData().func_74768_a("raidZ", province.getCenterPosZ() + rand.nextInt(33) - 16);
            creature.field_70133_I = true;
            creature.func_70624_b((EntityLivingBase)p);
            creature.func_70107_b((double)bsp.func_177958_n() + 0.5, (double)bsp.func_177956_o() + 0.1, (double)bsp.func_177952_p() + 0.5);
            w.func_72838_d((Entity)creature);
            creature.field_70175_ag = true;
            creature.func_70014_b(new NBTTagCompound());
        }
    }

    public void spawnWolves(World w, BlockPos banditSpawnPos, int rep, EntityPlayer player, Province province) {
        for (int i = rand.nextInt(MathHelper.func_76125_a((int)((Math.abs(rep) + 500) / 200), (int)2, (int)9)) + 3; i > 0; --i) {
            EntityWolfRaider creature = new EntityWolfRaider(w, (province.getCenterPosX() + player.func_180425_c().func_177958_n()) / 2, (province.getCenterPosZ() + player.func_180425_c().func_177952_p()) / 2);
            creature.getEntityData().func_74768_a("despawnTimer", 100);
            creature.getEntityData().func_74776_a("raidSpeed", 1.0f);
            creature.getEntityData().func_74768_a("raidX", province.getCenterPosX() + rand.nextInt(33) - 16);
            creature.getEntityData().func_74768_a("raidZ", province.getCenterPosZ() + rand.nextInt(33) - 16);
            creature.field_70133_I = true;
            creature.func_70624_b((EntityLivingBase)player);
            creature.func_70107_b((double)banditSpawnPos.func_177958_n() + 0.5, (double)banditSpawnPos.func_177956_o() + 0.1, (double)banditSpawnPos.func_177952_p() + 0.5);
            w.func_72838_d((Entity)creature);
            creature.field_70175_ag = true;
        }
    }

    public boolean spawnRaider(ArrayList<ToroQuestConfiguration.Raider> r, int rep, BlockPos bsp, Province province, EntityPlayer p, World w, boolean isNightTime) {
        ArrayList<ToroQuestConfiguration.Raider> raiderList = r;
        Collections.shuffle(raiderList);
        for (ToroQuestConfiguration.Raider raider : raiderList) {
            int count;
            if (raider.minReputationRequired > rep || (!isNightTime || raider.timeType.equals("day")) && (isNightTime || raider.timeType.equals("night"))) continue;
            for (int i = count = MathHelper.func_76125_a((int)(((randomAmount = Math.abs(rep - raider.minReputationRequired) / 100 + raider.maxSpawn - raider.minSpawn) > 0 ? rand.nextInt(randomAmount) : 0) + raider.minSpawn), (int)raider.minSpawn, (int)raider.maxSpawn); i > 0; --i) {
                String className = raider.entityResourceName;
                try {
                    EntityCreature creature = (EntityCreature)Class.forName(className).getConstructor(World.class).newInstance(w);
                    creature.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRaidDespawn(creature, (Integer)((province.getCenterPosX() + p.func_180425_c().func_177958_n()) / 2), (Integer)((province.getCenterPosZ() + p.func_180425_c().func_177952_p()) / 2), 1.0));
                    creature.func_110163_bv();
                    creature.getEntityData().func_74768_a("despawnTimer", 100);
                    creature.getEntityData().func_74776_a("raidSpeed", 1.0f);
                    creature.getEntityData().func_74768_a("raidX", province.getCenterPosX() + rand.nextInt(33) - 16);
                    creature.getEntityData().func_74768_a("raidZ", province.getCenterPosZ() + rand.nextInt(33) - 16);
                    creature.field_70133_I = true;
                    creature.func_70624_b((EntityLivingBase)p);
                    creature.func_70107_b((double)bsp.func_177958_n() + 0.5, (double)bsp.func_177956_o() + 0.1, (double)bsp.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)creature);
                    creature.field_70175_ag = true;
                    creature.func_70014_b(new NBTTagCompound());
                    continue;
                }
                catch (Exception error) {
                    System.err.println("Incorrect raider resource name: " + className);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onGuiOpen(PlayerInteractEvent.RightClickBlock event) {
        Vec3d vec = event.getHitVec();
        if (vec == null) {
            return;
        }
        BlockPos pos = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        Block block = event.getWorld().func_180495_p(pos).func_177230_c();
        if (block == null) {
            return;
        }
        if (block != Blocks.field_150447_bR) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        Province province = CivilizationUtil.getProvinceAt(event.getWorld(), player.field_70176_ah, player.field_70164_aj);
        if (province == null) {
            return;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        if (rep >= 250 || !ToroQuestConfiguration.loseReputationForBlockGrief || player.func_70644_a(MobEffects.field_76441_p)) {
            return;
        }
        boolean witnessed = this.villagersReportCrime(event.getWorld(), player);
        List help = player.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(@Nullable EntityToroNpc entity) {
                return true;
            }
        });
        Collections.shuffle(help);
        boolean flag = false;
        for (EntityToroNpc entity : help) {
            if (!entity.func_70685_l((Entity)player)) continue;
            witnessed = true;
            entity.func_70661_as().func_75497_a((Entity)player, 0.6);
            entity.setAnnoyed(player);
            entity.func_70624_b((EntityLivingBase)player);
            if (flag) continue;
            flag = true;
            entity.chat(entity, player, "steal", null);
        }
        if (witnessed) {
            EventHandlers.reportCrimeRep(player, province, -ToroQuestConfiguration.expensiveRepLoss);
        }
    }

    public static int randomSpawnDistance(int num) {
        Random rand = new Random();
        int result = rand.nextInt(num / 2) + num;
        if (rand.nextBoolean()) {
            result = -result;
        }
        return result;
    }

    private void spawnFugitives(World world) {
        if (world.field_72995_K) {
            return;
        }
        try {
            List players = world.field_73010_i;
            Collections.shuffle(players);
            int tries = 3;
            while (tries > 0) {
                --tries;
                for (EntityPlayer player : players) {
                    int localFugitiveCount;
                    Province province;
                    if (world.field_73011_w.getDimension() != 0 || (province = CivilizationUtil.getProvinceAt(world, player.field_70176_ah, player.field_70164_aj)) == null) continue;
                    int villageCenterX = province.getCenterPosX();
                    int villageCenterZ = province.getCenterPosZ();
                    double angle = rand.nextDouble() * Math.PI * 2.0;
                    int range = rand.nextInt(64);
                    int x = (int)(Math.cos(angle) * (double)range);
                    int z = (int)(Math.sin(angle) * (double)range);
                    BlockPos loc = new BlockPos(x += villageCenterX, MAX_SPAWN_HEIGHT, z += villageCenterZ);
                    BlockPos spawnPos = EventHandlers.findSpawnLocationFrom(world, loc);
                    if (spawnPos == null || !world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(spawnPos).func_72314_b(20.0, 10.0, 20.0)).isEmpty() || (localFugitiveCount = world.func_72872_a(EntityFugitive.class, new AxisAlignedBB(spawnPos).func_72314_b(90.0, 45.0, 90.0)).size()) > 3) continue;
                    if (localFugitiveCount == 3) {
                        if (!rand.nextBoolean()) continue;
                        this.spawnFugitive(world, spawnPos, player);
                        continue;
                    }
                    if (localFugitiveCount < 1) {
                        this.spawnFugitive(world, spawnPos, player);
                    }
                    this.spawnFugitive(world, spawnPos, player);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR SPAWNING EntityFugitive: " + e);
            return;
        }
    }

    public void spawnFugitive(World world, BlockPos spawnPos, EntityPlayer player) {
        EntityFugitive e = new EntityFugitive(world);
        e.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)e);
        e.field_70133_I = true;
        e.func_70624_b((EntityLivingBase)player);
    }

    public static BlockPos findSpawnLocationFrom(World world, BlockPos spawnPos) {
        boolean[] airSpace = new boolean[]{false, false};
        for (int j = 0; j <= 6; ++j) {
            for (int i = 0; i <= SPAWN_RANGE; ++i) {
                IBlockState blockState = world.func_180495_p(spawnPos);
                if (EventHandlers.isAir(blockState)) {
                    if (airSpace[0]) {
                        airSpace[1] = true;
                    } else {
                        airSpace[0] = true;
                    }
                } else {
                    if (EventHandlers.isStructureBlock(blockState) || EventHandlers.isLiquid(blockState)) break;
                    if (EventHandlers.isGroundBlock(blockState)) {
                        if (airSpace[0] && airSpace[1]) {
                            return spawnPos.func_177984_a();
                        }
                        airSpace[0] = false;
                        airSpace[1] = false;
                    } else {
                        airSpace[0] = false;
                        airSpace[1] = false;
                    }
                }
                spawnPos = spawnPos.func_177977_b();
            }
            spawnPos = spawnPos.func_177982_a(j * 2 * (rand.nextBoolean() ? 1 : -1), 0, j * 2 * (rand.nextBoolean() ? 1 : -1));
        }
        return null;
    }

    public static BlockPos findTeleportLocationFrom(World world, BlockPos pos) {
        boolean[] airSpace = new boolean[]{false, false};
        block0: for (int j = 0; j < 16; ++j) {
            BlockPos spawnPos = new BlockPos(pos.func_177958_n() + rand.nextInt(32) + j * 2 * (rand.nextBoolean() ? 1 : -1), MAX_SPAWN_HEIGHT, pos.func_177952_p() + rand.nextInt(32) + j * 2 * (rand.nextBoolean() ? 1 : -1));
            for (int i = 0; i < SPAWN_RANGE; ++i) {
                IBlockState blockState = world.func_180495_p(spawnPos);
                if (EventHandlers.isAir(blockState)) {
                    if (airSpace[0]) {
                        airSpace[1] = true;
                    } else {
                        airSpace[0] = true;
                    }
                } else {
                    if (EventHandlers.isStructureBlock(blockState) || EventHandlers.isLiquid(blockState)) continue block0;
                    if (EventHandlers.isGroundBlock(blockState)) {
                        if (airSpace[0] && airSpace[1]) {
                            return spawnPos.func_177984_a();
                        }
                        airSpace[0] = false;
                        airSpace[1] = false;
                    } else {
                        airSpace[0] = false;
                        airSpace[1] = false;
                    }
                }
                spawnPos = spawnPos.func_177977_b();
            }
        }
        return null;
    }

    public static BlockPos findSpawnSurface(World world, BlockPos pos) {
        pos = pos.func_177981_b(64);
        boolean[] airSpace = new boolean[]{false, false};
        for (int yOffset = 64; yOffset > 0; --yOffset) {
            IBlockState blockState = world.func_180495_p(pos);
            if (EventHandlers.isAir(blockState)) {
                if (airSpace[0]) {
                    airSpace[1] = true;
                } else {
                    airSpace[0] = true;
                }
            } else {
                if (EventHandlers.isLiquid(blockState)) break;
                if (!(blockState.func_177230_c() instanceof BlockAir)) {
                    if (airSpace[0] && airSpace[1]) {
                        return pos.func_177984_a();
                    }
                    airSpace[0] = false;
                    airSpace[1] = false;
                } else {
                    airSpace[0] = false;
                    airSpace[1] = false;
                }
            }
            pos = pos.func_177977_b();
        }
        return null;
    }

    protected static boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockLiquid;
    }

    public static boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockLeaves || blockState.func_177230_c() instanceof BlockLog || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    public static boolean isAir(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isStructureBlock(IBlockState blockState) {
        return !blockState.func_177230_c().func_176223_P().func_185917_h() || blockState.func_177230_c() instanceof BlockLeaves || blockState.func_177230_c().func_176223_P() == Blocks.field_150325_L.func_176223_P() || blockState.func_177230_c().func_176223_P() == Blocks.field_192443_dR.func_176223_P() || blockState.func_177230_c().func_176223_P() == Blocks.field_150417_aV.func_176223_P() || blockState.func_177230_c() instanceof BlockPlanks || blockState.func_177230_c() instanceof BlockFire;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ItemStack randomStolenItem(World world, Province province) {
        if (world == null) {
            return null;
        }
        CivilizationType civ = null;
        if (province == null) {
            province = QuestBase.chooseRandomProvince(null, world, false);
            if (province == null) return null;
            civ = province.civilization;
        } else {
            civ = province.civilization;
        }
        if (civ == null) {
            return null;
        }
        ItemStack stolenItem = null;
        switch (civ) {
            case FIRE: {
                stolenItem = new ItemStack(Item.func_111206_d((String)"toroquest:artifact_red"));
                break;
            }
            case MOON: {
                stolenItem = new ItemStack(Item.func_111206_d((String)"toroquest:artifact_black"));
                break;
            }
            case EARTH: {
                stolenItem = new ItemStack(Item.func_111206_d((String)"toroquest:artifact_green"));
                break;
            }
            case WATER: {
                stolenItem = new ItemStack(Item.func_111206_d((String)"toroquest:artifact_blue"));
                break;
            }
            case WIND: {
                stolenItem = new ItemStack(Item.func_111206_d((String)"toroquest:artifact_brown"));
                break;
            }
            case SUN: {
                stolenItem = new ItemStack(Item.func_111206_d((String)"toroquest:artifact_yellow"));
                break;
            }
            default: {
                return null;
            }
        }
        if (stolenItem.func_77973_b() == null) {
            return null;
        }
        if (!stolenItem.func_77942_o()) {
            stolenItem.func_77982_d(new NBTTagCompound());
        }
        stolenItem.func_77978_p().func_74778_a("civilizationName", civ.name());
        stolenItem.func_77978_p().func_74757_a("isStolen", true);
        return stolenItem;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (world == null || entity == null) {
            return;
        }
        if (entity instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)entity;
            if (entity.getEntityData().func_74764_b("despawnTimer")) {
                try {
                    creature.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRaidDespawn(creature, (Integer)creature.getEntityData().func_74762_e("raidX"), (Integer)creature.getEntityData().func_74762_e("raidZ"), (double)creature.getEntityData().func_74760_g("raidSpeed")));
                    creature.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget(creature, EntityVillager.class, false));
                    creature.func_110163_bv();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (creature instanceof IMob) {
                int creaturePosX = creature.func_180425_c().func_177958_n();
                int creaturePosZ = creature.func_180425_c().func_177952_p();
                Province province = CivilizationUtil.getProvinceAt(creature.func_130014_f_(), creaturePosX / 16, creaturePosZ / 16);
                if (province != null) {
                    if (creature instanceof EntityCreeper || creature instanceof EntityEnderman) {
                        creature.func_70106_y();
                        event.setCanceled(true);
                        return;
                    }
                    int villageCenterX = province.getCenterPosX();
                    int villageCenterZ = province.getCenterPosZ();
                    if (!creature.func_104002_bU()) {
                        int allowedDistance;
                        int n = allowedDistance = creature instanceof EntityZombie ? ToroQuestConfiguration.disableZombieSpawningNearVillage : ToroQuestConfiguration.disableMobSpawningNearVillage;
                        if (creature.func_180425_c().func_177956_o() >= 40 && Math.abs(villageCenterX - creaturePosX) < allowedDistance && Math.abs(villageCenterZ - creaturePosZ) < allowedDistance) {
                            creature.func_70106_y();
                            event.setCanceled(true);
                            return;
                        }
                    }
                }
                if (creature.getClass() == EntityZombie.class && !(creature instanceof EntityZombieRaider) && !(creature instanceof EntityZombieVillagerRaider) && ToroQuestConfiguration.zombieAttackVillageChance > 0 && ToroQuestConfiguration.zombieAttackVillageChance > rand.nextInt(100)) {
                    if (province == null && (province = CivilizationUtil.getProvinceAt(world, creaturePosX / 16 + 2, creaturePosZ / 16 + 2)) == null && (province = CivilizationUtil.getProvinceAt(world, creaturePosX / 16 + 2, creaturePosZ / 16 - 2)) == null && (province = CivilizationUtil.getProvinceAt(world, creaturePosX / 16 - 2, creaturePosZ / 16 + 2)) == null) {
                        province = CivilizationUtil.getProvinceAt(world, creaturePosX / 16 - 2, creaturePosZ / 16 - 2);
                    }
                    if (province != null) {
                        if (creature instanceof EntityZombieVillager || ToroQuestConfiguration.zombieRaiderVillagerChance > 0 && ToroQuestConfiguration.zombieRaiderVillagerChance > rand.nextInt(100)) {
                            if (!world.field_72995_K) {
                                EntityZombieVillagerRaider zombie = new EntityZombieVillagerRaider(world, province.getCenterPosX(), province.getCenterPosZ());
                                BlockPos pos = creature.func_180425_c();
                                zombie.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                world.func_72838_d((Entity)zombie);
                            }
                            creature.func_70606_j(0.0f);
                            creature.func_70106_y();
                            event.setCanceled(true);
                        } else {
                            if (!world.field_72995_K) {
                                EntityZombieRaider zombie = new EntityZombieRaider(world, province.getCenterPosX(), province.getCenterPosZ());
                                BlockPos pos = creature.func_180425_c();
                                zombie.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                world.func_72838_d((Entity)zombie);
                            }
                            creature.func_70606_j(0.0f);
                            creature.func_70106_y();
                            event.setCanceled(true);
                        }
                    }
                }
                return;
            }
            if (creature instanceof EntityVillager) {
                if (!(creature instanceof EntityToroVillager) && !(creature instanceof EntityFugitive)) {
                    Province province;
                    if (ToroQuestConfiguration.useDefaultVillagers) {
                        return;
                    }
                    if (ToroQuestConfiguration.useDefaultVillagersOutsideOfProvince && (province = CivilizationUtil.getProvinceAt(creature.func_130014_f_(), creature.func_180425_c().func_177958_n() / 16, creature.func_180425_c().func_177952_p() / 16)) == null) {
                        return;
                    }
                    EntityVillager villager = (EntityVillager)creature;
                    String jobName = villager.getProfessionForge().getCareer(0).getName();
                    boolean flag = false;
                    for (ToroQuestConfiguration.Trade trade : ToroQuestConfiguration.trades) {
                        if (!jobName.equals(trade.job)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) {
                        if (!world.field_72995_K) {
                            BlockPos pos;
                            EntityToroVillager newEntity;
                            if (world.field_73012_v.nextInt(100) < ToroQuestConfiguration.shopKeeperSpawnChance) {
                                newEntity = new EntityShopkeeper(world);
                                pos = creature.func_180425_c();
                                newEntity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                newEntity.func_70873_a(villager.func_70874_b());
                                world.func_72838_d((Entity)newEntity);
                            } else {
                                newEntity = new EntityToroVillager(world, villager.func_70946_n());
                                pos = creature.func_180425_c();
                                newEntity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                                if (world.field_73012_v.nextInt(3) == 0) {
                                    newEntity.func_70873_a(-10000 * (world.field_73012_v.nextInt(6) + 1));
                                } else {
                                    newEntity.func_70873_a(villager.func_70874_b());
                                }
                                world.func_72838_d((Entity)newEntity);
                            }
                        }
                        villager.func_70606_j(0.0f);
                        villager.func_70106_y();
                        event.setCanceled(true);
                    }
                }
                return;
            }
            if (event.getEntity() instanceof EntityIronGolem && !(event.getEntity() instanceof IMob)) {
                for (String tag : event.getEntity().func_184216_O()) {
                    if (!tag.equals("initialSpawn")) continue;
                    return;
                }
                event.getEntity().func_184211_a("initialSpawn");
                Province province = CivilizationUtil.getProvinceAt(creature.func_130014_f_(), event.getEntity().func_180425_c().func_177958_n() / 16, event.getEntity().func_180425_c().func_177952_p() / 16);
                if (province != null) {
                    List players = event.getEntity().field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(event.getEntity().func_180425_c()).func_72314_b(5.0, 5.0, 5.0), (Predicate)new Predicate<EntityPlayer>(){

                        public boolean apply(@Nullable EntityPlayer entity) {
                            return true;
                        }
                    });
                    for (EntityPlayer player : players) {
                        EventHandlers.adjustPlayerRep(player, province.getCiv(), ToroQuestConfiguration.recruitGuardRepGain);
                        player.func_146105_b((ITextComponent)new TextComponentString("Golem Constructed!"), true);
                        event.getEntity().func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                        try {
                            QuestRecruit.INSTANCE.onRecruit(player);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleWorldTick(TickEvent.ClientTickEvent event) {
        TaskRunner.run();
    }

    @SubscribeEvent
    public void crystalAttackFrom(AttackEntityEvent event) {
        List eyes;
        Entity entityCrystal = event.getTarget();
        if (entityCrystal != null && entityCrystal instanceof EntityEnderCrystal && (eyes = entityCrystal.field_70170_p.func_72872_a(EntityMonolithEye.class, new AxisAlignedBB(entityCrystal.func_180425_c()).func_72314_b(96.0, 64.0, 96.0))).size() > 0 && event != null && !(event.getEntity() instanceof EntityMonolithEye)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void potionAdded(PotionEvent.PotionAddedEvent event) {
        if (event.getEntityLiving() instanceof EntityWitch) {
            EntityWitch w0 = (EntityWitch)event.getEntityLiving();
            event.getEntityLiving().func_70674_bp();
            if (w0.func_70638_az() instanceof EntityWitch) {
                EntityWitch w1 = (EntityWitch)w0.func_70638_az();
                w0.func_70624_b(null);
                w1.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void crystalProjectileImpact(ProjectileImpactEvent event) {
        EntityArrow arrow;
        Entity entity;
        if (event == null || event.getEntity() == null) {
            return;
        }
        if (event.getEntity() instanceof EntityPotion && !event.getEntity().field_70170_p.field_72995_K) {
            EntityPotion p = (EntityPotion)event.getEntity();
            BlockPos pos = event.getRayTraceResult().func_178782_a();
            if (pos == null) {
                pos = event.getRayTraceResult().field_72308_g.func_180425_c();
            }
            if (pos != null) {
                if (event.getEntity() instanceof EntitySmartArrow) {
                    if (event.getEntity().func_130014_f_().func_180495_p(pos).func_177230_c() instanceof BlockFence || event.getEntity().func_130014_f_().func_180495_p(pos).func_177230_c() instanceof BlockTrapDoor) {
                        event.setCanceled(true);
                    }
                } else {
                    if (p.func_85052_h() instanceof EntitySentry) {
                        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72314_b(4.0, 2.0, 4.0);
                        List list = event.getEntity().field_70170_p.func_72872_a(EntitySentry.class, axisalignedbb);
                        for (EntitySentry entitylivingbase : list) {
                            if (!(entitylivingbase instanceof EntitySentry) || entitylivingbase instanceof EntityOrc) continue;
                            entitylivingbase.potionImmunity = (short)2;
                        }
                        return;
                    }
                    if (p.func_85052_h() instanceof EntityPlayer || p.func_85052_h() == null) {
                        List villagers;
                        Province province = CivilizationUtil.getProvinceAt(event.getEntity().field_70170_p, pos.func_177958_n() / 16, pos.func_177952_p() / 16);
                        if (province == null) {
                            return;
                        }
                        EntityPlayer player = (EntityPlayer)p.func_85052_h();
                        if (player == null && (player = p.field_70170_p.func_72890_a((Entity)p, 12.0)) == null) {
                            return;
                        }
                        String potion = p.func_184543_l().func_151000_E().toString();
                        for (String s : ToroQuestConfiguration.safePotionList) {
                            if (!potion.contains(s)) continue;
                            return;
                        }
                        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72314_b(4.0, 2.0, 4.0);
                        List guards = event.getEntity().field_70170_p.func_72872_a(EntityGuard.class, axisalignedbb);
                        CivilizationType civ = province.getCiv();
                        if (civ == null) {
                            return;
                        }
                        if (!guards.isEmpty()) {
                            for (EntityLivingBase guard : guards) {
                                if (!(guard instanceof EntityToroVillager)) continue;
                                ((EntityToroVillager)guard).setUnderAttack(p.func_85052_h());
                            }
                            EventHandlers.adjustPlayerRep((EntityPlayer)p.func_85052_h(), civ, -guards.size() * 10);
                        }
                        if (!(villagers = event.getEntity().field_70170_p.func_72872_a(EntityVillager.class, axisalignedbb)).isEmpty()) {
                            for (EntityLivingBase villager : villagers) {
                                if (!(villager instanceof EntityToroVillager)) continue;
                                ((EntityToroVillager)villager).setUnderAttack(p.func_85052_h());
                            }
                            EventHandlers.adjustPlayerRep((EntityPlayer)p.func_85052_h(), civ, -villagers.size() * 10);
                        }
                        return;
                    }
                }
            }
        }
        if ((entity = event.getRayTraceResult().field_72308_g) == null) {
            return;
        }
        if (entity instanceof EntityEnderCrystal) {
            List eyes;
            if (!(event.getEntity() instanceof EntityFireball) && (eyes = entity.field_70170_p.func_72872_a(EntityMonolithEye.class, new AxisAlignedBB(entity.func_180425_c()).func_72314_b(96.0, 64.0, 96.0))).size() > 0 && event.getEntity() != null) {
                event.setCanceled(true);
                return;
            }
        } else if (entity instanceof EntityGuard) {
            if (event.getEntity() instanceof EntityArrow) {
                arrow = (EntityArrow)event.getEntity();
                if (arrow.field_70250_c instanceof EntityGuard) {
                    event.setCanceled(true);
                    return;
                }
            }
        } else if (entity instanceof EntityToroMob) {
            if (event.getEntity() instanceof EntityArrow) {
                arrow = (EntityArrow)event.getEntity();
                if (arrow.field_70250_c instanceof EntityToroMob && arrow.field_70250_c.getClass() == entity.getClass()) {
                    event.setCanceled(true);
                    return;
                }
            }
        } else if (entity instanceof EntityIronGolem && event.getEntity() instanceof EntityArrow) {
            arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityGuard) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void livingHurtEvent(LivingHurtEvent event) {
        EntityLivingBase victim = event.getEntityLiving();
        EntityLivingBase attacker = this.getAttacker(event);
        if (victim == null || attacker == null) {
            return;
        }
        if (victim instanceof EntityVillager && !(victim instanceof EntityFugitive)) {
            EntityVillager villager = (EntityVillager)victim;
            if (villager.func_70638_az() != attacker && villager.func_70643_av() != attacker && !villager.func_130014_f_().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(villager.func_180425_c()).func_72314_b(3.0, 3.0, 3.0), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(@Nullable EntityLivingBase entity) {
                    return entity instanceof IMob || entity instanceof EntityMob;
                }
            }).isEmpty()) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            if (attacker instanceof EntityToroNpc || attacker instanceof EntityVillager) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            if (attacker instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)attacker;
                Province province = CivilizationUtil.getProvinceAt(player.field_70170_p, player.field_70176_ah, player.field_70164_aj);
                if (province == null) {
                    province = CivilizationUtil.getProvinceAt(villager.field_70170_p, villager.field_70176_ah, villager.field_70164_aj);
                }
                if (province != null) {
                    EventHandlers.adjustPlayerRep(player, province.civilization, -((int)MathHelper.func_76131_a((float)(event.getAmount() * 4.0f), (float)5.0f, (float)(villager.func_110143_aJ() * 4.0f))));
                }
            }
            if (villager instanceof EntityToroVillager) {
                ((EntityToroVillager)villager).callForHelp(attacker, true);
            } else {
                boolean flag = false;
                List guards = villager.field_70170_p.func_175647_a(EntityGuard.class, new AxisAlignedBB(villager.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityGuard>(){

                    public boolean apply(@Nullable EntityGuard entity) {
                        return true;
                    }
                });
                for (EntityGuard guard : guards) {
                    if (guard.func_70638_az() != null) continue;
                    villager.func_70661_as().func_75497_a((Entity)guard, (double)0.7f);
                    if (attacker instanceof EntityPlayer) {
                        guard.setAnnoyed((EntityPlayer)attacker);
                        if (!flag && guard.actionReady() && (double)guard.func_70032_d((Entity)attacker) <= 8.0) {
                            guard.chat((EntityPlayer)attacker, "attackvillager", null);
                            flag = true;
                        }
                    }
                    guard.func_70624_b(attacker);
                }
            }
        } else if (victim instanceof EntityAnimal) {
            if (victim instanceof EntityMule && attacker instanceof EntityPlayer) {
                List caravans = victim.func_130014_f_().func_72872_a(EntityCaravan.class, victim.func_174813_aQ().func_72314_b(20.0, 10.0, 20.0));
                for (EntityCaravan caravan : caravans) {
                    caravan.setUnderAttack(attacker);
                }
            }
        } else if (victim instanceof EntityIronGolem && attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            Province province = CivilizationUtil.getProvinceAt(player.field_70170_p, player.field_70176_ah, player.field_70164_aj);
            if (province == null) {
                province = CivilizationUtil.getProvinceAt(victim.field_70170_p, victim.field_70176_ah, victim.field_70164_aj);
            }
            if (province != null) {
                int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
                if (rep < 100 && ToroQuestConfiguration.loseReputationForAnimalGrief) {
                    boolean witnessed = this.villagersReportCrime(player.func_130014_f_(), player);
                    List help = player.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

                        public boolean apply(@Nullable EntityToroNpc entity) {
                            return true;
                        }
                    });
                    Collections.shuffle(help);
                    boolean flag = false;
                    for (EntityToroNpc entity : help) {
                        if (!entity.func_70685_l((Entity)player)) continue;
                        witnessed = true;
                        entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                        if (entity.isAnnoyed()) {
                            entity.func_70624_b((EntityLivingBase)player);
                        }
                        entity.setAnnoyed(player);
                        if (flag || !entity.actionReady()) continue;
                        flag = true;
                        entity.chat(entity, player, "golem", null);
                    }
                    if (witnessed) {
                        EventHandlers.reportCrimeRep(player, province, -1);
                    }
                } else {
                    List help = player.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

                        public boolean apply(@Nullable EntityToroNpc entity) {
                            return true;
                        }
                    });
                    Collections.shuffle(help);
                    boolean flag = false;
                    for (EntityToroNpc entity : help) {
                        if (!entity.func_70685_l((Entity)player)) continue;
                        entity.func_70661_as().func_75497_a((Entity)player, 0.6);
                        if (flag || !entity.actionReady()) continue;
                        flag = true;
                        entity.chat(entity, player, "golem", null);
                    }
                }
            }
        }
        if (attacker instanceof EntityGuard) {
            if (victim instanceof EntityCreeper) {
                victim.func_70606_j(0.0f);
            } else {
                if (victim instanceof EntityIronGolem || victim instanceof EntityVillager || victim instanceof EntityToroNpc) {
                    ((EntityGuard)attacker).func_70624_b(null);
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                    return;
                }
                if (victim instanceof EntityPlayer) {
                    event.setAmount(event.getAmount() * ToroQuestConfiguration.guardDamageBaseMultiplierToPlayers * this.rngDamageMultiplier());
                    return;
                }
                Province province = CivilizationUtil.getProvinceAt(attacker.func_130014_f_(), attacker.field_70176_ah, attacker.field_70164_aj);
                if (province == null || !victim.func_184222_aU() || victim.func_110138_aP() >= (float)ToroQuestConfiguration.minBaseHealthToBeConsideredBossMob) {
                    event.setAmount(event.getAmount() * ToroQuestConfiguration.guardDamageBaseMultiplierToMobsOutsideProvinceOrToBosses);
                    return;
                }
                event.setAmount(event.getAmount() * ToroQuestConfiguration.guardDamageBaseMultiplierToMobs * this.rngDamageMultiplier());
                CivilizationDataAccessor worldData = CivilizationsWorldSaveData.get(attacker.field_70170_p);
                if (worldData == null) {
                    return;
                }
                if (worldData.hasTrophyTitan(province.id)) {
                    event.setAmount(event.getAmount() * ToroQuestConfiguration.trophyTitanAdditionalGuardDamageMulitiplier);
                }
            }
        } else if (attacker instanceof EntityToroMob) {
            if (attacker instanceof EntityOrc) {
                event.setAmount(event.getAmount() * this.rngDamageMultiplier() * (event.getSource() != null && event.getSource().func_82725_o() ? this.damageMultiplier(ToroQuestConfiguration.banditAttackDamage, attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()) : 1.0f));
            } else {
                event.setAmount(event.getAmount() * this.rngDamageMultiplier() * (event.getSource() != null && event.getSource().func_82725_o() ? this.damageMultiplier(ToroQuestConfiguration.banditAttackDamage, attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()) : 1.0f));
            }
        } else if (attacker instanceof EntityIronGolem && (victim instanceof EntityToroNpc || victim instanceof EntityVillager)) {
            ((EntityIronGolem)attacker).func_70624_b(null);
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    protected float rngDamageMultiplier() {
        return 1.0f + (rand.nextFloat() - 0.5f) / 20.0f;
    }

    protected float damageMultiplier(float base, double current) {
        if (current <= 0.0 || base <= 0.0f) {
            return 1.0f;
        }
        float amount = (float)(1.0 + (current - (double)base) / (double)base);
        return amount > 0.0f ? amount : 0.0f;
    }

    private EntityLivingBase getAttacker(LivingHurtEvent event) {
        try {
            return (EntityLivingBase)event.getSource().func_76346_g();
        }
        catch (Exception e) {
            return null;
        }
    }

    @SubscribeEvent
    public void death(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player == null) {
                return;
            }
            if (!ToroQuestConfiguration.enderIdolTeleport) {
                SavedInventory savedInventory = new SavedInventory();
                boolean hasEnderIdol = false;
                int m = 0;
                for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                    if (!hasEnderIdol && itemStack.func_77973_b().equals(Item.func_111206_d((String)"toroquest:ender_idol"))) {
                        player.field_71071_by.field_70462_a.set(m, (Object)ItemStack.field_190927_a);
                        savedInventory.experienceTotal = 0 + player.field_71067_cb;
                        hasEnderIdol = true;
                    } else {
                        savedInventory.mainInventory.set(m, (Object)itemStack);
                    }
                    ++m;
                }
                int a = 0;
                for (ItemStack itemStack : player.field_71071_by.field_70460_b) {
                    savedInventory.armorInventory.set(a, (Object)itemStack);
                    ++a;
                }
                if (!hasEnderIdol && ((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b().equals(Item.func_111206_d((String)"toroquest:ender_idol"))) {
                    player.field_71071_by.field_184439_c.set(0, (Object)ItemStack.field_190927_a);
                    savedInventory.experienceTotal = 0 + player.field_71067_cb;
                    hasEnderIdol = true;
                } else {
                    savedInventory.offHandInventory.set(0, player.field_71071_by.field_184439_c.get(0));
                }
                if (hasEnderIdol) {
                    player.field_71071_by.func_174888_l();
                    player.func_71053_j();
                    player.field_71071_by.func_174886_c(player);
                    player.field_71067_cb = 0;
                    this.stack.put(player.func_70005_c_(), savedInventory);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193777_bb, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    event.setCanceled(true);
                } else {
                    savedInventory = null;
                    try {
                        this.stack.remove(player.func_70005_c_());
                    }
                    catch (Exception exception) {}
                }
            } else {
                boolean hasEnderIdol = false;
                int m = 0;
                for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                    if (!hasEnderIdol && itemStack.func_77973_b().equals(Item.func_111206_d((String)"toroquest:ender_idol"))) {
                        player.field_71071_by.field_70462_a.set(m, (Object)ItemStack.field_190927_a);
                        hasEnderIdol = true;
                    }
                    ++m;
                }
                if (!hasEnderIdol && ((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b().equals(Item.func_111206_d((String)"toroquest:ender_idol"))) {
                    player.field_71071_by.field_184439_c.set(0, (Object)ItemStack.field_190927_a);
                    hasEnderIdol = true;
                }
                if (hasEnderIdol) {
                    player.func_71053_j();
                    player.field_71071_by.func_174886_c(player);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193777_bb, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_193777_bb, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    this.teleportRandomly(player);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193777_bb, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_193777_bb, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 30, 1, true, false));
                    player.func_70606_j(player.func_110138_aP());
                    event.setCanceled(true);
                }
            }
        } else if (event.getEntity() instanceof IMob || event.getEntity() instanceof EntityMob) {
            if (!(event.getEntity() instanceof EntityLivingBase)) {
                return;
            }
            EntityLivingBase mob = (EntityLivingBase)event.getEntity();
            DamageSource source = event.getSource();
            if (source == null) {
                return;
            }
            if (source.func_76346_g() == null) {
                return;
            }
            if (!(source.func_76346_g() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
            if (rand.nextInt(2000) <= ToroQuestConfiguration.artifactDropRate) {
                ItemStack item = EventHandlers.randomStolenItem(mob.field_70170_p, province);
                if (item == null) {
                    return;
                }
                mob.func_70099_a(item, 1.0f);
            }
        }
    }

    protected void teleportRandomly(EntityPlayer p) {
        BlockPos pos = EventHandlers.findTeleportLocationFrom(p.field_70170_p, p.func_180425_c());
        if (pos != null) {
            p.func_184595_k((double)(pos.func_177958_n() + (rand.nextBoolean() ? 8 : -8)), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + (rand.nextBoolean() ? 8 : -8)));
        }
    }

    @SubscribeEvent
    public void respawn(PlayerEvent.Clone event) {
        if (!ToroQuestConfiguration.enderIdolTeleport) {
            EntityPlayer player = event.getEntityPlayer();
            if (player == null) {
                return;
            }
            try {
                SavedInventory savedIventory = this.stack.get(player.func_70005_c_());
                int m = 0;
                for (ItemStack itemStack : savedIventory.mainInventory) {
                    player.field_71071_by.field_70462_a.set(m, (Object)itemStack);
                    ++m;
                }
                int a = 0;
                for (ItemStack itemStack : savedIventory.armorInventory) {
                    player.field_71071_by.field_70460_b.set(a, (Object)itemStack);
                    ++a;
                }
                player.field_71071_by.field_184439_c.set(0, savedIventory.offHandInventory.get(0));
                player.func_71023_q(savedIventory.experienceTotal);
                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 0.8f);
                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187532_aV, SoundCategory.PLAYERS, 0.8f, 0.8f);
                this.stack.remove(player.func_70005_c_());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class SavedInventory {
        NonNullList<ItemStack> mainInventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
        NonNullList<ItemStack> armorInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        NonNullList<ItemStack> offHandInventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        int experienceTotal;

        SavedInventory() {
        }
    }

    public static class SyncTask
    implements Runnable {
        @Override
        public void run() {
            ToroQuestPacketHandler.INSTANCE.sendToServer((IMessage)new MessageRequestPlayerCivilizationSync());
        }
    }

    public static class PlayerCivilizationCapabilityProvider
    implements ICapabilityProvider {
        @CapabilityInject(value=PlayerCivilizationCapability.class)
        public static final Capability<PlayerCivilizationCapability> CAP = null;
        private PlayerCivilizationCapability instance;

        public PlayerCivilizationCapabilityProvider(EntityPlayer player) {
            this.instance = new PlayerCivilizationCapabilityImpl(player);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (CAP != null && capability == CAP) {
                return (T)PlayerCivilizationCapabilityImpl.INSTANCE.cast((Object)this.instance);
            }
            return null;
        }
    }
}

