/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.config.Configuration;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.nbt.NBTTagCompound;

public class FakePlayerData
implements IStageData {
    public static final FakePlayerData DEFAULT = new FakePlayerData("DEFAULT", Collections.emptySet());
    private Set<String> stages = new HashSet<String>();
    private String fakePlayerName;

    public FakePlayerData(String fakePlayerName, Set<String> stages) {
        this.stages.addAll(stages);
        this.fakePlayerName = fakePlayerName;
    }

    @Override
    public Collection<String> getStages() {
        return this.stages;
    }

    @Override
    public boolean hasStage(@Nonnull String stage) {
        boolean hasStage = this.stages.contains(stage);
        if (Configuration.debug.logDebug && !hasStage) {
            GameStages.LOG.info("Fake player {} does not have stage {}. Thay do have {}.", new Object[]{this.fakePlayerName, stage, this.stages});
        }
        return hasStage;
    }

    @Override
    public void addStage(@Nonnull String stage) {
    }

    @Override
    public void removeStage(@Nonnull String stage) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public NBTTagCompound writeToNBT() {
        return null;
    }

    public String getFakePlayerName() {
        return this.fakePlayerName;
    }
}

