/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages;

import java.util.Arrays;
import java.util.Collection;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.config.Configuration;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.darkhax.gamestages.packet.PacketSyncClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameStageHelper {
    public static boolean hasStage(EntityPlayer player, String stage) {
        return GameStageHelper.hasStage(player, GameStageHelper.getPlayerData(player), stage);
    }

    public static boolean hasAnyOf(EntityPlayer player, String ... stages) {
        return GameStageHelper.hasAnyOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAnyOf(EntityPlayer player, Collection<String> stages) {
        return GameStageHelper.hasAnyOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAnyOf(EntityPlayer player, IStageData playerData, Collection<String> stages) {
        return stages.stream().anyMatch(stage -> GameStageHelper.hasStage(player, playerData, stage));
    }

    public static boolean hasAnyOf(EntityPlayer player, IStageData playerData, String ... stages) {
        return Arrays.stream(stages).anyMatch(stage -> GameStageHelper.hasStage(player, playerData, stage));
    }

    public static boolean hasAllOf(EntityPlayer player, String ... stages) {
        return GameStageHelper.hasAllOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAllOf(EntityPlayer player, Collection<String> stages) {
        return GameStageHelper.hasAllOf(player, GameStageHelper.getPlayerData(player), stages);
    }

    public static boolean hasAllOf(EntityPlayer player, IStageData playerData, Collection<String> stages) {
        return stages.stream().allMatch(stage -> GameStageHelper.hasStage(player, playerData, stage));
    }

    public static boolean hasAllOf(EntityPlayer player, IStageData playerData, String ... stages) {
        return Arrays.stream(stages).allMatch(stage -> GameStageHelper.hasStage(player, playerData, stage));
    }

    public static boolean hasStage(EntityPlayer player, IStageData data, String stage) {
        if (data != null) {
            GameStageEvent.Check event = new GameStageEvent.Check(player, stage, data.hasStage(stage));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.hasStage();
        }
        return false;
    }

    public static void addStage(EntityPlayer player, String stage) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Add(player, stage))) {
            GameStageHelper.getPlayerData(player).addStage(stage);
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Added(player, stage));
        }
    }

    public static void removeStage(EntityPlayer player, String stage) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Remove(player, stage))) {
            GameStageHelper.getPlayerData(player).removeStage(stage);
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Removed(player, stage));
        }
    }

    public static IStageData getPlayerData(EntityPlayer player) {
        if (player == null) {
            return GameStageSaveHandler.EMPTY_STAGE_DATA;
        }
        if (player instanceof FakePlayer) {
            return GameStageSaveHandler.getFakeData(player.func_70005_c_());
        }
        if (!player.field_70170_p.field_72995_K) {
            return GameStageSaveHandler.getPlayerData(player.getPersistentID());
        }
        return GameStages.proxy.getPlayerData(player);
    }

    public static void syncPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            GameStageHelper.syncPlayer((EntityPlayerMP)player);
        }
    }

    public static void syncPlayer(EntityPlayerMP player) {
        IStageData info = GameStageHelper.getPlayerData((EntityPlayer)player);
        if (Configuration.debug.logDebug) {
            GameStages.LOG.info("Syncing {} stages for {}.", new Object[]{info.getStages().size(), player.func_70005_c_()});
        }
        GameStages.NETWORK.sendTo((IMessage)new PacketSyncClient(info.getStages()), player);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static boolean clientHasStage(EntityPlayer player, String stage) {
        return GameStageHelper.hasStage(player, GameStageSaveHandler.clientData, stage);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static boolean clientHasAllOf(EntityPlayer player, String ... stages) {
        return Arrays.stream(stages).allMatch(stage -> GameStageHelper.hasStage(player, GameStageSaveHandler.clientData, stage));
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static boolean clientHasAllOf(EntityPlayer player, Collection<String> stages) {
        return stages.stream().allMatch(stage -> GameStageHelper.hasStage(player, GameStageSaveHandler.clientData, stage));
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static boolean clientHasAnyOf(EntityPlayer player, String ... stages) {
        return GameStageHelper.hasAnyOf(player, GameStageSaveHandler.clientData, stages);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static boolean clientHasAnyOf(EntityPlayer player, Collection<String> stages) {
        return GameStageHelper.hasAnyOf(player, GameStageSaveHandler.clientData, stages);
    }
}

