/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.futurefireproof.entity;

import com.invadermonky.futurefireproof.config.ConfigHandlerFF;
import com.invadermonky.futurefireproof.config.ModTags;
import com.invadermonky.futurefireproof.util.FireproofHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityFireproofItem
extends EntityItem {
    protected int lavaDecay;

    public EntityFireproofItem(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.field_70178_ae = true;
        this.lavaDecay = 0;
    }

    public EntityFireproofItem(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z, stack);
        this.field_70178_ae = true;
        this.lavaDecay = 0;
    }

    public EntityFireproofItem(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.lavaDecay = 0;
    }

    public EntityFireproofItem(World world, EntityItem entityItem, ItemStack stack) {
        this(world, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, stack);
        this.field_70159_w = entityItem.field_70159_w;
        this.field_70181_x = entityItem.field_70181_x;
        this.field_70179_y = entityItem.field_70179_y;
        NBTTagCompound tag = new NBTTagCompound();
        entityItem.func_189511_e(tag);
        this.func_70037_a(tag);
        this.lavaDecay = 0;
    }

    public void func_70071_h_() {
        if (this.func_92059_d().func_77973_b().onEntityItemUpdate((EntityItem)this)) {
            return;
        }
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        } else {
            double d5;
            double d4;
            double d3;
            double d6;
            boolean flag;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_184202_aL());
            }
            this.func_70030_z();
            if (this.field_145804_b > 0 && this.field_145804_b != Short.MAX_VALUE) {
                --this.field_145804_b;
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            double d0 = this.field_70159_w;
            double d1 = this.field_70181_x;
            double d2 = this.field_70179_y;
            boolean inLava = this.func_70055_a(Material.field_151587_i);
            boolean inFire = this.func_70055_a(Material.field_151581_o);
            ItemStack stack = this.func_92059_d();
            if (inLava) {
                this.floatInLava();
            } else if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.04;
            }
            if (!inLava && this.field_70122_E && !inFire) {
                this.lavaDecay = 0;
            }
            this.field_70145_X = this.field_70170_p.field_72995_K ? false : this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
            if ((flag || this.field_70173_aa % 25 == 0) && !this.field_70170_p.field_72995_K) {
                this.func_85054_d();
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f *= underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this);
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= (double)f;
            if (this.field_70122_E) {
                this.field_70181_x *= -0.5;
            }
            if (this.field_70292_b != Short.MIN_VALUE) {
                ++this.field_70292_b;
                this.lavaDecay += FireproofHelper.getLavaDecayRate(this);
            }
            this.func_70072_I();
            this.handleLavaMovement();
            if (!this.field_70170_p.field_72995_K && (d6 = (d3 = this.field_70159_w - d0) * d3 + (d4 = this.field_70181_x - d1) * d4 + (d5 = this.field_70179_y - d2) * d5) > 0.01) {
                this.field_70160_al = true;
            }
            if (!(this.field_70170_p.field_72995_K || this.field_70292_b < this.lifespan && this.lavaDecay < this.lifespan)) {
                int hook = ForgeEventFactory.onItemExpire((EntityItem)this, (ItemStack)stack);
                if (hook < 0) {
                    if (inFire || inLava) {
                        this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
                    }
                    this.func_70106_y();
                } else {
                    this.lifespan += hook;
                }
            }
            if (stack.func_190926_b()) {
                this.func_70106_y();
            }
        }
    }

    public void func_85054_d() {
        for (EntityFireproofItem fpItem : this.field_70170_p.func_72872_a(EntityFireproofItem.class, this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5))) {
            this.combineItems(fpItem);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.func_92059_d().func_190926_b()) {
            if (source.func_94541_c() && (this.func_92059_d().func_77973_b() == Items.field_151156_bN || ConfigHandlerFF.explosionImmunity)) {
                return false;
            }
            if (source.func_76347_k()) {
                return false;
            }
            if (ModTags.isIgnoredDamageType(source)) {
                return false;
            }
        }
        this.func_70018_K();
        this.field_70291_e = (int)((float)this.field_70291_e - amount);
        if (this.field_70291_e <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    protected void floatInLava() {
        this.field_70159_w *= 0.95;
        this.field_70181_x += this.field_70181_x < 0.06 ? 5.0E-4 : 0.0;
        this.field_70179_y *= 0.95;
    }

    protected boolean combineItems(EntityFireproofItem other) {
        if (other == this) {
            return false;
        }
        if (other.func_70089_S() && this.func_70089_S()) {
            ItemStack itemstack = this.func_92059_d();
            ItemStack itemstack1 = other.func_92059_d();
            if (this.field_145804_b != Short.MAX_VALUE && other.field_145804_b != Short.MAX_VALUE) {
                if (this.field_70292_b != Short.MIN_VALUE && other.field_70292_b != Short.MIN_VALUE) {
                    if (itemstack1.func_77973_b() != itemstack.func_77973_b()) {
                        return false;
                    }
                    if (itemstack1.func_77942_o() ^ itemstack.func_77942_o()) {
                        return false;
                    }
                    if (itemstack1.func_77942_o() && !itemstack1.func_77978_p().equals((Object)itemstack.func_77978_p())) {
                        return false;
                    }
                    if (itemstack1.func_77973_b() == null) {
                        return false;
                    }
                    if (itemstack1.func_77973_b().func_77614_k() && itemstack1.func_77960_j() != itemstack.func_77960_j()) {
                        return false;
                    }
                    if (itemstack1.func_190916_E() < itemstack.func_190916_E()) {
                        return other.combineItems(this);
                    }
                    if (itemstack1.func_190916_E() + itemstack.func_190916_E() > itemstack1.func_77976_d()) {
                        return false;
                    }
                    if (!itemstack.areCapsCompatible(itemstack1)) {
                        return false;
                    }
                    itemstack1.func_190917_f(itemstack.func_190916_E());
                    other.field_145804_b = Math.max(other.field_145804_b, this.field_145804_b);
                    other.field_70292_b = Math.min(other.field_70292_b, this.field_70292_b);
                    other.lavaDecay = Math.min(other.lavaDecay, this.lavaDecay);
                    other.func_92058_a(itemstack1);
                    this.func_70106_y();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected boolean handleLavaMovement() {
        if (this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151587_i, (Entity)this)) {
            this.field_70159_w *= 0.75;
            this.field_70179_y *= 0.75;
        }
        return this.func_70055_a(Material.field_151587_i);
    }
}

