/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.futurefireproof.config;

import com.invadermonky.futurefireproof.config.ConfigHandlerFF;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;

public class ModTags {
    public static THashSet<String> DAMAGE_TYPES = new THashSet();
    public static THashMap<String, Integer> FIREPROOF_ITEMS = new THashMap();

    public static boolean isIgnoredDamageType(DamageSource source) {
        return DAMAGE_TYPES.contains((Object)source.func_76355_l()) && source != DamageSource.field_76380_i;
    }

    public static boolean isFireproofItem(ItemStack stack) {
        String itemId = stack.func_77973_b().getRegistryName().toString();
        return FIREPROOF_ITEMS.containsKey((Object)itemId) || FIREPROOF_ITEMS.containsKey((Object)(itemId + ":" + stack.func_77960_j()));
    }

    public static int getFireproofDecayRate(ItemStack stack) {
        String itemId = stack.func_77973_b().getRegistryName().toString();
        return Math.max((Integer)FIREPROOF_ITEMS.getOrDefault((Object)itemId, (Object)1), (Integer)FIREPROOF_ITEMS.getOrDefault((Object)(itemId + ":" + stack.func_77960_j()), (Object)1));
    }

    public static void syncConfig() {
        DAMAGE_TYPES.clear();
        FIREPROOF_ITEMS.clear();
        DAMAGE_TYPES.addAll(Arrays.asList(ConfigHandlerFF.damageTypes));
        for (String str : ConfigHandlerFF.fireproofItems) {
            if (str.matches(".+=[0-9]+")) {
                String[] split = str.split("=");
                FIREPROOF_ITEMS.put((Object)split[0], (Object)MathHelper.func_76125_a((int)Integer.parseInt(split[1]), (int)1, (int)6000));
                continue;
            }
            FIREPROOF_ITEMS.put((Object)str, (Object)1);
        }
    }
}

