/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.client;

import com.therandomlabs.randompatches.core.Patch;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityRendererPatch
extends Patch {
    public static final String SET_RENDER_VIEW_ENTITY = EntityRendererPatch.getName("setRenderViewEntity", "func_175607_a");
    public static final String ORIENT_CAMERA = EntityRendererPatch.getName("orientCamera", "func_78467_g");

    @Override
    public boolean apply(ClassNode node) {
        node.fields.add(new FieldNode(1, "entityRendererHook", "L" + this.hookClass + ";", null, null));
        this.patchUpdateRenderer(EntityRendererPatch.findInstructions(node, "updateRenderer", "func_78464_a"));
        this.patchSetupCameraTransform(EntityRendererPatch.findInstructions(node, "setupCameraTransform", "func_78479_a"));
        return true;
    }

    @Override
    public boolean computeFrames() {
        return true;
    }

    private void patchUpdateRenderer(InsnList instructions) {
        AbstractInsnNode label = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!SET_RENDER_VIEW_ENTITY.equals(method.name)) continue;
            label = method.getNext();
            break;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/EntityRenderer", "entityRendererHook", "L" + this.hookClass + ";"));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "updateRenderer", "(Lnet/minecraft/client/renderer/EntityRenderer;L" + this.hookClass + ";)V", false));
        instructions.insert(label, newInstructions);
    }

    private void patchSetupCameraTransform(InsnList instructions) {
        AbstractInsnNode orientCamera = null;
        for (int i = instructions.size() - 1; i >= 0; --i) {
            orientCamera = instructions.get(i);
            if (orientCamera.getOpcode() == 183 || orientCamera.getOpcode() == 182) {
                MethodInsnNode method = (MethodInsnNode)orientCamera;
                if (ORIENT_CAMERA.equals(method.name)) break;
            }
            orientCamera = null;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/EntityRenderer", "entityRendererHook", "L" + this.hookClass + ";"));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "orientCamera", "(FLnet/minecraft/client/renderer/EntityRenderer;L" + this.hookClass + ";)V", false));
        instructions.insert(orientCamera, newInstructions);
    }
}

