/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.engineering;

import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.CharsetAPI;
import pl.asie.charset.api.tools.IStopwatchTracker;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.capability.DummyCapabilityStorage;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.tools.engineering.ISignalMeterTracker;
import pl.asie.charset.module.tools.engineering.ItemSignalMeter;
import pl.asie.charset.module.tools.engineering.ItemStopwatch;
import pl.asie.charset.module.tools.engineering.ModelSignalMeter;
import pl.asie.charset.module.tools.engineering.PacketSignalMeterData;
import pl.asie.charset.module.tools.engineering.SignalMeterDataDummy;
import pl.asie.charset.module.tools.engineering.SignalMeterDataRedstone;
import pl.asie.charset.module.tools.engineering.SignalMeterProviderHandler;
import pl.asie.charset.module.tools.engineering.SignalMeterTracker;
import pl.asie.charset.module.tools.engineering.SignalMeterTrackerEventHandler;
import pl.asie.charset.module.tools.engineering.StopwatchTracker;

@CharsetModule(name="tools.engineering", description="Engineer's tools: Stopwatch, Signal Meter, Tuning Fork, Tape Measure.", profile=ModuleProfile.FORCED)
public class CharsetToolsEngineering {
    public static ItemStopwatch stopwatch;
    public static ItemSignalMeter signalMeter;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    @CharsetModule.Configuration
    public static Configuration config;
    private static final ResourceLocation stopwatchTrackerLoc;
    private static CapabilityProviderFactory<IStopwatchTracker> stopwatchTrackerProvider;
    @CapabilityInject(value=ISignalMeterTracker.class)
    static Capability<ISignalMeterTracker> meterTrackerCap;
    private static final ResourceLocation meterTrackerLoc;
    private static CapabilityProviderFactory<ISignalMeterTracker> meterTrackerProvider;
    public static double maxSendDistance;
    public static double maxRenderDistanceSq;

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        double maxRenderDistance = ConfigUtils.getDouble((Configuration)config, (String)"signalMeter", (String)"maxRenderDistance", (double)8.0, (double)0.0, (double)32.0, (String)"The maximum render/synchronization distance for Signal Meter Data. Lower this value if the packet usage becomes too high.", (boolean)false);
        maxRenderDistanceSq = maxRenderDistance * maxRenderDistance;
        maxSendDistance = maxRenderDistance >= 0.01 ? maxRenderDistance + 2.0 : 0.0;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        stopwatch = new ItemStopwatch();
        signalMeter = new ItemSignalMeter();
        CapabilityManager.INSTANCE.register(ISignalMeterTracker.class, (Capability.IStorage)DummyCapabilityStorage.get(), SignalMeterTracker::new);
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(ISignalMeterData.class).register(SignalMeterDataDummy.class, SignalMeterDataDummy::new);
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(ISignalMeterData.class).register(SignalMeterDataRedstone.class, SignalMeterDataRedstone::new);
        SignalMeterProviderHandler.INSTANCE.registerRemoteProvider(new SignalMeterDataRedstone.Provider(), false);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onPreInitClient(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketSignalMeterData.class);
        MinecraftForge.EVENT_BUS.register((Object)new SignalMeterTrackerEventHandler());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)stopwatch, (String)"stopwatch");
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)signalMeter, (String)"signal_meter");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        ModelSignalMeter.WHITE = event.getMap().func_174942_a(new ResourceLocation("charset", "misc/white"));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)stopwatch, (int)0, (String)"charset:stopwatch");
        RegistryUtils.registerModel((Item)signalMeter, (int)0, (String)"charset:signal_meter");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void postModelBake(ModelBakeEvent event) {
        try {
            ModelResourceLocation mrl = new ModelResourceLocation("charset:signal_meter", "inventory");
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)new ModelSignalMeter((IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((IItemColor)new ItemSignalMeter.Color(), new Item[]{signalMeter});
    }

    @SubscribeEvent
    public void attachCapsWorld(AttachCapabilitiesEvent<World> event) {
        if (!((World)event.getObject()).field_72995_K) {
            if (stopwatchTrackerProvider == null) {
                stopwatchTrackerProvider = new CapabilityProviderFactory(Capabilities.STOPWATCH_TRACKER);
            }
            event.addCapability(stopwatchTrackerLoc, stopwatchTrackerProvider.create((Object)new StopwatchTracker((World)event.getObject())));
        }
    }

    @SubscribeEvent
    public void attachCapsPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (meterTrackerProvider == null) {
            meterTrackerProvider = new CapabilityProviderFactory(meterTrackerCap);
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(meterTrackerLoc, meterTrackerProvider.create((Object)new SignalMeterTracker()));
        }
    }

    static {
        stopwatchTrackerLoc = new ResourceLocation("charset", "stopwatchTracker");
        meterTrackerLoc = new ResourceLocation("charset", "signal_meter_tracker");
    }
}

