/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.extendeddays.event;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.silentchaos512.extendeddays.ExtendedDays;
import net.silentchaos512.extendeddays.config.Config;
import net.silentchaos512.extendeddays.event.ClientEvents;
import net.silentchaos512.extendeddays.event.TimeEvents;
import net.silentchaos512.lib.client.gui.DebugRenderOverlay;

public class DebugOverlay
extends DebugRenderOverlay {
    private static final float TEXT_SCALE = 0.7f;
    private static final int SPLIT_WIDTH = 130;
    private static DebugOverlay instance;
    private int lastCapacity = 5;

    public static void init() {
        if (instance == null) {
            instance = new DebugOverlay();
        } else {
            ExtendedDays.logHelper.warn("DebugOverlay already initialized!", new Object[0]);
            ExtendedDays.logHelper.catching((Throwable)new IllegalStateException());
        }
    }

    @Nonnull
    public List<String> getDebugText() {
        ArrayList<String> list = new ArrayList<String>(this.lastCapacity);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null || world.field_73011_w == null) {
            list.add("World not found!");
        } else {
            list.add(String.format("Time (MC, Ext)%s%d, %d %s", "=", world.func_72820_D(), TimeEvents.INSTANCE.getExtendedTime(), TimeEvents.INSTANCE.isInExtendedPeriod((World)world) ? "(E)" : ""));
            list.add(String.format("Effective Time%s%d / %d", "=", TimeEvents.INSTANCE.getCurrentTime((World)world), TimeEvents.INSTANCE.getTotalDayLength((World)world)));
            list.add(String.format("Day/Night Length%s%d, %d", "=", TimeEvents.INSTANCE.getDaytimeLength((World)world), TimeEvents.INSTANCE.getNighttimeLength((World)world)));
            list.add(String.format("ClientEvents#worldTime%s%d", "=", ClientEvents.worldTime));
            list.add(String.format("Dimension%s%d, %s", "=", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p()));
            this.lastCapacity = list.size();
        }
        return list;
    }

    public float getTextScale() {
        return 0.7f;
    }

    public boolean isHidden() {
        return !Config.debugMode;
    }

    public int getStartX() {
        return 5;
    }

    public int getStartY() {
        return 30;
    }

    public int getUpdateFrequency() {
        return 0;
    }

    public int getSplitWidth() {
        return 130;
    }
}

