/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.extendeddays.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemClock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.extendeddays.client.render.SkyRenderer;
import net.silentchaos512.extendeddays.config.Config;
import net.silentchaos512.extendeddays.event.TimeEvents;
import net.silentchaos512.extendeddays.init.ModItems;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.TimeHelper;

public class ClientEvents {
    private static final int PLAYER_UPDATE_FREQUENCY = TimeHelper.ticksFromSeconds((float)5.0f);
    public static boolean playerCanSeeSky = true;
    public static boolean playerHasVanillaClock = true;
    public static boolean playerHasPocketWatch = true;
    public static long worldTime = 0L;
    private static final int RENDERER_ERROR_REPORT_DELAY = TimeHelper.ticksFromSeconds((float)30.0f);
    private int ticksUnableToReplaceRenderer = 0;
    private boolean reportedUnableToReplaceRenderer = false;

    @SubscribeEvent
    public void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        int extendedTime = TimeEvents.INSTANCE.getExtendedTime();
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        boolean isOverworld = TimeEvents.isOverworld((World)world);
        if (isOverworld && extendedTime > 0 && worldTime > 0L) {
            world.func_72877_b(worldTime);
        }
        if (Config.skyOverride && isOverworld) {
            if (world == null || world.field_73011_w == null) {
                ++this.ticksUnableToReplaceRenderer;
                if (!this.reportedUnableToReplaceRenderer && this.ticksUnableToReplaceRenderer > RENDERER_ERROR_REPORT_DELAY) {
                    ChatHelper.sendMessage((EntityPlayer)event.player, (String)"Extended Days was unable to replace sky renderer!");
                    this.reportedUnableToReplaceRenderer = true;
                }
                return;
            }
            WorldProvider provider = mc.field_71441_e.field_73011_w;
            if (!(provider.getSkyRenderer() instanceof SkyRenderer)) {
                provider.setSkyRenderer((IRenderHandler)new SkyRenderer());
                this.ticksUnableToReplaceRenderer = 0;
            }
        }
        if (!Minecraft.func_71410_x().func_71356_B() && isOverworld && extendedTime > 0) {
            TimeEvents.INSTANCE.setExtendedTime(extendedTime - 1);
        }
        if (event.player.field_70173_aa % PLAYER_UPDATE_FREQUENCY == 0) {
            playerCanSeeSky = this.checkCanPlayerSeeSky(event.player);
            this.checkPlayerHasWatchOrClock(event.player);
        }
    }

    private boolean checkCanPlayerSeeSky(EntityPlayer player) {
        if (player == null) {
            return true;
        }
        RayTraceResult raytrace = player.field_70170_p.func_147447_a(player.func_174824_e(0.0f), player.func_174824_e(0.0f).func_178787_e(new Vec3d(0.0, 256.0 - player.field_70163_u, 0.0)), false, true, false);
        return raytrace == null;
    }

    private void checkPlayerHasWatchOrClock(EntityPlayer player) {
        playerHasPocketWatch = false;
        playerHasVanillaClock = false;
        for (ItemStack stack : PlayerHelper.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (stack.func_77973_b() == ModItems.POCKET_WATCH) {
                playerHasPocketWatch = true;
                return;
            }
            if (!(stack.func_77973_b() instanceof ItemClock)) continue;
            playerHasVanillaClock = true;
        }
    }
}

