/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.extendeddays.command;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.silentchaos512.extendeddays.ExtendedDays;
import net.silentchaos512.extendeddays.event.TimeEvents;
import net.silentchaos512.lib.command.CommandBaseSL;

public class CommandExtTime
extends CommandBaseSL {
    public String func_71517_b() {
        return "edtime";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Gets/sets the Extended Days time. Currently, the set command requires 2 values, I'm working on making it more 'sensible'.\nUsage: /" + this.func_71517_b() + " <get|set> <value>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
            return;
        }
        String command = args[0];
        if (command.equals("get")) {
            this.executeGet(server, sender);
        } else if (command.equals("set")) {
            if (args.length < 2) {
                this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
                return;
            }
            if (args.length < 3) {
                this.tell(sender, "This command is currently incomplete. You must enter two values, the world time and the extended time.", false, new Object[0]);
                return;
            }
            try {
                long value1 = Long.parseLong(args[1]);
                int value2 = Integer.parseInt(args[2]);
                this.executeSet(server, sender, value1, value2);
            }
            catch (NumberFormatException ex) {
                this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
            }
        } else {
            this.tell(sender, this.func_71518_a(sender), false, new Object[0]);
        }
    }

    private void executeGet(MinecraftServer server, ICommandSender sender) {
        WorldServer world = server.field_71305_c[0];
        int currentTime = TimeEvents.INSTANCE.getCurrentTime((World)world);
        int totalDayLength = TimeEvents.INSTANCE.getTotalDayLength((World)world);
        String str = String.format("Actual time: %d / %d", currentTime, totalDayLength);
        this.tell(sender, str, false, new Object[0]);
    }

    private void executeSet(MinecraftServer server, ICommandSender sender, long amount) {
        this.tell(sender, "Not yet implemented.", false, new Object[0]);
    }

    private void executeSet(MinecraftServer server, ICommandSender sender, long amount, int amountExt) {
        ExtendedDays.logHelper.info("Trying to set time ({}, {})", new Object[]{amount, amountExt});
        TimeEvents.INSTANCE.setTime((World)server.field_71305_c[0], amount, amountExt);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length < 1 ? ImmutableList.of((Object)"get", (Object)"set") : ImmutableList.of();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    private void tell(ICommandSender sender, String key, boolean fromLocalizationFile, Object ... args) {
        String value = fromLocalizationFile ? ExtendedDays.i18n.translate("command." + key, args) : key;
        sender.func_145747_a((ITextComponent)new TextComponentString(value));
    }
}

