/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

public class Multiblock
implements IMultiblock,
IBlockAccess {
    final String[][] pattern;
    public ResourceLocation res;
    public IStateMatcher[][][] stateTargets;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int offX;
    public int offY;
    public int offZ;
    public int viewOffX;
    public int viewOffY;
    public int viewOffZ;
    int centerX;
    int centerY;
    int centerZ;
    boolean symmetrical;
    World world;
    private final transient Map<BlockPos, TileEntity> teCache = new HashMap<BlockPos, TileEntity>();

    public Multiblock(String[][] pattern, Object ... targets) {
        this.pattern = pattern;
        this.build(targets, this.getPatternDimensions());
    }

    @Override
    public Multiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    public Multiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    @Override
    public Multiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    public Multiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    @Override
    public Multiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public Multiblock setResourceLocation(ResourceLocation res) {
        this.res = res;
        return this;
    }

    @Override
    public void place(World world, BlockPos pos, Rotation rotation) {
        this.setWorld(world);
        BlockPos start = pos.func_177982_a(RotationUtil.x(rotation, -this.offX, -this.offZ), -this.offY, RotationUtil.z(rotation, -this.offX, -this.offZ));
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    BlockPos placePos = start.func_177982_a(RotationUtil.x(rotation, x, z), y, RotationUtil.z(rotation, x, z));
                    IBlockState targetState = this.stateTargets[x][y][z].getDisplayedState().func_185907_a(rotation);
                    Block targetBlock = targetState.func_177230_c();
                    if (targetBlock.isAir(targetState, (IBlockAccess)world, placePos) || !targetBlock.func_176196_c(world, placePos) || !world.func_180495_p(placePos).func_177230_c().func_176200_f((IBlockAccess)world, placePos)) continue;
                    world.func_175656_a(placePos, targetState);
                }
            }
        }
    }

    @Override
    public void forEach(World world, BlockPos pos, Rotation rotation, char c, Consumer<BlockPos> action) {
        this.setWorld(world);
        this.forEachMatcher(world, pos, rotation, c, (start, actionPos, x, y, z, ch, matcher) -> {
            action.accept(actionPos);
            return true;
        });
    }

    @Override
    public boolean forEachMatcher(World world, BlockPos pos, Rotation rotation, char c, IMultiblock.MatcherAcceptor acceptor) {
        this.setWorld(world);
        BlockPos start = pos.func_177982_a(RotationUtil.x(rotation, -this.offX, -this.offZ), -this.offY, RotationUtil.z(rotation, -this.offX, -this.offZ));
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    BlockPos actionPos;
                    char currC = this.pattern[y][x].charAt(z);
                    if (c != '\u0000' && c != currC || acceptor.accepts(start, actionPos = start.func_177982_a(RotationUtil.x(rotation, x, z), y, RotationUtil.z(rotation, x, z)), x, y, z, currC, this.stateTargets[x][y][z])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean validate(World world, BlockPos pos) {
        if (this.symmetrical) {
            return this.validate(world, pos, Rotation.NONE);
        }
        return this.validate(world, pos, Rotation.NONE) || this.validate(world, pos, Rotation.CLOCKWISE_90) || this.validate(world, pos, Rotation.CLOCKWISE_180) || this.validate(world, pos, Rotation.COUNTERCLOCKWISE_90);
    }

    protected boolean validate(World world, BlockPos pos, Rotation rotation) {
        this.setWorld(world);
        BlockPos start = pos.func_177982_a(RotationUtil.x(rotation, -this.offX, -this.offZ), -this.offY, RotationUtil.z(rotation, -this.offX, -this.offZ));
        if (!this.test(world, start, this.centerX, this.centerY, this.centerZ, rotation)) {
            return false;
        }
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (this.test(world, start, x, y, z, rotation)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean test(World world, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setWorld(world);
        BlockPos checkPos = start.func_177982_a(RotationUtil.x(rotation, x, z), y, RotationUtil.z(rotation, x, z));
        Predicate<IBlockState> pred = this.stateTargets[x][y][z].getStatePredicate();
        IBlockState state = world.func_180495_p(checkPos).func_185907_a(RotationUtil.fixHorizontal(rotation));
        return pred.test(state);
    }

    void build(Object[] targets, int[] dimensions) {
        if (targets.length % 2 == 1) {
            throw new IllegalArgumentException("Illegal argument length for targets array " + targets.length);
        }
        HashMap<Character, StateMatcher> stateMap = new HashMap<Character, StateMatcher>();
        for (int i = 0; i < targets.length / 2; ++i) {
            IStateMatcher state;
            char c = ((Character)targets[i * 2]).charValue();
            Object o = targets[i * 2 + 1];
            if (o instanceof Block) {
                state = StateMatcher.fromBlockLoose((Block)o);
            } else if (o instanceof IBlockState) {
                state = StateMatcher.fromState((IBlockState)o);
            } else if (o instanceof IStateMatcher) {
                state = (IStateMatcher)o;
            } else {
                throw new IllegalArgumentException("Invalid target " + o);
            }
            stateMap.put(Character.valueOf(c), (StateMatcher)state);
        }
        if (!stateMap.containsKey(Character.valueOf('_'))) {
            stateMap.put(Character.valueOf('_'), StateMatcher.ANY);
        }
        if (!stateMap.containsKey(Character.valueOf(' '))) {
            stateMap.put(Character.valueOf(' '), StateMatcher.AIR);
        }
        if (!stateMap.containsKey(Character.valueOf('0'))) {
            stateMap.put(Character.valueOf('0'), StateMatcher.AIR);
        }
        boolean foundCenter = false;
        this.sizeX = dimensions[1];
        this.sizeY = dimensions[0];
        this.sizeZ = dimensions[2];
        this.stateTargets = new IStateMatcher[dimensions[1]][dimensions[0]][dimensions[2]];
        for (int y = 0; y < dimensions[0]; ++y) {
            for (int x = 0; x < dimensions[1]; ++x) {
                for (int z = 0; z < dimensions[2]; ++z) {
                    char c = this.pattern[y][x].charAt(z);
                    if (!stateMap.containsKey(Character.valueOf(c))) {
                        throw new IllegalArgumentException("Character " + c + " isn't mapped");
                    }
                    IStateMatcher matcher = (IStateMatcher)stateMap.get(Character.valueOf(c));
                    if (c == '0') {
                        if (foundCenter) {
                            throw new IllegalArgumentException("A structure can't have two centers");
                        }
                        foundCenter = true;
                        this.offX = this.centerX = x;
                        this.offY = this.centerY = this.sizeY - y - 1;
                        this.offZ = this.centerZ = z;
                        this.setViewOffset();
                    }
                    this.stateTargets[x][this.sizeY - y - 1][z] = matcher;
                }
            }
        }
        if (!foundCenter) {
            throw new IllegalArgumentException("A structure can't have no center");
        }
    }

    int[] getPatternDimensions() {
        int expectedLenX = -1;
        int expectedLenZ = -1;
        for (String[] arr : this.pattern) {
            if (expectedLenX == -1) {
                expectedLenX = arr.length;
            }
            if (arr.length != expectedLenX) {
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
            for (String s : arr) {
                if (expectedLenZ == -1) {
                    expectedLenZ = s.length();
                }
                if (s.length() == expectedLenZ) continue;
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
        }
        return new int[]{this.pattern.length, expectedLenX, expectedLenZ};
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    @Nullable
    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        if (state.func_177230_c().hasTileEntity(state)) {
            return this.teCache.computeIfAbsent(pos.func_185334_h(), p -> state.func_177230_c().createTileEntity(this.world, state));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
        return 0xF000F0;
    }

    @Nonnull
    public IBlockState func_180495_p(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < 0 || y < 0 || z < 0 || x >= this.sizeX || y >= this.sizeY || z >= this.sizeZ) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.stateTargets[x][y][z].getDisplayedState();
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Biome func_180494_b(@Nonnull BlockPos pos) {
        return Biomes.field_76772_c;
    }

    public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }
}

