/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import java.awt.Color;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.common.multiblock.Multiblock;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

public class MultiblockVisualizationHandler {
    public static boolean hasMultiblock;
    public static PersistentData.DataHolder.BookData.Bookmark bookmark;
    private static Multiblock multiblock;
    private static String name;
    private static BlockPos pos;
    private static boolean isAnchored;
    private static Rotation facingRotation;
    private static Function<BlockPos, BlockPos> offsetApplier;
    private static int blocks;
    private static int blocksDone;
    private static int airFilled;
    private static int timeComplete;
    private static IBlockState lookingState;
    private static BlockPos lookingPos;

    public static void setMultiblock(Multiblock multiblock, String name, PersistentData.DataHolder.BookData.Bookmark bookmark, boolean flip) {
        MultiblockVisualizationHandler.setMultiblock(multiblock, name, bookmark, flip, pos -> pos);
    }

    public static void setMultiblock(Multiblock multiblock, String name, PersistentData.DataHolder.BookData.Bookmark bookmark, boolean flip, Function<BlockPos, BlockPos> offsetApplier) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockVisualizationHandler.multiblock = multiblock;
            MultiblockVisualizationHandler.name = name;
            MultiblockVisualizationHandler.bookmark = bookmark;
            MultiblockVisualizationHandler.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = true;
            isAnchored = false;
        }
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && hasMultiblock) {
            int fullAnimTime;
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : event.getPartialTicks());
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(-Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed), (float)0.0f);
            int x = event.getResolution().func_78326_a() / 2;
            int y = 12;
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71466_p.func_175063_a(name, (float)(x - mc.field_71466_p.func_78256_a(name) / 2), (float)y, 0xFFFFFF);
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = I18n.func_135052_a((String)"patchouli.gui.lexicon.structure_complete", (Object[])new Object[0]);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)Math.min((float)(height + 5), animTime), (float)0.0f);
                mc.field_71466_p.func_175063_a(s, (float)(x - mc.field_71466_p.func_78256_a(s) / 2), (float)(top + height - 10), 65280);
                GlStateManager.func_179121_F();
            }
            Gui.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + width + 1), (int)(top + height + 1), (int)-16777216);
            MultiblockVisualizationHandler.drawGradientRect(left, top, left + width, top + height, -10066330, -11184811);
            float fract = (float)blocksDone / (float)Math.max(1, blocks);
            int progressWidth = (int)((float)width * fract);
            int color = MathHelper.func_181758_c((float)(fract / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            MultiblockVisualizationHandler.drawGradientRect(left, top, left + progressWidth, top + height, color, color2);
            if (!isAnchored) {
                String s = I18n.func_135052_a((String)"patchouli.gui.lexicon.not_anchored", (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(s, (float)(x - mc.field_71466_p.func_78256_a(s) / 2), (float)(top + height + 8), 0xFFFFFF);
            } else {
                if (lookingState != null) {
                    try {
                        Block block = lookingState.func_177230_c();
                        ItemStack stack = block.getPickBlock(lookingState, mc.field_71476_x, (World)mc.field_71441_e, lookingPos, (EntityPlayer)mc.field_71439_g);
                        if (!stack.func_190926_b()) {
                            mc.field_71466_p.func_175063_a(stack.func_82833_r(), (float)(left + 20), (float)(top + height + 8), 0xFFFFFF);
                            RenderHelper.func_74520_c();
                            mc.func_175599_af().func_175042_a(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    int mult = 1;
                    String progress = blocksDone + "/" + blocks;
                    if (blocksDone == blocks && airFilled > 0) {
                        progress = I18n.func_135052_a((String)"patchouli.gui.lexicon.needs_air", (Object[])new Object[0]);
                        color = 14306879;
                        mult *= 2;
                        posx -= width / 2;
                        posy += 2;
                    }
                    mc.field_71466_p.func_175063_a(progress, (float)(posx - mc.field_71466_p.func_78256_a(progress) / mult), (float)posy, color);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        if (hasMultiblock && multiblock != null) {
            MultiblockVisualizationHandler.renderMultiblock((World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (hasMultiblock && !isAnchored && event.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            pos = event.getPos();
            facingRotation = MultiblockVisualizationHandler.getRotation((Entity)event.getEntityPlayer());
            isAnchored = true;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            if (++timeComplete == 14) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187604_bf, (float)1.0f));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(World world) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!isAnchored) {
            facingRotation = MultiblockVisualizationHandler.getRotation((Entity)mc.field_71439_g);
            if (mc.field_71476_x != null) {
                pos = mc.field_71476_x.func_178782_a();
            }
        } else if (mc.field_71439_g.func_174818_b(pos) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        double posX = manager.field_78725_b;
        double posY = manager.field_78726_c;
        double posZ = manager.field_78723_d;
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)32771, (int)32772);
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(-posX), (double)(-posY), (double)(-posZ));
        BlockPos checkPos = mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK ? mc.field_71476_x.func_178782_a().func_177972_a(mc.field_71476_x.field_178784_b) : null;
        BlockPos startPos = MultiblockVisualizationHandler.getStartPos();
        airFilled = 0;
        blocksDone = 0;
        blocks = 0;
        lookingState = null;
        lookingPos = checkPos;
        for (int x = 0; x < MultiblockVisualizationHandler.multiblock.sizeX; ++x) {
            for (int y = 0; y < MultiblockVisualizationHandler.multiblock.sizeY; ++y) {
                for (int z = 0; z < MultiblockVisualizationHandler.multiblock.sizeZ; ++z) {
                    boolean air;
                    float alpha = 0.3f;
                    BlockPos renderPos = startPos.func_177982_a(RotationUtil.x(facingRotation, x, z), y, RotationUtil.z(facingRotation, x, z));
                    IStateMatcher matcher = MultiblockVisualizationHandler.multiblock.stateTargets[x][y][z];
                    if (renderPos.equals((Object)checkPos)) {
                        lookingState = matcher.getDisplayedState();
                        alpha = 0.6f + (float)(Math.sin(ClientTicker.total * 0.3f) + 1.0) * 0.1f;
                    }
                    if (matcher == StateMatcher.ANY) continue;
                    boolean bl = air = matcher == StateMatcher.AIR;
                    if (!air) {
                        ++blocks;
                    }
                    if (!multiblock.test(world, startPos, x, y, z, facingRotation)) {
                        IBlockState renderState = matcher.getDisplayedState().func_185907_a(facingRotation);
                        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                        MultiblockVisualizationHandler.renderBlock(world, renderState, renderPos, alpha, dispatcher);
                        if (!air) continue;
                        ++airFilled;
                        continue;
                    }
                    if (air) continue;
                    ++blocksDone;
                }
            }
        }
        if (!isAnchored) {
            blocksDone = 0;
            blocks = 0;
        }
        GL11.glPopAttrib();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public static void renderBlock(World world, IBlockState state, BlockPos pos, float alpha, BlockRendererDispatcher brd) {
        if (pos != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            try {
                if (state.func_177230_c() == Blocks.field_150350_a) {
                    float scale = 0.3f;
                    float off = (1.0f - scale) / 2.0f;
                    GlStateManager.func_179109_b((float)off, (float)off, (float)(-off));
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    brd.func_175016_a(Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED), 1.0f);
                } else {
                    brd.func_175016_a(state, 1.0f);
                }
            }
            catch (NullPointerException e) {
                BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
                builder.func_178965_a();
                builder.func_178977_d();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static Multiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static Rotation getFacingRotation() {
        return multiblock.isSymmetrical() ? Rotation.NONE : facingRotation;
    }

    public static BlockPos getStartPos() {
        Rotation rot = MultiblockVisualizationHandler.getFacingRotation();
        BlockPos startPos = offsetApplier.apply(pos);
        startPos = startPos.func_177982_a(-RotationUtil.x(rot, MultiblockVisualizationHandler.multiblock.viewOffX, MultiblockVisualizationHandler.multiblock.viewOffZ), -MultiblockVisualizationHandler.multiblock.viewOffY + 1, -RotationUtil.z(rot, MultiblockVisualizationHandler.multiblock.viewOffX, MultiblockVisualizationHandler.multiblock.viewOffZ));
        return startPos;
    }

    private static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private static Rotation getRotation(Entity entity) {
        return RotationUtil.rotationFromFacing(EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(-entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)));
    }
}

