/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;
import vazkii.patchouli.common.util.ValidationUtils;

public abstract class BookPage {
    public transient Minecraft mc;
    public transient FontRenderer fontRenderer;
    public transient GuiBookEntry parent;
    public transient Book book;
    protected transient BookEntry entry;
    protected transient int pageNum;
    private transient List<GuiButton> buttons;
    public transient int left;
    public transient int top;
    public transient JsonObject sourceObject;
    public transient ItemStack itemStack;
    protected String type;
    protected String flag;
    protected String advancement;
    protected String anchor;
    protected String link_item;

    public void build(BookEntry entry, int pageNum) {
        this.book = entry.book;
        this.entry = entry;
        this.pageNum = pageNum;
        if (this.link_item != null && !this.link_item.isEmpty()) {
            this.itemStack = ItemStackUtil.loadStackFromString(this.link_item);
            if (!this.itemStack.func_190926_b()) {
                entry.addRelevantStack(this.itemStack, pageNum);
            }
        }
        ValidationUtils.validateAdvancement(this.advancement);
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        this.mc = parent.field_146297_k;
        this.book = parent.book;
        this.fontRenderer = this.mc.field_71466_p;
        this.parent = parent;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<GuiButton>();
    }

    public boolean isPageUnlocked() {
        return this.advancement == null || this.advancement.isEmpty() || ClientAdvancements.hasDone(this.advancement);
    }

    public void onHidden(GuiBookEntry parent) {
        parent.getButtonList().removeAll(this.buttons);
    }

    protected void addButton(GuiButton button) {
        button.field_146128_h += this.parent.bookLeft + this.left;
        button.field_146129_i += this.parent.bookTop + this.top;
        this.buttons.add(button);
        this.parent.getButtonList().add(button);
    }

    public void render(int mouseX, int mouseY, float pticks) {
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    protected void onButtonClicked(GuiButton button) {
    }

    public final boolean interceptButton(GuiButton button) {
        if (this.buttons.contains(button)) {
            this.onButtonClicked(button);
            return true;
        }
        return false;
    }

    public boolean canAdd(Book book) {
        return this.flag == null || this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }
}

